/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.remoteService;

import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.messageFactory.NameServiceFactory;
import com.tangosol.coherence.component.net.extend.protocol.NameServiceProtocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator;
import com.tangosol.discovery.NSLookup;
import com.tangosol.internal.net.service.extend.remote.RemoteServiceDependencies;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.NameService;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.internal.NameServicePofContext;
import com.tangosol.net.internal.WrapperSocketAddressProvider;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.naming.NamingException;

public class RemoteNameService
extends RemoteService
implements SerializerFactory,
NameService,
AutoCloseable {
    private InetSocketAddress __m_MulticastAddress;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("InterruptTask", InterruptTask.get_CLASS());
    }

    public RemoteNameService() {
        this(null, null, true);
    }

    public RemoteNameService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setMemberListeners(new Listeners());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setServiceListeners(new Listeners());
            this.setServiceVersion("1");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new RemoteNameService();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/remoteService/RemoteNameService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addLookupCallback(NameService.LookupCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(String sName, Object o) throws NamingException {
        Channel channel = this.ensureChannel();
        NameServiceFactory.BindRequest request = (NameServiceFactory.BindRequest)channel.getMessageFactory().createMessage(2);
        request.setName(sName);
        request.setResource(o);
        channel.request(request);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Override
    public Serializer createSerializer(ClassLoader loader) {
        return NameServicePofContext.INSTANCE;
    }

    @Override
    protected void doStart() {
        try {
            super.doStart();
        }
        catch (ConnectionException e) {
            SocketAddressProvider provider = ((TcpInitiator)this.getInitiator()).getRemoteAddressProvider();
            InetSocketAddress32 addr = (InetSocketAddress32)provider.getNextAddress();
            while (addr != null) {
                if (addr.getAddress().isMulticastAddress()) {
                    this.setMulticastAddress(new InetSocketAddress(addr.getAddress(), MultiplexedSocketProvider.getBasePort(addr.getPort())));
                    provider.accept();
                    return;
                }
                provider.reject(null);
                addr = (InetSocketAddress32)provider.getNextAddress();
            }
            throw e;
        }
    }

    @Override
    protected void doStop() {
        this.setMulticastAddress(null);
        super.doStop();
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getMulticastAddress() {
        return this.__m_MulticastAddress;
    }

    @Override
    public String getServiceType() {
        return "RemoteNameService";
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() || this.getMulticastAddress() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String sName) throws NamingException {
        InetSocketAddress addrMC = this.getMulticastAddress();
        if (addrMC == null) {
            Channel channel = this.ensureChannel();
            NameServiceFactory.LookupRequest request = (NameServiceFactory.LookupRequest)channel.getMessageFactory().createMessage(1);
            request.setLookupName(sName);
            return channel.request(request);
        }
        RemoteServiceDependencies deps = (RemoteServiceDependencies)this.getDependencies();
        TcpInitiatorDependencies depsInit = (TcpInitiatorDependencies)deps.getInitiatorDependencies();
        Initiator initiator = (Initiator)this.getInitiator();
        SafeHashSet setClose = initiator.getCloseOnExit();
        InterruptTask task = new InterruptTask();
        OperationalContext ctx = this.getOperationalContext();
        InetSocketAddress addrLocal = (InetSocketAddress)depsInit.getLocalAddress();
        InetAddress addrMember = ctx.getLocalMember().getAddress();
        InetAddress addrDisc = ctx.getDiscoveryInterface();
        InetAddress addrLocalInet = addrLocal == null ? ((addrDisc == null || addrDisc.isAnyLocalAddress()) && addrMember != null && addrMember.isLoopbackAddress() ? addrMember : addrDisc) : addrLocal.getAddress();
        Initiator initiator2 = initiator;
        synchronized (initiator2) {
            if (!initiator.isRunning()) {
                throw new IllegalStateException("service has been shutdown");
            }
            task.setThread(Thread.currentThread());
            setClose.add(task);
        }
        try {
            Binary binMember = ExternalizableHelper.toBinary(this.getOperationalContext().getLocalMember(), initiator.getSerializer());
            long cMillisTimeout = Math.min(depsInit.getConnectTimeoutMillis(), Timeout.remainingTimeoutMillis());
            DataInputStream in = NSLookup.datagramLookupRaw(deps.getRemoteClusterName(), sName, addrMC, addrLocalInet, (int)cMillisTimeout, ctx.getDiscoveryTimeToLive(), binMember.toByteArray());
            Binary binResult = new Binary(in);
            Object var18_21 = binResult.length() == 0 ? null : ExternalizableHelper.fromBinary(binResult, initiator.getSerializer());
            return var18_21;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
        finally {
            setClose.remove(task);
        }
    }

    @Override
    protected void onDependencies(RemoteServiceDependencies deps) {
        super.onDependencies(deps);
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator instanceof Initiator) {
            Initiator initiatorImpl = (Initiator)initiator;
            initiatorImpl.setSerializerFactory(this);
            initiatorImpl.setWrapperStreamFactoryList(null);
            if (initiator instanceof TcpInitiator) {
                TcpInitiator tcpInitiator = (TcpInitiator)initiator;
                tcpInitiator.setRemoteAddressProvider(new WrapperSocketAddressProvider(tcpInitiator.getRemoteAddressProvider(), MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_NAME_SERVICE.getSubPort()));
            }
        }
        initiator.registerProtocol(NameServiceProtocol.getInstance());
    }

    @Override
    protected Channel openChannel() {
        return this.getInitiator().ensureConnection().openChannel(NameServiceProtocol.getInstance(), "NameService", null, null, SecurityHelper.getCurrentSubject());
    }

    public void setMulticastAddress(InetSocketAddress addressMulticast) {
        this.__m_MulticastAddress = addressMulticast;
    }

    @Override
    public void unbind(String sName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    static {
        RemoteNameService.__initStatic();
    }

    public static class InterruptTask
    extends Component
    implements AutoCloseable {
        private Thread __m_Thread;

        public InterruptTask() {
            this(null, null, true);
        }

        public InterruptTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InterruptTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/remoteService/RemoteNameService$InterruptTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void close() {
            this.getThread().interrupt();
        }

        public Thread getThread() {
            return this.__m_Thread;
        }

        public void setThread(Thread sProperty) {
            this.__m_Thread = sProperty;
        }
    }
}

