/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy.serviceProxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.message.request.CacheServiceRequest;
import com.tangosol.coherence.component.net.extend.protocol.CacheServiceProtocol;
import com.tangosol.coherence.component.net.extend.proxy.ServiceProxy;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.scheme.ViewScheme;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.Parameter;
import com.tangosol.internal.net.service.extend.proxy.CacheServiceProxyDependencies;
import com.tangosol.internal.net.service.extend.proxy.DefaultCacheServiceProxyDependencies;
import com.tangosol.internal.net.service.extend.proxy.DefaultProxyDependencies;
import com.tangosol.internal.net.service.extend.proxy.LegacyXmlCacheServiceProxyHelper;
import com.tangosol.internal.net.service.extend.proxy.ProxyDependencies;
import com.tangosol.internal.util.collection.ConvertingNamedCache;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.net.cache.WrapperNamedCache;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CacheServiceProxy
extends ServiceProxy
implements CacheService,
SynchronousListener {
    private BackingMapManager __m_BackingMapManager;
    private ConfigurableCacheFactory __m_CacheFactory;
    private CacheService __m_CacheService;
    private ConverterFromBinary __m_ConverterFromBinary;
    private ConverterToBinary __m_ConverterToBinary;
    private boolean __m_LockEnabled;
    private Set __m_NamedCacheSet;
    private boolean __m_PassThroughEnabled;
    private boolean __m_ReadOnly;
    private long __m_TransferThreshold;

    public CacheServiceProxy() {
        this(null, null, true);
    }

    public CacheServiceProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setEnabled(true);
            this.setNamedCacheSet(new SafeHashSet());
            this.setPassThroughEnabled(true);
            this.setServiceVersion("14");
            this.setTransferThreshold(524288L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ConverterFromBinary("ConverterFromBinary", this, true), "ConverterFromBinary");
        this._addChild(new ConverterToBinary("ConverterToBinary", this, true), "ConverterToBinary");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new CacheServiceProxy();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/serviceProxy/CacheServiceProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected DefaultProxyDependencies cloneDependencies(ProxyDependencies deps) {
        return new DefaultCacheServiceProxyDependencies((CacheServiceProxyDependencies)deps);
    }

    @Override
    public void destroyCache(NamedCache cache) {
        if (this.isReadOnly()) {
            throw new SecurityException("NamedCache \"" + cache.getCacheName() + "\" is read-only");
        }
        this.releaseCache(cache, true);
    }

    @Override
    public NamedCache ensureCache(String sName, ClassLoader loader) {
        return this.ensureTypedCache(sName, loader, TypeAssertion.WITHOUT_TYPE_CHECKING);
    }

    protected NamedCache ensureTypedCache(String sName, ClassLoader loader, TypeAssertion assertion) {
        Serializer serializerThat;
        Serializer serializerThis;
        CacheService service;
        ConvertingNamedCache cache;
        boolean fNear;
        ConfigurableCacheFactory ccf = this.getCacheFactory();
        if (!this.isPassThroughEnabled()) {
            return ccf.ensureTypedCache(sName, loader, assertion);
        }
        ClassLoader loaderInternal = NullImplementation.getClassLoader();
        if (ccf instanceof ExtensibleConfigurableCacheFactory && ((ExtensibleConfigurableCacheFactory)ccf).getCacheConfig().findSchemeByCacheName(sName) instanceof ViewScheme) {
            loaderInternal = loader;
        }
        if ((fNear = (cache = ccf.ensureTypedCache(sName, loaderInternal, assertion)) instanceof NearCache) && (service = cache.getCacheService()) != null && service instanceof DistributedCacheService && ((DistributedCacheService)service).isLocalStorageEnabled()) {
            cache = ((NearCache)((Object)cache)).getBackCache();
            fNear = false;
        }
        if (ExternalizableHelper.isSerializerCompatible(serializerThis = this.getSerializer(), serializerThat = CacheServiceProxy.getSerializer(cache))) {
            if (fNear) {
                cache = new ConvertingNamedCache((NamedCache)cache, NullImplementation.getConverter(), ExternalizableHelper.CONVERTER_STRIP_INTDECO, NullImplementation.getConverter(), NullImplementation.getConverter());
            }
        } else {
            cache = ccf.ensureTypedCache(sName, loader, assertion);
            cache = new ConvertingNamedCache((NamedCache)cache, (Converter)this.getConverterToBinary(), (Converter)this.getConverterFromBinary(), (Converter)this.getConverterToBinary(), (Converter)this.getConverterFromBinary());
            if (this.getNamedCacheSet().add(sName)) {
                if (serializerThat == null) {
                    CacheServiceProxy._trace("The cache \"" + sName + "\" does not support pass-through optimization for objects in internal format. If possible, consider using a different cache topology.", 3);
                } else {
                    ExternalizableHelper.reportIncompatibleSerializers(cache, this.getServiceName(), serializerThis);
                }
            }
        }
        return cache;
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public ConfigurableCacheFactory getCacheFactory() {
        return this.__m_CacheFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration getCacheNames() {
        Set set;
        Set set2 = set = this.getNamedCacheSet();
        synchronized (set2) {
            ImmutableArrayList col = new ImmutableArrayList(set.toArray());
            return new IteratorEnumerator(col.iterator());
        }
    }

    public CacheService getCacheService() {
        CacheService service = this.__m_CacheService;
        return service == null ? this : service;
    }

    public ConverterFromBinary getConverterFromBinary() {
        return this.__m_ConverterFromBinary;
    }

    public ConverterToBinary getConverterToBinary() {
        return this.__m_ConverterToBinary;
    }

    @Override
    public String getName() {
        return "CacheServiceProxy";
    }

    protected Set getNamedCacheSet() {
        return this.__m_NamedCacheSet;
    }

    @Override
    public Protocol getProtocol() {
        return CacheServiceProtocol.getInstance();
    }

    public static Serializer getSerializer(NamedCache cache) {
        CacheService service;
        String sType;
        Serializer serializer = null;
        if (cache instanceof WrapperNamedCache) {
            Map map = ((WrapperNamedCache)cache).getMap();
            cache = map instanceof NamedCache ? (NamedCache)map : null;
        } else if (cache instanceof NearCache) {
            cache = ((NearCache)cache).getBackCache();
        }
        if (cache instanceof SafeNamedCache && !"LocalCache".equals(sType = (service = cache.getCacheService()).getInfo().getServiceType()) && !"ReplicatedCache".equals(sType) && !"OptimisticCache".equals(sType)) {
            serializer = service.getSerializer();
        }
        return serializer;
    }

    @Override
    public String getServiceType() {
        return "RemoteCache";
    }

    public long getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    public boolean isLockEnabled() {
        return this.__m_LockEnabled;
    }

    public boolean isPassThroughEnabled() {
        return this.__m_PassThroughEnabled;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    @Override
    protected void onDependencies(ProxyDependencies deps) {
        super.onDependencies(deps);
        CacheServiceProxyDependencies proxyDeps = (CacheServiceProxyDependencies)deps;
        ParameterizedBuilder<? extends Service> bldrService = proxyDeps.getServiceBuilder();
        if (bldrService == null) {
            XmlElement xml = proxyDeps.getServiceClassConfig();
            if (xml != null) {
                try {
                    this.setCacheService((CacheService)XmlHelper.createInstance(xml, Base.getContextClassLoader(), this, CacheService.class));
                }
                catch (Exception e) {
                    throw CacheServiceProxy.ensureRuntimeException(e);
                }
            }
        } else {
            ResolvableParameterList listParams = new ResolvableParameterList();
            listParams.add(new Parameter("cache-service", this));
            if (bldrService instanceof InstanceBuilder) {
                Iterator iterParams = ((InstanceBuilder)bldrService).getConstructorParameterList().iterator();
                if (iterParams.hasNext()) {
                    iterParams.next();
                }
                while (iterParams.hasNext()) {
                    listParams.add((Parameter)iterParams.next());
                }
            }
            this.setCacheService((CacheService)bldrService.realize(new NullParameterResolver(), Base.getContextClassLoader(), listParams));
        }
        this.setLockEnabled(proxyDeps.isLockEnabled());
        this.setReadOnly(proxyDeps.isReadOnly());
        this.setTransferThreshold(proxyDeps.getTransferThreshold());
    }

    @Override
    public void onInit() {
        this.setConverterFromBinary((ConverterFromBinary)this._findChild("ConverterFromBinary"));
        this.setConverterToBinary((ConverterToBinary)this._findChild("ConverterToBinary"));
        super.onInit();
    }

    @Override
    public void onMessage(Message message) {
        if (message instanceof CacheServiceRequest) {
            CacheServiceRequest request = (CacheServiceRequest)message;
            request.setCacheService(this.getCacheService());
            request.setLockEnabled(this.isLockEnabled());
            request.setReadOnly(this.isReadOnly());
            request.setTransferThreshold(this.getTransferThreshold());
        }
        message.run();
    }

    @Override
    public void releaseCache(NamedCache cache) {
        this.releaseCache(cache, false);
    }

    public void releaseCache(NamedCache cache, boolean fDestroy) {
        if (cache instanceof ConverterCollections.ConverterNamedCache) {
            cache = ((ConverterCollections.ConverterNamedCache)cache).getNamedCache();
        }
        ConfigurableCacheFactory ccf = this.getCacheFactory();
        try {
            if (fDestroy) {
                ccf.destroyCache(cache);
            } else {
                ccf.releaseCache(cache);
            }
        }
        catch (IllegalArgumentException e) {
            NamedCache cacheFront;
            if (this.isPassThroughEnabled() && (cacheFront = ccf.ensureTypedCache(cache.getCacheName(), NullImplementation.getClassLoader(), TypeAssertion.WITHOUT_TYPE_CHECKING)) instanceof NearCache && ((NearCache)cacheFront).getBackCache() == cache) {
                if (fDestroy) {
                    ccf.destroyCache(cacheFront);
                } else {
                    ccf.releaseCache(cacheFront);
                }
                return;
            }
            throw e;
        }
    }

    @Override
    public Object resolveParameter(String sType, String sValue) {
        if (CacheService.class.getName().equals(sType) && "{service}".equals(sValue)) {
            return this;
        }
        return super.resolveParameter(sType, sValue);
    }

    @Override
    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    public void setCacheFactory(ConfigurableCacheFactory factory) {
        this.__m_CacheFactory = factory;
    }

    protected void setCacheService(CacheService service) {
        this.__m_CacheService = service;
    }

    @Override
    public void setConfig(XmlElement xml) {
        this.setDependencies(LegacyXmlCacheServiceProxyHelper.fromXml(xml, new DefaultCacheServiceProxyDependencies()));
    }

    protected void setConverterFromBinary(ConverterFromBinary conv) {
        this.__m_ConverterFromBinary = conv;
    }

    protected void setConverterToBinary(ConverterToBinary conv) {
        this.__m_ConverterToBinary = conv;
    }

    protected void setLockEnabled(boolean fEnabled) {
        this.__m_LockEnabled = fEnabled;
    }

    protected void setNamedCacheSet(Set set) {
        this.__m_NamedCacheSet = set;
    }

    public void setPassThroughEnabled(boolean fEnabled) {
        this.__m_PassThroughEnabled = fEnabled;
    }

    protected void setReadOnly(boolean fReadOnly) {
        this.__m_ReadOnly = fReadOnly;
    }

    @Override
    public void setSerializer(Serializer serializer) {
        super.setSerializer(serializer);
        this.getConverterFromBinary().setSerializer(serializer);
        this.getConverterToBinary().setSerializer(serializer);
    }

    protected void setTransferThreshold(long cb) {
        this.__m_TransferThreshold = cb;
    }

    public static class ConverterFromBinary
    extends com.tangosol.coherence.component.util.Converter {
        public ConverterFromBinary() {
            this(null, null, true);
        }

        public ConverterFromBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterFromBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/serviceProxy/CacheServiceProxy$ConverterFromBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            return o == null ? null : ExternalizableHelper.fromBinary((Binary)o, this.getSerializer());
        }
    }

    public static class ConverterToBinary
    extends com.tangosol.coherence.component.util.Converter {
        public ConverterToBinary() {
            this(null, null, true);
        }

        public ConverterToBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterToBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/serviceProxy/CacheServiceProxy$ConverterToBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            return ExternalizableHelper.toBinary(o, this.getSerializer());
        }
    }
}

