/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.Proxy;
import com.tangosol.coherence.component.net.extend.message.request.NamedCacheRequest;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedCacheFactory;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.proxy.MapListenerProxy;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.collections.WrapperCollection;
import com.tangosol.coherence.component.util.collections.WrapperSet;
import com.tangosol.coherence.component.util.collections.wrapperSet.EntrySet;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.SuspectConnectionException;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NamedCacheProxy
extends Proxy
implements NamedCacheDeactivationListener,
MemberListener,
NamedCache,
Channel.Receiver,
Runnable {
    public static final String ATTR_LISTENER = "named-cache-listener";
    public static final String ATTR_LOCK_MAP = "named-cache-lock-map";
    private Channel __m_Channel;
    private static boolean __s_LockDeprecateWarned;
    private boolean __m_LockEnabled;
    private NamedCache __m_NamedCache;
    private boolean __m_ReadOnly;
    private long __m_TransferThreshold;
    private static ListMap __mapChildren;
    private int m_cacheId;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("CleanupTask", CleanupTask.get_CLASS());
        __mapChildren.put("EntrySet", EntrySet.get_CLASS());
        __mapChildren.put("KeySet", KeySet.get_CLASS());
        __mapChildren.put("Values", Values.get_CLASS());
    }

    public NamedCacheProxy() {
        this(null, null, true);
    }

    public NamedCacheProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setEnabled(true);
            this.setTransferThreshold(524288L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new NamedCacheProxy();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public int getCacheId() {
        return this.m_cacheId;
    }

    public void setCacheId(int cacheId) {
        this.m_cacheId = cacheId;
    }

    public AsyncNamedCache async() {
        return this.getNamedCache().async();
    }

    @Override
    public AsyncNamedCache async(AsyncNamedMap.Option ... options) {
        return this.getNamedCache().async(options);
    }

    private void addIndex$Router(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getNamedCache().addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.assertWriteable();
        this.addIndex$Router(extractor, fOrdered, comparator);
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.getNamedCache().addMapListener(listener);
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.getNamedCache().addMapListener(listener, filter, fLite);
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.getNamedCache().addMapListener(listener, oKey, fLite);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getNamedCache().aggregate(filter, agent);
    }

    @Override
    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        return this.getNamedCache().aggregate(colKeys, agent);
    }

    private void clear$Router() {
        this.getNamedCache().clear();
    }

    @Override
    public void clear() {
        this.assertWriteable();
        this.clear$Router();
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getNamedCache().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getNamedCache().containsValue(oValue);
    }

    private Set entrySet$Router() {
        return this.getNamedCache().entrySet();
    }

    @Override
    public Set entrySet() {
        EntrySet set = (EntrySet)this._newChild("EntrySet");
        set.setSet(this.entrySet$Router());
        return set;
    }

    @Override
    public Set entrySet(Filter filter) {
        return this.getNamedCache().entrySet(filter);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getNamedCache().entrySet(filter, comparator);
    }

    @Override
    public Object get(Object oKey) {
        return this.getNamedCache().get(oKey);
    }

    @Override
    public Map getAll(Collection colKeys) {
        return this.getNamedCache().getAll(colKeys);
    }

    @Override
    public String getCacheName() {
        return this.getNamedCache().getCacheName();
    }

    @Override
    public CacheService getCacheService() {
        return this.getNamedCache().getCacheService();
    }

    private Object invoke$Router(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invoke(oKey, agent);
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invoke$Router(oKey, agent);
    }

    private Map invokeAll$Router(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invokeAll(filter, agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invokeAll$Router(filter, agent);
    }

    private Map invokeAll$Router(Collection colKeys, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invokeAll(colKeys, agent);
    }

    @Override
    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invokeAll$Router(colKeys, agent);
    }

    @Override
    public boolean isActive() {
        return this.getNamedCache().isActive();
    }

    @Override
    public boolean isReady() {
        return this.getNamedCache().isReady();
    }

    @Override
    public boolean isEmpty() {
        return this.getNamedCache().isEmpty();
    }

    private Set keySet$Router() {
        return this.getNamedCache().keySet();
    }

    @Override
    public Set keySet() {
        KeySet set = (KeySet)this._newChild("KeySet");
        set.setSet(this.keySet$Router());
        return set;
    }

    @Override
    public Set keySet(Filter filter) {
        return this.getNamedCache().keySet(filter);
    }

    private boolean lock$Router(Object oKey) {
        return this.getNamedCache().lock(oKey);
    }

    @Override
    public boolean lock(Object oKey) {
        this.assertLockEnabled();
        return this.lock$Router(oKey);
    }

    private boolean lock$Router(Object oKey, long cWait) {
        return this.getNamedCache().lock(oKey, cWait);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        this.printLockDeprecatedMessage();
        this.assertLockEnabled();
        return this.lock$Router(oKey, cWait);
    }

    private Object put$Router(Object oKey, Object oValue) {
        return this.getNamedCache().put(oKey, oValue);
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        this.assertWriteable();
        return this.put$Router(oKey, oValue);
    }

    private Object put$Router(Object oKey, Object oValue, long cMillis) {
        return this.getNamedCache().put(oKey, oValue, cMillis);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        this.assertWriteable();
        return this.put$Router(oKey, oValue, cMillis);
    }

    private void putAll$Router(Map map) {
        this.getNamedCache().putAll(map);
    }

    @Override
    public void putAll(Map map) {
        this.assertWriteable();
        this.putAll$Router(map);
    }

    private Object remove$Router(Object oKey) {
        return this.getNamedCache().remove(oKey);
    }

    @Override
    public Object remove(Object oKey) {
        this.assertWriteable();
        return this.remove$Router(oKey);
    }

    private void removeIndex$Router(ValueExtractor extractor) {
        this.getNamedCache().removeIndex(extractor);
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        this.assertWriteable();
        this.removeIndex$Router(extractor);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.getNamedCache().removeMapListener(listener);
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        this.getNamedCache().removeMapListener(listener, filter);
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        this.getNamedCache().removeMapListener(listener, oKey);
    }

    @Override
    public int size() {
        return this.getNamedCache().size();
    }

    private void truncate$Router() {
        this.getNamedCache().truncate();
    }

    @Override
    public void truncate() {
        this.assertWriteable();
        this.truncate$Router();
    }

    private boolean unlock$Router(Object oKey) {
        return this.getNamedCache().unlock(oKey);
    }

    @Override
    public boolean unlock(Object oKey) {
        this.printLockDeprecatedMessage();
        this.assertLockEnabled();
        return this.unlock$Router(oKey);
    }

    private Collection values$Router() {
        return this.getNamedCache().values();
    }

    @Override
    public Collection values() {
        Values col = (Values)this._newChild("Values");
        col.setCollection(this.values$Router());
        return col;
    }

    public void assertLockEnabled() {
        if (this.isLockEnabled()) {
            return;
        }
        throw new SecurityException("lock operations are prohibited on NamedCache \"" + this.getCacheName() + "\"");
    }

    public void assertWriteable() {
        if (this.isReadOnly()) {
            throw new SecurityException("NamedCache \"" + this.getCacheName() + "\" is read-only");
        }
    }

    protected void closeChannel() {
        Channel channel = this.getChannel();
        if (channel != null) {
            channel.close();
        }
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void entryDeleted(MapEvent evt) {
        if (evt.getKey() == null) {
            if (this.getProtocol().getCurrentVersion() >= 10) {
                if (this.getCacheService().isRunning()) {
                    this.closeChannel();
                }
            } else {
                this.closeChannel();
            }
        }
    }

    @Override
    public void entryInserted(MapEvent evt) {
    }

    @Override
    public void entryUpdated(MapEvent evt) {
        Channel channel = this.getChannel();
        NamedCacheProxy._assert(channel != null);
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory.MapEvent message = (NamedCacheFactory.MapEvent)factory.createMessage(13);
        if (message.getImplVersion() >= 6) {
            message.setTruncate(true);
            try {
                channel.send(message);
            }
            catch (ConnectionException connectionException) {
            }
            catch (Throwable t) {
                NamedCacheProxy._trace(t, "Error sending MapEvent to " + String.valueOf(channel));
            }
        } else {
            this.closeChannel();
        }
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    @Override
    protected String getDescription() {
        String sCacheName = null;
        String sServiceName = null;
        try {
            sCacheName = this.getCacheName();
            sServiceName = this.getCacheService().getInfo().getServiceName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "NamedCache=" + (sCacheName == null ? "N/A" : sCacheName) + ", Service=" + (sServiceName == null ? "N/A" : sServiceName);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    @Override
    public Protocol getProtocol() {
        return NamedCacheProtocol.getInstance();
    }

    public long getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    public static boolean isLockDeprecateWarned() {
        return __s_LockDeprecateWarned;
    }

    public boolean isLockEnabled() {
        return this.__m_LockEnabled;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    @Override
    public void memberJoined(MemberEvent evt) {
    }

    @Override
    public void memberLeaving(MemberEvent evt) {
    }

    @Override
    public void memberLeft(MemberEvent evt) {
        DistributedCacheService service;
        Channel channel = this.getChannel();
        if (channel != null && (service = (DistributedCacheService)evt.getService()).getPartitionOwner(0) == null && service.getOwnershipSenior() == null) {
            if (this.getProtocol().getCurrentVersion() >= 10) {
                Protocol.MessageFactory factory = channel.getMessageFactory();
                NamedCacheFactory.NoStorageMembers message = (NamedCacheFactory.NoStorageMembers)factory.createMessage(56);
                channel.send(message);
            } else {
                this.closeChannel();
            }
        }
    }

    @Override
    public void onMessage(Message message) {
        if (message instanceof NamedCacheRequest) {
            NamedCacheRequest request = (NamedCacheRequest)message;
            request.setNamedCache(this);
            request.setTransferThreshold(this.getTransferThreshold());
        }
        message.run();
    }

    public void printLockDeprecatedMessage() {
        if (!NamedCacheProxy.isLockDeprecateWarned()) {
            NamedCacheProxy._trace("Using the lock API from a Coherence*Extend client is deprecated and will be removed in a future release", 2);
            NamedCacheProxy.setLockDeprecateWarned(true);
        }
    }

    @Override
    public void registerChannel(Channel channel) {
        NamedCacheProxy._assert(this.getChannel() == null);
        NamedCache cache = this.getNamedCache();
        NamedCacheProxy._assert(cache != null);
        MapListenerProxy proxyListener = new MapListenerProxy();
        proxyListener.setChannel(channel);
        channel.setAttribute(ATTR_LISTENER, proxyListener);
        channel.setAttribute(ATTR_LOCK_MAP, new SegmentedConcurrentMap());
        this.setChannel(channel);
        cache.addMapListener(this);
        CacheService service = cache.getCacheService();
        if (service instanceof DistributedCacheService && !((DistributedCacheService)service).isLocalStorageEnabled()) {
            service.addMemberListener(this);
        }
    }

    @Override
    public void release() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run() {
    }

    protected void setChannel(Channel set) {
        this.__m_Channel = set;
    }

    public static void setLockDeprecateWarned(boolean fEnabled) {
        __s_LockDeprecateWarned = fEnabled;
    }

    public void setLockEnabled(boolean fEnabled) {
        this.__m_LockEnabled = fEnabled;
    }

    public void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.__m_ReadOnly = fReadOnly;
    }

    public void setTransferThreshold(long cb) {
        this.__m_TransferThreshold = cb;
    }

    @Override
    public void unregisterChannel(Channel channel) {
        Connection connImpl;
        Throwable t;
        NamedCacheProxy._assert(this.getChannel() == channel);
        NamedCache cache = this.getNamedCache();
        NamedCacheProxy._assert(cache != null);
        MapListenerProxy proxyListener = (MapListenerProxy)channel.getAttribute(ATTR_LISTENER);
        NamedCacheProxy._assert(proxyListener != null);
        cache.removeMapListener(this);
        com.tangosol.net.messaging.Connection conn = channel.getConnection();
        if (conn instanceof Connection && (t = (connImpl = (Connection)conn).getCloseThrowable()) != null && t instanceof SuspectConnectionException && NamedCacheProxy._isTraceEnabled(3)) {
            StringBuilder sb = new StringBuilder(connImpl.toString() + " ");
            ConcurrentMap filterMap = proxyListener.getFilterMap();
            ConcurrentMap keyMap = proxyListener.getKeyMap();
            if (filterMap.isEmpty() && keyMap.isEmpty()) {
                sb.append("At the time it was closed, this suspect connection had no registered listeners");
            } else {
                int nListenerCount;
                sb.append("At the time it was closed, this suspect connection had registered " + keyMap.size() + " key and " + filterMap.size() + " filter listeners, including ");
                if (!filterMap.isEmpty()) {
                    Iterator it = filterMap.keySet().iterator();
                    for (nListenerCount = 0; it.hasNext() && nListenerCount < 50; ++nListenerCount) {
                        Object nextKey = it.next();
                        Object[] nextValue = (Object[])filterMap.get(nextKey);
                        sb.append("{filter=" + String.valueOf(nextKey) + ", Lite event=" + ((Boolean)nextValue[1]).toString() + "}");
                    }
                }
                sb.append(", (" + nListenerCount + "/" + filterMap.size() + " filter listeners logged)");
            }
            if (sb.length() > 0) {
                NamedCacheProxy._trace(sb.toString(), 3);
            }
        }
        CleanupTask task = new CleanupTask();
        task.setProxy(this);
        DaemonPool pool = (DaemonPool)this.getDaemonPool();
        if (pool != null && pool.isStarted()) {
            pool.add(task);
        } else {
            task.run();
        }
        channel.setAttribute(ATTR_LISTENER, null);
        channel.setAttribute(ATTR_LOCK_MAP, null);
        this.setChannel(null);
    }

    static {
        NamedCacheProxy.__initStatic();
    }

    public static class CleanupTask
    extends Collections
    implements Runnable {
        private NamedCacheProxy __m_Proxy;

        public CleanupTask() {
            this(null, null, true);
        }

        public CleanupTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CleanupTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$CleanupTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public NamedCacheProxy getProxy() {
            return this.__m_Proxy;
        }

        @Override
        public void run() {
            NamedCacheProxy proxy = this.getProxy();
            NamedCache cache = proxy.getNamedCache();
            Channel channel = proxy.getChannel();
            MapListenerProxy proxyListener = (MapListenerProxy)channel.getAttribute(NamedCacheProxy.ATTR_LISTENER);
            Map mapLock = (Map)channel.getAttribute(NamedCacheProxy.ATTR_LOCK_MAP);
            try {
                proxyListener.removeListener(proxy);
                Iterator iter = mapLock.keySet().iterator();
                while (iter.hasNext()) {
                    cache.unlock(iter.next());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public void setProxy(NamedCacheProxy pool) {
            this.__m_Proxy = pool;
        }
    }

    public static class EntrySet
    extends com.tangosol.coherence.component.util.collections.wrapperSet.EntrySet {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Entry", Entry.get_CLASS());
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public EntrySet() {
            this(null, null, true);
        }

        public EntrySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EntrySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$EntrySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            EntrySet.__initStatic();
        }

        public static class Entry
        extends EntrySet.Entry {
            public Entry() {
                this(null, null, true);
            }

            public Entry(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Entry();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$EntrySet$Entry".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class Iterator
        extends EntrySet.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$EntrySet$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class KeySet
    extends com.tangosol.coherence.component.util.collections.wrapperSet.KeySet {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public KeySet() {
            this(null, null, true);
        }

        public KeySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$KeySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean remove(Object o) {
            ((NamedCacheProxy)this.get_Module()).assertWriteable();
            return super.remove(o);
        }

        @Override
        public boolean removeAll(Collection col) {
            ((NamedCacheProxy)this.get_Module()).assertWriteable();
            return KeySet.removeAll(this, col);
        }

        public static boolean removeAll(Collection colThis, Collection colThat) {
            boolean fModified = false;
            java.util.Iterator iter = colThat.iterator();
            while (iter.hasNext()) {
                fModified |= colThis.remove(iter.next());
            }
            return fModified;
        }

        static {
            KeySet.__initStatic();
        }

        public static class Iterator
        extends WrapperSet.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$KeySet$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class Values
    extends WrapperCollection {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public Values() {
            this(null, null, true);
        }

        public Values(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Values();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$Values".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            Values.__initStatic();
        }

        public static class Iterator
        extends WrapperCollection.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/NamedCacheProxy$Values$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

