/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Message;
import com.tangosol.coherence.component.net.extend.Proxy;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedCacheFactory;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SegmentedHashSet;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.InKeySetFilter;
import java.util.Iterator;
import java.util.Set;

public class MapListenerProxy
extends Proxy
implements MapListenerSupport.SynchronousListener {
    private Channel __m_Channel;
    private ConcurrentMap __m_FilterMap;
    private ConcurrentMap __m_KeyMap;
    private Set __m_KeySet;
    protected static final int LITE = 1;
    protected static final int PRIMING = 2;
    private MapListener __m_PrimingListener;

    public MapListenerProxy() {
        this(null, null, true);
    }

    public MapListenerProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setEnabled(true);
            this.setFilterMap(new SegmentedConcurrentMap());
            this.setKeyMap(new SegmentedConcurrentMap());
            this.setKeySet(new SegmentedHashSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new MapListenerProxy();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/proxy/MapListenerProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(NamedCache cache, Filter filter, long lFilterId, boolean fLite, boolean fPriming) {
        MapListenerProxy._assert(lFilterId > 0L);
        if (filter instanceof InKeySetFilter) {
            InKeySetFilter filterKeys = (InKeySetFilter)filter;
            for (Binary binKey : filterKeys.getKeys()) {
                this.addListener(cache, binKey, fLite, fPriming, false);
            }
            filterKeys.markConverted();
            cache.addMapListener(fPriming ? this.getPrimingListener() : this, filterKeys, fLite);
        } else {
            if (fPriming) {
                throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
            }
            ConcurrentMap map = this.getFilterMap();
            map.lock(filter, -1L);
            try {
                map.put(filter, new Object[]{lFilterId, fLite});
                cache.addMapListener(this, filter, fLite);
            }
            finally {
                map.unlock(filter);
            }
        }
    }

    public void addListener(NamedCache cache, Object oKey, boolean fLite, boolean fPriming) {
        this.addListener(cache, oKey, fLite, fPriming, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(NamedCache cache, Object oKey, boolean fLite, boolean fPriming, boolean fRegister) {
        Object oKeyDown = oKey;
        if (cache instanceof NamedCacheProxy) {
            oKey = this.normalizeKey(oKey);
        }
        ConcurrentMap map = this.getKeyMap();
        map.lock(oKey, -1L);
        try {
            int nFlags = fLite ? 1 : 0;
            nFlags |= fPriming ? 2 : nFlags;
            if (map.containsKey(oKey)) {
                nFlags = (Integer)map.get(oKey);
                if ((nFlags & 2) == 2) {
                    fRegister = false;
                }
                if (fPriming) {
                    fRegister = false;
                    Channel channel = this.getChannel();
                    Protocol.MessageFactory factory = channel.getMessageFactory();
                    NamedCacheFactory.MapEvent message = (NamedCacheFactory.MapEvent)factory.createMessage(13);
                    message.setId(74);
                    message.setKey(oKey);
                    message.setSynthetic(true);
                    message.setTransformationState(CacheEvent.TransformationState.TRANSFORMABLE.ordinal());
                    message.setPriming(true);
                    message.setValueNew(cache.get(oKey));
                    channel.send(message);
                    nFlags |= 2;
                    fRegister = false;
                }
                if (!fLite) {
                    nFlags &= 0xFFFFFFFE;
                    fRegister = true;
                }
            }
            map.put(oKey, nFlags);
            this.getKeySet().add(oKeyDown);
            if (fRegister) {
                cache.addMapListener(fPriming ? this.getPrimingListener() : this, oKeyDown, fLite);
            }
        }
        finally {
            map.unlock(oKey);
        }
    }

    @Override
    public void entryDeleted(MapEvent evt) {
        this.onMapEvent(evt);
    }

    @Override
    public void entryInserted(MapEvent evt) {
        this.onMapEvent(evt);
    }

    @Override
    public void entryUpdated(MapEvent evt) {
        this.onMapEvent(evt);
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    public ConcurrentMap getFilterMap() {
        return this.__m_FilterMap;
    }

    public ConcurrentMap getKeyMap() {
        return this.__m_KeyMap;
    }

    public Set getKeySet() {
        return this.__m_KeySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapListener getPrimingListener() {
        MapListenerSupport.WrapperPrimingListener listener = (MapListenerSupport.WrapperPrimingListener)this.__m_PrimingListener;
        if (listener == null) {
            MapListenerProxy mapListenerProxy = this;
            synchronized (mapListenerProxy) {
                listener = (MapListenerSupport.WrapperPrimingListener)this.__m_PrimingListener;
                if (listener == null) {
                    listener = new MapListenerSupport.WrapperPrimingListener((MapListener)this);
                    this.setPrimingListener(listener);
                }
            }
        }
        return listener;
    }

    protected Message[] instantiateMapEventMessages(MapEvent evt) {
        Message[] aMessages;
        Channel channel;
        Protocol.MessageFactory factory;
        int nId = evt.getId();
        Object oKey = evt.getKey();
        Integer NFlags = (Integer)this.getKeyMap().get(oKey);
        boolean fKeyLite = NFlags == null || (NFlags & 1) != 0;
        boolean fPriming = NFlags != null && (NFlags & 2) != 0;
        int cFilters = 0;
        long[] alFilterIds = null;
        boolean[] afFilterLite = null;
        boolean fFilterLite = true;
        CacheEvent evtCache = evt instanceof CacheEvent ? (CacheEvent)evt : null;
        boolean fSynthetic = evtCache != null && evtCache.isSynthetic();
        boolean fExpired = evtCache != null && evtCache.isExpired();
        ConcurrentMap mapFilters = this.getFilterMap();
        MapEvent evtUnwrapped = MapListenerSupport.unwrapEvent(evt);
        if (evtUnwrapped instanceof MapListenerSupport.FilterEvent) {
            Filter[] aFilters = ((MapListenerSupport.FilterEvent)evtUnwrapped).getFilter();
            cFilters = aFilters.length;
            alFilterIds = new long[cFilters];
            afFilterLite = new boolean[cFilters];
            for (int i = 0; i < cFilters; ++i) {
                Object[] ao = (Object[])mapFilters.get(aFilters[i]);
                if (ao == null) continue;
                long lId = (Long)ao[0];
                boolean fLite = (Boolean)ao[1];
                alFilterIds[i] = lId;
                afFilterLite[i] = fLite;
                if (fLite) continue;
                fFilterLite = false;
            }
        } else {
            Object[] ao = (Object[])mapFilters.get(null);
            if (ao != null) {
                long lId = (Long)ao[0];
                boolean fLite = (Boolean)ao[1];
                cFilters = 1;
                alFilterIds = new long[]{lId};
                afFilterLite = new boolean[]{fLite};
                fFilterLite = fLite;
            }
        }
        if ((factory = (channel = this.getChannel()).getMessageFactory()).getVersion() > 3 || cFilters == 0) {
            NamedCacheFactory.MapEvent message = (NamedCacheFactory.MapEvent)factory.createMessage(13);
            message.setId(nId);
            message.setFilterIds(alFilterIds);
            message.setKey(oKey);
            message.setSynthetic(fSynthetic);
            message.setExpired(fExpired);
            if (!fKeyLite || !fFilterLite || fPriming) {
                message.setValueNew(evt.getNewValue());
                if (!fPriming) {
                    message.setValueOld(evt.getOldValue());
                }
            }
            message.setTransformationState((evtCache == null ? CacheEvent.TransformationState.TRANSFORMABLE : evtCache.getTransformationState()).ordinal());
            message.setPriming(evtCache != null && evtCache.isPriming());
            aMessages = new NamedCacheFactory.MapEvent[]{message};
        } else {
            aMessages = new NamedCacheFactory.MapEvent[cFilters];
            for (int i = 0; i < cFilters; ++i) {
                NamedCacheFactory.MapEvent message = (NamedCacheFactory.MapEvent)factory.createMessage(13);
                message.setId(nId);
                message.setKey(oKey);
                message.setFilterId(alFilterIds[i]);
                message.setSynthetic(fSynthetic);
                message.setExpired(fExpired);
                if (!afFilterLite[i]) {
                    message.setValueNew(evt.getNewValue());
                    message.setValueOld(evt.getOldValue());
                }
                aMessages[i] = message;
            }
        }
        return aMessages;
    }

    protected Object normalizeKey(Object oKey) {
        Binary binKey;
        if (oKey instanceof Binary && ExternalizableHelper.isIntDecorated(binKey = (Binary)oKey)) {
            oKey = ExternalizableHelper.removeIntDecoration(binKey);
        }
        return oKey;
    }

    public void onMapEvent(MapEvent evt) {
        Channel channel = this.getChannel();
        MapListenerProxy._assert(channel != null);
        Message[] aMessages = this.instantiateMapEventMessages(evt);
        try {
            int c = aMessages.length;
            for (int i = 0; i < c; ++i) {
                channel.send(aMessages[i]);
            }
        }
        catch (ConnectionException i) {
        }
        catch (Throwable t) {
            MapListenerProxy._trace(t, "Error sending MapEvent to " + String.valueOf(channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(NamedCache cache) {
        ConcurrentMap map = this.getFilterMap();
        map.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            for (Filter filter : map.keySet()) {
                cache.removeMapListener(this, filter);
            }
            map.clear();
        }
        finally {
            map.unlock(ConcurrentMap.LOCK_ALL);
        }
        map = this.getKeyMap();
        map.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            Set set = this.getKeySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Integer NFlags;
                Object oKey;
                Object oKeyDown = oKey = iter.next();
                if (cache instanceof NamedCacheProxy) {
                    oKey = this.normalizeKey(oKey);
                }
                boolean fPriming = (NFlags = (Integer)map.remove(oKey)) != null && (NFlags & 2) != 0;
                cache.removeMapListener(fPriming ? this.getPrimingListener() : this, oKeyDown);
            }
            set.clear();
        }
        finally {
            map.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(NamedCache cache, Filter filter, boolean fPriming) {
        if (filter instanceof InKeySetFilter) {
            InKeySetFilter filterKeys = (InKeySetFilter)filter;
            for (Binary binKey : filterKeys.getKeys()) {
                this.removeListener(cache, binKey, fPriming, false);
            }
            filterKeys.markConverted();
            cache.removeMapListener(fPriming ? this.getPrimingListener() : this, filterKeys);
        } else {
            if (fPriming) {
                throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
            }
            ConcurrentMap map = this.getFilterMap();
            map.lock(filter, -1L);
            try {
                if (map.remove(filter) != null) {
                    cache.removeMapListener(this, filter);
                }
            }
            finally {
                map.unlock(filter);
            }
        }
    }

    public void removeListener(NamedCache cache, Object oKey, boolean fPriming) {
        this.removeListener(cache, oKey, fPriming, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListener(NamedCache cache, Object oKey, boolean fPriming, boolean fUnregister) {
        Object oKeyDown = oKey;
        if (cache instanceof NamedCacheProxy) {
            oKey = this.normalizeKey(oKey);
        }
        ConcurrentMap map = this.getKeyMap();
        map.lock(oKey, -1L);
        try {
            Integer NFlags = (Integer)map.remove(oKey);
            if (NFlags != null) {
                int nFlags = NFlags;
                fPriming &= (nFlags & 2) == 2;
                if (this.getKeySet().remove(oKeyDown)) {
                    if (fUnregister) {
                        cache.removeMapListener(fPriming ? this.getPrimingListener() : this, oKeyDown);
                    }
                } else {
                    MapListenerProxy._assert(false);
                }
            }
        }
        finally {
            map.unlock(oKey);
        }
    }

    public void setChannel(Channel channel) {
        MapListenerProxy._assert(this.getChannel() == null);
        this.__m_Channel = channel;
    }

    protected void setFilterMap(ConcurrentMap map) {
        this.__m_FilterMap = map;
    }

    protected void setKeyMap(ConcurrentMap map) {
        this.__m_KeyMap = map;
    }

    protected void setKeySet(Set set) {
        this.__m_KeySet = set;
    }

    public void setPrimingListener(MapListener sProperty) {
        this.__m_PrimingListener = sProperty;
    }
}

