/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.message.request;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.message.Request;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class NamedCacheRequest
extends Request {
    private transient NamedCache __m_NamedCache;
    private transient long __m_TransferThreshold;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Status", Request.Status.get_CLASS());
    }

    public NamedCacheRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/message/request/NamedCacheRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected int calculateBatchSize(int cPart, int cb) {
        int cBatch = cb == 0 ? cPart : (int)(this.getTransferThreshold() / (long)cb);
        cBatch = Math.max(cBatch, 1);
        cBatch = Math.min(cBatch, cPart);
        return cBatch;
    }

    protected int calculateBinarySize(Collection col, boolean fEntries) {
        int cb = 0;
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                if (fEntries) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    cb += ((Binary)entry.getKey()).length();
                    cb += ((Binary)entry.getValue()).length();
                    continue;
                }
                cb += ((Binary)iter.next()).length();
            }
        }
        return cb;
    }

    protected PartitionSet createPartitionSet() {
        int cPart;
        CacheService service = this.getNamedCache().getCacheService();
        if (service instanceof PartitionedService) {
            cPart = ((PartitionedService)((Object)service)).getPartitionCount();
        } else {
            XmlElement xml = null;
            if (service instanceof SafeCacheService) {
                xml = ((SafeCacheService)service).getConfig();
            } else if (service instanceof XmlConfigurable) {
                xml = ((XmlConfigurable)((Object)service)).getConfig();
            }
            cPart = 17;
            if (xml != null) {
                cPart = xml.getSafeElement("partition-count").getInt(cPart);
            }
        }
        PartitionSet parts = new PartitionSet(cPart);
        parts.fill();
        return parts;
    }

    protected Object[] decodeCookie(Binary bin) {
        int n;
        PartitionSet parts;
        if (bin == null) {
            parts = this.createPartitionSet();
            n = 0;
        } else {
            ReadBuffer.BufferInput bi = bin.getBufferInput();
            try {
                parts = new PartitionSet();
                parts.readExternal(bi);
                n = bi.readPackedInt();
            }
            catch (IOException e) {
                throw NamedCacheRequest.ensureRuntimeException(e, "error decoding cookie");
            }
        }
        return new Object[]{parts, Base.makeInteger(n)};
    }

    protected Binary encodeCookie(PartitionSet parts, int n) {
        if (parts.isEmpty()) {
            return null;
        }
        WriteBuffer.BufferOutput bo = new BinaryWriteBuffer(64).getBufferOutput();
        try {
            parts.writeExternal(bo);
            bo.writePackedInt(n);
        }
        catch (IOException e) {
            throw NamedCacheRequest.ensureRuntimeException(e, "error encoding cookie");
        }
        return bo.getBuffer().toBinary();
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    public long getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    protected PartitionSet removePartitionBatch(PartitionSet partsRemain, int cBatch) {
        PartitionSet partsBatch;
        int cPartsAll = partsRemain.getPartitionCount();
        int cPartsRemain = partsRemain.cardinality();
        if (cPartsRemain <= cBatch) {
            partsBatch = new PartitionSet(partsRemain);
            partsRemain.clear();
        } else {
            partsBatch = new PartitionSet(cPartsAll);
            CacheService service = this.getNamedCache().getCacheService();
            if (service instanceof PartitionedService) {
                int c;
                PartitionedService svcPartitioned = (PartitionedService)((Object)service);
                for (int cBatchLeft = cBatch; !partsRemain.isEmpty() && cBatchLeft > 0; cBatchLeft -= c) {
                    int nPart = partsRemain.rnd();
                    Member member = null;
                    for (int i = 0; i < cPartsRemain && (member = svcPartitioned.getPartitionOwner(nPart)) == null; ++i) {
                        nPart = partsRemain.next(nPart);
                    }
                    if (member == null) break;
                    PartitionSet parts = svcPartitioned.getOwnedPartitions(member);
                    parts.retain(partsRemain);
                    for (c = parts.cardinality(); c > cBatchLeft; --c) {
                        parts.removeNext(0);
                    }
                    partsBatch.add(parts);
                    partsRemain.remove(parts);
                }
            }
            if (partsBatch.isEmpty()) {
                int nPart = partsRemain.rnd();
                while (--cBatch >= 0 && (nPart = partsRemain.removeNext(nPart)) >= 0) {
                    partsBatch.add(nPart);
                }
            }
        }
        return partsBatch;
    }

    public void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void setTransferThreshold(long cb) {
        this.__m_TransferThreshold = cb;
    }

    static {
        NamedCacheRequest.__initStatic();
    }
}

