/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.Message;
import com.tangosol.coherence.component.net.extend.message.Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Request
extends Message
implements com.tangosol.net.messaging.Request {
    private long __m_Id;
    private transient com.tangosol.net.messaging.Response __m_Response;
    private transient Request.Status __m_Status;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Status", Status.get_CLASS());
    }

    public Request(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/message/Request".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public com.tangosol.net.messaging.Response ensureResponse() {
        com.tangosol.net.messaging.Response response = this.getResponse();
        if (response == null) {
            com.tangosol.net.messaging.Channel channel = this.getChannel();
            Request._assert(channel != null);
            Protocol.MessageFactory factory = channel.getMessageFactory();
            Request._assert(factory != null);
            response = this.instantiateResponse(factory);
            this.setResponse(response);
        }
        return response;
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", Id=" + this.getId() + ", Status=" + String.valueOf(this.getStatus());
    }

    @Override
    public long getId() {
        return this.__m_Id;
    }

    protected com.tangosol.net.messaging.Response getResponse() {
        return this.__m_Response;
    }

    @Override
    public Request.Status getStatus() {
        return this.__m_Status;
    }

    protected Response instantiateResponse(Protocol.MessageFactory factory) {
        return (Response)factory.createMessage(0);
    }

    public boolean isIncoming() {
        return this.getStatus() == null;
    }

    protected void onException(RuntimeException e) {
        if (this.isIncoming() && Request._isTraceEnabled(5)) {
            Peer manager = (Peer)this.getChannel().getConnection().getConnectionManager();
            Request._trace("An exception occurred while processing a " + this.get_Name() + " for Service=" + manager.getServiceName() + ": " + Request.getStackTrace(e), 5);
        }
    }

    protected void onRun(Response response) {
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.setId(in.readLong(0));
    }

    @Override
    public final void run() {
        Response response = (Response)this.ensureResponse();
        try {
            this.onRun(response);
        }
        catch (RuntimeException e) {
            this.onException(e);
            response.setFailure(true);
            response.setResult(e);
        }
    }

    @Override
    public void setId(long lId) {
        this.__m_Id = lId;
    }

    protected void setResponse(com.tangosol.net.messaging.Response response) {
        Request._assert(this.getResponse() == null);
        this.__m_Response = response;
    }

    @Override
    public void setStatus(Request.Status status) {
        Request._assert(status != null);
        if (this.getStatus() != null) {
            throw new IllegalStateException();
        }
        this.__m_Status = status;
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeLong(0, this.getId());
    }

    static {
        Request.__initStatic();
    }

    public static class Status
    extends Extend
    implements Request.Status {
        private volatile Channel __m_Channel;
        private volatile boolean __m_Closed;
        private long __m_DefaultTimeoutMillis;
        private Throwable __m_Error;
        private volatile long __m_InitTimeMillis;
        private volatile com.tangosol.net.messaging.Request __m_Request;
        private volatile com.tangosol.net.messaging.Response __m_Response;
        private final Lock __m_Lock = new ReentrantLock();
        private final Condition __m_Completed = this.__m_Lock.newCondition();

        public Status() {
            this(null, null, true);
        }

        public Status(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Status();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/message/Request$Status".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void cancel() {
            this.cancel(null);
        }

        @Override
        public void cancel(Throwable cause) {
            Channel channel;
            if (cause == null) {
                cause = new RuntimeException("Request was canceled");
            }
            this.lock();
            try {
                if (this.isClosed()) {
                    channel = null;
                } else {
                    channel = this.getChannel();
                    this.setError(cause);
                    this.onCompletion();
                }
            }
            finally {
                this.unlock();
            }
            if (channel != null) {
                channel.onRequestCompleted(this);
            }
        }

        public Channel getChannel() {
            return this.__m_Channel;
        }

        public long getDefaultTimeoutMillis() {
            return this.__m_DefaultTimeoutMillis;
        }

        @Override
        protected String getDescription() {
            StringBuffer sb = new StringBuffer();
            boolean fClosed = this.isClosed();
            sb.append("InitTimeMillis=").append(this.getInitTimeMillis()).append(", Closed=").append(fClosed);
            if (fClosed) {
                Throwable t = this.getError();
                if (t == null) {
                    sb.append(", Response=").append(this.getResponse());
                } else {
                    sb.append(", Error=").append(t);
                }
            }
            return sb.toString();
        }

        public Throwable getError() {
            return this.__m_Error;
        }

        public long getInitTimeMillis() {
            return this.__m_InitTimeMillis;
        }

        @Override
        public com.tangosol.net.messaging.Request getRequest() {
            return this.__m_Request;
        }

        @Override
        public com.tangosol.net.messaging.Response getResponse() {
            Throwable t = this.getError();
            if (t == null) {
                return this.__m_Response;
            }
            throw Status.ensureRuntimeException(t);
        }

        @Override
        public boolean isClosed() {
            return this.__m_Closed;
        }

        protected void onCompletion() {
            this.setClosed(true);
            this.__m_Completed.signalAll();
        }

        @Override
        public void onInit() {
            this.setInitTimeMillis(System.currentTimeMillis());
        }

        public void setChannel(Channel channel) {
            Status._assert(!this.isClosed() && channel != null && this.getChannel() == null);
            this.__m_Channel = channel;
        }

        protected void setClosed(boolean fClosed) {
            this.__m_Closed = fClosed;
        }

        public void setDefaultTimeoutMillis(long cMillis) {
            this.__m_DefaultTimeoutMillis = cMillis;
        }

        protected void setError(Throwable cause) {
            this.__m_Error = cause;
        }

        protected void setInitTimeMillis(long cMillis) {
            this.__m_InitTimeMillis = cMillis;
        }

        public void setRequest(com.tangosol.net.messaging.Request request) {
            Status._assert(!this.isClosed() && request != null && this.getRequest() == null);
            this.__m_Request = request;
        }

        public void setResponse(com.tangosol.net.messaging.Response response) {
            Channel channel;
            Status._assert(response != null);
            this.lock();
            try {
                if (this.isClosed()) {
                    channel = null;
                } else {
                    channel = this.getChannel();
                    Status._assert(this.getResponse() == null);
                    this.__m_Response = response;
                    this.onCompletion();
                }
            }
            finally {
                this.unlock();
            }
            if (channel != null) {
                channel.onRequestCompleted(this);
            }
        }

        @Override
        public com.tangosol.net.messaging.Response waitForResponse() {
            return this.waitForResponse(-1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public com.tangosol.net.messaging.Response waitForResponse(long cMillis) {
            block14: {
                if (cMillis == -1L) {
                    cMillis = this.getDefaultTimeoutMillis();
                }
                try {
                    if (cMillis <= 0L) {
                        this.getChannel().getConnectionManager().drainOverflow(0L);
                        this.lock();
                        try {
                            while (!this.isClosed()) {
                                this.__m_Completed.await();
                            }
                            break block14;
                        }
                        finally {
                            this.unlock();
                        }
                    }
                    long cRemain = this.getChannel().getConnectionManager().drainOverflow(cMillis);
                    this.lock();
                    try {
                        long ldtStart = -1L;
                        while (!this.isClosed()) {
                            if (ldtStart < 0L) {
                                ldtStart = Base.getSafeTimeMillis();
                            }
                            this.__m_Completed.await(cRemain, TimeUnit.MILLISECONDS);
                            if (this.isClosed()) {
                                break;
                            }
                            if ((cRemain -= Base.getSafeTimeMillis() - ldtStart) > 0L) continue;
                            throw new RequestTimeoutException("Request timed out");
                        }
                    }
                    finally {
                        this.unlock();
                    }
                }
                catch (Exception e) {
                    this.cancel(e);
                    if (!(e instanceof InterruptedException)) break block14;
                    Thread.currentThread().interrupt();
                    throw new WrapperException(e, "Request interrupted");
                }
            }
            return this.getResponse();
        }

        public void lock() {
            this.__m_Lock.lock();
        }

        public void unlock() {
            this.__m_Lock.unlock();
        }
    }
}

