/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteNameService;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteNameServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.LegacyXmlRemoteNameServiceHelper;
import com.tangosol.internal.net.service.extend.remote.LegacyXmlRemoteServiceHelper;
import com.tangosol.internal.net.service.extend.remote.RemoteServiceDependencies;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.CompositeSocketAddressProvider;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Listeners;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import java.util.Collections;
import java.util.Set;
import java.util.function.IntPredicate;

public abstract class RemoteService
extends Extend
implements Service,
ServiceInfo,
ConnectionListener,
ServiceListener {
    private volatile com.tangosol.net.messaging.Channel __m_Channel;
    private Cluster __m_Cluster;
    private ClassLoader __m_ContextClassLoader;
    private ServiceDependencies __m_Dependencies;
    private volatile ConnectionInitiator __m_Initiator;
    private Listeners __m_MemberListeners;
    private boolean __m_NameServiceAddressProvider;
    private OperationalContext __m_OperationalContext;
    private ResourceRegistry __m_ResourceRegistry;
    private String __m_ScopeName;
    private Listeners __m_ServiceListeners;
    private String __m_ServiceName;
    private String __m_ServiceVersion;
    private Object __m_UserContext;

    public RemoteService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public void addMemberListener(MemberListener listener) {
        this.getMemberListeners().add(listener);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        this.getServiceListeners().add(listener);
    }

    protected DefaultRemoteServiceDependencies cloneDependencies(RemoteServiceDependencies deps) {
        return new DefaultRemoteServiceDependencies(deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        RemoteService._assert(!this.isRunning());
        this.doConfigure(xml);
    }

    @Override
    public void connectionClosed(ConnectionEvent evt) {
        this.setChannel(null);
        this.dispatchMemberEvent(2);
        this.dispatchMemberEvent(3);
    }

    @Override
    public void connectionError(ConnectionEvent evt) {
        this.setChannel(null);
        this.dispatchMemberEvent(2);
        this.dispatchMemberEvent(3);
    }

    @Override
    public void connectionOpened(ConnectionEvent evt) {
        this.dispatchMemberEvent(1);
    }

    protected void dispatchMemberEvent(int nId) {
        Listeners listeners = this.getMemberListeners();
        if (!listeners.isEmpty()) {
            new MemberEvent(this, nId, this.getLocalMember()).dispatch(listeners);
        }
    }

    protected void dispatchServiceEvent(int nId) {
        Listeners listeners = this.getServiceListeners();
        if (!listeners.isEmpty()) {
            new ServiceEvent(this, nId).dispatch(listeners);
        }
    }

    protected void doConfigure(XmlElement xml) {
        this.setDependencies(LegacyXmlRemoteServiceHelper.fromXml(xml, new DefaultRemoteServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
    }

    protected void doShutdown() {
        this.getInitiator().shutdown();
    }

    protected void doStart() {
        ConnectionInitiator initiator = this.getInitiator();
        RemoteService._assert(initiator != null);
        initiator.addConnectionListener(this);
        initiator.addServiceListener(this);
        initiator.setContextClassLoader(this.getContextClassLoader());
        initiator.start();
        this.ensureChannel();
    }

    protected void doStop() {
        this.getInitiator().stop();
    }

    protected synchronized com.tangosol.net.messaging.Channel ensureChannel() {
        com.tangosol.net.messaging.Channel channel = this.getChannel();
        if (channel == null || !channel.isOpen()) {
            channel = this.openChannel();
            this.setChannel(channel);
        }
        return channel;
    }

    protected QueueProcessor ensureEventDispatcher() {
        Channel channel = (Channel)this.ensureChannel();
        return channel.getConnectionManager().ensureEventDispatcher();
    }

    public com.tangosol.net.messaging.Channel getChannel() {
        return this.__m_Channel;
    }

    @Override
    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    @Override
    public ServiceDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    @Override
    protected String getDescription() {
        return "Name=" + this.getServiceName();
    }

    @Override
    public ServiceInfo getInfo() {
        return this;
    }

    public ConnectionInitiator getInitiator() {
        return this.__m_Initiator;
    }

    protected Member getLocalMember() {
        OperationalContext ctx = this.getOperationalContext();
        return ctx == null ? null : ctx.getLocalMember();
    }

    protected Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    @Override
    public Member getOldestMember() {
        return this.getLocalMember();
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public String getRemoteClusterName() {
        String sName = ((RemoteServiceDependencies)this.getDependencies()).getRemoteClusterName();
        if (sName == null || sName.isEmpty()) {
            return this.isNameServiceAddressProvider() ? this.getOperationalContext().getLocalMember().getClusterName() : null;
        }
        return sName;
    }

    public String getRemoteServiceName() {
        String sName = ((RemoteServiceDependencies)this.getDependencies()).getRemoteServiceName();
        if (sName == null || sName.isEmpty()) {
            return this.isNameServiceAddressProvider() ? this.getServiceName() : null;
        }
        String sScopeName = this.getScopeName();
        return sScopeName == null || sScopeName.length() == 0 ? sName : sScopeName + ":" + sName;
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    public String getScopeName() {
        return this.__m_ScopeName;
    }

    @Override
    public Serializer getSerializer() {
        ConnectionManager manager;
        Connection connection = this.ensureChannel().getConnection();
        if (connection != null && (manager = connection.getConnectionManager()) instanceof com.tangosol.coherence.component.util.daemon.queueProcessor.Service) {
            return ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)((Object)manager)).getSerializer();
        }
        return null;
    }

    protected Listeners getServiceListeners() {
        return this.__m_ServiceListeners;
    }

    @Override
    public Member getServiceMember(int nId) {
        Member member = this.getLocalMember();
        if (member != null && member.getId() == nId) {
            return member;
        }
        return null;
    }

    @Override
    public Set getServiceMembers() {
        Member member = this.getLocalMember();
        return member == null ? Collections.EMPTY_SET : Collections.singleton(member);
    }

    @Override
    public String getServiceName() {
        return this.__m_ServiceName;
    }

    @Override
    public String getServiceType() {
        return null;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    @Override
    public String getServiceVersion(Member member) {
        return this.getServiceVersion();
    }

    @Override
    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public boolean isNameServiceAddressProvider() {
        return this.__m_NameServiceAddressProvider;
    }

    @Override
    public boolean isRunning() {
        ConnectionInitiator initiator = this.getInitiator();
        return initiator == null ? false : initiator.isRunning();
    }

    public boolean isServiceThread(boolean fStrict) {
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator instanceof Initiator) {
            return ((Initiator)initiator).isServiceThread(fStrict);
        }
        return false;
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupProxyServiceAddress() {
        ConnectionInitiator initiator;
        if (this.isNameServiceAddressProvider() && (initiator = this.getInitiator()) instanceof TcpInitiator) {
            RemoteServiceDependencies deps = (RemoteServiceDependencies)this.getDependencies();
            TcpInitiator tcpInitiator = (TcpInitiator)initiator;
            RemoteNameService serviceNS = new RemoteNameService();
            serviceNS.setOperationalContext(this.getOperationalContext());
            serviceNS.setContextClassLoader(this.getContextClassLoader());
            serviceNS.setServiceName(this.getServiceName() + ":RemoteNameService");
            DefaultRemoteNameServiceDependencies nameServiceDeps = LegacyXmlRemoteNameServiceHelper.fromXml(CacheFactory.getServiceConfig("RemoteNameService"), new DefaultRemoteNameServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader());
            DefaultTcpInitiatorDependencies depsNsTcp = new DefaultTcpInitiatorDependencies((TcpInitiatorDependencies)deps.getInitiatorDependencies());
            depsNsTcp.setSocketProviderBuilder(new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER, false));
            nameServiceDeps.setInitiatorDependencies(depsNsTcp);
            String sClusterRemote = this.getRemoteClusterName();
            String sServiceRemote = this.getRemoteServiceName();
            nameServiceDeps.setRemoteClusterName(sClusterRemote);
            nameServiceDeps.setRemoteServiceName("NameService");
            serviceNS.setDependencies(nameServiceDeps);
            ConnectionException e = null;
            try {
                tcpInitiator.getCloseOnExit().add(serviceNS);
                serviceNS.start();
                Object[] ao = (Object[])serviceNS.lookup(sServiceRemote);
                if (ao == null) {
                    e = new ConnectionException("Unable to locate ProxyService '" + sServiceRemote + "' within cluster '" + sClusterRemote + "'");
                } else {
                    tcpInitiator.setRemoteAddressProvider(new CompositeSocketAddressProvider(new InetSocketAddress32((String)ao[0], (int)((Integer)ao[1]))));
                }
            }
            catch (Exception ex) {
                e = new ConnectionException("Unable to locate cluster '" + sClusterRemote + "' while looking for its ProxyService '" + sServiceRemote + "'", ex);
            }
            finally {
                tcpInitiator.getCloseOnExit().remove(serviceNS);
                serviceNS.stop();
            }
            if (e != null) {
                throw e;
            }
        }
    }

    protected void onDependencies(RemoteServiceDependencies deps) {
        ConnectionInitiator initiator;
        OperationalContext ctx = this.getOperationalContext();
        if (ctx == null) {
            throw new IllegalStateException("missing required OperationalContext");
        }
        InitiatorDependencies initiatorDeps = deps.getInitiatorDependencies();
        if (initiatorDeps instanceof TcpInitiatorDependencies) {
            this.setNameServiceAddressProvider(((TcpInitiatorDependencies)initiatorDeps).isNameServiceAddressProvider());
        }
        if ((initiator = Initiator.createInitiator(initiatorDeps, this.getOperationalContext())) instanceof Initiator) {
            Initiator initiatorImpl = (Initiator)initiator;
            initiatorImpl.setServiceName(this.getServiceName() + ":" + initiatorImpl.getServiceName());
            initiatorImpl.setParentService(this);
        }
        this.setInitiator(initiator);
    }

    protected com.tangosol.net.messaging.Channel openChannel() {
        return null;
    }

    protected void prepareExit() {
    }

    @Override
    public void removeMemberListener(MemberListener listener) {
        this.getMemberListeners().remove(listener);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.getServiceListeners().remove(listener);
    }

    @Override
    public void serviceStarted(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
    }

    @Override
    public void serviceStarting(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
    }

    @Override
    public void serviceStopped(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
        this.setChannel(null);
    }

    @Override
    public void serviceStopping(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
    }

    protected void setChannel(com.tangosol.net.messaging.Channel channel) {
        this.__m_Channel = channel;
    }

    public void setCluster(Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    @Override
    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator != null) {
            initiator.setContextClassLoader(loader);
        }
    }

    @Override
    public void setDependencies(ServiceDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies((RemoteServiceDependencies)deps).validate();
        this.onDependencies((RemoteServiceDependencies)this.getDependencies());
    }

    protected void setInitiator(ConnectionInitiator initiator) {
        RemoteService._assert(this.getInitiator() == null);
        this.__m_Initiator = initiator;
    }

    protected void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    protected void setNameServiceAddressProvider(boolean fNameService) {
        this.__m_NameServiceAddressProvider = fNameService;
    }

    public void setOperationalContext(OperationalContext ctx) {
        RemoteService._assert(this.getOperationalContext() == null);
        this.__m_OperationalContext = ctx;
    }

    protected void setResourceRegistry(ResourceRegistry registry) {
        this.__m_ResourceRegistry = registry;
    }

    public void setScopeName(String sName) {
        this.__m_ScopeName = sName;
    }

    protected void setServiceListeners(Listeners listeners) {
        this.__m_ServiceListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    protected void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    @Override
    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    @Override
    public void shutdown() {
        this.doShutdown();
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning()) {
            try {
                this.doStart();
            }
            catch (RuntimeException e) {
                this.doStop();
                throw e;
            }
        }
    }

    @Override
    public void stop() {
        this.doStop();
    }

    @Override
    public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        return CacheFactory.VERSION_ENCODED >= nEncoded;
    }

    @Override
    public boolean isVersionCompatible(int nYear, int nMonth, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion(nYear, nMonth, nPatch);
        return CacheFactory.VERSION_ENCODED >= nEncoded;
    }

    @Override
    public boolean isVersionCompatible(int nVersion) {
        return CacheFactory.VERSION_ENCODED >= nVersion;
    }

    @Override
    public boolean isVersionCompatible(IntPredicate predicate) {
        return predicate.test(CacheFactory.VERSION_ENCODED);
    }

    @Override
    public int getMinimumServiceVersion() {
        return CacheFactory.VERSION_ENCODED;
    }
}

