/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.message.response.PartialResponse;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedCacheFactory;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.Converter;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.messaging.Response;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.EntrySetMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ImmutableMultiList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.PagedIterator;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.LimitFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoteNamedCache
extends Extend
implements NamedCache,
BinaryEntryStore,
CacheStore,
Channel.Receiver {
    private BinaryCache __m_BinaryCache;
    private String __m_CacheName;
    private CacheService __m_CacheService;
    private Channel __m_Channel;
    private NamedCache __m_ConverterCache;
    private ConverterFromBinary __m_ConverterFromBinary;
    private ConverterKeyToBinary __m_ConverterKeyToBinary;
    private ConverterValueToBinary __m_ConverterValueToBinary;
    private Listeners __m_DeactivationListeners;
    private boolean __m_DeferKeyAssociationCheck;
    private transient QueueProcessor __m_EventDispatcher;
    private static boolean __s_LockDeprecateWarned;
    private boolean __m_PassThrough;
    private boolean __m_Released;

    public RemoteNamedCache() {
        this(null, null, true);
    }

    public RemoteNamedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDeactivationListeners(new Listeners());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new BinaryCache("BinaryCache", this, true), "BinaryCache");
        this._addChild(new ConverterBinaryToDecoratedBinary("ConverterBinaryToDecoratedBinary", this, true), "ConverterBinaryToDecoratedBinary");
        this._addChild(new ConverterBinaryToUndecoratedBinary("ConverterBinaryToUndecoratedBinary", this, true), "ConverterBinaryToUndecoratedBinary");
        this._addChild(new ConverterFromBinary("ConverterFromBinary", this, true), "ConverterFromBinary");
        this._addChild(new ConverterKeyToBinary("ConverterKeyToBinary", this, true), "ConverterKeyToBinary");
        this._addChild(new ConverterValueToBinary("ConverterValueToBinary", this, true), "ConverterValueToBinary");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new RemoteNamedCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getBinaryCache().addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().add(listener);
        } else {
            if (filter instanceof InKeySetFilter) {
                InKeySetFilter filterKeys = new InKeySetFilter(null, ((InKeySetFilter)filter).getKeys());
                filterKeys.ensureConverted(this.getConverterKeyToBinary());
                filter = filterKeys;
            }
            this.getBinaryCache().addMapListener(this.instantiateConverterListener(listener), (Filter)filter, fLite);
        }
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.getBinaryCache().addMapListener(this.instantiateConverterListener(listener), this.getConverterKeyToBinary().convert(oKey), fLite);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getConverterCache().aggregate(filter, agent);
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return this.getConverterCache().aggregate(collKeys, agent);
    }

    @Override
    public AsyncNamedCache async(AsyncNamedMap.Option ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.getBinaryCache().clear();
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getConverterCache().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getConverterCache().containsValue(oValue);
    }

    @Override
    public void destroy() {
        this.getCacheService().destroyCache(this);
    }

    @Override
    public Set entrySet() {
        return this.getConverterCache().entrySet();
    }

    @Override
    public Set entrySet(Filter filter) {
        if (filter instanceof LimitFilter) {
            ((LimitFilter)filter).setComparator(null);
        }
        return this.getConverterCache().entrySet(filter);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        ImmutableArrayList set;
        if (comparator == null) {
            comparator = SafeComparator.INSTANCE;
        }
        LimitFilter filterLimit = null;
        if (filter instanceof LimitFilter) {
            filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(comparator);
        }
        if ((set = this.getConverterCache().entrySet(filter)).size() <= 1) {
            return set;
        }
        Object[] aEntry = set.toArray();
        EntryComparator compEntry = new EntryComparator(comparator);
        Arrays.sort(aEntry, compEntry);
        if (filterLimit == null) {
            return new ImmutableArrayList(aEntry);
        }
        filterLimit.setComparator(compEntry);
        set = new ImmutableArrayList(filterLimit.extractPage(aEntry));
        filterLimit.setComparator(comparator);
        return set;
    }

    public void erase(BinaryEntry binEntry) {
        this.getBinaryCache().remove((Object)binEntry.getBinaryKey(), false);
    }

    public void erase(Object oKey) {
        this.getBinaryCache().remove(this.getConverterKeyToBinary().convert(oKey), false);
    }

    public void eraseAll(Collection colKeys) {
        this.getBinaryCache().removeAll(ConverterCollections.getCollection(colKeys, this.getConverterKeyToBinary(), this.getConverterFromBinary()));
    }

    public void eraseAll(Set setBinEntries) {
        this.getBinaryCache().removeAll(new EntrySetMap(setBinEntries).keySet());
    }

    @Override
    public Object get(Object oKey) {
        return this.getConverterCache().get(oKey);
    }

    @Override
    public Map getAll(Collection colKeys) {
        return this.getConverterCache().getAll(colKeys);
    }

    public BinaryCache getBinaryCache() {
        return this.__m_BinaryCache;
    }

    @Override
    public String getCacheName() {
        return this.__m_CacheName;
    }

    @Override
    public CacheService getCacheService() {
        return this.__m_CacheService;
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    public NamedCache getConverterCache() {
        return this.__m_ConverterCache;
    }

    public ConverterFromBinary getConverterFromBinary() {
        return this.__m_ConverterFromBinary;
    }

    public ConverterKeyToBinary getConverterKeyToBinary() {
        return this.__m_ConverterKeyToBinary;
    }

    public ConverterValueToBinary getConverterValueToBinary() {
        return this.__m_ConverterValueToBinary;
    }

    public Listeners getDeactivationListeners() {
        return this.__m_DeactivationListeners;
    }

    @Override
    protected String getDescription() {
        return "NamedCache=" + this.getCacheName() + ", Service=" + this.getCacheService().getInfo().getServiceName();
    }

    public QueueProcessor getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    @Override
    public String getName() {
        return "RemoteNamedCache(Cache=" + this.getCacheName() + ")";
    }

    @Override
    public Protocol getProtocol() {
        return NamedCacheProtocol.getInstance();
    }

    protected MapListener instantiateConverterListener(MapListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (listener instanceof MapTriggerListener) {
            return listener;
        }
        ConverterFromBinary conv = this.getConverterFromBinary();
        return ContainerHelper.getContextAwareListener(this.getCacheService(), ConverterCollections.getMapListener(this, listener, conv, conv));
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getConverterCache().invoke(oKey, agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getConverterCache().invokeAll(filter, agent);
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return this.getConverterCache().invokeAll(collKeys, agent);
    }

    @Override
    public boolean isActive() {
        return this.getBinaryCache().isActive();
    }

    @Override
    public boolean isReady() {
        return this.getBinaryCache().isReady();
    }

    public boolean isDeferKeyAssociationCheck() {
        return this.__m_DeferKeyAssociationCheck;
    }

    @Override
    public boolean isDestroyed() {
        return this.getBinaryCache().isDestroyed();
    }

    @Override
    public boolean isEmpty() {
        return this.getBinaryCache().isEmpty();
    }

    public static boolean isLockDeprecateWarned() {
        return __s_LockDeprecateWarned;
    }

    public boolean isPassThrough() {
        return this.__m_PassThrough;
    }

    @Override
    public boolean isReleased() {
        return this.__m_Released;
    }

    @Override
    public Set keySet() {
        return this.getConverterCache().keySet();
    }

    @Override
    public Set keySet(Filter filter) {
        return this.getConverterCache().keySet(filter);
    }

    @Override
    public void load(BinaryEntry binEntry) {
        binEntry.updateBinaryValue((Binary)this.getBinaryCache().get(binEntry.getBinaryKey()));
    }

    @Override
    public Object load(Object oKey) {
        return this.getConverterCache().get(oKey);
    }

    @Override
    public Map loadAll(Collection colKeys) {
        return this.getConverterCache().getAll(colKeys);
    }

    public void loadAll(Set setBinEntries) {
        Map map = this.getBinaryCache().getAll((Collection)new EntrySetMap(setBinEntries).keySet());
        for (BinaryEntry binEntry : setBinEntries) {
            Binary binValue = (Binary)map.get(binEntry.getBinaryKey());
            if (binValue == null) continue;
            binEntry.updateBinaryValue(binValue);
        }
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        this.printLockDeprecatedMessage();
        if (oKey == ConcurrentMap.LOCK_ALL) {
            throw new UnsupportedOperationException("RemoteNamedCache does not support LOCK_ALL");
        }
        return this.getConverterCache().lock(oKey, cWait);
    }

    @Override
    public void onChannelClosed(Channel channel) {
        Listeners listeners = this.getDeactivationListeners();
        if (!listeners.isEmpty()) {
            com.tangosol.net.cache.CacheEvent<Object, Object> evt = new com.tangosol.net.cache.CacheEvent<Object, Object>(this, 3, null, null, null, true);
            CacheEvent.dispatchSafe(evt, listeners, null);
        }
    }

    @Override
    public void onInit() {
        this.setBinaryCache((BinaryCache)this._findChild("BinaryCache"));
        this.setConverterFromBinary((ConverterFromBinary)this._findChild("ConverterFromBinary"));
        this.setConverterKeyToBinary((ConverterKeyToBinary)this._findChild("ConverterKeyToBinary"));
        this.setConverterValueToBinary((ConverterValueToBinary)this._findChild("ConverterValueToBinary"));
        this.setConverterCache(ConverterCollections.getNamedCache(this.getBinaryCache(), this.getConverterFromBinary(), this.getConverterKeyToBinary(), this.getConverterFromBinary(), this.getConverterValueToBinary()));
        super.onInit();
    }

    @Override
    public void onMessage(Message message) {
        message.run();
    }

    public void printLockDeprecatedMessage() {
        if (!RemoteNamedCache.isLockDeprecateWarned()) {
            RemoteNamedCache._trace("Using the lock API from a Coherence*Extend client is deprecated and will be removed in a future release", 2);
            RemoteNamedCache.setLockDeprecateWarned(true);
        }
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.getConverterCache().put(oKey, oValue);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.getConverterCache().put(oKey, oValue, cMillis);
    }

    @Override
    public void putAll(Map mapEntries) {
        this.getConverterCache().putAll(mapEntries);
    }

    @Override
    public void registerChannel(Channel channel) {
        ConfigurablePofContext cpc;
        this.setChannel(channel);
        Serializer serializer = channel.getSerializer();
        this.getBinaryCache().setChannel(channel);
        this.getConverterFromBinary().setSerializer(serializer);
        this.getConverterValueToBinary().setSerializer(serializer);
        if (serializer instanceof ConfigurablePofContext && (cpc = (ConfigurablePofContext)serializer).isReferenceEnabled()) {
            cpc = new ConfigurablePofContext(cpc);
            cpc.setReferenceEnabled(false);
            serializer = cpc;
        }
        this.getConverterKeyToBinary().setSerializer(serializer);
    }

    @Override
    public void release() {
        this.setReleased(true);
        this.getCacheService().releaseCache(this);
    }

    @Override
    public Object remove(Object oKey) {
        return this.getConverterCache().remove(oKey);
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        this.getBinaryCache().removeIndex(extractor);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().remove(listener);
        } else {
            if (filter instanceof InKeySetFilter) {
                InKeySetFilter filterKeys = new InKeySetFilter(null, ((InKeySetFilter)filter).getKeys());
                filterKeys.ensureConverted(this.getConverterKeyToBinary());
                filter = filterKeys;
            }
            this.getBinaryCache().removeMapListener(this.instantiateConverterListener(listener), (Filter)filter);
        }
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        this.getBinaryCache().removeMapListener(this.instantiateConverterListener(listener), this.getConverterKeyToBinary().convert(oKey));
    }

    protected void setBinaryCache(BinaryCache cache) {
        this.__m_BinaryCache = cache;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setCacheService(CacheService service) {
        this.__m_CacheService = service;
    }

    public void setChannel(Channel channel) {
        this.__m_Channel = channel;
    }

    protected void setConverterCache(NamedCache cache) {
        this.__m_ConverterCache = cache;
    }

    protected void setConverterFromBinary(ConverterFromBinary conv) {
        this.__m_ConverterFromBinary = conv;
    }

    protected void setConverterKeyToBinary(ConverterKeyToBinary conv) {
        this.__m_ConverterKeyToBinary = conv;
    }

    protected void setConverterValueToBinary(ConverterValueToBinary conv) {
        this.__m_ConverterValueToBinary = conv;
    }

    protected void setDeactivationListeners(Listeners listeners) {
        this.__m_DeactivationListeners = listeners;
    }

    public void setDeferKeyAssociationCheck(boolean fDefer) {
        this.__m_DeferKeyAssociationCheck = fDefer;
    }

    public void setEventDispatcher(QueueProcessor dispatcher) {
        this.__m_EventDispatcher = dispatcher;
        this.getBinaryCache().setEventDispatcher(dispatcher);
    }

    public static void setLockDeprecateWarned(boolean fDeprecateWarned) {
        __s_LockDeprecateWarned = fDeprecateWarned;
    }

    public void setPassThrough(boolean fPassThrough) {
        this.__m_PassThrough = fPassThrough;
    }

    public void setReleased(boolean fRelease) {
        this.__m_Released = fRelease;
    }

    @Override
    public int size() {
        return this.getBinaryCache().size();
    }

    public void store(BinaryEntry binEntry) {
        this.getBinaryCache().put(binEntry.getBinaryKey(), binEntry.getBinaryValue(), 0L, false);
    }

    public void store(Object oKey, Object oValue) {
        this.getBinaryCache().put(this.getConverterKeyToBinary().convert(oKey), this.getConverterValueToBinary().convert(oValue), 0L, false);
    }

    public void storeAll(Map mapEntries) {
        this.getConverterCache().putAll(mapEntries);
    }

    public void storeAll(Set setBinEntries) {
        this.getBinaryCache().putAll((Map)new EntrySetMap(setBinEntries));
    }

    @Override
    public void truncate() {
        this.getBinaryCache().truncate();
    }

    @Override
    public boolean unlock(Object oKey) {
        this.printLockDeprecatedMessage();
        if (oKey == ConcurrentMap.LOCK_ALL) {
            throw new UnsupportedOperationException("RemoteNamedCache does not support LOCK_ALL");
        }
        return this.getConverterCache().unlock(oKey);
    }

    @Override
    public void unregisterChannel(Channel channel) {
        this.setChannel(null);
    }

    @Override
    public Collection values() {
        return this.getConverterCache().values();
    }

    public static class BinaryCache
    extends Util
    implements NamedCache {
        private Channel __m_Channel;
        private ConverterBinaryToDecoratedBinary __m_ConverterBinaryToDecoratedBinary;
        private ConverterBinaryToUndecoratedBinary __m_ConverterBinaryToUndecoratedBinary;
        private Set __m_EntrySet;
        private transient QueueProcessor __m_EventDispatcher;
        private LongArray __m_FilterArray;
        private Set __m_KeySet;
        private MapListenerSupport __m_MapListenerSupport;
        private Collection __m_Values;

        public BinaryCache() {
            this(null, null, true);
        }

        public BinaryCache(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setFilterArray(new SparseArray());
                this.setMapListenerSupport(new MapListenerSupport());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new EntrySet("EntrySet", this, true), "EntrySet");
            this._addChild(new KeySet("KeySet", this, true), "KeySet");
            this._addChild(new Values("Values", this, true), "Values");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BinaryCache();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.IndexRequest request = (NamedCacheFactory.IndexRequest)factory.createMessage(42);
            request.setAdd(true);
            request.setComparator(comparator);
            request.setExtractor(extractor);
            request.setOrdered(fOrdered);
            channel.request(request);
        }

        @Override
        public void addMapListener(MapListener listener) {
            this.addMapListener(listener, (Filter)null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
            MapListenerSupport support = this.getMapListenerSupport();
            boolean fPriming = MapListenerSupport.isPrimingListener(listener);
            if (listener instanceof MapTriggerListener) {
                this.addRemoteMapListener(filter, 0L, fLite, ((MapTriggerListener)listener).getTrigger(), false);
            } else if (filter instanceof InKeySetFilter) {
                InKeySetFilter filterKeys = (InKeySetFilter)filter;
                Set<?> setKeys = filterKeys.getKeys();
                HashMap<Binary, Boolean> mapKeys = new HashMap<Binary, Boolean>(setKeys.size());
                ConverterBinaryToUndecoratedBinary conv = this.getConverterBinaryToUndecoratedBinary();
                Iterator<?> iter = setKeys.iterator();
                while (iter.hasNext()) {
                    Binary binKey = (Binary)conv.convert(iter.next());
                    boolean fNew = support.addListenerWithCheck(listener, binKey, fLite);
                    if (fNew || fPriming) {
                        mapKeys.put(binKey, fNew);
                        continue;
                    }
                    iter.remove();
                }
                if (!setKeys.isEmpty()) {
                    try {
                        this.addRemoteMapListener(filterKeys, 1L, fLite, null, fPriming);
                    }
                    catch (RuntimeException e) {
                        for (Map.Entry entry : mapKeys.entrySet()) {
                            if (entry.getValue() != Boolean.TRUE) continue;
                            support.removeListener(listener, entry.getKey());
                        }
                        throw e;
                    }
                }
            } else {
                long lFilterId;
                if (fPriming) {
                    throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
                }
                MapListenerSupport mapKeys = support;
                synchronized (mapKeys) {
                    boolean fWasEmpty = support.isEmpty(filter);
                    if (!support.addListenerWithCheck(listener, filter, fLite)) {
                        return;
                    }
                    lFilterId = fWasEmpty ? this.registerFilter(filter) : this.getFilterId(filter);
                }
                try {
                    this.addRemoteMapListener(filter, lFilterId, fLite, null, false);
                }
                catch (RuntimeException e) {
                    MapListenerSupport mapListenerSupport = support;
                    synchronized (mapListenerSupport) {
                        this.getFilterArray().remove(lFilterId);
                        support.removeListener(listener, filter);
                    }
                    throw e;
                }
            }
        }

        @Override
        public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
            if (oKey == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (listener instanceof MapTriggerListener) {
                this.addRemoteMapListener(oKey, fLite, ((MapTriggerListener)listener).getTrigger(), false);
            } else {
                Binary binKey = (Binary)this.getConverterBinaryToUndecoratedBinary().convert(oKey);
                MapListenerSupport support = this.getMapListenerSupport();
                boolean fNew = support.addListenerWithCheck(listener, binKey, fLite);
                boolean fPriming = MapListenerSupport.isPrimingListener(listener);
                if (fNew || fPriming) {
                    try {
                        this.addRemoteMapListener(oKey, fLite, null, fPriming);
                    }
                    catch (RuntimeException e) {
                        if (fNew) {
                            support.removeListener(listener, binKey);
                        }
                        throw e;
                    }
                }
            }
        }

        protected void addRemoteMapListener(Filter filter, long lFilterId, boolean fLite, MapTrigger trigger, boolean fPriming) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ListenerFilterRequest request = (NamedCacheFactory.ListenerFilterRequest)factory.createMessage(12);
            if (request.getImplVersion() <= 5 && filter instanceof InKeySetFilter && fLite) {
                throw new UnsupportedOperationException("Priming events are not supported");
            }
            request.setAdd(true);
            request.setFilter(filter);
            request.setFilterId(lFilterId);
            request.setLite(fLite);
            request.setTrigger(trigger);
            request.setPriming(fPriming);
            channel.request(request);
        }

        protected void addRemoteMapListener(Object oKey, boolean fLite, MapTrigger trigger, boolean fPriming) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ListenerKeyRequest request = (NamedCacheFactory.ListenerKeyRequest)factory.createMessage(11);
            request.setAdd(true);
            request.setKey(oKey);
            request.setLite(fLite);
            request.setTrigger(trigger);
            request.setPriming(fPriming);
            channel.request(request);
        }

        @Override
        public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.AggregateFilterRequest request = (NamedCacheFactory.AggregateFilterRequest)factory.createMessage(52);
            request.setAggregator(agent);
            request.setFilter(filter);
            return channel.request(request);
        }

        @Override
        public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.AggregateAllRequest request = (NamedCacheFactory.AggregateAllRequest)factory.createMessage(51);
            request.setAggregator(agent);
            request.setKeySet(collKeys);
            return channel.request(request);
        }

        @Override
        public void clear() {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ClearRequest request = (NamedCacheFactory.ClearRequest)factory.createMessage(8);
            channel.request(request);
        }

        public boolean containsAll(Collection colKeys) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ContainsAllRequest request = (NamedCacheFactory.ContainsAllRequest)factory.createMessage(9);
            request.setKeySet(colKeys);
            return (Boolean)channel.request(request);
        }

        @Override
        public boolean containsKey(Object oKey) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ContainsKeyRequest request = (NamedCacheFactory.ContainsKeyRequest)factory.createMessage(2);
            request.setKey(oKey);
            return (Boolean)channel.request(request);
        }

        @Override
        public boolean containsValue(Object oValue) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ContainsValueRequest request = (NamedCacheFactory.ContainsValueRequest)factory.createMessage(3);
            request.setValue(oValue);
            return (Boolean)channel.request(request);
        }

        @Override
        public void destroy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch(int nEventId, long[] alFilterIds, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic, int nTransformState, boolean fPriming, boolean fExpired) {
            Listeners listeners;
            MapListenerSupport support = this.getMapListenerSupport();
            int cFilters = alFilterIds == null ? 0 : alFilterIds.length;
            CacheEvent.TransformationState transformState = CacheEvent.TransformationState.values()[nTransformState];
            MapListenerSupport.FilterEvent evt = null;
            Listeners listeners2 = listeners = transformState == CacheEvent.TransformationState.TRANSFORMED ? null : support.getListeners(oKey);
            if (cFilters > 0) {
                LongArray laFilters = this.getFilterArray();
                ArrayList<Filter> listFilters = null;
                MapListenerSupport mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    for (int i = 0; i < cFilters; ++i) {
                        long lFilterId = alFilterIds[i];
                        if (!laFilters.exists(lFilterId)) continue;
                        Filter filter = (Filter)laFilters.get(lFilterId);
                        if (listFilters == null) {
                            listFilters = new ArrayList<Filter>(cFilters - i);
                            Listeners listenersTemp = new Listeners();
                            listenersTemp.addAll(listeners);
                            listeners = listenersTemp;
                        }
                        listFilters.add(filter);
                        listeners.addAll(support.getListeners(filter));
                    }
                }
                if (listFilters != null) {
                    Filter[] aFilters = new Filter[listFilters.size()];
                    aFilters = listFilters.toArray(aFilters);
                    evt = new MapListenerSupport.FilterEvent(this, nEventId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming, fExpired, aFilters);
                }
            }
            if (listeners != null && !listeners.isEmpty()) {
                if (evt == null) {
                    evt = new com.tangosol.net.cache.CacheEvent(this, nEventId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming, fExpired);
                }
                CacheEvent.dispatchSafe(evt, listeners, this.getEventDispatcher().getQueue());
            }
        }

        protected Channel ensureChannel() {
            Channel channel = this.getChannel();
            if (channel == null || !channel.isOpen()) {
                String sCause = "released";
                Connection connection = null;
                if (!(channel == null || (connection = channel.getConnection()) != null && connection.isOpen())) {
                    sCause = "closed";
                }
                throw new ConnectionException("NamedCache \"" + this.getCacheName() + "\" has been " + sCause, connection);
            }
            return channel;
        }

        @Override
        public Set entrySet() {
            return this.getEntrySet();
        }

        @Override
        public Set entrySet(Filter filter) {
            if (filter == null) {
                return this.entrySet();
            }
            return this.query(filter, false);
        }

        @Override
        public Set entrySet(Filter filter, Comparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object oKey) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.GetRequest request = (NamedCacheFactory.GetRequest)factory.createMessage(4);
            request.setKey(oKey);
            return channel.request(request);
        }

        @Override
        public Map getAll(Collection colKeys) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.GetAllRequest request = (NamedCacheFactory.GetAllRequest)factory.createMessage(21);
            request.setKeySet(colKeys);
            ConverterCollections.ConverterMap response = (ConverterCollections.ConverterMap)channel.request(request);
            return response == null ? response : ConverterCollections.getMap(response, NullImplementation.getConverter(), this.getConverterBinaryToUndecoratedBinary(), NullImplementation.getConverter(), NullImplementation.getConverter());
        }

        @Override
        public String getCacheName() {
            return ((RemoteNamedCache)this.get_Parent()).getCacheName();
        }

        @Override
        public CacheService getCacheService() {
            return null;
        }

        public Channel getChannel() {
            return this.__m_Channel;
        }

        public ConverterBinaryToDecoratedBinary getConverterBinaryToDecoratedBinary() {
            return this.__m_ConverterBinaryToDecoratedBinary;
        }

        public ConverterBinaryToUndecoratedBinary getConverterBinaryToUndecoratedBinary() {
            return this.__m_ConverterBinaryToUndecoratedBinary;
        }

        public Set getEntrySet() {
            return this.__m_EntrySet;
        }

        public QueueProcessor getEventDispatcher() {
            return this.__m_EventDispatcher;
        }

        protected LongArray getFilterArray() {
            return this.__m_FilterArray;
        }

        protected long getFilterId(Filter filter) {
            Iterator iter = this.getFilterArray().iterator();
            while (iter.hasNext()) {
                Filter filterThat = (Filter)iter.next();
                if (!Base.equals(filter, filterThat)) continue;
                return iter.getIndex();
            }
            return 0L;
        }

        public Set getKeySet() {
            return this.__m_KeySet;
        }

        public MapListenerSupport getMapListenerSupport() {
            return this.__m_MapListenerSupport;
        }

        public Collection getValues() {
            return this.__m_Values;
        }

        @Override
        public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.InvokeRequest request = (NamedCacheFactory.InvokeRequest)factory.createMessage(53);
            request.setKey(oKey);
            request.setProcessor(agent);
            return channel.request(request);
        }

        @Override
        public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
            PartialResponse response;
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            Binary binCookie = null;
            ConverterCollections.ConverterMap mapResult = null;
            do {
                NamedCacheFactory.InvokeFilterRequest request = (NamedCacheFactory.InvokeFilterRequest)factory.createMessage(55);
                request.setCookie(binCookie);
                request.setFilter(filter);
                request.setProcessor(agent);
                Request.Status status = channel.send(request);
                response = (PartialResponse)status.waitForResponse();
                Map map = (Map)this.processResponse(response);
                if (mapResult == null || mapResult.isEmpty()) {
                    mapResult = map;
                    continue;
                }
                if (map == null || map.isEmpty()) continue;
                mapResult.putAll(map);
            } while ((binCookie = response.getCookie()) != null);
            return mapResult == null ? mapResult : ConverterCollections.getMap(mapResult, NullImplementation.getConverter(), this.getConverterBinaryToUndecoratedBinary(), NullImplementation.getConverter(), NullImplementation.getConverter());
        }

        @Override
        public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.InvokeAllRequest request = (NamedCacheFactory.InvokeAllRequest)factory.createMessage(54);
            request.setKeySet(collKeys);
            request.setProcessor(agent);
            ConverterCollections.ConverterMap response = (ConverterCollections.ConverterMap)channel.request(request);
            return response == null ? response : ConverterCollections.getMap(response, NullImplementation.getConverter(), this.getConverterBinaryToUndecoratedBinary(), NullImplementation.getConverter(), NullImplementation.getConverter());
        }

        @Override
        public boolean isActive() {
            Channel channel = this.getChannel();
            return channel == null ? false : channel.isOpen();
        }

        @Override
        public boolean isDestroyed() {
            Connection connection;
            Channel channel = this.getChannel();
            Connection connection2 = connection = channel == null ? null : channel.getConnection();
            if (channel == null || connection == null) {
                return false;
            }
            return !channel.isOpen() && connection.isOpen();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean isReady() {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            if (factory.getVersion() < 11) {
                throw new UnsupportedOperationException("NamedMap.isReady is not supported by the current proxy. Either upgrade the version of Coherence on the proxy or connect to a proxy that supports the isReady operation.");
            }
            NamedCacheFactory.ReadyRequest request = (NamedCacheFactory.ReadyRequest)factory.createMessage(61);
            return (Boolean)channel.request(request);
        }

        @Override
        public Set keySet() {
            return this.getKeySet();
        }

        @Override
        public Set keySet(Filter filter) {
            return this.query(filter, true);
        }

        public PartialResponse keySetPage(Binary binCookie) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.QueryRequest request = (NamedCacheFactory.QueryRequest)factory.createMessage(41);
            request.setCookie(binCookie);
            request.setKeysOnly(true);
            Request.Status status = channel.send(request);
            PartialResponse response = (PartialResponse)status.waitForResponse();
            this.processResponse(response);
            return response;
        }

        @Override
        public boolean lock(Object oKey) {
            return this.lock(oKey, 0L);
        }

        @Override
        public boolean lock(Object oKey, long cWait) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.LockRequest request = (NamedCacheFactory.LockRequest)factory.createMessage(31);
            request.setKey(oKey);
            request.setTimeoutMillis(cWait);
            return (Boolean)channel.request(request);
        }

        @Override
        public void onInit() {
            this.setConverterBinaryToDecoratedBinary((ConverterBinaryToDecoratedBinary)this.get_Parent()._findChild("ConverterBinaryToDecoratedBinary"));
            this.setConverterBinaryToUndecoratedBinary((ConverterBinaryToUndecoratedBinary)this.get_Parent()._findChild("ConverterBinaryToUndecoratedBinary"));
            this.setEntrySet((EntrySet)this._findChild("EntrySet"));
            this.setKeySet((KeySet)this._findChild("KeySet"));
            this.setValues((Values)this._findChild("Values"));
            super.onInit();
        }

        protected Object processResponse(Response response) {
            if (response.isFailure()) {
                Object oResult = response.getResult();
                if (oResult instanceof Throwable) {
                    throw RemoteNamedCache.ensureRuntimeException((Throwable)oResult);
                }
                throw new RuntimeException("received error: " + String.valueOf(oResult));
            }
            return response.getResult();
        }

        @Override
        public Object put(Object oKey, Object oValue) {
            return this.put(oKey, oValue, 0L);
        }

        @Override
        public Object put(Object oKey, Object oValue, long cMillis) {
            return this.put(oKey, oValue, cMillis, true);
        }

        public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.PutRequest request = (NamedCacheFactory.PutRequest)factory.createMessage(5);
            request.setKey(oKey);
            request.setValue(oValue);
            request.setExpiryDelay(cMillis);
            request.setReturnRequired(fReturn);
            return channel.request(request);
        }

        @Override
        public void putAll(Map mapEntries) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.PutAllRequest request = (NamedCacheFactory.PutAllRequest)factory.createMessage(7);
            request.setMap(mapEntries);
            channel.request(request);
        }

        protected Set query(Filter filter, boolean fKeysOnly) {
            ConverterCollections.ConverterSet setReturn;
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            Binary binCookie = null;
            ConverterCollections.ConverterSet setResult = null;
            ArrayList<Object[]> listPart = null;
            do {
                NamedCacheFactory.QueryRequest request = (NamedCacheFactory.QueryRequest)factory.createMessage(41);
                request.setCookie(binCookie);
                request.setFilter(filter);
                request.setKeysOnly(fKeysOnly);
                if (filter instanceof LimitFilter) {
                    request.setFilterCookie(((LimitFilter)filter).getCookie());
                }
                Request.Status status = channel.send(request);
                PartialResponse response = (PartialResponse)status.waitForResponse();
                Set set = (Set)this.processResponse(response);
                if (setResult == null || setResult.isEmpty()) {
                    setResult = set;
                } else if (set != null && !set.isEmpty()) {
                    if (listPart == null) {
                        listPart = new ArrayList<Object[]>();
                        listPart.add(setResult.toArray());
                    }
                    listPart.add(set.toArray());
                }
                if (filter instanceof LimitFilter) {
                    LimitFilter filterLimit = (LimitFilter)filter;
                    NamedCacheFactory.PartialResponse partialResponse = (NamedCacheFactory.PartialResponse)response;
                    LimitFilter filterReturned = (LimitFilter)partialResponse.getFilter();
                    filterLimit.setBottomAnchor(filterReturned.getBottomAnchor());
                    filterLimit.setTopAnchor(filterReturned.getTopAnchor());
                    filterLimit.setCookie(partialResponse.getFilterCookie());
                    continue;
                }
                binCookie = response.getCookie();
            } while (binCookie != null);
            Set set = setReturn = listPart == null ? setResult : new ImmutableMultiList(listPart);
            return setReturn == null ? setReturn : (fKeysOnly ? ConverterCollections.getSet(setReturn, NullImplementation.getConverter(), this.getConverterBinaryToUndecoratedBinary()) : ConverterCollections.getEntrySet(setReturn, NullImplementation.getConverter(), this.getConverterBinaryToUndecoratedBinary(), NullImplementation.getConverter(), NullImplementation.getConverter()));
        }

        protected long registerFilter(Filter filter) {
            LongArray laFilter = this.getFilterArray();
            if (laFilter.isEmpty()) {
                laFilter.set(1L, filter);
                return 1L;
            }
            return laFilter.add(filter);
        }

        @Override
        public void release() {
        }

        @Override
        public Object remove(Object oKey) {
            return this.remove(oKey, true);
        }

        public Object remove(Object oKey, boolean fReturn) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.RemoveRequest request = (NamedCacheFactory.RemoveRequest)factory.createMessage(6);
            request.setKey(oKey);
            request.setReturnRequired(fReturn);
            return channel.request(request);
        }

        public boolean removeAll(Collection colKeys) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.RemoveAllRequest request = (NamedCacheFactory.RemoveAllRequest)factory.createMessage(10);
            request.setKeySet(colKeys);
            return (Boolean)channel.request(request);
        }

        @Override
        public void removeIndex(ValueExtractor extractor) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.IndexRequest request = (NamedCacheFactory.IndexRequest)factory.createMessage(42);
            request.setExtractor(extractor);
            channel.request(request);
        }

        @Override
        public void removeMapListener(MapListener listener) {
            this.removeMapListener(listener, (Filter)null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMapListener(MapListener listener, Filter filter) {
            MapListenerSupport support = this.getMapListenerSupport();
            boolean fSync = listener instanceof MapListenerSupport.SynchronousListener;
            if (listener instanceof MapTriggerListener) {
                this.removeRemoteMapListener(filter, 0L, fSync, ((MapTriggerListener)listener).getTrigger(), false);
            } else if (filter instanceof InKeySetFilter) {
                InKeySetFilter filterKeys = (InKeySetFilter)filter;
                ConverterCollections.ConverterSet setBinKeys = ConverterCollections.getSet(filterKeys.getKeys(), this.getConverterBinaryToUndecoratedBinary(), NullImplementation.getConverter());
                support.removeListenerWithCheck(listener, setBinKeys);
                if (!setBinKeys.isEmpty()) {
                    this.removeRemoteMapListener(filterKeys, 1L, fSync, null, MapListenerSupport.isPrimingListener(listener));
                }
            } else {
                long lFilterId = 0L;
                MapListenerSupport mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    if (!support.removeListenerWithCheck(listener, filter)) {
                        return;
                    }
                    lFilterId = this.getFilterId(filter);
                    this.getFilterArray().remove(lFilterId);
                }
                this.removeRemoteMapListener(filter, lFilterId, fSync, null, false);
            }
        }

        @Override
        public void removeMapListener(MapListener listener, Object oKey) {
            if (oKey == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (listener instanceof MapTriggerListener) {
                this.removeRemoteMapListener(oKey, listener instanceof MapListenerSupport.SynchronousListener, ((MapTriggerListener)listener).getTrigger(), false);
            } else {
                Binary binKey = (Binary)this.getConverterBinaryToUndecoratedBinary().convert(oKey);
                MapListenerSupport support = this.getMapListenerSupport();
                boolean fEmpty = support.removeListenerWithCheck(listener, binKey);
                boolean fPriming = MapListenerSupport.isPrimingListener(listener);
                if (fEmpty || fPriming) {
                    this.removeRemoteMapListener(oKey, listener instanceof MapListenerSupport.SynchronousListener, null, fPriming);
                }
            }
        }

        protected void removeRemoteMapListener(Filter filter, long lFilterId, boolean fSync, MapTrigger trigger, boolean fPriming) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ListenerFilterRequest request = (NamedCacheFactory.ListenerFilterRequest)factory.createMessage(12);
            request.setFilter(filter);
            request.setFilterId(lFilterId);
            request.setTrigger(trigger);
            request.setPriming(fPriming);
            if (fSync) {
                channel.send(request);
            } else {
                channel.request(request);
            }
        }

        protected void removeRemoteMapListener(Object oKey, boolean fSync, MapTrigger trigger, boolean fPriming) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ListenerKeyRequest request = (NamedCacheFactory.ListenerKeyRequest)factory.createMessage(11);
            request.setKey(oKey);
            request.setTrigger(trigger);
            request.setPriming(fPriming);
            if (fSync) {
                channel.send(request);
            } else {
                channel.request(request);
            }
        }

        public void setChannel(Channel channel) {
            BinaryCache._assert(this.getChannel() == null && channel != null);
            this.__m_Channel = channel;
            this.getConverterBinaryToDecoratedBinary().setSerializer(channel.getSerializer());
        }

        protected void setConverterBinaryToDecoratedBinary(ConverterBinaryToDecoratedBinary conv) {
            this.__m_ConverterBinaryToDecoratedBinary = conv;
        }

        protected void setConverterBinaryToUndecoratedBinary(ConverterBinaryToUndecoratedBinary conv) {
            this.__m_ConverterBinaryToUndecoratedBinary = conv;
        }

        protected void setEntrySet(Set set) {
            this.__m_EntrySet = set;
        }

        public void setEventDispatcher(QueueProcessor dispatcher) {
            this.__m_EventDispatcher = dispatcher;
        }

        protected void setFilterArray(LongArray la) {
            this.__m_FilterArray = la;
        }

        protected void setKeySet(Set set) {
            this.__m_KeySet = set;
        }

        protected void setMapListenerSupport(MapListenerSupport support) {
            this.__m_MapListenerSupport = support;
        }

        protected void setValues(Collection col) {
            this.__m_Values = col;
        }

        @Override
        public int size() {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.SizeRequest request = (NamedCacheFactory.SizeRequest)factory.createMessage(1);
            return (Integer)channel.request(request);
        }

        @Override
        public void truncate() {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.ClearRequest request = (NamedCacheFactory.ClearRequest)factory.createMessage(8);
            if (request.getImplVersion() <= 5) {
                throw new UnsupportedOperationException("NamedCache.truncate is not supported by the current proxy. Either upgrade the version of Coherence on the proxy or connect to a proxy that supports the truncate operation.");
            }
            request.setTruncate(true);
            channel.request(request);
        }

        @Override
        public boolean unlock(Object oKey) {
            Channel channel = this.ensureChannel();
            Protocol.MessageFactory factory = channel.getMessageFactory();
            NamedCacheFactory.UnlockRequest request = (NamedCacheFactory.UnlockRequest)factory.createMessage(32);
            request.setKey(oKey);
            return (Boolean)channel.request(request);
        }

        @Override
        public Collection values() {
            return this.getValues();
        }

        public static class EntrySet
        extends Collections
        implements Set {
            private BinaryCache __m_BinaryCache;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public EntrySet() {
                this(null, null, true);
            }

            public EntrySet(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EntrySet();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache$EntrySet".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection col) {
                return EntrySet.addAll(this, col);
            }

            @Override
            public void clear() {
                this.getBinaryCache().clear();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry;
                    Object oKey;
                    BinaryCache cache = this.getBinaryCache();
                    return cache.containsKey(oKey = (entry = (Map.Entry)o).getKey()) && Base.equals(cache.get(oKey), entry.getValue());
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection col) {
                return EntrySet.containsAll(this, col);
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof Set) {
                    Set setThat = (Set)obj;
                    return this.size() == setThat.size() && setThat.containsAll(this);
                }
                return false;
            }

            public BinaryCache getBinaryCache() {
                return this.__m_BinaryCache;
            }

            @Override
            public int hashCode() {
                int h = 0;
                for (Object o : this) {
                    if (o == null) continue;
                    h += o.hashCode();
                }
                return h;
            }

            @Override
            public boolean isEmpty() {
                return this.getBinaryCache().isEmpty();
            }

            @Override
            public java.util.Iterator iterator() {
                return (Iterator)this._newChild("Iterator");
            }

            @Override
            public void onInit() {
                this.setBinaryCache((BinaryCache)this.get_Parent());
                super.onInit();
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Set set = java.util.Collections.singleton(entry.getKey());
                    return this.getBinaryCache().removeAll(set);
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection col) {
                HashSet setKeys = new HashSet();
                for (Map.Entry entry : col) {
                    setKeys.add(entry.getKey());
                }
                return this.getBinaryCache().removeAll(setKeys);
            }

            @Override
            public boolean retainAll(Collection col) {
                return EntrySet.retainAll(this, col);
            }

            protected void setBinaryCache(BinaryCache cache) {
                this.__m_BinaryCache = cache;
            }

            @Override
            public int size() {
                return this.getBinaryCache().size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray((Object[])null);
            }

            @Override
            public Object[] toArray(Object[] ao) {
                while (true) {
                    try {
                        return EntrySet.toArray(this, ao);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
            }

            static {
                EntrySet.__initStatic();
            }

            public static class Iterator
            extends Util
            implements java.util.Iterator {
                private BinaryCache __m_BinaryCache;
                private Object __m_Key;
                private transient java.util.Iterator __m_KeyIterator;

                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache$EntrySet$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                public BinaryCache getBinaryCache() {
                    return this.__m_BinaryCache;
                }

                public Object getKey() {
                    return this.__m_Key;
                }

                public java.util.Iterator getKeyIterator() {
                    return this.__m_KeyIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.getKeyIterator().hasNext();
                }

                public Object next() {
                    Object oKey = this.getKeyIterator().next();
                    this.setKey(oKey);
                    return new SimpleMapEntry(oKey, this.getBinaryCache().get(this.getBinaryCache().getConverterBinaryToDecoratedBinary().convert(oKey)));
                }

                @Override
                public void onInit() {
                    BinaryCache cache = ((EntrySet)this.get_Parent()).getBinaryCache();
                    this.setBinaryCache(cache);
                    this.setKeyIterator(cache.keySet().iterator());
                    super.onInit();
                }

                @Override
                public void remove() {
                    Object oKey = this.getKey();
                    if (oKey == null) {
                        throw new IllegalStateException();
                    }
                    try {
                        BinaryCache cache = this.getBinaryCache();
                        cache.remove(cache.getConverterBinaryToDecoratedBinary().convert(oKey), false);
                    }
                    finally {
                        this.setKey(null);
                    }
                }

                protected void setBinaryCache(BinaryCache cache) {
                    this.__m_BinaryCache = cache;
                }

                protected void setKey(Object oKey) {
                    this.__m_Key = oKey;
                }

                protected void setKeyIterator(java.util.Iterator iterator) {
                    this.__m_KeyIterator = iterator;
                }
            }
        }

        public static class KeySet
        extends Collections
        implements Set {
            private BinaryCache __m_BinaryCache;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Advancer", Advancer.get_CLASS());
            }

            public KeySet() {
                this(null, null, true);
            }

            public KeySet(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new KeySet();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache$KeySet".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection col) {
                return KeySet.addAll(this, col);
            }

            @Override
            public void clear() {
                this.getBinaryCache().clear();
            }

            @Override
            public boolean contains(Object o) {
                return this.getBinaryCache().containsKey(o);
            }

            @Override
            public boolean containsAll(Collection col) {
                return this.getBinaryCache().containsAll(col);
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof Set) {
                    Set setThis = this.getBinaryCache().keySet(null);
                    Set setThat = (Set)obj;
                    return setThat.size() == setThis.size() && setThat.containsAll(setThis);
                }
                return false;
            }

            public BinaryCache getBinaryCache() {
                return this.__m_BinaryCache;
            }

            @Override
            public int hashCode() {
                int h = 0;
                for (Object o : this) {
                    if (o == null) continue;
                    h += o.hashCode();
                }
                return h;
            }

            @Override
            public boolean isEmpty() {
                return this.getBinaryCache().isEmpty();
            }

            @Override
            public Iterator iterator() {
                return new PagedIterator((PagedIterator.Advancer)((Object)this._newChild("Advancer")));
            }

            @Override
            public void onInit() {
                this.setBinaryCache((BinaryCache)this.get_Parent());
                super.onInit();
            }

            @Override
            public boolean remove(Object o) {
                Set<Object> set = java.util.Collections.singleton(o);
                return this.getBinaryCache().removeAll(set);
            }

            @Override
            public boolean removeAll(Collection col) {
                return this.getBinaryCache().removeAll(col);
            }

            @Override
            public boolean retainAll(Collection col) {
                return KeySet.retainAll(this, col);
            }

            protected void setBinaryCache(BinaryCache cache) {
                this.__m_BinaryCache = cache;
            }

            @Override
            public int size() {
                return this.getBinaryCache().size();
            }

            @Override
            public Object[] toArray() {
                return this.getBinaryCache().keySet(null).toArray();
            }

            @Override
            public Object[] toArray(Object[] ao) {
                return this.getBinaryCache().keySet(null).toArray(ao);
            }

            static {
                KeySet.__initStatic();
            }

            public static class Advancer
            extends Util
            implements PagedIterator.Advancer {
                private BinaryCache __m_BinaryCache;
                private Binary __m_Cookie;
                private boolean __m_Exhausted;

                public Advancer() {
                    this(null, null, true);
                }

                public Advancer(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Advancer();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache$KeySet$Advancer".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                public BinaryCache getBinaryCache() {
                    return this.__m_BinaryCache;
                }

                public Binary getCookie() {
                    return this.__m_Cookie;
                }

                public boolean isExhausted() {
                    return this.__m_Exhausted;
                }

                @Override
                public Collection nextPage() {
                    if (this.isExhausted()) {
                        return null;
                    }
                    PartialResponse response = this.getBinaryCache().keySetPage(this.getCookie());
                    Binary binCookie = response.getCookie();
                    this.setCookie(binCookie);
                    if (binCookie == null) {
                        this.setExhausted(true);
                    }
                    return (Collection)response.getResult();
                }

                @Override
                public void onInit() {
                    BinaryCache cache = ((KeySet)this.get_Parent()).getBinaryCache();
                    this.setBinaryCache(cache);
                    super.onInit();
                }

                @Override
                public void remove(Object oCurr) {
                    BinaryCache cache = this.getBinaryCache();
                    cache.remove(cache.getConverterBinaryToDecoratedBinary().convert(oCurr), false);
                }

                protected void setBinaryCache(BinaryCache cache) {
                    this.__m_BinaryCache = cache;
                }

                protected void setCookie(Binary bin) {
                    this.__m_Cookie = bin;
                }

                protected void setExhausted(boolean f) {
                    this.__m_Exhausted = f;
                }
            }
        }

        public static class Values
        extends Collections
        implements Collection {
            private BinaryCache __m_BinaryCache;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Values() {
                this(null, null, true);
            }

            public Values(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Values();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache$Values".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection col) {
                return Values.addAll(this, col);
            }

            @Override
            public void clear() {
                this.getBinaryCache().clear();
            }

            @Override
            public boolean contains(Object o) {
                return this.getBinaryCache().containsValue(o);
            }

            public boolean containsAll(Collection col) {
                return Values.containsAll(this, col);
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof Collection) {
                    Collection colThat = (Collection)obj;
                    return this.size() == colThat.size() && colThat.containsAll(this);
                }
                return false;
            }

            public BinaryCache getBinaryCache() {
                return this.__m_BinaryCache;
            }

            @Override
            public int hashCode() {
                int h = 1;
                for (Object o : this) {
                    h = 31 * h + (o == null ? 0 : o.hashCode());
                    if (o == null) continue;
                    h += o.hashCode();
                }
                return h;
            }

            @Override
            public boolean isEmpty() {
                return this.getBinaryCache().isEmpty();
            }

            @Override
            public java.util.Iterator iterator() {
                return (Iterator)this._newChild("Iterator");
            }

            @Override
            public void onInit() {
                this.setBinaryCache((BinaryCache)this.get_Parent());
                super.onInit();
            }

            @Override
            public boolean remove(Object o) {
                return Values.remove(this, o);
            }

            public boolean removeAll(Collection col) {
                return Values.removeAll(this, col);
            }

            public boolean retainAll(Collection col) {
                return Values.retainAll(this, col);
            }

            protected void setBinaryCache(BinaryCache cache) {
                this.__m_BinaryCache = cache;
            }

            @Override
            public int size() {
                return this.getBinaryCache().size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray((Object[])null);
            }

            public Object[] toArray(Object[] ao) {
                while (true) {
                    try {
                        return Values.toArray(this, ao);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
            }

            static {
                Values.__initStatic();
            }

            public static class Iterator
            extends Util
            implements java.util.Iterator {
                private BinaryCache __m_BinaryCache;
                private Object __m_Key;
                private transient java.util.Iterator __m_KeyIterator;

                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$BinaryCache$Values$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                public BinaryCache getBinaryCache() {
                    return this.__m_BinaryCache;
                }

                public Object getKey() {
                    return this.__m_Key;
                }

                public java.util.Iterator getKeyIterator() {
                    return this.__m_KeyIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.getKeyIterator().hasNext();
                }

                public Object next() {
                    Object oKey = this.getKeyIterator().next();
                    this.setKey(oKey);
                    return this.getBinaryCache().get(this.getBinaryCache().getConverterBinaryToDecoratedBinary().convert(oKey));
                }

                @Override
                public void onInit() {
                    BinaryCache cache = ((Values)this.get_Parent()).getBinaryCache();
                    this.setBinaryCache(cache);
                    this.setKeyIterator(cache.keySet().iterator());
                    super.onInit();
                }

                @Override
                public void remove() {
                    Object oKey = this.getKey();
                    if (oKey == null) {
                        throw new IllegalStateException();
                    }
                    try {
                        BinaryCache cache = this.getBinaryCache();
                        cache.remove(cache.getConverterBinaryToDecoratedBinary().convert(oKey), false);
                    }
                    finally {
                        this.setKey(null);
                    }
                }

                protected void setBinaryCache(BinaryCache cache) {
                    this.__m_BinaryCache = cache;
                }

                protected void setKey(Object oKey) {
                    this.__m_Key = oKey;
                }

                protected void setKeyIterator(java.util.Iterator iterator) {
                    this.__m_KeyIterator = iterator;
                }
            }
        }
    }

    public static class ConverterBinaryToDecoratedBinary
    extends Converter {
        public ConverterBinaryToDecoratedBinary() {
            this(null, null, true);
        }

        public ConverterBinaryToDecoratedBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterBinaryToDecoratedBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$ConverterBinaryToDecoratedBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            if (o == null || ((RemoteNamedCache)this.get_Module()).isDeferKeyAssociationCheck()) {
                return o;
            }
            Binary bin = (Binary)o;
            if (ExternalizableHelper.isIntDecorated(bin)) {
                return bin;
            }
            Binary binDeco = bin;
            o = ExternalizableHelper.fromBinary(bin, this.getSerializer());
            if (o instanceof KeyAssociation && (o = ((KeyAssociation)o).getAssociatedKey()) != null) {
                binDeco = ExternalizableHelper.toBinary(o, this.getSerializer());
            }
            return ExternalizableHelper.decorateBinary(bin, binDeco.calculateNaturalPartition(0));
        }
    }

    public static class ConverterBinaryToUndecoratedBinary
    extends Converter {
        public ConverterBinaryToUndecoratedBinary() {
            this(null, null, true);
        }

        public ConverterBinaryToUndecoratedBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterBinaryToUndecoratedBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$ConverterBinaryToUndecoratedBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            if (o == null || ((RemoteNamedCache)this.get_Module()).isDeferKeyAssociationCheck()) {
                return o;
            }
            Binary bin = (Binary)o;
            return ExternalizableHelper.isIntDecorated(bin) ? ExternalizableHelper.removeIntDecoration(bin) : bin;
        }
    }

    public static class ConverterFromBinary
    extends Converter {
        public ConverterFromBinary() {
            this(null, null, true);
        }

        public ConverterFromBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterFromBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$ConverterFromBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            return o == null || ((RemoteNamedCache)this.get_Module()).isPassThrough() ? (Binary)o : ExternalizableHelper.fromBinary((Binary)o, this.getSerializer());
        }
    }

    public static class ConverterKeyToBinary
    extends Converter {
        public ConverterKeyToBinary() {
            this(null, null, true);
        }

        public ConverterKeyToBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterKeyToBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$ConverterKeyToBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            if (((RemoteNamedCache)this.get_Module()).isPassThrough()) {
                return o;
            }
            Binary bin = ExternalizableHelper.toBinary(o, this.getSerializer());
            if (((RemoteNamedCache)this.get_Module()).isDeferKeyAssociationCheck()) {
                return bin;
            }
            Binary binDeco = bin;
            if (o instanceof KeyAssociation && (o = ((KeyAssociation)o).getAssociatedKey()) != null) {
                binDeco = ExternalizableHelper.toBinary(o, this.getSerializer());
            }
            return ExternalizableHelper.decorateBinary(bin, binDeco.calculateNaturalPartition(0));
        }
    }

    public static class ConverterValueToBinary
    extends Converter {
        public ConverterValueToBinary() {
            this(null, null, true);
        }

        public ConverterValueToBinary(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConverterValueToBinary();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/RemoteNamedCache$ConverterValueToBinary".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object convert(Object o) {
            return ((RemoteNamedCache)this.get_Module()).isPassThrough() ? (Binary)o : ExternalizableHelper.toBinary(o, this.getSerializer());
        }
    }
}

