/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.internal.net.security.AccessAdapter;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.Member;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public class Connection
extends Extend
implements com.tangosol.net.messaging.Connection {
    private LongArray __m_ChannelArray;
    private LongArray __m_ChannelPendingArray;
    private volatile boolean __m_CloseNotify;
    private volatile boolean __m_CloseOnExit;
    private volatile Throwable __m_CloseThrowable;
    private volatile ConnectionManager __m_ConnectionManager;
    private UUID __m_Id;
    private static final int MAX_PENDING = 100;
    private Member __m_Member;
    private transient Map __m_MessageFactoryMap;
    private boolean __m_MessagingDebug;
    private volatile boolean __m_Open;
    private int __m_PeerEdition;
    private UUID __m_PeerId;
    private transient long __m_PingLastMillis;
    private transient long __m_StatsBytesReceived;
    private transient long __m_StatsBytesSent;
    private transient long __m_StatsReceived;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private ThreadGate __m_ThreadGate;

    public Connection() {
        this(null, null, true);
    }

    public Connection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setChannelArray(new SparseArray());
            this.setChannelPendingArray(new SparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Connection();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/Connection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public com.tangosol.net.messaging.Channel acceptChannel(URI uri, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        return ((Peer)this.getConnectionManager()).acceptChannel(this, uri, loader, receiver, subject);
    }

    public Request.Status acceptChannelInternal(URI uri, Serializer serializer, Channel.Receiver receiver, Subject subject, byte[] abToken) {
        int nId;
        this.assertOpen();
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        try {
            nId = Integer.parseInt(uri.getSchemeSpecificPart());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("illegal URI: " + String.valueOf(uri));
        }
        if (nId == 0) {
            throw new IllegalArgumentException("channel 0 is reserved");
        }
        if (this.getChannel(nId) != null) {
            throw new IllegalArgumentException("duplicate channel: " + nId);
        }
        String sProtocol = uri.getFragment();
        if (sProtocol == null) {
            throw new IllegalArgumentException("illegal URI: " + String.valueOf(uri));
        }
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException("unknown protocol: " + sProtocol);
        }
        if (receiver != null && receiver.getProtocol() != factory.getProtocol()) {
            throw new IllegalArgumentException("protocol mismatch; expected " + String.valueOf(factory.getProtocol()) + ", retrieved " + String.valueOf(receiver.getProtocol()) + ")");
        }
        Channel channel0 = (Channel)this.getChannel(0);
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer.MessageFactory.AcceptChannelRequest request = (Peer.MessageFactory.AcceptChannelRequest)factory0.createMessage(13);
        request.setChannelId(nId);
        request.setIdentityToken(abToken);
        request.setMessageFactory(factory);
        request.setProtocolName(sProtocol);
        request.setReceiver(receiver);
        request.setSerializer(serializer);
        request.setSubject(subject);
        return channel0.send(request);
    }

    public void acceptChannelRequest(int nId, Subject subject, AccessAdapter adapter) {
        if (nId == 0) {
            throw new IllegalArgumentException("channel 0 is reserved");
        }
        if (this.getChannel(nId) != null) {
            throw new IllegalArgumentException("channel already exists: " + nId);
        }
        Channel channel = (Channel)this.getChannelPendingArray().remove(nId);
        if (channel == null) {
            throw new IllegalArgumentException("no such channel: " + nId);
        }
        channel.setSubject(subject);
        channel.setAccessAdapter(adapter);
        channel.openInternal();
        this.registerChannel(channel);
    }

    public com.tangosol.net.messaging.Channel acceptChannelResponse(int nId, Protocol.MessageFactory factory, Serializer serializer, Channel.Receiver receiver, Subject subject) {
        this.assertOpen();
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setSerializer(serializer);
        channel.setSubject(subject);
        channel.openInternal();
        this.registerChannel(channel);
        return channel;
    }

    protected void assertOpen() {
        if (!this.isOpen()) {
            throw new ConnectionException("connection is closed", (com.tangosol.net.messaging.Connection)this);
        }
    }

    @Override
    public void close() {
        this.close(true, null);
    }

    public void close(boolean fNotify, Throwable e) {
        this.close(fNotify, e, true);
    }

    public void close(boolean fNotify, Throwable e, boolean fWait) {
        if (this.isOpen()) {
            Peer manager = (Peer)this.getConnectionManager();
            if (Thread.currentThread() == manager.getThread()) {
                this.closeInternal(fNotify, e, 0L);
            } else {
                Connection._assert(!this.isActiveThread(), "cannot close a connection while executing within the connection");
                manager.closeConnection(this, fNotify, e, fWait);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        block16: {
            Channel channel0;
            LongArray la;
            if (!this.isOpen()) {
                return false;
            }
            LongArray longArray = la = this.getChannelArray();
            synchronized (longArray) {
                channel0 = (Channel)la.get(0L);
                Iterator iter = la.iterator();
                while (iter.hasNext()) {
                    Channel channel = (Channel)iter.next();
                    if (channel == channel0) continue;
                    iter.remove();
                    channel.closeInternal(false, e, 0L);
                }
            }
            boolean fClose = this.gateClose(cMillis);
            try {
                if (!fClose) {
                    this.setCloseOnExit(true);
                    this.setCloseNotify(fNotify);
                    this.setCloseThrowable(e);
                    fClose = this.gateClose(0L);
                }
                if (fClose && this.isOpen()) {
                    if (fNotify) {
                        try {
                            Protocol.MessageFactory factory0 = channel0.getMessageFactory();
                            Peer.MessageFactory.NotifyConnectionClosed message = (Peer.MessageFactory.NotifyConnectionClosed)factory0.createMessage(10);
                            message.setCause(e);
                            channel0.send(message);
                        }
                        catch (RuntimeException factory0) {
                            // empty catch block
                        }
                    }
                    channel0.closeInternal(false, e, -1L);
                    this.getChannelPendingArray().clear();
                    this.setPeerId(null);
                    this.setOpen(false);
                    break block16;
                }
                boolean factory0 = false;
                return factory0;
            }
            finally {
                if (fClose) {
                    this.gateOpen();
                }
            }
        }
        Peer manager = (Peer)this.getConnectionManager();
        if (e == null) {
            manager.onConnectionClosed(this);
        } else {
            manager.onConnectionError(this, e);
        }
        return true;
    }

    @Override
    public URI createChannel(Protocol protocol, ClassLoader loader, Channel.Receiver receiver) {
        Peer manager = (Peer)this.getConnectionManager();
        if (Thread.currentThread() == manager.getThread()) {
            return this.createChannelInternal(protocol, manager.ensureSerializer(loader), receiver);
        }
        return manager.createChannel(this, protocol, loader, receiver);
    }

    public URI createChannelInternal(Protocol protocol, Serializer serializer, Channel.Receiver receiver) {
        this.assertOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        String sProtocol = protocol.getName();
        if (sProtocol == null) {
            throw new IllegalArgumentException("missing protocol name: " + String.valueOf(protocol));
        }
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException("unsupported protocol: " + String.valueOf(protocol));
        }
        int nId = this.generateChannelId();
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setReceiver(receiver);
        channel.setMessageFactory(factory);
        channel.setSerializer(serializer);
        LongArray la = this.getChannelPendingArray();
        int size = la.getSize();
        if (size > 100) {
            Connection._trace("There is a high number of pending open channel requests [" + size + "] for connection=" + String.valueOf(this), 2);
        }
        la.set(nId, channel);
        try {
            return new URI("channel", String.valueOf(nId), sProtocol);
        }
        catch (URISyntaxException e) {
            la.remove(nId);
            throw Connection.ensureRuntimeException(e, "error creating URI");
        }
    }

    protected boolean gateClose(long cMillis) {
        return this.getThreadGate().close(cMillis);
    }

    public void gateEnter() {
        ThreadGate gate = this.getThreadGate();
        if (this.isCloseOnExit() && !gate.isEnteredByCurrentThread()) {
            throw new ConnectionException("connection is closing", (com.tangosol.net.messaging.Connection)this);
        }
        if (gate.enter(0L)) {
            try {
                this.assertOpen();
            }
            catch (Throwable e) {
                gate.exit();
                throw Connection.ensureRuntimeException(e);
            }
        } else {
            throw new ConnectionException("connection is closing", (com.tangosol.net.messaging.Connection)this);
        }
    }

    public void gateExit() {
        ThreadGate gate = this.getThreadGate();
        gate.exit();
        if (this.isCloseOnExit() && !gate.isEnteredByCurrentThread()) {
            boolean fClose = this.gateClose(0L);
            try {
                if (fClose && this.isOpen()) {
                    this.gateOpen();
                    fClose = false;
                    this.close(this.isCloseNotify(), this.getCloseThrowable());
                }
            }
            finally {
                if (fClose) {
                    this.gateOpen();
                }
            }
        }
    }

    protected void gateOpen() {
        this.getThreadGate().open();
    }

    protected int generateChannelId() {
        int nId;
        int nScale;
        LongArray la = this.getChannelPendingArray();
        int n = nScale = this.getConnectionManager() instanceof ConnectionAcceptor ? 1 : -1;
        while ((nId = Base.getRandom().nextInt(Integer.MAX_VALUE) * nScale) == 0 || this.getChannel(nId) != null || la.get(nId) != null) {
        }
        return nId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.tangosol.net.messaging.Channel getChannel(int nId) {
        LongArray la = this.getChannelArray();
        if (((Peer)this.getConnectionManager()).isServiceThread(false)) {
            return (Channel)la.get(nId);
        }
        LongArray longArray = la;
        synchronized (longArray) {
            return (Channel)la.get(nId);
        }
    }

    public LongArray getChannelArray() {
        return this.__m_ChannelArray;
    }

    public LongArray getChannelPendingArray() {
        return this.__m_ChannelPendingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getChannels() {
        LongArray la;
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            ArrayList list = new ArrayList(la.getSize());
            Iterator iter = la.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            return list;
        }
    }

    public Throwable getCloseThrowable() {
        return this.__m_CloseThrowable;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.__m_ConnectionManager;
    }

    @Override
    protected String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getId()).append(", Open=").append(this.isOpen());
        Member member = this.getMember();
        if (member != null) {
            sb.append(", ").append(member.toString());
        }
        return sb.toString();
    }

    @Override
    public UUID getId() {
        return this.__m_Id;
    }

    public Member getMember() {
        return this.__m_Member;
    }

    public Map getMessageFactoryMap() {
        return this.__m_MessageFactoryMap;
    }

    public int getPeerEdition() {
        return this.__m_PeerEdition;
    }

    @Override
    public UUID getPeerId() {
        return this.__m_PeerId;
    }

    public long getPingLastMillis() {
        return this.__m_PingLastMillis;
    }

    public long getStatsBytesReceived() {
        return this.__m_StatsBytesReceived;
    }

    public long getStatsBytesSent() {
        return this.__m_StatsBytesSent;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    protected ThreadGate getThreadGate() {
        return this.__m_ThreadGate;
    }

    public boolean isActiveThread() {
        return this.getThreadGate().isEnteredByCurrentThread();
    }

    public boolean isCloseNotify() {
        return this.__m_CloseNotify;
    }

    public boolean isCloseOnExit() {
        return this.__m_CloseOnExit;
    }

    public boolean isMessagingDebug() {
        return this.__m_MessagingDebug;
    }

    @Override
    public boolean isOpen() {
        return this.__m_Open;
    }

    @Override
    public void onInit() {
        Channel channel0 = new Channel();
        channel0.setConnection(this);
        this.registerChannel(channel0);
        this.setThreadGate(new ThreadGate());
        super.onInit();
    }

    public void open() {
        if (!this.isOpen()) {
            ((Peer)this.getConnectionManager()).openConnection(this);
        }
    }

    @Override
    public com.tangosol.net.messaging.Channel openChannel(Protocol protocol, String sName, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        return ((Peer)this.getConnectionManager()).openChannel(this, protocol, sName, loader, receiver, subject);
    }

    public Request.Status openChannelInternal(Protocol protocol, String sName, Serializer serializer, Channel.Receiver receiver, Subject subject, byte[] abToken) {
        this.assertOpen();
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        if (sName == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        String sProtocol = protocol.getName();
        Connection._assert(sProtocol != null);
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException("unknown protocol: " + sProtocol);
        }
        if (receiver != null && receiver.getProtocol() != factory.getProtocol()) {
            throw new IllegalArgumentException("protocol mismatch; expected " + String.valueOf(factory.getProtocol()) + ", retrieved " + String.valueOf(receiver.getProtocol()) + ")");
        }
        Channel channel0 = (Channel)this.getChannel(0);
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer.MessageFactory.OpenChannelRequest request = (Peer.MessageFactory.OpenChannelRequest)factory0.createMessage(11);
        request.setIdentityToken(abToken);
        request.setMessageFactory(factory);
        request.setProtocolName(sProtocol);
        request.setReceiver(receiver);
        request.setReceiverName(sName);
        request.setSerializer(serializer);
        request.setSubject(subject);
        return channel0.send(request);
    }

    public int openChannelRequest(String sProtocol, Serializer serializer, Channel.Receiver receiver, Subject subject, AccessAdapter adapter) {
        this.assertOpen();
        if (sProtocol == null) {
            throw new IllegalArgumentException("protocol name cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        Protocol.MessageFactory factory = (Protocol.MessageFactory)this.getMessageFactoryMap().get(sProtocol);
        if (factory == null) {
            throw new IllegalArgumentException("unknown protocol: " + sProtocol);
        }
        if (receiver != null && receiver.getProtocol() != factory.getProtocol()) {
            throw new IllegalArgumentException("protocol mismatch; expected " + String.valueOf(factory.getProtocol()) + ", retrieved " + String.valueOf(receiver.getProtocol()) + ")");
        }
        int nId = this.generateChannelId();
        Channel channel = new Channel();
        channel.setConnection(this);
        channel.setId(nId);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setSerializer(serializer);
        channel.setSubject(subject);
        channel.setAccessAdapter(adapter);
        channel.openInternal();
        this.registerChannel(channel);
        return nId;
    }

    public com.tangosol.net.messaging.Channel openChannelResponse(int nId, Protocol.MessageFactory factory, Serializer serializer, Channel.Receiver receiver, Subject subject) {
        this.assertOpen();
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null");
        }
        Channel channel = new Channel();
        channel.setId(nId);
        channel.setConnection(this);
        channel.setMessageFactory(factory);
        channel.setReceiver(receiver);
        channel.setSerializer(serializer);
        channel.setSubject(subject);
        channel.openInternal();
        this.registerChannel(channel);
        return channel;
    }

    public void openInternal() {
        if (this.isOpen()) {
            return;
        }
        Peer manager = (Peer)this.getConnectionManager();
        Connection._assert(manager != null);
        Peer.Protocol protocol = (Peer.Protocol)manager.getProtocol("MessagingProtocol");
        Connection._assert(protocol != null);
        Protocol.MessageFactory factory = protocol.getMessageFactory(protocol.getCurrentVersion());
        Channel channel0 = (Channel)this.getChannel(0);
        channel0.setMessageFactory(factory);
        channel0.setReceiver(manager);
        channel0.setSerializer(manager.ensureSerializer());
        channel0.openInternal();
        this.setOpen(true);
    }

    public boolean ping() {
        if (this.getPingLastMillis() == 0L) {
            Channel channel0 = (Channel)this.getChannel(0);
            Protocol.MessageFactory factory = channel0.getMessageFactory();
            Peer.MessageFactory.PingRequest request = (Peer.MessageFactory.PingRequest)factory.createMessage(3);
            try {
                channel0.send(request);
            }
            catch (RuntimeException e) {
                return false;
            }
            this.setPingLastMillis(Base.getSafeTimeMillis());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerChannel(Channel channel) {
        LongArray la;
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            Channel oChannel = la.set(channel.getId(), channel);
            if (oChannel != null) {
                la.set(channel.getId(), oChannel);
                throw new IllegalArgumentException("duplicate channel: " + String.valueOf(channel));
            }
        }
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
    }

    public void resetStats() {
        this.setStatsBytesReceived(0L);
        this.setStatsBytesSent(0L);
        this.setStatsReceived(0L);
        this.setStatsSent(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void send(WriteBuffer wb) throws ConnectionException {
        this.assertOpen();
        this.setStatsBytesSent(this.getStatsBytesSent() + (long)wb.length());
        this.setStatsSent(this.getStatsSent() + 1L);
    }

    protected void setChannelArray(LongArray list) {
        this.__m_ChannelArray = list;
    }

    protected void setChannelPendingArray(LongArray list) {
        this.__m_ChannelPendingArray = list;
    }

    public void setCloseNotify(boolean f) {
        this.__m_CloseNotify = f;
    }

    public void setCloseOnExit(boolean fClose) {
        this.__m_CloseOnExit = fClose;
    }

    public void setCloseThrowable(Throwable e) {
        this.__m_CloseThrowable = e;
    }

    public void setConnectionManager(ConnectionManager manager) {
        Connection._assert(!this.isOpen());
        this.__m_ConnectionManager = manager;
    }

    public void setId(UUID uuid) {
        Connection._assert(this.getId() == null);
        this.__m_Id = uuid;
    }

    public void setMember(Member member) {
        this.__m_Member = member;
    }

    public void setMessageFactoryMap(Map map) {
        this.__m_MessageFactoryMap = map;
    }

    public void setMessagingDebug(boolean fMessageDebug) {
        this.__m_MessagingDebug = fMessageDebug;
    }

    protected void setOpen(boolean fOpen) {
        this.__m_Open = fOpen;
    }

    public void setPeerEdition(int nEdition) {
        this.__m_PeerEdition = nEdition;
    }

    public void setPeerId(UUID uuid) {
        this.__m_PeerId = uuid;
    }

    public void setPingLastMillis(long ldt) {
        this.__m_PingLastMillis = ldt;
    }

    public void setStatsBytesReceived(long cb) {
        this.__m_StatsBytesReceived = cb;
    }

    public void setStatsBytesSent(long cb) {
        this.__m_StatsBytesSent = cb;
    }

    public void setStatsReceived(long cMessage) {
        this.__m_StatsReceived = cMessage;
    }

    public void setStatsReset(long ldt) {
        this.__m_StatsReset = ldt;
    }

    public void setStatsSent(long cMessage) {
        this.__m_StatsSent = cMessage;
    }

    protected void setThreadGate(ThreadGate gate) {
        this.__m_ThreadGate = gate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChannel(com.tangosol.net.messaging.Channel channel) {
        LongArray la;
        if (channel.getId() == 0) {
            return;
        }
        LongArray longArray = la = this.getChannelArray();
        synchronized (longArray) {
            la.remove(channel.getId());
        }
    }
}

