/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.MessageFactory;
import com.tangosol.coherence.component.net.extend.Protocol;
import com.tangosol.coherence.component.net.extend.message.Request;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.security.AccessAdapter;
import com.tangosol.internal.net.security.AccessAdapterPrivilegedAction;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.messaging.Response;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Gate;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;

public class Channel
extends Extend
implements PofContext,
PofSerializer,
com.tangosol.net.messaging.Channel {
    private AccessAdapter __m_AccessAdapter;
    private Map __m_AttributeMap;
    private volatile boolean __m_CloseNotify;
    private volatile boolean __m_CloseOnExit;
    private volatile Throwable __m_CloseThrowable;
    private volatile transient com.tangosol.net.messaging.Connection __m_Connection;
    private Subject __m_EmptySubject;
    private int __m_Id;
    private boolean __m_LegacyPromotion;
    private Protocol.MessageFactory __m_MessageFactory;
    private volatile boolean __m_Open;
    private Channel.Receiver __m_Receiver;
    private LongArray __m_RequestArray;
    private transient AtomicLong __m_RequestId = new AtomicLong();
    private boolean __m_SecureContext;
    private Serializer __m_Serializer;
    private Subject __m_Subject;
    private transient Gate __m_ThreadGate;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("MessageAction", MessageAction.get_CLASS());
    }

    public Channel() {
        this(null, null, true);
    }

    public Channel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAttributeMap(new SafeHashMap());
            this.setRequestArray(new SparseArray());
            this.setThreadGate(new ThreadGate());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Channel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/extend/Channel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected void assertOpen() {
        if (!this.isOpen()) {
            throw new ConnectionException("channel is closed", this.getConnection());
        }
    }

    protected long calculateRequestTimeout(Request request) {
        Peer manager = this.getConnectionManager();
        long cMillis = 0L;
        if (manager != null) {
            cMillis = manager.getRequestTimeout();
            if (request instanceof PriorityTask) {
                cMillis = Peer.adjustTimeout(cMillis, ((PriorityTask)((Object)request)).getRequestTimeoutMillis());
            }
        }
        return cMillis;
    }

    @Override
    public void close() {
        this.close(true, null);
    }

    public void close(boolean fNotify, Throwable e) {
        if (this.isOpen()) {
            if (this.getId() == 0) {
                throw new UnsupportedOperationException("cannot closed reserved channel: 0");
            }
            Peer manager = this.getConnectionManager();
            if (Thread.currentThread() == manager.getThread()) {
                this.closeInternal(fNotify, e, 0L);
            } else {
                Channel._assert(!this.isActiveThread(), "cannot close a channel while executing within the channel");
                manager.closeChannel(this, fNotify, e, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        if (!this.isOpen()) {
            return false;
        }
        LongArray laStatus = this.getRequestArray();
        Channel.Receiver receiver = this.getReceiver();
        boolean fCloseReceiver = false;
        LongArray longArray = laStatus;
        synchronized (longArray) {
            block20: {
                Throwable eStatus = e == null ? new ConnectionException("channel closed", this.getConnection()) : e;
                Iterator iter = laStatus.iterator();
                while (iter.hasNext()) {
                    Request.Status status = (Request.Status)iter.next();
                    iter.remove();
                    status.cancel(eStatus);
                }
                boolean fClose = this.gateClose(cMillis);
                try {
                    if (!fClose) {
                        this.setCloseOnExit(true);
                        this.setCloseNotify(fNotify);
                        this.setCloseThrowable(e);
                        fClose = this.gateClose(0L);
                    }
                    if (fClose && this.isOpen()) {
                        if (receiver != null) {
                            fCloseReceiver = true;
                            try {
                                receiver.unregisterChannel(this);
                            }
                            catch (Throwable ee222) {
                                Channel._trace(ee222, "Error unregistering channel from receiver: " + String.valueOf(receiver));
                            }
                        }
                        this.setOpen(false);
                        break block20;
                    }
                    boolean ee222 = false;
                    return ee222;
                }
                finally {
                    if (fClose) {
                        this.gateOpen();
                    }
                }
            }
        }
        if (fCloseReceiver) {
            try {
                receiver.onChannelClosed(this);
            }
            catch (Throwable ee) {
                Channel._trace(ee, "Error notifying channel closed to receiver: " + String.valueOf(receiver));
            }
        }
        if (fNotify && !this.isOpen() && this.getId() != 0) {
            try {
                Connection connection = (Connection)this.getConnection();
                com.tangosol.net.messaging.Channel channel0 = connection.getChannel(0);
                Protocol.MessageFactory factory0 = channel0.getMessageFactory();
                Peer.MessageFactory.NotifyChannelClosed message = (Peer.MessageFactory.NotifyChannelClosed)factory0.createMessage(20);
                message.setCause(e);
                message.setChannelId(this.getId());
                channel0.send(message);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        ((Connection)this.getConnection()).unregisterChannel(this);
        this.getConnectionManager().onChannelClosed(this);
        return true;
    }

    public Message createMessage(int nType) {
        return this.getMessageFactory().createMessage(nType);
    }

    public Object deserialize(PofReader in) throws IOException {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofSerializer) {
            return ((PofSerializer)((Object)serializer)).deserialize(in);
        }
        Binary bin = in.readBinary(0);
        in.readRemainder();
        return serializer.deserialize(bin.getBufferInput());
    }

    @Override
    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        PofBufferReader reader = new PofBufferReader(in, this);
        return reader.readObject(-1);
    }

    protected void execute(Message message) {
        Channel.Receiver receiver = message instanceof Response ? null : this.getReceiver();
        AccessAdapter adapter = this.getAccessAdapter();
        if (this.isSecureContext() || adapter != null) {
            MessageAction action = new MessageAction();
            action.setMessage(message);
            action.setReceiver(receiver);
            Subject subject = this.getSubject();
            if (this.isLegacyPromotion()) {
                Subject.doAs(subject, action);
            } else {
                subject = subject == null ? this.getEmptySubject() : subject;
                Subject.doAs(subject, adapter == null ? action : new AccessAdapterPrivilegedAction(adapter, subject, action));
            }
        } else if (receiver == null) {
            message.run();
        } else {
            receiver.onMessage(message);
        }
    }

    protected boolean gateClose(long cMillis) {
        return this.getThreadGate().close(cMillis);
    }

    public void gateEnter() {
        block6: {
            Connection connection = (Connection)this.getConnection();
            connection.gateEnter();
            try {
                Gate gate = this.getThreadGate();
                if (this.isCloseOnExit() && !gate.isEnteredByCurrentThread()) {
                    throw new ConnectionException("channel is closing", (com.tangosol.net.messaging.Connection)connection);
                }
                if (gate.enter(0L)) {
                    try {
                        this.assertOpen();
                        break block6;
                    }
                    catch (Throwable ee) {
                        gate.exit();
                        throw Channel.ensureRuntimeException(ee);
                    }
                }
                throw new ConnectionException("connection is closing", (com.tangosol.net.messaging.Connection)connection);
            }
            catch (Throwable e) {
                connection.gateExit();
                throw Channel.ensureRuntimeException(e);
            }
        }
    }

    public void gateExit() {
        Gate gate = this.getThreadGate();
        gate.exit();
        ((Connection)this.getConnection()).gateExit();
        if (this.isCloseOnExit() && !gate.isEnteredByCurrentThread()) {
            boolean fClose = this.gateClose(0L);
            try {
                if (fClose && this.isOpen()) {
                    this.gateOpen();
                    fClose = false;
                    this.close(this.isCloseNotify(), this.getCloseThrowable());
                }
            }
            finally {
                if (fClose) {
                    this.gateOpen();
                }
            }
        }
    }

    protected void gateOpen() {
        this.getThreadGate().open();
    }

    protected long generateRequestId() {
        return this.__m_RequestId.getAndIncrement();
    }

    public AccessAdapter getAccessAdapter() {
        return this.__m_AccessAdapter;
    }

    @Override
    public Object getAttribute(String sName) {
        return this.getAttributeMap().get(sName);
    }

    public Map getAttributeMap() {
        return this.__m_AttributeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getAttributes() {
        Map map;
        Map map2 = map = this.getAttributeMap();
        synchronized (map2) {
            return new HashMap(map);
        }
    }

    @Override
    public Class getClass(int nTypeId) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getClass(nTypeId);
        }
        throw new IllegalStateException("cannot determine class for user type ID: " + nTypeId);
    }

    @Override
    public String getClassName(int nTypeId) {
        return this.getClass(nTypeId).getName();
    }

    public Throwable getCloseThrowable() {
        return this.__m_CloseThrowable;
    }

    @Override
    public com.tangosol.net.messaging.Connection getConnection() {
        return this.__m_Connection;
    }

    public Peer getConnectionManager() {
        com.tangosol.net.messaging.Connection connection = this.getConnection();
        return connection == null ? null : (Peer)connection.getConnectionManager();
    }

    @Override
    protected String getDescription() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Id=").append(this.getId());
        boolean fOpen = this.isOpen();
        sb.append(", Open=").append(fOpen);
        if (fOpen) {
            Channel.Receiver receiver;
            Protocol protocol;
            com.tangosol.net.messaging.Connection connection = this.getConnection();
            sb.append(", Connection=").append(connection == null ? "null" : String.valueOf(connection.getId()));
            MessageFactory factory = (MessageFactory)this.getMessageFactory();
            if (factory != null && (protocol = (Protocol)factory.getProtocol()) != null) {
                sb.append(", Protocol=").append(protocol).append(", ").append("NegotiatedProtocolVersion=").append(factory.getVersion());
            }
            if ((receiver = this.getReceiver()) != null) {
                sb.append(", Receiver=").append(receiver);
            }
        }
        return sb.toString();
    }

    public Subject getEmptySubject() {
        return this.__m_EmptySubject;
    }

    @Override
    public int getId() {
        return this.__m_Id;
    }

    @Override
    public Protocol.MessageFactory getMessageFactory() {
        return this.__m_MessageFactory;
    }

    @Override
    public PofSerializer getPofSerializer(int nTypeId) {
        String sTarget;
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getPofSerializer(nTypeId);
        }
        if (nTypeId == 0) {
            return this;
        }
        try {
            sTarget = this.getConnectionManager().toString();
        }
        catch (RuntimeException e) {
            sTarget = this.toString();
        }
        throw new IllegalStateException(sTarget + " has not been configured with a PofContext;  this channel cannot decode POF-encoded user types");
    }

    @Override
    public Channel.Receiver getReceiver() {
        return this.__m_Receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Request getRequest(long lId) {
        LongArray laStatus;
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            Request.Status status = (Request.Status)laStatus.get(lId);
            return status == null ? null : status.getRequest();
        }
    }

    public LongArray getRequestArray() {
        return this.__m_RequestArray;
    }

    @Override
    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    @Override
    public Subject getSubject() {
        return this.__m_Subject;
    }

    protected Gate getThreadGate() {
        return this.__m_ThreadGate;
    }

    @Override
    public int getUserTypeIdentifier(Class clz) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(clz);
        }
        Channel._assert(clz != null);
        return 0;
    }

    @Override
    public int getUserTypeIdentifier(Object o) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(o);
        }
        Channel._assert(o != null);
        return 0;
    }

    @Override
    public int getUserTypeIdentifier(String sClass) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(sClass);
        }
        Channel._assert(sClass != null);
        return 0;
    }

    public boolean isActiveThread() {
        return this.getThreadGate().isEnteredByCurrentThread();
    }

    public boolean isCloseNotify() {
        return this.__m_CloseNotify;
    }

    public boolean isCloseOnExit() {
        return this.__m_CloseOnExit;
    }

    public boolean isLegacyPromotion() {
        return this.__m_LegacyPromotion;
    }

    @Override
    public boolean isOpen() {
        return this.__m_Open;
    }

    public boolean isSecureContext() {
        return this.__m_SecureContext;
    }

    @Override
    public boolean isUserType(Class clz) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(clz);
        }
        Channel._assert(clz != null);
        return false;
    }

    @Override
    public boolean isUserType(Object o) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(o);
        }
        Channel._assert(o != null);
        return false;
    }

    @Override
    public boolean isUserType(String sClass) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(sClass);
        }
        Channel._assert(sClass != null);
        return false;
    }

    @Override
    public void onInit() {
        this.setSecureContext(SecurityHelper.getCurrentSubject() != null);
        this.setEmptySubject(SecurityHelper.EMPTY_SUBJECT);
        this.setLegacyPromotion(Config.getBoolean("coherence.security.legacypromotion"));
        super.onInit();
    }

    public void onRequestCompleted(Request.Status status) {
        this.unregisterRequest(status);
    }

    public void open() {
        this.openInternal();
    }

    public void openInternal() {
        if (this.isOpen()) {
            return;
        }
        Channel._assert(this.getConnection() != null);
        Channel._assert(this.getMessageFactory() != null);
        Channel._assert(this.getSerializer() != null);
        this.setOpen(true);
        Channel.Receiver receiver = this.getReceiver();
        if (receiver != null) {
            try {
                receiver.registerChannel(this);
            }
            catch (Throwable e) {
                Channel._trace(e, "Error registering channel with receiver: " + String.valueOf(receiver));
            }
        }
        this.getConnectionManager().onChannelOpened(this);
    }

    protected void post(Message message) {
        boolean fEnter;
        if (message instanceof Response) {
            Channel._assert(this.isActiveThread(), "can only send a response while executing within a channel");
            fEnter = false;
        } else {
            fEnter = true;
        }
        if (fEnter) {
            this.gateEnter();
        }
        try {
            message.setChannel(this);
            this.getConnectionManager().post(message);
        }
        catch (Throwable e) {
            Request.Status status;
            if (message instanceof Request && (status = ((Request)message).getStatus()) != null) {
                status.cancel(e);
            }
            throw Base.ensureRuntimeException(e);
        }
        finally {
            if (fEnter) {
                this.gateExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        block27: {
            Channel._assert(message != null);
            try {
                this.gateEnter();
            }
            catch (ConnectionException e) {
                return;
            }
            try {
                if (message instanceof Request) {
                    Request request = (Request)message;
                    try {
                        this.execute(message);
                    }
                    catch (RuntimeException e) {
                        Response response = request.ensureResponse();
                        Channel._assert(response != null);
                        if (request.getStatus() == null && Channel._isTraceEnabled(5)) {
                            Channel._trace("An exception occurred while processing a " + ClassHelper.getSimpleName(message.getClass()) + " for Service=" + this.getConnectionManager().getServiceName() + ": " + Channel.getStackTrace(e), 5);
                        }
                        response.setFailure(true);
                        response.setResult(e);
                    }
                    Response response = request.ensureResponse();
                    Channel._assert(response != null);
                    response.setRequestId(request.getId());
                    this.send(response);
                    break block27;
                }
                if (message instanceof Response) {
                    Request.Status status;
                    Response response = (Response)message;
                    LongArray laStatus = this.getRequestArray();
                    long lId = response.getRequestId();
                    LongArray longArray = laStatus;
                    synchronized (longArray) {
                        status = (Request.Status)laStatus.get(lId);
                    }
                    if (status == null) {
                        break block27;
                    }
                    try {
                        this.execute(response);
                        if (response.isFailure()) {
                            Object oResult = response.getResult();
                            if (oResult instanceof Throwable) {
                                status.cancel((Throwable)oResult);
                            } else {
                                status.cancel(new RuntimeException(String.valueOf(oResult)));
                            }
                        } else {
                            status.setResponse(response);
                        }
                        break block27;
                    }
                    catch (Throwable e) {
                        status.cancel(e);
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                        break block27;
                    }
                }
                this.execute(message);
            }
            catch (Throwable e) {
                Connection connection = (Connection)this.getConnection();
                if (!connection.isCloseOnExit() || !Thread.currentThread().isInterrupted()) {
                    Channel._trace(e, "Caught an unhandled exception while processing a " + ClassHelper.getSimpleName(message.getClass()) + " for Service=" + this.getConnectionManager().getServiceName());
                }
                if (this.getId() == 0) {
                    connection.setCloseOnExit(true);
                    connection.setCloseNotify(true);
                    connection.setCloseThrowable(e);
                } else {
                    this.setCloseOnExit(true);
                    this.setCloseNotify(true);
                    this.setCloseThrowable(e);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
            finally {
                this.gateExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request.Status registerRequest(Request request) {
        LongArray laStatus;
        Channel._assert(request != null);
        Request.Status status = new Request.Status();
        status.setChannel(this);
        status.setDefaultTimeoutMillis(this.calculateRequestTimeout(request));
        status.setRequest(request);
        request.setStatus(status);
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            this.assertOpen();
            long lId = this.generateRequestId();
            request.setId(lId);
            Request.Status oStatus = laStatus.set(lId, status);
            if (oStatus != null) {
                laStatus.set(lId, oStatus);
                Channel._assert(false, "duplicate request: " + String.valueOf(request));
            }
        }
        return status;
    }

    @Override
    public Object removeAttribute(String sName) {
        return this.getAttributeMap().remove(sName);
    }

    @Override
    public Object request(Request request) {
        return this.request(request, -1L);
    }

    @Override
    public Object request(Request request, long cMillis) {
        Peer manager = this.getConnectionManager();
        Channel._assert(manager.getThread() != Thread.currentThread(), "request() is a blocking call and cannot be called on the service thread");
        manager.waitAcceptingClients();
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Request.Status status = this.registerRequest(request);
        this.post(request);
        Response response = status.waitForResponse(cMillis);
        if (response.isFailure()) {
            Object oResult = response.getResult();
            if (oResult instanceof Throwable) {
                throw Channel.ensureRuntimeException((Throwable)oResult);
            }
            throw new RuntimeException("received error: " + String.valueOf(oResult));
        }
        return response.getResult();
    }

    @Override
    public void send(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.post(message);
    }

    @Override
    public Request.Status send(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Request.Status status = this.registerRequest(request);
        this.post(request);
        return status;
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofSerializer) {
            ((PofSerializer)((Object)serializer)).serialize(out, o);
        } else {
            BinaryWriteBuffer buf = new BinaryWriteBuffer(32);
            serializer.serialize(buf.getBufferOutput(), o);
            out.writeBinary(0, buf.toBinary());
            out.writeRemainder(null);
        }
    }

    @Override
    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        writer.writeObject(-1, o);
    }

    public void setAccessAdapter(AccessAdapter subject) {
        this.__m_AccessAdapter = subject;
    }

    @Override
    public Object setAttribute(String sName, Object oValue) {
        return this.getAttributeMap().put(sName, oValue);
    }

    protected void setAttributeMap(Map map) {
        this.__m_AttributeMap = map;
    }

    public void setCloseNotify(boolean f) {
        this.__m_CloseNotify = f;
    }

    public void setCloseOnExit(boolean fClose) {
        this.__m_CloseOnExit = fClose;
    }

    public void setCloseThrowable(Throwable e) {
        this.__m_CloseThrowable = e;
    }

    public void setConnection(com.tangosol.net.messaging.Connection connection) {
        Channel._assert(!this.isOpen());
        this.__m_Connection = connection;
    }

    public void setEmptySubject(Subject subject) {
        this.__m_EmptySubject = subject;
    }

    public void setId(int nId) {
        Channel._assert(!this.isOpen());
        this.__m_Id = nId;
    }

    protected void setLegacyPromotion(boolean fSecure) {
        this.__m_LegacyPromotion = fSecure;
    }

    public void setMessageFactory(Protocol.MessageFactory factory) {
        Channel._assert(!this.isOpen());
        this.__m_MessageFactory = factory;
    }

    protected void setOpen(boolean fOpen) {
        this.__m_Open = fOpen;
    }

    public void setReceiver(Channel.Receiver receiver) {
        Channel._assert(!this.isOpen());
        this.__m_Receiver = receiver;
    }

    protected void setRequestArray(LongArray la) {
        this.__m_RequestArray = la;
    }

    protected void setSecureContext(boolean fSecure) {
        this.__m_SecureContext = fSecure;
    }

    public void setSerializer(Serializer serializer) {
        Channel._assert(!this.isOpen());
        this.__m_Serializer = serializer;
    }

    public void setSubject(Subject subject) {
        this.setSecureContext(this.isSecureContext() || subject != null);
        this.__m_Subject = subject;
    }

    protected void setThreadGate(Gate gate) {
        this.__m_ThreadGate = gate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterRequest(Request.Status status) {
        LongArray laStatus;
        Channel._assert(status != null);
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            laStatus.remove(status.getRequest().getId());
        }
    }

    static {
        Channel.__initStatic();
    }

    public static class MessageAction
    extends Extend
    implements PrivilegedAction {
        private Message __m_Message;
        private Channel.Receiver __m_Receiver;

        public MessageAction() {
            this(null, null, true);
        }

        public MessageAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MessageAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/extend/Channel$MessageAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected String getDescription() {
            return "Message=" + String.valueOf(this.getMessage()) + ", Receiver=" + String.valueOf(this.getReceiver());
        }

        public Message getMessage() {
            return this.__m_Message;
        }

        public Channel.Receiver getReceiver() {
            return this.__m_Receiver;
        }

        @Override
        public void onInit() {
        }

        public Object run() {
            Message message = this.getMessage();
            Channel.Receiver receiver = this.getReceiver();
            if (receiver == null) {
                message.run();
            } else {
                receiver.onMessage(message);
            }
            return null;
        }

        public void setMessage(Message message) {
            this.__m_Message = message;
        }

        public void setReceiver(Channel.Receiver receiver) {
            this.__m_Receiver = receiver;
        }
    }
}

