/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.util.Config;
import com.tangosol.coherence.component.util.FileHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;

public class URL
extends Net {
    private transient java.net.URL __m__URL;
    private URL __m_BaseURL;
    private String __m_File;
    private String __m_Host;
    private int __m_Port;
    private String __m_Protocol;

    public URL() {
        this(null, null, true);
    }

    public URL(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setFile("");
            this.setPort(-1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new URL();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/URL".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public Object getContent() throws IOException {
        return this.get_URL().getContent();
    }

    public URLConnection openConnection() throws IOException {
        return this.get_URL().openConnection();
    }

    public InputStream openStream() throws IOException {
        return this.get_URL().openStream();
    }

    public String toExternalForm() {
        return this.get_URL().toExternalForm();
    }

    @Override
    public void applyConfig(Config config, String sPrefix) {
        this.setProtocol(config.getString(sPrefix + ".Protocol", this.getProtocol()));
        this.setHost(config.getString(sPrefix + ".Host", this.getHost()));
        this.setPort(config.getInt(sPrefix + ".Port", this.getPort()));
        this.setFile(config.getString(sPrefix + ".File", this.getFile()));
        super.applyConfig(config, sPrefix);
    }

    public java.net.URL get_URL() {
        java.net.URL _url = this.__m__URL;
        if (_url == null) {
            URL urlBase;
            String sProtocol = this.getProtocol();
            String sHost = this.getHost();
            int iPort = this.getPort();
            Object sFile = this.getFile();
            if (sProtocol == null && sHost == null && (urlBase = this.getBaseURL()) != null && urlBase.isBaseFor(this)) {
                sProtocol = urlBase.getProtocol();
                sHost = urlBase.getHost();
                iPort = urlBase.getPort();
                String sFileBase = urlBase.getFile();
                if (sFileBase != null) {
                    sFile = sFileBase + (String)sFile;
                }
            }
            try {
                if (sFile == null) {
                    sFile = "";
                }
                _url = new java.net.URL(sProtocol, sHost, iPort, (String)sFile);
                this.set_URL(_url);
            }
            catch (MalformedURLException e) {
                throw new WrapperException(e);
            }
        }
        return _url;
    }

    public URL getBaseURL() {
        return this.__m_BaseURL;
    }

    public String getFile() {
        return this.__m_File;
    }

    public String getHost() {
        return this.__m_Host;
    }

    public int getPort() {
        return this.__m_Port;
    }

    public String getProtocol() {
        return this.__m_Protocol;
    }

    public String getRelativePath() {
        URL urlBase = this.getBaseURL();
        if (urlBase != null && urlBase.isBaseFor(this)) {
            return this.getFile().substring(urlBase.getFile().length());
        }
        return this.get_URL().toString();
    }

    public String getRelativePath(URL url) {
        if (url.getProtocol().equals(this.getProtocol()) && url.getHost().equals(this.getHost()) && url.getPort() == this.getPort()) {
            String sPathThis = this.getFile();
            String sPathThat = url.getFile();
            return FileHelper.getRelativePath(sPathThat, sPathThis);
        }
        return url.get_URL().toString();
    }

    private boolean isBaseFor(URL url) {
        String sProtocol = url.getProtocol();
        String sHost = url.getHost();
        int iPort = url.getPort();
        String sFile = url.getFile();
        if (sProtocol == null && sHost == null && iPort == -1) {
            return true;
        }
        return sProtocol != null && sProtocol.equals(this.getProtocol()) && sHost != null && sHost.equals(this.getHost()) && iPort == this.getPort() && sFile != null && sFile.startsWith(this.getFile());
    }

    @Override
    public void saveConfig(Config config, String sPrefix) {
        String sFile;
        int iPort;
        String sHost;
        String sProtocol = this.getProtocol();
        if (sProtocol != null) {
            config.putString(sPrefix + ".Protocol", sProtocol);
        }
        if ((sHost = this.getHost()) != null) {
            config.putString(sPrefix + ".Host", sHost);
        }
        if ((iPort = this.getPort()) != -1) {
            config.putInt(sPrefix + ".Port", iPort);
        }
        if ((sFile = this.getFile()) != null) {
            config.putString(sPrefix + ".File", sFile);
        }
        super.saveConfig(config, sPrefix);
    }

    public void set_URL(java.net.URL p_URL) {
        if (p_URL != null) {
            this.setProtocol(p_URL.getProtocol());
            this.setHost(p_URL.getHost());
            this.setPort(p_URL.getPort());
            this.setFile(p_URL.getFile());
        }
        this.__m__URL = p_URL;
    }

    public void setBaseURL(URL pBaseURL) {
        this.__m_BaseURL = pBaseURL;
    }

    public void setFile(String pFile) {
        this.__m_File = pFile;
        this.set_URL(null);
    }

    public void setHost(String pHost) {
        this.__m_Host = pHost;
        this.set_URL(null);
    }

    public void setPort(int pPort) {
        this.__m_Port = pPort;
        this.set_URL(null);
    }

    public void setProtocol(String pProtocol) {
        this.__m_Protocol = pProtocol;
        this.set_URL(null);
    }

    @Override
    public String toString() {
        return this.get_URL().toString();
    }
}

