/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.Sockets;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.net.SocketOptions;
import com.tangosol.util.Base;
import com.tangosol.util.LiteSet;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TcpRing
extends Net {
    private Map __m_Buddies;
    private transient ByteBuffer __m_Buffer;
    private int __m_InboundConnectionCount;
    private int __m_RedundancyLevel;
    private transient Selector __m_Selector;
    private transient ServerSocketChannel __m_ServerSocketChannel;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private transient long __m_StatsFailures;
    private transient long __m_StatsPings;

    public TcpRing(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/TcpRing".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Selector selector = this.getSelector();
        selector.wakeup();
        Selector selector2 = selector;
        synchronized (selector2) {
            if (selector.isOpen()) {
                try {
                    for (SelectionKey key : selector.keys()) {
                        try {
                            if (!key.isValid() || !key.channel().isOpen()) continue;
                            key.channel().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (ClosedSelectorException closedSelectorException) {
                    // empty catch block
                }
                try {
                    selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        ServerSocketChannel server = this.getServerSocketChannel();
        if (server != null) {
            try {
                server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected MemberMonitor close(SelectionKey key) {
        if (key != null) {
            LiteSet setKeys;
            MemberMonitor monitor = (MemberMonitor)key.attachment();
            if (monitor != null && !(setKeys = monitor.getKeys()).remove(key)) {
                monitor.setPendingConnections(monitor.getPendingConnections() - 1);
            }
            try {
                if (key.channel().isOpen()) {
                    key.channel().close();
                }
            }
            catch (IOException e) {
                this.onDisconnectException(e, key);
            }
            return monitor;
        }
        return null;
    }

    protected void connect(Member member) {
        Map mapBuddies = this.getBuddies();
        MemberMonitor monitor = (MemberMonitor)mapBuddies.get(member);
        if (monitor == null) {
            monitor = new MemberMonitor();
            monitor.setMember(member);
            mapBuddies.put(member, monitor);
        }
        int cNew = 1 + this.getRedundancyLevel() - (monitor.getKeys().size() + monitor.getPendingConnections());
        for (int i = 0; i < cNew; ++i) {
            SelectionKey key = null;
            try {
                SocketChannel channel = this.getSocketProvider().openSocketChannel();
                Sockets.configureBlocking(channel, false);
                this.getSocketOptions().apply(channel.socket());
                key = channel.register(this.ensureSelector(channel), 8, monitor);
                monitor.setPendingConnections(monitor.getPendingConnections() + 1);
                if (channel.connect(new InetSocketAddress(member.getAddress(), member.getTcpRingPort()))) {
                    this.onConnect(key);
                    continue;
                }
                TcpRing._trace("TcpRing connecting to " + String.valueOf(member), 6);
                continue;
            }
            catch (IOException e) {
                this.onDisconnect(key, e);
            }
        }
    }

    protected void disconnectAll() {
        for (SelectionKey key : this.getSelector().keys()) {
            if (!key.isValid()) continue;
            this.close(key);
        }
    }

    protected Selector ensureSelector(SelectableChannel channel) throws IOException {
        Selector selector = this.getSelector();
        if (selector == null) {
            selector = channel.provider().openSelector();
            this.setSelector(selector);
        }
        return selector;
    }

    public void ensureTopology(Set setConnect) {
        Map mapBuddies = this.getBuddies();
        Iterator iter = mapBuddies.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Member member = (Member)entry.getKey();
            if (setConnect.remove(member)) continue;
            iter.remove();
            MemberMonitor monitor = (MemberMonitor)entry.getValue();
            LiteSet setKeys = monitor.getKeys();
            if (setKeys.isEmpty()) continue;
            TcpRing._trace("TcpRing disconnected from " + String.valueOf(member) + " to maintain ring", 3);
            for (SelectionKey key : setKeys) {
                if (!key.isValid()) continue;
                this.close(key);
            }
        }
        iter = setConnect.iterator();
        while (iter.hasNext()) {
            this.connect((Member)((Object)iter.next()));
        }
    }

    public String formatStats() {
        return "Pings=" + this.getStatsPings() + ", Failures=" + this.getStatsFailures();
    }

    public Map getBuddies() {
        return this.__m_Buddies;
    }

    public ByteBuffer getBuffer() {
        return this.__m_Buffer;
    }

    public int getInboundConnectionCount() {
        return this.__m_InboundConnectionCount;
    }

    public int getRedundancyLevel() {
        return this.__m_RedundancyLevel;
    }

    public Selector getSelector() {
        return this.__m_Selector;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.__m_ServerSocketChannel;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public long getStatsFailures() {
        return this.__m_StatsFailures;
    }

    public long getStatsPings() {
        return this.__m_StatsPings;
    }

    protected void heartbeat(SelectionKey key) {
        SocketChannel channel;
        if (key != null && !(channel = (SocketChannel)key.channel()).isConnectionPending()) {
            ByteBuffer buffer = this.getBuffer();
            buffer.clear();
            try {
                channel.write(buffer);
                this.setStatsPings(this.getStatsPings() + 1L);
            }
            catch (IOException e) {
                this.onDisconnect(key, e);
            }
        }
    }

    public void heartbeatBuddies() {
        try {
            for (MemberMonitor monitor : this.getBuddies().values()) {
                this.connect(monitor.getMember());
                Iterator iterKey = monitor.getKeys().iterator();
                while (iterKey.hasNext()) {
                    this.heartbeat((SelectionKey)iterKey.next());
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        if (this.getInboundConnectionCount() == 0) {
            this.onIsolation();
        }
    }

    protected void onAccept(SelectionKey key) {
        SocketChannel channel = null;
        try {
            channel = ((ServerSocketChannel)key.channel()).accept();
            if (channel == null) {
                return;
            }
        }
        catch (IOException e) {
            this.onAcceptException(e);
            return;
        }
        SelectionKey keyClient = null;
        try {
            channel.configureBlocking(false);
            try {
                channel.socket().setSoLinger(false, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            keyClient = channel.register(this.ensureSelector(channel), 1);
            this.setInboundConnectionCount(this.getInboundConnectionCount() + 1);
        }
        catch (IOException e) {
            if (!channel.socket().isClosed()) {
                TcpRing._trace("error on TcpRing accept: " + String.valueOf(channel.socket()) + "\n" + TcpRing.getStackTrace(e), 1);
            }
            if (keyClient == null) {
                try {
                    channel.socket().close();
                }
                catch (IOException iOException) {}
            }
            this.close(keyClient);
        }
    }

    protected void onAcceptException(Exception e) {
        this.onException(e);
    }

    protected void onConnect(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        MemberMonitor monitor = (MemberMonitor)key.attachment();
        try {
            if (channel.finishConnect()) {
                key.interestOps(1);
                monitor.setPendingConnections(monitor.getPendingConnections() - 1);
                monitor.getKeys().add(key);
                Member member = monitor.getMember();
                if (this.getBuddies().get(member) == monitor) {
                    TcpRing._trace("TcpRing connected to " + String.valueOf(member), 6);
                } else {
                    this.close(key);
                }
            }
        }
        catch (IOException e) {
            this.onDisconnect(key, e);
        }
    }

    protected void onDeadBuddy(Member member, IOException e) {
        this.setStatsFailures(this.getStatsFailures() + 1L);
        this.getBuddies().remove(member);
    }

    protected void onDisconnect(SelectionKey key, IOException e) {
        MemberMonitor monitor = this.close(key);
        if (monitor == null) {
            int cInbound = this.getInboundConnectionCount() - 1;
            this.setInboundConnectionCount(cInbound);
            if (cInbound == 0) {
                this.onIsolation();
            }
        } else {
            Member member = monitor.getMember();
            if (this.getBuddies().containsKey(member)) {
                Object sReason = e.getMessage();
                sReason = e.getClass().getSimpleName() + (String)(sReason == null ? "" : ": " + (String)sReason);
                if (e instanceof NoRouteToHostException || "No route to host".equals(e.getMessage()) || "Connection timed out".equals(e.getMessage())) {
                    TcpRing._trace("TcpRing connection to " + String.valueOf(member) + " timed out (" + (String)sReason + "); retrying.", 2);
                } else if (monitor.getKeys().isEmpty()) {
                    TcpRing._trace("TcpRing disconnected from " + String.valueOf(member) + " due to a peer departure (" + (String)sReason + "); removing the member.", 3);
                    this.onDeadBuddy(member, e);
                } else {
                    TcpRing._trace("TcpRing connection to " + String.valueOf(member) + " failed (" + (String)sReason + "); retrying.", 6);
                }
            }
        }
    }

    protected void onDisconnectException(Exception e, SelectionKey key) {
        TcpRing._trace("TcpRing disconnect from " + String.valueOf(key.attachment()) + " failed: " + e.getMessage(), 3);
    }

    protected void onException(Exception e) {
    }

    @Override
    public void onInit() {
        this.setBuffer(ByteBuffer.allocate(1));
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(1, Boolean.TRUE);
            options.setOption(128, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onIsolation() {
    }

    protected void onRead(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = this.getBuffer();
        buffer.clear();
        try {
            if (channel.read(buffer) == -1) {
                this.onDisconnect(key, new IOException("end of stream"));
            }
        }
        catch (IOException e) {
            this.onDisconnect(key, e);
        }
    }

    protected void onSelect() {
        Iterator<SelectionKey> iter = this.getSelector().selectedKeys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = iter.next();
            iter.remove();
            if (!key.isValid()) continue;
            int nMaskOps = key.readyOps();
            if ((nMaskOps & 0x10) != 0) {
                this.onAccept(key);
            }
            if ((nMaskOps & 8) != 0) {
                this.onConnect(key);
            }
            if ((nMaskOps & 1) == 0) continue;
            this.onRead(key);
        }
    }

    public void resetStats() {
        this.setStatsFailures(0L);
        this.setStatsPings(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(long cMillis) {
        Selector selector;
        Selector selector2 = selector = this.getSelector();
        synchronized (selector2) {
            try {
                if (!selector.isOpen()) {
                    throw new IllegalStateException("TcpRing has been closed");
                }
                if (cMillis < 0L) {
                    selector.selectNow();
                } else {
                    Blocking.select(selector, cMillis);
                }
                this.onSelect();
            }
            catch (ClosedSelectorException e) {
                TcpRing._trace(e, "socket is closed");
            }
            catch (IOException e) {
                TcpRing._trace(e, "Caught an I/O exception while processing a TcpRing Socket; the exception has been logged and will be ignored");
            }
        }
    }

    protected void setBuddies(Map mapBuddies) {
        this.__m_Buddies = mapBuddies;
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.__m_Buffer = buffer;
    }

    public void setInboundConnectionCount(int nCount) {
        this.__m_InboundConnectionCount = nCount;
    }

    public void setRedundancyLevel(int nLevel) {
        this.__m_RedundancyLevel = nLevel;
    }

    public void setSelector(Selector selector) {
        this.__m_Selector = selector;
    }

    public void setServerSocketChannel(ServerSocketChannel channel) {
        ServerSocketChannel channelOld = this.getServerSocketChannel();
        if (channelOld != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            channel.register(this.ensureSelector(channel), 16);
            this.getSocketOptions().apply(channel.socket());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        this.__m_ServerSocketChannel = channel;
    }

    protected void setSocketOptions(SocketOptions options) {
        TcpRing._assert(options != null);
        TcpRing._assert(this.getSocketOptions() == null);
        this.__m_SocketOptions = options;
    }

    public void setSocketProvider(SocketProvider providerSocket) {
        this.__m_SocketProvider = providerSocket;
    }

    protected void setStatsFailures(long cFailures) {
        this.__m_StatsFailures = cFailures;
    }

    protected void setStatsPings(long cPings) {
        this.__m_StatsPings = cPings;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TcpRing{Connections=[");
        Set setBuddies = this.getBuddies().keySet();
        try {
            Iterator iter = setBuddies.iterator();
            while (iter.hasNext()) {
                sb.append(((Member)iter.next()).getId());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        sb.append("]}");
        return sb.toString();
    }

    public boolean verifyReachable(Member member, long cTimeoutMillis) {
        try {
            Socket socket = this.getSocketProvider().openSocket();
            Blocking.connect(socket, new InetSocketAddress(member.getAddress(), member.getTcpRingPort()), (int)cTimeoutMillis);
            socket.getOutputStream().write(0);
            socket.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void wakeup() {
        this.getSelector().wakeup();
    }

    public static class MemberMonitor
    extends Net {
        private LiteSet __m_Keys;
        private Member __m_Member;
        private int __m_PendingConnections;

        public MemberMonitor() {
            this(null, null, true);
        }

        public MemberMonitor(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setKeys(new LiteSet());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberMonitor();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/TcpRing$MemberMonitor".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public LiteSet getKeys() {
            return this.__m_Keys;
        }

        public Member getMember() {
            return this.__m_Member;
        }

        public int getPendingConnections() {
            return this.__m_PendingConnections;
        }

        protected void setKeys(LiteSet setChannel) {
            this.__m_Keys = setChannel;
        }

        public void setMember(Member member) {
            this.__m_Member = member;
        }

        public void setPendingConnections(int nConnections) {
            this.__m_PendingConnections = nConnections;
        }
    }
}

