/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;

public abstract class Socket
extends Net {
    private InetAddress __m_InetAddress;
    private Exception __m_LastException;
    private long __m_LastExceptionLogMillis;
    private Object __m_Lock;
    private int __m_Port;
    private SocketProvider __m_Provider;
    private int __m_SoTimeout;
    private int __m_State;
    public static final int STATE_CLOSED = 2;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_OPEN = 1;

    public Socket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/Socket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public void close() {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_INITIAL";
            }
            case 1: {
                return "STATE_OPEN";
            }
            case 2: {
                return "STATE_CLOSED";
            }
        }
        return "<unknown>";
    }

    public String getDescription() {
        return "address:port=" + Socket.toString(this.getInetAddress()) + ":" + this.getPort();
    }

    public InetAddress getInetAddress() {
        return this.__m_InetAddress;
    }

    public Exception getLastException() {
        return this.__m_LastException;
    }

    public long getLastExceptionLogMillis() {
        return this.__m_LastExceptionLogMillis;
    }

    public Object getLock() {
        Object lock = this.__m_Lock;
        return lock == null ? this : lock;
    }

    public int getPort() {
        return this.__m_Port;
    }

    public SocketProvider getProvider() {
        return this.__m_Provider;
    }

    public int getSoTimeout() {
        return this.__m_SoTimeout;
    }

    public int getState() {
        return this.__m_State;
    }

    protected void onException(IOException eException) {
        this.setLastException(eException);
        long ldtNow = Base.getSafeTimeMillis();
        if (this.getLastExceptionLogMillis() < ldtNow - 1000L) {
            this.setLastExceptionLogMillis(ldtNow);
            Socket._trace("Exception on " + String.valueOf(this) + "; " + String.valueOf(eException) + "\n" + Base.getStackTrace(eException), 9);
        }
    }

    @Override
    public void onInit() {
        this.setProvider(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
        super.onInit();
    }

    protected void onInterruptedIOException(InterruptedIOException eException) {
        this.onException(eException);
    }

    public void open() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInetAddress(InetAddress addr) {
        Object object = this.getLock();
        synchronized (object) {
            InetAddress addrCurr = this.getInetAddress();
            Socket._assert(this.getState() == 0 || addrCurr == null || addrCurr.isAnyLocalAddress(), "InetAddress cannot be modified once the socket has been opened");
            this.__m_InetAddress = addr;
        }
    }

    protected void setLastException(Exception e) {
        this.__m_LastException = e;
    }

    protected void setLastExceptionLogMillis(long lMillis) {
        this.__m_LastExceptionLogMillis = lMillis;
    }

    public void setLock(Object oLock) {
        Socket._assert(this.getState() == 0, "Lock cannot be modified once the socket has been opened");
        this.__m_Lock = oLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int nPort) {
        Object object = this.getLock();
        synchronized (object) {
            Socket._assert(this.getState() == 0, "Port cannot be modified once the socket has been opened");
            this.__m_Port = nPort;
        }
    }

    public void setProvider(SocketProvider provider) {
        if (provider == null) {
            provider = SocketProviderFactory.DEFAULT_SOCKET_PROVIDER;
        }
        this.__m_Provider = provider;
    }

    public void setSoTimeout(int cMillis) {
        this.__m_SoTimeout = cMillis;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.get_Name());
        sb.append("{State=").append(Socket.formatStateName(this.getState())).append(", ").append(this.getDescription()).append('}');
        return sb.toString();
    }

    public static String toString(InetAddress addr) {
        return InetAddressHelper.toString(addr);
    }

    protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
        if (cbActualSize < cbRequestedSize) {
            String sMsg = this.get_Name() + " failed to set " + sBufferName + " buffer size to " + cbRequestedSize + " bytes; actual size is " + cbActualSize + " bytes. Consult your OS documentation regarding increasing the maximum socket buffer size.";
            if (cbActualSize < cbMinimumSize) {
                Socket._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            sMsg = sMsg + " Proceeding with the actual value may cause sub-optimal performance.";
            Socket._trace(sMsg, 2);
        }
    }

    protected void validateSoTimeout(int cActual, int cRequired) {
        if (cActual != cRequired) {
            throw new RuntimeException("Failed to set SoTimeout to " + cRequired + "; actual value is " + cActual);
        }
    }
}

