/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.security.Standard;
import com.tangosol.internal.net.security.DefaultSecurityDependencies;
import com.tangosol.internal.net.security.DefaultStandardDependencies;
import com.tangosol.internal.net.security.LegacyXmlStandardHelper;
import com.tangosol.internal.net.security.SecurityDependencies;
import com.tangosol.net.Cluster;
import com.tangosol.net.ClusterPermission;
import com.tangosol.net.Service;
import com.tangosol.net.security.Authorizer;
import com.tangosol.net.security.DefaultIdentityAsserter;
import com.tangosol.net.security.DefaultIdentityTransformer;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.IdentityTransformer;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public abstract class Security
extends Net
implements PrivilegedAction {
    private static transient Authorizer __s_Authorizer;
    private static volatile transient boolean __s_Configured;
    private static transient IdentityAsserter __s_IdentityAsserter;
    private static transient IdentityTransformer __s_IdentityTransformer;
    private static transient Security __s_Instance;
    private static transient boolean __s_SubjectScoped;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("CheckPermissionAction", CheckPermissionAction.get_CLASS());
        __mapChildren.put("ConfigAction", ConfigAction.get_CLASS());
        __mapChildren.put("RefAction", RefAction.get_CLASS());
    }

    public Security(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/Security".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public void checkPermission(Cluster cluster, ClusterPermission permission, Subject subject) {
    }

    public static void checkPermission(Cluster cluster, String sServiceName, String sCacheName, String sAction) {
        Authorizer authorizer = Security.getAuthorizer();
        Security security = Security.getInstance();
        if (authorizer == null && security == null) {
            return;
        }
        Security._assert(sServiceName != null, "Service must be specified");
        String sTarget = "service=" + sServiceName + (String)(sCacheName == null ? "" : ",cache=" + sCacheName);
        ClusterPermission permission = new ClusterPermission(cluster == null || !cluster.isRunning() ? null : cluster.getClusterName(), sTarget, sAction);
        Subject subject = null;
        if (authorizer != null) {
            subject = authorizer.authorize(subject, permission);
        }
        if (security != null) {
            CheckPermissionAction action = new CheckPermissionAction();
            action.setCluster(cluster);
            action.setPermission(permission);
            action.setSubject(subject);
            action.setSecurity(security);
            AccessController.doPrivileged(new DoAsAction(action));
        }
    }

    public static DefaultSecurityDependencies cloneDeps(SecurityDependencies deps) {
        return new DefaultSecurityDependencies(deps);
    }

    public static synchronized void configureSecurity() {
        if (Security.isConfigured()) {
            return;
        }
        DefaultStandardDependencies deps = null;
        Standard security = null;
        try {
            deps = new DefaultStandardDependencies();
            XmlElement xmlConfig = Coherence.getServiceConfig("$Security");
            if (xmlConfig != null && (deps = LegacyXmlStandardHelper.fromXml(xmlConfig, deps)).isEnabled()) {
                security = (Standard)Security._newInstance("Component.Net.Security." + deps.getModel());
            }
        }
        finally {
            if (security == null) {
                Security.processDependencies(deps.validate());
            } else {
                if (deps.getModel().equals("Standard")) {
                    ((Standard)security).setDependencies(deps);
                }
                Security.setInstance(security);
            }
            Security.setConfigured(true);
        }
    }

    public static PrivilegedAction createPrivilegedAction(Method method) {
        RefAction action = new RefAction();
        action.setMethod(method);
        return action;
    }

    public static PrivilegedAction createPrivilegedAction(Method method, Object oTarget, Object[] aoArg) {
        RefAction action = new RefAction();
        action.setMethod(method);
        action.setTarget(oTarget);
        action.setArguments(aoArg);
        return action;
    }

    public static Authorizer getAuthorizer() {
        return __s_Authorizer;
    }

    public static IdentityAsserter getIdentityAsserter() {
        return __s_IdentityAsserter;
    }

    public static IdentityTransformer getIdentityTransformer() {
        return __s_IdentityTransformer;
    }

    public static Security getInstance() {
        if (!Security.isConfigured()) {
            AccessController.doPrivileged(new ConfigAction());
        }
        return __s_Instance;
    }

    public Subject impersonate(Subject subject, String sNameOld, String sNameNew) {
        return null;
    }

    protected static boolean isConfigured() {
        return __s_Configured;
    }

    public static boolean isSecurityEnabled() {
        return Security.getInstance() != null || Security.getAuthorizer() != null;
    }

    public static boolean isSubjectScoped() {
        return __s_SubjectScoped;
    }

    public static Subject login(CallbackHandler handler) {
        Security security = Security.getInstance();
        return security == null ? null : security.loginSecure(handler, null);
    }

    protected Subject loginSecure(CallbackHandler handler, Subject subject) {
        return null;
    }

    protected static void processDependencies(SecurityDependencies deps) {
        IdentityAsserter asserter = deps.getIdentityAsserter();
        Security.setIdentityAsserter(asserter == null ? DefaultIdentityAsserter.INSTANCE : asserter);
        IdentityTransformer transformer = deps.getIdentityTransformer();
        Security.setIdentityTransformer(transformer == null ? DefaultIdentityTransformer.INSTANCE : transformer);
        Security.setAuthorizer(deps.getAuthorizer());
        Security.setSubjectScoped(deps.isSubjectScoped());
    }

    public Object processSecureRequest(Member memberThis, Member memberFrom, PermissionInfo piRequest) {
        return null;
    }

    public void releaseSecureContext(String sServiceName) {
    }

    public Object run() {
        return null;
    }

    protected static Object runAnonymously(Object oAction) throws PrivilegedActionException {
        if (oAction instanceof PrivilegedAction) {
            return ((PrivilegedAction)oAction).run();
        }
        try {
            return ((PrivilegedExceptionAction)oAction).run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static Object runAs(Subject subject, Object oAction) throws PrivilegedActionException {
        Security security = Security.getInstance();
        return security == null ? Security.runAnonymously(oAction) : security.runSecure(subject, oAction);
    }

    protected Object runSecure(Subject subject, Object oAction) throws PrivilegedActionException {
        return null;
    }

    protected static void setAuthorizer(Authorizer authorizer) {
        __s_Authorizer = authorizer;
    }

    protected static void setConfigured(boolean fConfig) {
        __s_Configured = fConfig;
    }

    protected static void setIdentityAsserter(IdentityAsserter asserter) {
        __s_IdentityAsserter = asserter;
    }

    protected static void setIdentityTransformer(IdentityTransformer transformer) {
        __s_IdentityTransformer = transformer;
    }

    protected static void setInstance(Security security) {
        __s_Instance = security;
    }

    protected static void setSubjectScoped(boolean fSubjectScoped) {
        __s_SubjectScoped = fSubjectScoped;
    }

    public void verifySecureResponse(Service service, PermissionInfo info) {
    }

    static {
        Security.__initStatic();
    }

    public static class CheckPermissionAction
    extends Util
    implements PrivilegedAction {
        private Cluster __m_Cluster;
        private ClusterPermission __m_Permission;
        private Security __m_Security;
        private Subject __m_Subject;

        public CheckPermissionAction() {
            this(null, null, true);
        }

        public CheckPermissionAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CheckPermissionAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Security$CheckPermissionAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Cluster getCluster() {
            return this.__m_Cluster;
        }

        public ClusterPermission getPermission() {
            return this.__m_Permission;
        }

        public Security getSecurity() {
            return this.__m_Security;
        }

        public Subject getSubject() {
            return this.__m_Subject;
        }

        public Object run() {
            this.getSecurity().checkPermission(this.getCluster(), this.getPermission(), this.getSubject());
            return null;
        }

        public void setCluster(Cluster cluster) {
            this.__m_Cluster = cluster;
        }

        public void setPermission(ClusterPermission permission) {
            this.__m_Permission = permission;
        }

        public void setSecurity(Security security) {
            this.__m_Security = security;
        }

        public void setSubject(Subject subject) {
            this.__m_Subject = subject;
        }
    }

    public static class ConfigAction
    extends Util
    implements PrivilegedAction {
        public ConfigAction() {
            this(null, null, true);
        }

        public ConfigAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConfigAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Security$ConfigAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            try {
                Security cfr_ignored_0 = (Security)this.get_Module();
                Security.configureSecurity();
            }
            catch (RuntimeException e) {
                ConfigAction._trace("Failed to configure the Security module", 1);
                ConfigAction._trace(e);
            }
            return null;
        }
    }

    public static class RefAction
    extends Util
    implements PrivilegedAction {
        private transient Object[] __m_Arguments;
        private transient Method __m_Method;
        private transient Object __m_Target;

        public RefAction() {
            this(null, null, true);
        }

        public RefAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new RefAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Security$RefAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object[] getArguments() {
            return this.__m_Arguments;
        }

        public Method getMethod() {
            return this.__m_Method;
        }

        public Object getTarget() {
            return this.__m_Target;
        }

        public Object run() {
            try {
                return this.getMethod().invoke(this.getTarget(), this.getArguments());
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, this.toString());
            }
        }

        public void setArguments(Object[] method) {
            this.__m_Arguments = method;
        }

        public void setMethod(Method method) {
            this.__m_Method = method;
        }

        public void setTarget(Object method) {
            this.__m_Target = method;
        }

        @Override
        public String toString() {
            return "RefAction{Method=" + this.getMethod().getName() + ", Target=" + String.valueOf(this.getTarget()) + ", Args=" + Coherence.toString(this.getArguments()) + "}";
        }
    }
}

