/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterCooperativeNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.LiteSingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public class Poll
extends Net {
    private long __m_ExpiryTimeMillis;
    private long __m_InitTimeMillis;
    private MemberSet __m_LeftMemberSet;
    private transient SingleWaiterCooperativeNotifier __m_Notifier;
    private long __m_PollId;
    private MemberSet __m_RemainingMemberSet;
    private MemberSet __m_RespondedMemberSet;
    private Object __m_Result;
    private Grid __m_Service;
    private volatile int __m_State;
    public static final int STATE_CLOSED = 2;
    public static final int STATE_CLOSING = 1;
    public static final int STATE_OPEN = 0;
    private Span __m_TracingSpan;

    public Poll() {
        this(null, null, true);
    }

    public Poll(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_Notifier = new SingleWaiterCooperativeNotifier();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public boolean isPreprocessable() {
        return false;
    }

    public static Component get_Instance() {
        return new Poll();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/Poll".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    protected long checkRequestTimeout(long ldtStart, long cTimeout) {
        if (cTimeout == 0L) {
            return 0L;
        }
        long cElapsed = Base.getSafeTimeMillis() - ldtStart;
        if (cElapsed >= cTimeout) {
            Grid service = this.getService();
            service.setStatsTimeoutCount(service.getStatsTimeoutCount() + 1L);
            throw new RequestTimeoutException("Request timed out after " + cElapsed + " milliseconds");
        }
        return cTimeout - Math.max(0L, cElapsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Grid svc;
        boolean fCleanup = false;
        Poll poll = this;
        synchronized (poll) {
            if (this.getState() == 0) {
                this.setState(1);
                try {
                    this.onCompletion();
                }
                finally {
                    Span span = this.getTracingSpan();
                    if (span != null) {
                        span.end();
                    }
                    this.setState(2);
                    this.getNotifier().signal();
                    fCleanup = true;
                }
            }
        }
        if (fCleanup && (svc = this.getService()) != null) {
            svc.onPollClosed(this);
        }
    }

    public String getDescription() {
        return null;
    }

    public long getExpiryTimeMillis() {
        return this.__m_ExpiryTimeMillis;
    }

    public long getInitTimeMillis() {
        return this.__m_InitTimeMillis;
    }

    public MemberSet getLeftMemberSet() {
        return this.__m_LeftMemberSet;
    }

    public SingleWaiterCooperativeNotifier getNotifier() {
        return this.__m_Notifier;
    }

    public long getPollId() {
        return this.__m_PollId;
    }

    public MemberSet getRemainingMemberSet() {
        return this.__m_RemainingMemberSet;
    }

    public MemberSet getRespondedMemberSet() {
        return this.__m_RespondedMemberSet;
    }

    public Object getResult() {
        return this.__m_Result;
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public int getState() {
        return this.__m_State;
    }

    public Span getTracingSpan() {
        return this.__m_TracingSpan;
    }

    protected MemberSet instantiateRespondedMemberSet() {
        return new MemberSet();
    }

    public boolean isCloseableOnDelivery() {
        return this.get_StateAux() != 0;
    }

    public boolean isClosed() {
        return this.getState() == 2;
    }

    protected void onCompletion() {
    }

    public void onDelivery(RequestMessage msg) {
        if (this.getState() == 0 && this.isCloseableOnDelivery()) {
            this.close();
        }
    }

    public void onException(Throwable eReason) {
        TracingHelper.augmentSpanWithErrorDetails(this.getTracingSpan(), true, eReason);
    }

    @Override
    public void onInit() {
        super.onInit();
        EmptyMemberSet setEmpty = (EmptyMemberSet)EmptyMemberSet.get_Instance();
        this.setRemainingMemberSet(setEmpty);
        this.setRespondedMemberSet(setEmpty);
        this.setLeftMemberSet(setEmpty);
        this.setInitTimeMillis(Base.getSafeTimeMillis());
    }

    public synchronized void onLeft(Member member) {
        MemberSet setRemain = this.getRemainingMemberSet();
        MemberSet setLeft = this.getLeftMemberSet();
        if (!this.isClosed() && setRemain.contains(member)) {
            if (setRemain.size() == 1 && setLeft.isEmpty()) {
                MemberSet setTemp = setLeft;
                setLeft = setRemain;
                setRemain = setTemp;
                this.setLeftMemberSet(setLeft);
                this.setRemainingMemberSet(setRemain);
            } else {
                setRemain.remove(member);
                if (setLeft instanceof EmptyMemberSet) {
                    setLeft = new MemberSet();
                    this.setLeftMemberSet(setLeft);
                }
                setLeft.add(member);
            }
            if (setRemain.isEmpty()) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponded(Member member) {
        boolean fClose = false;
        Poll poll = this;
        synchronized (poll) {
            MemberSet setRemain = this.getRemainingMemberSet();
            MemberSet setResponded = this.getRespondedMemberSet();
            if (!this.isClosed() && setRemain.contains(member)) {
                if (setRemain.size() == 1 && setResponded.isEmpty()) {
                    MemberSet setTemp = setResponded;
                    setResponded = setRemain;
                    setRemain = setTemp;
                    this.setRespondedMemberSet(setResponded);
                    this.setRemainingMemberSet(setRemain);
                } else {
                    setRemain.remove(member);
                    if (setResponded instanceof EmptyMemberSet) {
                        setResponded = this.instantiateRespondedMemberSet();
                        this.setRespondedMemberSet(setResponded);
                    }
                    setResponded.add(member);
                }
                if (setRemain.isEmpty()) {
                    fClose = true;
                }
            }
        }
        if (fClose) {
            this.close();
        }
    }

    public void onResponse(Message msg) {
        if (!this.isClosed()) {
            this.onResponded(msg.getFromMember());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDispatch(RequestMessage msg) {
        MemberSet setPoll;
        Poll._assert(this.getPollId() != 0L);
        MemberSet setMsg = msg.getToMemberSet();
        switch (setMsg.size()) {
            case 0: {
                setPoll = (EmptyMemberSet)EmptyMemberSet.get_Instance();
                break;
            }
            case 1: {
                setPoll = LiteSingleMemberSet.copyFrom(setMsg);
                break;
            }
            default: {
                setPoll = new MemberSet();
                setPoll.addAll((Collection)setMsg);
            }
        }
        this.setRemainingMemberSet(setPoll);
        Grid service = this.getService();
        ServiceMemberSet setMember = service.getServiceMemberSet();
        if (service.getServiceState() == 4) {
            this.close();
        } else if (setPoll.isEmpty()) {
            service.doPollClose(this);
        } else if (setMember == null) {
            if (setPoll.size() != 1 || !setPoll.contains(service.getThisMember())) {
                throw new IllegalStateException();
            }
        } else if (!setMember.containsAll((Collection)setPoll)) {
            MasterMemberSet setMaster = service.getClusterMemberSet();
            int iLast = setPoll.getLastId();
            for (int i = setPoll.getFirstId(); i <= iLast; ++i) {
                if (!setPoll.contains(i) || setMember.contains(i)) continue;
                Member member = setMaster.getMember(i);
                if (member == null) {
                    MasterMemberSet masterMemberSet = setMaster;
                    synchronized (masterMemberSet) {
                        member = setMaster.getRecycleSet().getMember(i);
                    }
                    Poll._assert(member != null);
                }
                service.doPollMemberLeft(this, member);
            }
        }
        Span span = this.getTracingSpan();
        span.setMetadata("internal.message", msg.getMessageType() < 0);
        msg.setTracingSpanContext(span.getContext());
    }

    public boolean preprocessResponse(Message msgResponse) {
        Grid service;
        if (this.isPreprocessable() && (service = this.getService()).getQueue().isEmpty() && service.isInWait()) {
            service.onMessage(msgResponse);
            return true;
        }
        return false;
    }

    protected void setCloseableOnDelivery(boolean fDelivery) {
        this.set_StateAux(fDelivery ? 1 : 0);
    }

    public void setExpiryTimeMillis(long ldtExpiry) {
        this.__m_ExpiryTimeMillis = ldtExpiry;
    }

    protected void setInitTimeMillis(long cMillis) {
        this.__m_InitTimeMillis = cMillis;
    }

    protected void setLeftMemberSet(MemberSet setMember) {
        this.__m_LeftMemberSet = setMember;
    }

    private void setNotifier(SingleWaiterCooperativeNotifier notifier) {
        this.__m_Notifier = notifier;
    }

    public void setPollId(long lMsgId) {
        this.__m_PollId = lMsgId;
    }

    protected void setRemainingMemberSet(MemberSet setMember) {
        this.__m_RemainingMemberSet = setMember;
    }

    protected void setRespondedMemberSet(MemberSet setMember) {
        this.__m_RespondedMemberSet = setMember;
    }

    public void setResult(Object oResult) {
        this.__m_Result = oResult;
    }

    public void setService(Grid service) {
        Poll._assert(service != null && this.getService() == null);
        this.__m_Service = service;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    public void setTracingSpan(Span spanTracing) {
        this.__m_TracingSpan = spanTracing;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Poll").append("\n  {").append("\n  PollId=").append(this.getPollId()).append((String)(this.isClosed() ? ", closed" : ", active(" + String.valueOf(this.getNotifier()) + ")")).append("\n  InitTimeMillis=").append(new Timestamp(this.getInitTimeMillis())).append("\n  Service=");
        Grid service = this.getService();
        if (service == null) {
            sb.append("null");
        } else {
            sb.append(service.getServiceName()).append(" (").append(service.getServiceId()).append(')');
        }
        Component parent = this.get_Parent();
        if (parent != null) {
            sb.append(parent instanceof Message ? "\n  Message=" : "\n  Parent=").append(parent.get_Name());
        }
        sb.append("\n  RespondedMemberSet=[").append(this.getRespondedMemberSet().getIdList()).append(']').append("\n  LeftMemberSet=[").append(this.getLeftMemberSet().getIdList()).append(']').append("\n  RemainingMemberSet=[").append(this.getRemainingMemberSet().getIdList()).append(']');
        String sDesc = this.getDescription();
        if (sDesc != null && sDesc.length() > 0) {
            sb.append('\n').append(Base.indentString(sDesc, "  "));
        }
        sb.append("\n  }");
        return sb.toString();
    }

    public Object waitCompletion(long ldtStart, long cMillisTimeout) throws InterruptedException {
        SingleWaiterCooperativeNotifier notifier = this.getNotifier();
        while (!this.isClosed()) {
            notifier.await(this.checkRequestTimeout(ldtStart, cMillisTimeout));
        }
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitServiceResume(long ldtStart, long cMillisTimeout) throws InterruptedException {
        AtomicLong atl;
        long lId = this.getPollId();
        AtomicLong atomicLong = atl = this.getService().getSuspendPollLimit();
        synchronized (atomicLong) {
            while (lId > atl.get()) {
                Blocking.wait(atl, this.checkRequestTimeout(ldtStart, cMillisTimeout));
            }
        }
        return this.checkRequestTimeout(ldtStart, cMillisTimeout);
    }
}

