/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.io.BufferManager;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.packet.notifyPacket.Request;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.ArrayList;

public abstract class Packet
extends Net {
    private int __m_FromId;
    private int __m_PacketType;
    private long __m_ReceivedMillis;
    private int __m_SentCount;
    private long __m_SentMillis;
    private int __m_ToId;
    public static final int TRINT_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT_MAX_VARIANCE = 0x800000;
    public static final int TYPE_ACK = 232718545;
    public static final int TYPE_BROADCAST = 232718546;
    public static final int TYPE_DIAGNOSTIC = 0xDDF00D0;
    public static final int TYPE_DIRECTED_FEW = 232718547;
    public static final int TYPE_DIRECTED_MANY = 232718548;
    public static final int TYPE_DIRECTED_ONE = 232718549;
    public static final int TYPE_NAME_SERVICE = 232718554;
    public static final int TYPE_REQUEST = 232718550;
    public static final int TYPE_SEQUEL_FEW = 232718551;
    public static final int TYPE_SEQUEL_MANY = 232718552;
    public static final int TYPE_SEQUEL_ONE = 232718553;
    public static final int TYPE_TEST_MULTICAST = 1952805748;

    public Packet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public boolean isConfirmationRequired() {
        return false;
    }

    public boolean isOutgoingBroadcast() {
        return false;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/Packet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public static void ensureSkipBytes(ReadBuffer.BufferInput input, int cb) throws EOFException, IOException {
        if (input.skipBytes(cb) != cb) {
            throw input.available() == 0 ? new EOFException() : new IOException("failed to skip " + cb + " bytes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Packet[] extract(SocketAddress addrSrc, ByteBuffer buffer, BufferManager mgr, Packet[] aPacket, int nMemberId) throws IOException {
        ByteBufferReadBuffer bufferIn = new ByteBufferReadBuffer(buffer);
        ReadBuffer.BufferInput input = bufferIn.getBufferInput();
        int cPacket = 0;
        ArrayList<Packet> listPacket = null;
        boolean fOwned = false;
        int cSlots = aPacket == null ? 0 : aPacket.length;
        try {
            do {
                input.mark(3840);
                if (Packet.isForMember(input, nMemberId)) {
                    input.reset();
                    Packet packet = Packet.instantiate(input, nMemberId);
                    if (cPacket < cSlots) {
                        aPacket[cPacket] = packet;
                    } else if (cPacket == cSlots) {
                        listPacket = new ArrayList<Packet>(cSlots << 1);
                        for (int i = 0; i < cPacket; ++i) {
                            listPacket.add(aPacket[i]);
                        }
                        listPacket.add(packet);
                    } else {
                        listPacket.add(packet);
                    }
                    ++cPacket;
                    if (!(packet instanceof MessagePacket)) continue;
                    if (addrSrc != null && packet instanceof Broadcast) {
                        ((Broadcast)packet).setFromAddress((InetSocketAddress)addrSrc);
                    }
                    MessagePacket msgPacket = (MessagePacket)packet;
                    int cb = msgPacket.getBodyLength();
                    buffer.position(input.getOffset());
                    if (buffer.remaining() > cb) {
                        ByteBuffer bufDup = buffer.duplicate().limit(buffer.position() + cb);
                        msgPacket.setByteBuffer(mgr.acquire(cb).put(bufDup).flip());
                        Packet.ensureSkipBytes(input, cb);
                        continue;
                    }
                    msgPacket.setByteBuffer(buffer);
                    fOwned = true;
                    break;
                }
                input.reset();
                Packet.skip(input);
            } while (input.available() > 0);
        }
        finally {
            if (!fOwned) {
                mgr.release(buffer);
            }
        }
        if (aPacket.length > cPacket) {
            aPacket[cPacket] = null;
        }
        return listPacket == null ? aPacket : listPacket.toArray(new Packet[cPacket]);
    }

    public String getDescription() {
        return null;
    }

    public int getFromId() {
        return this.__m_FromId;
    }

    public int getLength() {
        return 0;
    }

    public int getPacketType() {
        return this.__m_PacketType;
    }

    public long getReceivedMillis() {
        return this.__m_ReceivedMillis;
    }

    public int getSentCount() {
        return this.__m_SentCount;
    }

    public long getSentMillis() {
        return this.__m_SentMillis;
    }

    public int getToId() {
        return this.__m_ToId;
    }

    public static Packet instantiate(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        int nType = input.readInt();
        Packet packet = switch (nType) {
            case 232718546 -> new Broadcast();
            case 232718547, 232718548, 232718549 -> new Directed();
            case 232718551, 232718552, 232718553 -> new Sequel();
            case 232718550 -> new Request();
            case 232718545 -> new Ack();
            case 0xDDF00D0 -> new DiagnosticPacket();
            default -> throw new IOException("unknown packet type: " + nType);
        };
        packet.setPacketType(nType);
        if (nType != 232718546) {
            packet.setToId(nMemberId);
        }
        packet.read(input, nMemberId);
        packet.setReceivedMillis(Base.getSafeTimeMillis());
        return packet;
    }

    public boolean isAddressedTo(int nMemberId) {
        return this.getToId() == nMemberId;
    }

    public boolean isDeferrable() {
        return this.isConfirmationRequired() && !this.isOutgoingMultipoint();
    }

    public static boolean isForCoherence(ReadBuffer.BufferInput input) throws IOException {
        if (input.available() >= 4) {
            switch (input.readInt()) {
                case 232718545: 
                case 232718546: 
                case 232718547: 
                case 232718548: 
                case 232718549: 
                case 232718550: 
                case 232718551: 
                case 232718552: 
                case 232718553: 
                case 232718554: 
                case 1952805748: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isForMember(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        try {
            int nType = input.readInt();
            if (nMemberId == 0) {
                return nType == 232718546;
            }
            switch (nType) {
                case 232718546: {
                    return true;
                }
                case 0xDDF00D0: 
                case 232718545: 
                case 232718549: 
                case 232718550: 
                case 232718553: {
                    return input.readUnsignedShort() == nMemberId;
                }
                case 232718547: 
                case 232718551: {
                    int c = input.readUnsignedByte();
                    for (int i = 0; i < c; ++i) {
                        if (input.readUnsignedShort() != nMemberId) continue;
                        return true;
                    }
                    return false;
                }
                case 232718548: 
                case 232718552: {
                    int nMask;
                    int cbSkip;
                    int of = Member.calcByteOffset(nMemberId);
                    int c = input.readUnsignedByte();
                    if (of >= c) {
                        return false;
                    }
                    if (of > 0 && input.skipBytes(cbSkip = of << 2) != cbSkip) {
                        throw new IOException("skip bytes failed!");
                    }
                    int nBits = input.readInt();
                    return (nBits & (nMask = Member.calcByteMask(nMemberId))) != 0;
                }
            }
            return false;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public boolean isIncoming() {
        return this.getReceivedMillis() != 0L;
    }

    public boolean isOutgoing() {
        return this.getReceivedMillis() == 0L;
    }

    public boolean isOutgoingMultipoint() {
        return false;
    }

    public static int makeTrint(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
    }

    public static int readUnsignedTrint(ReadBuffer.BufferInput input) throws IOException {
        byte[] ab = new byte[3];
        input.readFully(ab);
        return (ab[0] & 0xFF) << 16 | (ab[1] & 0xFF) << 8 | (ab[2] & 0xFF) << 0;
    }

    public void setFromId(int nId) {
        Packet._assert(!this.isIncoming());
        this.__m_FromId = nId;
    }

    protected void setPacketType(int nType) {
        this.__m_PacketType = nType;
    }

    protected void setReceivedMillis(long cMillis) {
        this.__m_ReceivedMillis = cMillis;
    }

    public void setSentCount(int cSent) {
        this.__m_SentCount = cSent;
    }

    public void setSentMillis(long cMillis) {
        this.__m_SentMillis = cMillis;
    }

    public void setToId(int nId) {
        Packet._assert(!this.isIncoming());
        this.__m_ToId = nId;
    }

    public static void skip(ReadBuffer.BufferInput input) throws IOException {
        try {
            int nType = input.readInt();
            switch (nType) {
                case 232718546: {
                    Broadcast.skip(input, nType);
                    break;
                }
                case 232718547: 
                case 232718548: 
                case 232718549: {
                    Directed.skip(input, nType);
                    break;
                }
                case 232718551: 
                case 232718552: 
                case 232718553: {
                    Sequel.skip(input, nType);
                    break;
                }
                case 232718550: {
                    Request.skip(input, nType);
                    break;
                }
                case 232718545: {
                    Ack.skip(input, nType);
                    break;
                }
                case 0xDDF00D0: {
                    DiagnosticPacket.skip(input, nType);
                    break;
                }
                case 1952805748: {
                    input.skip(input.available());
                    break;
                }
                default: {
                    throw new IOException("unknown packet type: " + nType);
                }
            }
        }
        catch (EOFException e) {
            input.skip(input.available());
        }
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        long lTime;
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{PacketType=0x").append(Base.toHexString(this.getPacketType(), 8)).append(", ToId=").append(this.getToId()).append(", FromId=").append(this.getFromId()).append(", Direction=");
        if (this.isIncoming()) {
            sb.append("Incoming, ReceivedMillis=");
            lTime = this.getReceivedMillis();
        } else {
            sb.append("Outgoing, SentCount=");
            sb.append(this.getSentCount());
            sb.append(", SentMillis=");
            lTime = this.getSentMillis();
        }
        if (lTime == 0L) {
            sb.append("none");
        } else {
            sb.append(new Time(lTime));
            sb.append('.');
            sb.append(lTime % 1000L);
        }
        String sDesc = this.getDescription();
        if (sDesc != null && sDesc.length() > 0) {
            sb.append(", ").append(sDesc);
        }
        sb.append('}');
        return sb.toString();
    }

    public static long translateTrint(int nTrint, long lCurrent) {
        long lLo = lCurrent - 0x800000L;
        long lHi = lCurrent + 0x800000L;
        nTrint &= 0xFFFFFF;
        long lBase = lCurrent >>> 24;
        for (int i = -1; i <= 1; ++i) {
            long lGuess = lBase + (long)i << 24 | (long)nTrint;
            if (lGuess < lLo || lGuess > lHi) continue;
            if (lGuess < 1L) {
                if (lCurrent > 2048L) {
                    Packet._trace("Large gap while initializing packet translation; current=" + lCurrent + " packet=" + nTrint + " value=" + lGuess, 6);
                }
                Packet._assert((lGuess += 0x1000000L) >= 1L);
            }
            return lGuess;
        }
        throw new IllegalStateException("translateTrint failed: nTrint=" + nTrint + ", lCurrent=" + lCurrent);
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
    }

    public static void writeTrint(WriteBuffer.BufferOutput output, int n) throws IOException {
        output.write(new byte[]{(byte)(n >>> 16), (byte)(n >>> 8), (byte)n});
    }

    public static void writeTrint(WriteBuffer.BufferOutput output, long l) throws IOException {
        Packet.writeTrint(output, (int)(l & 0xFFFFFFL));
    }
}

