/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.internal.net.socketbus.AbstractSocketBus;
import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.internal.util.HeapDump;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.Event;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.BusEventMessage;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.io.BufferSequenceWriteBufferPool;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import javax.net.ssl.SSLException;

public class MessageHandler
extends Net
implements MessagePublisher {
    private BufferManager __m_BufferManager;
    private volatile transient boolean __m_Closing;
    private transient Map __m_ConnectionMap;
    private long __m_DeliveryTimeoutMillis;
    private AtomicLong __m_DisconnectCounter;
    private static transient boolean __s_EstimateMessageSize;
    private Collector __m_EventCollector;
    private boolean __m_GlobalBacklog;
    private Object __m_GlobalBacklogMonitor;
    private SafeHashMap __m_HungConnectionIPs;
    private Queue __m_IncomingQueue;
    private boolean __m_LocalBacklog;
    private MessageBus __m_MessageBus;
    private MessagePublisher __m_ParentMessagePublisher;
    private AtomicBoolean __m_PendingParentFlush;
    private Grid __m_Service;
    private long __m_StatsBacklogDirect;
    private long __m_StatsBacklogGlobal;
    private long __m_StatsBacklogLocal;
    private transient long __m_StatsBusBytesIn;
    private transient long __m_StatsBusBytesOut;
    private AtomicLong __m_StatsBusBytesOutBuffered;
    private long __m_StatsBusReceives;
    private long __m_StatsBusSends;
    private LongAdder __m_StatsDrainOverflowDuration;
    private static ListMap __mapChildren;

    private static void _initStatic$Default() {
        MessageHandler.__initStatic();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Connection", Connection.get_CLASS());
    }

    public MessageHandler() {
        this(null, null, true);
    }

    public MessageHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionMap(new SafeHashMap());
            this.setGlobalBacklogMonitor(new Object());
            this.setStatsBusBytesOutBuffered(new AtomicLong());
            this.setStatsDrainOverflowDuration(new LongAdder());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new EventCollector("EventCollector", this, true), "EventCollector");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_DisconnectCounter = new AtomicLong();
            this.__m_HungConnectionIPs = new SafeHashMap();
            this.__m_PendingParentFlush = new AtomicBoolean();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Component get_Instance() {
        return new MessageHandler();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/MessageHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected boolean checkReleased(EndPoint peer) {
        Connection connect = (Connection)this.getConnectionMap().get(peer);
        return connect == null || connect.isReleased();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            if (!this.isClosing()) {
                this.setClosing(true);
                this.getMessageBus().close();
                Grid service = this.getService();
                Queue queue = this.getIncomingQueue();
                block7: while (true) {
                    Message msg;
                    if ((msg = (Message)queue.remove()) instanceof BusEventMessage) {
                        switch (((BusEventMessage)msg).getEvent().getType().ordinal()) {
                            case 3: 
                            case 4: {
                                service.onMessage(msg);
                                continue block7;
                            }
                            case 1: {
                                service.onMessage(msg);
                                return;
                            }
                        }
                        continue;
                    }
                    if (!msg.isDeserializationRequired()) continue;
                    msg.releaseIncoming();
                }
            }
        }
    }

    public int compareImportance(Member member) {
        return this.getService().compareImportance(member);
    }

    public boolean connect(Member member, EndPoint peer) {
        Map mapConnect = this.getConnectionMap();
        MessageHandler._assert(member != null && peer != null);
        MessageHandler._assert(!mapConnect.containsKey(peer), "Connect request out of order");
        Connection connect = this.instantiateConnection(peer, member);
        connect.setState(1);
        mapConnect.put(peer, connect);
        try {
            this.getMessageBus().connect(peer);
        }
        catch (IllegalArgumentException e) {
            MessageHandler._trace("Unable to connect to " + String.valueOf(peer) + " using " + String.valueOf(this.getMessageBus().getLocalEndPoint()) + " (" + e.getMessage() + "), falling back on default cluster transport", 2);
            mapConnect.remove(peer);
            return false;
        }
        MessageHandler._trace("Registered " + String.valueOf(connect), 6);
        return true;
    }

    public void connectAll() {
        Grid service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        Member memberThis = service.getThisMember();
        for (Member member : setMembers) {
            if (member == memberThis) continue;
            int nMember = member.getId();
            EndPoint peer = setMembers.getServiceEndPoint(nMember);
            if (peer == null && (peer = service.resolveEndPoint(setMembers.getServiceEndPointName(nMember), member, setMembers.getMemberConfigMap(nMember))) != null && this.connect(member, peer)) {
                setMembers.setServiceEndPoint(nMember, peer);
            }
            setMembers.setServiceEndPointName(nMember, peer == null ? null : peer.getCanonicalName());
        }
    }

    public ReadBuffer createReadBuffer(BufferSequence bufseq) {
        int cBuffers = bufseq.getBufferCount();
        if (cBuffers == 1) {
            return new ByteBufferReadBuffer(bufseq.getBuffer(0));
        }
        ReadBuffer[] abuf = new ReadBuffer[cBuffers];
        for (int i = 0; i < cBuffers; ++i) {
            abuf[i] = new ByteBufferReadBuffer(bufseq.getBuffer(i));
        }
        return new MultiBufferReadBuffer(abuf);
    }

    public long drainOverflow(Set setDest, long cMillisTimeout) throws InterruptedException {
        int nMemberTo;
        ServiceMemberSet setMemberService;
        EndPoint peer;
        MemberSet setMember = (MemberSet)setDest;
        if (!(setMember.size() != 1 || this.isGlobalBacklog() || this.isLocalBacklog() || (peer = (setMemberService = this.getService().getServiceMemberSet()).getServiceEndPoint(nMemberTo = setMember.getFirstId())) == null || setMemberService.isServiceBacklogged(nMemberTo))) {
            return cMillisTimeout;
        }
        long ldtStart = Base.getSafeTimeMillis();
        cMillisTimeout = this.drainOverflowComplex(setMember, cMillisTimeout);
        long ldtDelta = Base.getSafeTimeMillis() - ldtStart;
        if (ldtDelta > 0L) {
            this.getStatsDrainOverflowDuration().add(ldtDelta);
        }
        return cMillisTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long drainOverflowComplex(MemberSet setMember, long cMillisTimeout) throws InterruptedException {
        Object object;
        long ldtTimeout;
        Grid service = this.getService();
        ServiceMemberSet setMemberService = service.getServiceMemberSet();
        long l = ldtTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillisTimeout;
        if (this.isGlobalBacklog()) {
            Object oMonitor;
            object = oMonitor = this.getGlobalBacklogMonitor();
            synchronized (object) {
                while (cMillisTimeout >= 0L && this.isGlobalBacklog()) {
                    Blocking.wait(oMonitor, cMillisTimeout);
                    cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                }
            }
        }
        if (this.isLocalBacklog()) {
            EndPoint pointLocal = this.getMessageBus().getLocalEndPoint();
            object = pointLocal;
            synchronized (object) {
                while (cMillisTimeout >= 0L && this.isLocalBacklog()) {
                    Blocking.wait(pointLocal, cMillisTimeout);
                    cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                }
            }
        }
        boolean fParent = false;
        switch (setMember.size()) {
            case 0: {
                break;
            }
            case 1: {
                int nMemberTo = setMember.getFirstId();
                EndPoint peer = setMemberService.getServiceEndPoint(nMemberTo);
                if (peer == null) {
                    fParent = true;
                    break;
                }
                if (nMemberTo == 0 || !setMemberService.isServiceBacklogged(nMemberTo)) break;
                EndPoint endPoint = peer;
                synchronized (endPoint) {
                    while (cMillisTimeout >= 0L && setMemberService.isServiceBacklogged(nMemberTo)) {
                        Blocking.wait(peer, cMillisTimeout);
                        cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                    }
                    break;
                }
            }
            default: {
                for (int nMemberTo : setMember.toIdArray()) {
                    EndPoint peer = setMemberService.getServiceEndPoint(nMemberTo);
                    if (peer == null) {
                        fParent = true;
                        continue;
                    }
                    if (nMemberTo == 0 || !setMemberService.isServiceBacklogged(nMemberTo)) continue;
                    EndPoint endPoint = peer;
                    synchronized (endPoint) {
                        while (cMillisTimeout >= 0L && setMemberService.isServiceBacklogged(nMemberTo)) {
                            Blocking.wait(peer, cMillisTimeout);
                            cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                        }
                    }
                }
            }
        }
        if (cMillisTimeout < 0L) {
            throw new RequestTimeoutException("Request timed out");
        }
        return fParent ? this.getParentMessagePublisher().drainOverflow(setMember, cMillisTimeout) : cMillisTimeout;
    }

    @Override
    public void flush() {
        block3: {
            try {
                this.getMessageBus().flush();
            }
            catch (IllegalStateException e) {
                if (this.isClosing()) break block3;
                throw e;
            }
        }
        AtomicBoolean atomicFlush = this.getPendingParentFlush();
        if (atomicFlush.get() && atomicFlush.compareAndSet(true, false)) {
            this.getParentMessagePublisher().flush();
        }
    }

    public BufferManager getBufferManager() {
        return this.__m_BufferManager;
    }

    public Map getConnectionMap() {
        return this.__m_ConnectionMap;
    }

    public long getDeliveryTimeoutMillis() {
        return this.__m_DeliveryTimeoutMillis;
    }

    public AtomicLong getDisconnectCounter() {
        return this.__m_DisconnectCounter;
    }

    public Collector getEventCollector() {
        return this.__m_EventCollector;
    }

    public Object getGlobalBacklogMonitor() {
        return this.__m_GlobalBacklogMonitor;
    }

    public SafeHashMap getHungConnectionIPs() {
        return this.__m_HungConnectionIPs;
    }

    public Queue getIncomingQueue() {
        return this.__m_IncomingQueue;
    }

    public MessageBus getMessageBus() {
        return this.__m_MessageBus;
    }

    public MessagePublisher getParentMessagePublisher() {
        return this.__m_ParentMessagePublisher;
    }

    protected AtomicBoolean getPendingParentFlush() {
        return this.__m_PendingParentFlush;
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public Grid getServiceById(int nSvcId) {
        Grid service = this.getService();
        MessageHandler._assert(service.getServiceId() == nSvcId);
        return service;
    }

    public long getStatsBacklogDirect() {
        return this.__m_StatsBacklogDirect;
    }

    public long getStatsBacklogGlobal() {
        return this.__m_StatsBacklogGlobal;
    }

    public long getStatsBacklogLocal() {
        return this.__m_StatsBacklogLocal;
    }

    public long getStatsBusBytesIn() {
        return this.__m_StatsBusBytesIn;
    }

    public long getStatsBusBytesOut() {
        return this.__m_StatsBusBytesOut;
    }

    public AtomicLong getStatsBusBytesOutBuffered() {
        return this.__m_StatsBusBytesOutBuffered;
    }

    public long getStatsBusReceives() {
        return this.__m_StatsBusReceives;
    }

    public long getStatsBusSends() {
        return this.__m_StatsBusSends;
    }

    public LongAdder getStatsDrainOverflowDuration() {
        return this.__m_StatsDrainOverflowDuration;
    }

    public void initialize(Grid service, MessageBus bus, MessagePublisher publisherParent) {
        MessageHandler._assert(this.getService() == null, "Already initialized");
        service.ensureGuardSupport();
        this.setService(service);
        this.setMessageBus(bus);
        this.setParentMessagePublisher(publisherParent);
        this.setIncomingQueue(service.getQueue());
        this.setDeliveryTimeoutMillis(service.getCluster().getDependencies().getPublisherResendTimeoutMillis());
        this.setBufferManager(bus instanceof AbstractSocketBus ? SocketBusDriver.DefaultDependencies.DEFAULT_BUFFER_MANAGER : BufferManagers.getNetworkDirectManager());
        bus.setEventCollector(this.getEventCollector());
        bus.open();
    }

    protected Connection instantiateConnection(EndPoint peer, Member member) {
        Connection connect = (Connection)this._newChild("Connection");
        connect.setPeer(peer);
        connect.setMember(member);
        return connect;
    }

    public boolean isClosing() {
        return this.__m_Closing;
    }

    public static boolean isEstimateMessageSize() {
        return __s_EstimateMessageSize;
    }

    public boolean isGlobalBacklog() {
        return this.__m_GlobalBacklog;
    }

    public boolean isLocalBacklog() {
        return this.__m_LocalBacklog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBacklog(EndPoint peer, boolean fExcessive) {
        EndPoint pointLocal = this.getMessageBus().getLocalEndPoint();
        if (peer == null) {
            if (fExcessive) {
                this.setGlobalBacklog(true);
                this.setStatsBacklogGlobal(this.getStatsBacklogGlobal() + 1L);
            } else {
                Object oMonitor;
                Object object = oMonitor = this.getGlobalBacklogMonitor();
                synchronized (object) {
                    this.setGlobalBacklog(false);
                    oMonitor.notifyAll();
                }
            }
        } else if (peer.equals(pointLocal)) {
            if (fExcessive) {
                this.setLocalBacklog(true);
                this.setStatsBacklogLocal(this.getStatsBacklogLocal() + 1L);
            } else {
                EndPoint oMonitor = pointLocal;
                synchronized (oMonitor) {
                    this.setLocalBacklog(false);
                    pointLocal.notifyAll();
                }
            }
        } else {
            Connection connect = (Connection)this.getConnectionMap().get(peer);
            if (connect != null) {
                ServiceMemberSet setMember = this.getService().getServiceMemberSet();
                int nMember = connect.getMember().getId();
                if (fExcessive) {
                    setMember.setServiceBacklogged(nMember, true);
                    this.setStatsBacklogDirect(this.getStatsBacklogDirect() + 1L);
                } else {
                    EndPoint endPoint = peer = connect.getPeer();
                    synchronized (endPoint) {
                        setMember.setServiceBacklogged(nMember, false);
                        peer.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onBusEvent(Event event) {
        try {
            switch (event.getType().ordinal()) {
                case 0: {
                    this.onOpen();
                    return;
                }
                case 1: {
                    this.onClose();
                    return;
                }
                case 2: {
                    this.onConnect(event.getEndPoint());
                    return;
                }
                case 9: {
                    this.onMessage(event.getEndPoint(), (BufferSequence)event.getContent());
                    return;
                }
                case 3: {
                    this.onDisconnect(event.getEndPoint(), (Throwable)event.getContent());
                    return;
                }
                case 4: {
                    this.onReleased(event.getEndPoint());
                    return;
                }
                case 5: {
                    this.onBacklog(event.getEndPoint(), true);
                    return;
                }
                case 6: {
                    this.onBacklog(event.getEndPoint(), false);
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        finally {
            event.dispose();
        }
    }

    protected void onClose() {
        this.onBacklog(this.getMessageBus().getLocalEndPoint(), false);
        this.onBacklog(null, false);
    }

    protected void onConnect(EndPoint peer) {
        Connection conn = (Connection)this.getConnectionMap().get(peer);
        if (conn == null) {
            this.getMessageBus().release(peer);
        } else {
            switch (conn.getState()) {
                case 1: {
                    conn.setState(2);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Connect event: " + String.valueOf(conn));
                }
            }
        }
    }

    protected void onDisconnect(EndPoint peer, Throwable tReason) {
        Connection conn = (Connection)this.getConnectionMap().get(peer);
        if (conn != null) {
            conn.onDisconnect(tReason);
        }
    }

    public void onException(Throwable e) {
        this.getService().onException(e);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setEventCollector((EventCollector)this._findChild("EventCollector"));
    }

    public void onInterval() {
        try {
            Iterator iter = this.getConnectionMap().values().iterator();
            while (iter.hasNext()) {
                ((Connection)iter.next()).onInterval();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMessage(EndPoint peer, BufferSequence bufseq) throws IOException {
        Connection connect = (Connection)this.getConnectionMap().get(peer);
        if (connect == null) {
            MessageHandler._trace("Discarding a message from disconnected or unknown peer: " + String.valueOf(peer), 2);
            return;
        } else if (connect.isEstablished() || connect.establish()) {
            Message msg = connect.prepareMessage(bufseq);
            if (msg == null) return;
            Grid service = msg.getService();
            if (service != this.getService()) throw new IllegalStateException();
            if (msg.isDeserializationRequired() && !service.deserializeMessage(msg)) return;
            service.onMessage(msg);
            return;
        } else {
            MessageHandler._trace("Ignoring delayed message from departing " + String.valueOf(connect), 6);
        }
    }

    protected void onOpen() {
    }

    protected void onReleased(EndPoint peer) {
        this.onBacklog(peer, false);
        Connection conn = (Connection)this.getConnectionMap().remove(peer);
        if (conn != null) {
            conn.onReleased();
            MessageHandler._trace("Unregistered " + String.valueOf(conn), 6);
        }
    }

    public boolean post(Object oMsg) {
        if (this.isClosing()) {
            return false;
        }
        Message msg = (Message)oMsg;
        ServiceMemberSet setEndPoint = this.getService().getServiceMemberSet();
        MemberSet setMemberTo = msg.getToMemberSet();
        MessageHandler._assert(setMemberTo != null, "MessageBus cannot be used to broadcast");
        switch (setMemberTo.size()) {
            case 0: {
                return false;
            }
            case 1: {
                int nMemberTo = setMemberTo.getFirstId();
                EndPoint peer = setEndPoint.getServiceEndPoint(nMemberTo);
                if (peer == null) {
                    if (this.getParentMessagePublisher().post(msg)) {
                        this.getPendingParentFlush().set(true);
                        return true;
                    }
                    return false;
                }
                BufferSequence bufseq = this.serializeMessage(msg);
                long cbMsg = bufseq.getLength();
                this.getStatsBusBytesOutBuffered().addAndGet(cbMsg);
                try {
                    Connection conn = (Connection)this.getConnectionMap().get(peer);
                    if (conn == null) {
                        throw new IllegalArgumentException("unknown peer " + String.valueOf(peer));
                    }
                    this.getMessageBus().send(peer, bufseq, msg, false);
                    conn.getSentMessageCount().incrementAndGet();
                    this.setStatsBusSends(this.getStatsBusSends() + 1L);
                    this.setStatsBusBytesOut(this.getStatsBusBytesOut() + cbMsg);
                    return true;
                }
                catch (RuntimeException e) {
                    msg.releaseOutgoing(true);
                    if (this.isClosing() || this.checkReleased(peer)) {
                        return false;
                    }
                    throw e;
                }
            }
        }
        return this.postMulti(msg);
    }

    public void postEventMessage(Event event) {
        Grid service = this.getService();
        BusEventMessage msgEvent = (BusEventMessage)service.instantiateMessage("BusEventMessage");
        msgEvent.setEvent(event);
        msgEvent.setMessageHandler(this);
        msgEvent.addToMember(service.getThisMember());
        service.post(msgEvent);
    }

    protected boolean postMulti(Message msg) {
        ServiceMemberSet setEndPoint = this.getService().getServiceMemberSet();
        MemberSet setMemberTo = msg.getToMemberSet();
        MessageBus bus = this.getMessageBus();
        BufferSequence bufseq = null;
        boolean fSent = false;
        long cbSent = 0L;
        long cbMsg = 0L;
        for (int nId : setMemberTo.toIdArray()) {
            MessageHandler._assert(nId != 0);
            EndPoint peer = setEndPoint.getServiceEndPoint(nId);
            if (peer == null) continue;
            if (bufseq == null) {
                bufseq = this.serializeMessage(msg);
                cbMsg = bufseq.getLength();
            }
            setMemberTo.remove(nId);
            try {
                Connection conn = (Connection)this.getConnectionMap().get(peer);
                if (conn == null) {
                    throw new IllegalArgumentException("unknown peer " + String.valueOf(peer));
                }
                bus.send(peer, bufseq, msg);
                conn.getSentMessageCount().incrementAndGet();
                cbSent += cbMsg;
                fSent = true;
            }
            catch (RuntimeException e) {
                msg.releaseOutgoing(true);
                if (this.isClosing() || this.checkReleased(peer)) continue;
                throw e;
            }
        }
        if (cbSent != 0L) {
            this.setStatsBusSends(this.getStatsBusSends() + 1L);
            this.setStatsBusBytesOut(this.getStatsBusBytesOut() + cbSent);
            this.getStatsBusBytesOutBuffered().addAndGet(cbSent);
        }
        if (!setMemberTo.isEmpty() && this.getParentMessagePublisher().post(msg)) {
            fSent = true;
            this.getPendingParentFlush().set(true);
        }
        return fSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(Event event) throws IOException {
        EndPoint peer = event.getEndPoint();
        BufferSequence bufseq = (BufferSequence)event.getContent();
        Connection connect = (Connection)this.getConnectionMap().get(peer);
        this.setStatsBusReceives(this.getStatsBusReceives() + 1L);
        this.setStatsBusBytesIn(this.getStatsBusBytesIn() + bufseq.getLength());
        try {
            if (connect == null) {
                this.postEventMessage(event);
                event = null;
            } else if (connect.isEstablished() || connect.establish()) {
                Message msg = connect.prepareMessage(bufseq);
                if (msg != null) {
                    Grid service;
                    int cWorkers;
                    if (msg.isDeserializationRequired()) {
                        msg.setBufferController(event);
                        event = null;
                    }
                    if ((cWorkers = (service = msg.getService()).getDependencies().getWorkerThreadCount()) <= 0 && (service.isAcceptingOthers() || service == this.getService())) {
                        if (service.deserializeMessage(msg)) {
                            if (cWorkers < 0) {
                                service.onMessage(msg);
                                return;
                            }
                        } else {
                            msg = null;
                        }
                    }
                    if (msg != null) {
                        msg.getService().getQueue().add(msg);
                    }
                }
            } else {
                MessageHandler._trace("Ignoring delayed message from departing " + String.valueOf(connect), 6);
            }
        }
        finally {
            if (event != null) {
                event.dispose();
            }
        }
    }

    public void processReceipt(EndPoint peer, Message msg, boolean fSuspect) {
        if (msg == null) {
            MessageHandler._trace("received a delivery receipt for a null message", 2);
            MessageHandler._trace(new Throwable());
            return;
        }
        BufferSequence bufseq = (BufferSequence)msg.getBufferController();
        if (bufseq == null) {
            MessageHandler._trace("received a delivery receipt for a disposed message: " + String.valueOf(msg), 2);
            MessageHandler._trace(new Throwable());
            return;
        }
        this.getStatsBusBytesOutBuffered().addAndGet(-bufseq.getLength());
        Connection connection = (Connection)this.getConnectionMap().get(peer);
        if (connection != null) {
            connection.setReceivedReceiptCount(connection.getReceivedReceiptCount() + 1L);
        }
        msg.releaseOutgoing(fSuspect);
    }

    public void release(EndPoint peer, Continuation continuation) {
        Connection conn = (Connection)this.getConnectionMap().get(peer);
        if (conn == null) {
            throw new IllegalArgumentException("No connection to: " + String.valueOf(peer));
        }
        conn.release(continuation);
    }

    public void resetStats() {
        this.setStatsBusSends(0L);
        this.setStatsBusReceives(0L);
        this.setStatsBusBytesOut(0L);
        this.setStatsBusBytesIn(0L);
        this.setStatsBacklogGlobal(0L);
        this.setStatsBacklogLocal(0L);
        this.setStatsBacklogDirect(0L);
    }

    protected BufferSequence serializeMessage(Message msg) {
        BufferSequence bufseq = (BufferSequence)msg.getBufferController();
        if (bufseq == null) {
            BufferSequenceWriteBufferPool adapter = new BufferSequenceWriteBufferPool(this.getBufferManager());
            try {
                Grid service = msg.getService();
                service.serializeMessage(msg, new MultiBufferWriteBuffer(adapter, 0).getBufferOutput());
            }
            catch (Throwable e) {
                adapter.toBufferSequence().dispose();
                throw Base.ensureRuntimeException(e);
            }
            bufseq = adapter.toBufferSequence();
            msg.setBufferController(bufseq, msg.getToMemberSet().size());
        }
        return bufseq;
    }

    public void setBufferManager(BufferManager managerBuffer) {
        this.__m_BufferManager = managerBuffer;
        MessageHandler._trace("Initialized BufferManager to: " + String.valueOf(managerBuffer), 4);
    }

    protected void setClosing(boolean fClosing) {
        this.__m_Closing = fClosing;
    }

    protected void setConnectionMap(Map map) {
        this.__m_ConnectionMap = map;
    }

    public void setDeliveryTimeoutMillis(long lMillis) {
        this.__m_DeliveryTimeoutMillis = lMillis;
    }

    private void setDisconnectCounter(AtomicLong longCounter) {
        this.__m_DisconnectCounter = longCounter;
    }

    public static void setEstimateMessageSize(boolean fSize) {
        __s_EstimateMessageSize = fSize;
    }

    protected void setEventCollector(Collector collector) {
        this.__m_EventCollector = collector;
    }

    public void setGlobalBacklog(boolean pGlobalBacklog) {
        this.__m_GlobalBacklog = pGlobalBacklog;
    }

    protected void setGlobalBacklogMonitor(Object oMonitor) {
        this.__m_GlobalBacklogMonitor = oMonitor;
    }

    private void setHungConnectionIPs(SafeHashMap integerCount) {
        this.__m_HungConnectionIPs = integerCount;
    }

    protected void setIncomingQueue(Queue queue) {
        this.__m_IncomingQueue = queue;
    }

    public void setLocalBacklog(boolean pGlobalBacklog) {
        this.__m_LocalBacklog = pGlobalBacklog;
    }

    protected void setMessageBus(MessageBus bus) {
        this.__m_MessageBus = bus;
    }

    protected void setParentMessagePublisher(MessagePublisher publisher) {
        this.__m_ParentMessagePublisher = publisher;
    }

    private void setPendingParentFlush(AtomicBoolean atomic) {
        this.__m_PendingParentFlush = atomic;
    }

    protected void setService(Grid service) {
        this.__m_Service = service;
    }

    protected void setStatsBacklogDirect(long c) {
        this.__m_StatsBacklogDirect = c;
    }

    protected void setStatsBacklogGlobal(long c) {
        this.__m_StatsBacklogGlobal = c;
    }

    protected void setStatsBacklogLocal(long c) {
        this.__m_StatsBacklogLocal = c;
    }

    protected void setStatsBusBytesIn(long lOut) {
        this.__m_StatsBusBytesIn = lOut;
    }

    protected void setStatsBusBytesOut(long lOut) {
        this.__m_StatsBusBytesOut = lOut;
    }

    protected void setStatsBusBytesOutBuffered(AtomicLong longBuffered) {
        this.__m_StatsBusBytesOutBuffered = longBuffered;
    }

    protected void setStatsBusReceives(long lReceives) {
        this.__m_StatsBusReceives = lReceives;
    }

    protected void setStatsBusSends(long lSends) {
        this.__m_StatsBusSends = lSends;
    }

    public void setStatsDrainOverflowDuration(LongAdder adderDuration) {
        this.__m_StatsDrainOverflowDuration = adderDuration;
    }

    @Override
    public String toString() {
        return this.get_Name() + "{Service=" + this.getService().getServiceName() + (this.isClosing() ? ", closing" : "") + ", connections=" + this.getConnectionMap().size() + ", disconnectedIPs=" + this.getHungConnectionIPs().size() + ", backlogs=(" + this.getStatsBacklogGlobal() + "/" + this.getStatsBacklogLocal() + "/" + this.getStatsBacklogDirect() + "), bus=" + String.valueOf(this.getMessageBus()) + "}";
    }

    static {
        MessageHandler._initStatic$Default();
        MessageHandler.setEstimateMessageSize(Boolean.parseBoolean(Config.getProperty("coherence.estimateBusMessageSize", "true")));
    }

    public static class Connection
    extends Util
    implements Guardable {
        private Guardian.GuardContext __m_Context;
        private Throwable __m_DisconnectCause;
        private boolean __m_Established;
        private BufferSequence __m_LastBadMessage;
        private long __m_LastHealthyTimestamp;
        private long __m_LastHeuristicDeathTimestamp;
        private Member __m_Member;
        private EndPoint __m_Peer;
        private volatile long __m_ReceivedReceiptCount;
        private Continuation __m_ReleaseAction;
        private AtomicLong __m_SentMessageCount;
        private int __m_State;
        public static final int STATE_CONNECTED = 2;
        public static final int STATE_CONNECTING = 1;
        public static final int STATE_DISCONNECTED = 4;
        public static final int STATE_DISCONNECTING = 3;
        public static final int STATE_INITIAL = 0;
        public static final int STATE_RELEASED = 5;
        private long __m_SuspectReceivedReceiptCount;
        private long __m_SuspectTimeoutTimestamp;

        public Connection() {
            this(null, null, true);
        }

        public Connection(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
            try {
                this.__m_SentMessageCount = new AtomicLong();
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
        }

        public static Component get_Instance() {
            return new Connection();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/MessageHandler$Connection".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean establish() {
            Connection connection = this;
            synchronized (connection) {
                if (this.getState() < 3) {
                    if (!this.isEstablished()) {
                        Connection._trace("Connection established with " + String.valueOf(this.getPeer()), 3);
                        this.setEstablished(true);
                    }
                    return true;
                }
                return false;
            }
        }

        public String formatStateName(int nState) {
            switch (nState) {
                case 0: {
                    return "INITIAL";
                }
                case 1: {
                    return "CONNECTING";
                }
                case 2: {
                    return "CONNECTED";
                }
                case 3: {
                    return "DISCONNECTING";
                }
                case 4: {
                    Throwable t = this.getDisconnectCause();
                    return "DISCONNECTED" + (String)(t == null ? "" : "(" + String.valueOf(t) + ")");
                }
                case 5: {
                    return "RELEASED";
                }
            }
            return "<unknown> " + nState;
        }

        @Override
        public Guardian.GuardContext getContext() {
            return this.__m_Context;
        }

        public long getDeliveryTimeoutMillis() {
            int nImportance;
            MessageHandler handler = (MessageHandler)this.get_Module();
            long cMillis = handler.getDeliveryTimeoutMillis();
            Member member = this.getMember();
            if (member != null && ((nImportance = handler.compareImportance(member)) > 0 || nImportance == 0 && handler.getService().getThisMember().getTimestamp() < member.getTimestamp())) {
                cMillis += cMillis / 20L;
            }
            return cMillis;
        }

        public Throwable getDisconnectCause() {
            return this.__m_DisconnectCause;
        }

        public BufferSequence getLastBadMessage() {
            return this.__m_LastBadMessage;
        }

        public long getLastHealthyTimestamp() {
            return this.__m_LastHealthyTimestamp;
        }

        public long getLastHeuristicDeathTimestamp() {
            return this.__m_LastHeuristicDeathTimestamp;
        }

        public Member getMember() {
            return this.__m_Member;
        }

        public EndPoint getPeer() {
            return this.__m_Peer;
        }

        public long getReceivedReceiptCount() {
            return this.__m_ReceivedReceiptCount;
        }

        public Continuation getReleaseAction() {
            return this.__m_ReleaseAction;
        }

        public AtomicLong getSentMessageCount() {
            return this.__m_SentMessageCount;
        }

        public int getState() {
            return this.__m_State;
        }

        public long getSuspectReceivedReceiptCount() {
            return this.__m_SuspectReceivedReceiptCount;
        }

        public long getSuspectTimeoutTimestamp() {
            return this.__m_SuspectTimeoutTimestamp;
        }

        public boolean isEstablished() {
            return this.__m_Established;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReleased() {
            Connection connection = this;
            synchronized (connection) {
                return this.getState() >= 3;
            }
        }

        public void onDeliveryTimeout() {
            if (this.getState() < 3) {
                MessageHandler handler = (MessageHandler)this.get_Module();
                EndPoint peer = this.getPeer();
                Connection._trace("Disconnecting with " + String.valueOf(peer) + " after failing to deliver a message for " + String.valueOf(new Duration(handler.getDeliveryTimeoutMillis() * 1000000L)), 3);
                handler.getMessageBus().disconnect(peer);
            }
        }

        public void onDisconnect(Throwable tReason) {
            MessageHandler handler = (MessageHandler)this.get_Module();
            if (this.getState() != 3 && !handler.isClosing()) {
                String sReason;
                int nImportance;
                Grid service = handler.getService();
                Cluster cluster = (Cluster)service.getCluster();
                long cMillisMax = cluster.getDependencies().getPublisherResendTimeoutMillis() * 3 / 2;
                long cMillisMin = cluster.getIpMonitor().getAddressTimeout() * 3L / 2L;
                long cMillis = cMillisMin == 0L ? cMillisMax : Math.max(cMillisMin, cMillisMax >> handler.getHungConnectionIPs().size());
                Member member = this.getMember();
                if (member != null && ((nImportance = service.compareImportance(member)) > 0 || nImportance == 0 && service.getThisMember().getTimestamp() < member.getTimestamp())) {
                    cMillis += cMillis / 2L;
                }
                if (tReason == null) {
                    sReason = "n/a";
                } else {
                    sReason = tReason.getMessage();
                    if (sReason == null || sReason.length() == 0) {
                        sReason = tReason.getClass().getName();
                    }
                    Connection._trace(Connection.getStackTrace(tReason), tReason instanceof SSLException ? 2 : (tReason instanceof IOException ? 9 : 7));
                }
                Connection._trace("Detected disconnect (" + sReason + ") of " + String.valueOf(this) + " awaiting ServiceLeft notification with timeout of " + String.valueOf(new Duration(cMillis * 1000000L)) + " based on " + String.valueOf(((MessageHandler)this.get_Module()).getDisconnectCounter()) + " concurrent disconnects", tReason instanceof SSLException ? 2 : 7);
                service.guard(this, cMillis, 1.0f);
            }
            this.setState(4);
            this.setDisconnectCause(tReason);
        }

        public void onIdle() {
        }

        public void onInterval() {
            long ldtNow = Base.getLastSafeTimeMillis();
            long cRecNow = this.getReceivedReceiptCount();
            long cRecLast = this.getSuspectReceivedReceiptCount();
            this.setSuspectReceivedReceiptCount(cRecNow);
            if (cRecNow > cRecLast) {
                long ldtLast = this.getSuspectTimeoutTimestamp();
                if (ldtLast != 0L && ldtNow - ldtLast > this.getDeliveryTimeoutMillis() / 2L) {
                    this.setLastHeuristicDeathTimestamp(ldtNow);
                }
                this.setSuspectTimeoutTimestamp(0L);
                this.setLastHealthyTimestamp(ldtNow);
            } else if (cRecNow < this.getSentMessageCount().get()) {
                long ldtTimeout = this.getSuspectTimeoutTimestamp();
                if (ldtTimeout == 0L) {
                    this.setSuspectTimeoutTimestamp(ldtNow + this.getDeliveryTimeoutMillis());
                } else if (ldtNow > ldtTimeout) {
                    this.onDeliveryTimeout();
                }
            } else {
                this.onIdle();
            }
        }

        public void onReleased() {
            Continuation action;
            if (this.getState() != 4) {
                Connection._trace("Unexpected RELEASE event: " + String.valueOf(this), 1);
            }
            this.setState(5);
            Guardian.GuardContext context = this.getContext();
            if (context != null) {
                context.release();
            }
            if ((action = this.getReleaseAction()) != null) {
                this.setReleaseAction(null);
                action.proceed(null);
            }
        }

        public Message prepareMessage(BufferSequence bufseq) throws IOException {
            Grid service;
            MessageHandler handler = (MessageHandler)this.get_Module();
            ReadBuffer buffer = handler.createReadBuffer(bufseq);
            ReadBuffer.BufferInput input = buffer.getBufferInput();
            short nService = input.readShort();
            short nMsgType = input.readShort();
            input.setOffset(0);
            try {
                service = handler.getServiceById(nService);
            }
            catch (RuntimeException e) {
                this.setLastBadMessage(bufseq);
                String sDump = HeapDump.dumpHeapForBug("SR-3-15874362211");
                this.setLastBadMessage(null);
                throw new IllegalStateException("Heap dump " + sDump + " has been generated due to an invalid service id " + nService + " from " + String.valueOf(this) + " received in message: " + Buffers.toString(bufseq, true, 1024L), e);
            }
            if (service == null) {
                Connection._trace("Ignoring message from " + String.valueOf(this) + " for locally stopped service " + nService + "; message type " + nMsgType, 3);
                return null;
            }
            try {
                Message msg = service.instantiateMessage(nMsgType);
                msg.setFromMember(this.getMember());
                msg.setReadBuffer(buffer);
                msg.setDeserializationRequired(true);
                return msg;
            }
            catch (RuntimeException e) {
                Connection._trace("Received corrupted message from " + String.valueOf(this) + " content " + Buffers.toString(bufseq, true, 0x100000L), 1);
                throw e;
            }
        }

        @Override
        public void recover() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Continuation continuation) {
            boolean fEstablished;
            int nState = this.getState();
            if (nState < 3) {
                this.setState(3);
            } else {
                Connection._assert(nState < 5);
            }
            Connection connection = this;
            synchronized (connection) {
                fEstablished = this.isEstablished();
            }
            if (fEstablished) {
                this.setReleaseAction(continuation);
            } else if (continuation != null) {
                continuation.proceed(null);
            }
            ((MessageHandler)this.get_Module()).getMessageBus().release(this.getPeer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setContext(Guardian.GuardContext context) {
            Connection connection = this;
            synchronized (connection) {
                Member member = this.getMember();
                if (member != null) {
                    if (this.getContext() == null) {
                        if (context != null) {
                            ((MessageHandler)this.get_Module()).getHungConnectionIPs().put(member.getAddress(), null);
                        }
                    } else if (context == null) {
                        ((MessageHandler)this.get_Module()).getHungConnectionIPs().remove(member.getAddress());
                    }
                }
                this.__m_Context = context;
            }
        }

        public void setDisconnectCause(Throwable tCause) {
            this.__m_DisconnectCause = tCause;
        }

        protected void setEstablished(boolean fEstablished) {
            this.__m_Established = fEstablished;
        }

        public void setLastBadMessage(BufferSequence sequenceMessage) {
            this.__m_LastBadMessage = sequenceMessage;
        }

        public void setLastHealthyTimestamp(long lTimestamp) {
            this.__m_LastHealthyTimestamp = lTimestamp;
        }

        protected void setLastHeuristicDeathTimestamp(long lTimestamp) {
            this.__m_LastHeuristicDeathTimestamp = lTimestamp;
        }

        public void setMember(Member member) {
            Connection._assert(member != null && this.getMember() == null, "Not resettable");
            this.__m_Member = member;
        }

        public void setPeer(EndPoint peer) {
            Connection._assert(peer != null);
            Connection._assert(this.getPeer() == null || this.getPeer().equals(peer), "Not resettable");
            this.__m_Peer = peer;
        }

        public void setReceivedReceiptCount(long atomicCount) {
            this.__m_ReceivedReceiptCount = atomicCount;
        }

        public void setReleaseAction(Continuation cont) {
            this.__m_ReleaseAction = cont;
        }

        private void setSentMessageCount(AtomicLong atomicCount) {
            this.__m_SentMessageCount = atomicCount;
        }

        public void setState(int nState) {
            this.__m_State = nState;
        }

        protected void setSuspectReceivedReceiptCount(long lTimestamp) {
            this.__m_SuspectReceivedReceiptCount = lTimestamp;
        }

        protected void setSuspectTimeoutTimestamp(long lTimestamp) {
            this.__m_SuspectTimeoutTimestamp = lTimestamp;
        }

        @Override
        public void terminate() {
            MessageHandler handler = (MessageHandler)this.get_Module();
            Grid service = handler.getService();
            Connection._trace("This member has been unexpectedly disconnected from members on " + Math.max(1, handler.getHungConnectionIPs().size()) + " machines running service " + service.getServiceName() + "; stopping service", 1);
            Throwable tReason = this.getDisconnectCause();
            if (tReason != null) {
                Connection._trace(tReason);
            }
            service.stop();
        }

        @Override
        public String toString() {
            long ldtLast = this.getLastHealthyTimestamp();
            long ldtStuck = this.getLastHeuristicDeathTimestamp();
            long ldtNow = Base.getSafeTimeMillis();
            long ldtNext = this.getSuspectTimeoutTimestamp();
            Member member = this.getMember();
            EndPoint peer = this.getPeer();
            MessageHandler handler = (MessageHandler)this.get_Module();
            return this.get_Name() + " {Peer=" + String.valueOf(peer) + ", Service=" + handler.getService().getServiceName() + ", Member=" + (member == null ? 0 : member.getId()) + (this.isEstablished() ? "" : ", Not established") + ", State=" + this.formatStateName(this.getState()) + (String)(ldtLast == 0L ? "" : ", lastAck=" + String.valueOf(new Duration((ldtNow - ldtLast) * 1000000L))) + (String)(ldtStuck == 0L ? "" : ", lastStuck=" + String.valueOf(new Duration((ldtNow - ldtStuck) * 1000000L))) + (String)(ldtNext == 0L ? "" : ", pendingAckTimeout=" + String.valueOf(new Duration(Math.max(0L, ldtNext - ldtNow) * 1000000L))) + ", " + handler.getMessageBus().toString(peer) + "}";
        }
    }

    public static class EventCollector
    extends Util
    implements Collector {
        public static final int ET_BACKLOG_EXCESSIVE = 5;
        public static final int ET_BACKLOG_NORMAL = 6;
        public static final int ET_CLOSE = 1;
        public static final int ET_CONNECT = 2;
        public static final int ET_DISCONNECT = 3;
        public static final int ET_MESSAGE = 9;
        public static final int ET_OPEN = 0;
        public static final int ET_RECEIPT = 7;
        public static final int ET_RELEASE = 4;
        public static final int ET_SIGNAL = 8;

        private static void _initStatic$Default() {
        }

        public EventCollector() {
            this(null, null, true);
        }

        public EventCollector(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EventCollector();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/MessageHandler$EventCollector".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void add(Object oEvent) {
            MessageHandler handler = (MessageHandler)this.get_Module();
            Event event = (Event)oEvent;
            try {
                switch (event.getType().ordinal()) {
                    case 1: {
                        if (handler.isClosing()) {
                            handler.postEventMessage(event);
                            break;
                        }
                        event.dispose();
                        throw new IllegalStateException("Unexpected CLOSE event");
                    }
                    case 7: {
                        handler.processReceipt(event.getEndPoint(), (Message)event.getContent(), handler.getDisconnectCounter().get() > 0L);
                        event.dispose();
                        break;
                    }
                    case 5: {
                        handler.onBacklog(event.getEndPoint(), true);
                        event.dispose();
                        break;
                    }
                    case 6: {
                        handler.onBacklog(event.getEndPoint(), false);
                        event.dispose();
                        break;
                    }
                    case 3: {
                        handler.getDisconnectCounter().incrementAndGet();
                        handler.postEventMessage(event);
                        break;
                    }
                    case 4: {
                        handler.getDisconnectCounter().decrementAndGet();
                        handler.postEventMessage(event);
                        break;
                    }
                    case 9: {
                        handler.processMessage(event);
                        break;
                    }
                    default: {
                        handler.postEventMessage(event);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                handler.onException(e);
            }
        }

        @Override
        public void flush() {
            ((MessageHandler)this.get_Module()).getService().flush();
        }

        static {
            EventCollector._initStatic$Default();
            Event.Type[] enumType = new Event.Type[]{Event.Type.OPEN, Event.Type.CLOSE, Event.Type.CONNECT, Event.Type.DISCONNECT, Event.Type.RELEASE, Event.Type.BACKLOG_EXCESSIVE, Event.Type.BACKLOG_NORMAL, Event.Type.RECEIPT, Event.Type.SIGNAL, Event.Type.MESSAGE};
            int c = enumType.length;
            for (int i = 0; i < c; ++i) {
                Event.Type type = enumType[i];
                EventCollector._assert(type.ordinal() == i, "Invalid ordinal value for " + String.valueOf((Object)type));
            }
        }
    }
}

