/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.queue.OptimisticQueue;
import com.tangosol.coherence.component.util.queue.PriorityQueue;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Member
extends Net
implements ExternalizableLite,
PortableObject,
com.tangosol.net.Member,
Externalizable {
    private transient InetAddress __m_Address;
    private transient int __m_ByteMask;
    private transient int __m_ByteOffset;
    private String __m_ClusterName;
    private volatile transient PacketIdentifier __m_ContiguousFromPacketId;
    private volatile transient PacketIdentifier __m_ContiguousToPacketId;
    private int __m_CpuCount;
    private transient boolean __m_Dead;
    private transient boolean __m_Deaf;
    private int __m_Edition;
    public static final String[] EDITION_NAME;
    private transient FlowControl __m_FlowControl;
    private int __m_Id;
    private transient long __m_LastHeuristicDeathMillis;
    private transient long __m_LastIncomingMessageId;
    private transient long __m_LastIncomingMillis;
    private transient long __m_LastOutgoingMessageId;
    private transient long __m_LastOutgoingMillis;
    private transient long __m_LastSlowMillis;
    private transient long __m_LastTimeoutMillis;
    private transient boolean __m_Leaving;
    private transient int __m_MachineId;
    private String __m_MachineName;
    private String __m_MemberName;
    private transient WindowedArray __m_MessageIncoming;
    private transient SparseArray __m_MessagePile;
    private int __m_Mode;
    public static final String[] MODE_NAME;
    private volatile transient PacketIdentifier __m_NewestFromPacketId;
    private volatile transient PacketIdentifier __m_NewestToPacketId;
    private volatile transient Ack __m_PacketAck;
    private transient int __m_Port;
    private int __m_PreferredAckSize;
    private int __m_PreferredPacketLength;
    private transient int __m_PreferredPort;
    private transient InetSocketAddress __m_PreferredSocketAddress;
    private int __m_Priority;
    private String __m_ProcessName;
    private String __m_RackName;
    private transient SentQueue __m_RecentPacketQueue;
    private String __m_RoleName;
    public static final int SHOW_ALL = -1;
    public static final int SHOW_LICENSE = 1;
    public static final int SHOW_STATS = 2;
    public static final int SHOW_STD = 0;
    private String __m_SiteName;
    private transient InetSocketAddress __m_SocketAddress;
    private int __m_SocketCount;
    private transient long __m_StatsReceived;
    private transient long __m_StatsRepeated;
    private transient long __m_StatsResent;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private int __m_TcpRingPort;
    private transient long __m_Timestamp;
    private int __m_TxDebugDropCount;
    private UUID __m_Uid32;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("FlowControl", FlowControl.get_CLASS());
        __mapChildren.put("SentQueue", SentQueue.get_CLASS());
    }

    public Member() {
        this(null, null, true);
    }

    public Member(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setMessagePile(new SparseArray());
            this.setPreferredAckSize(65535);
            this.setTxDebugDropCount(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Member();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/Member".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static int calcByteMask(int nId) {
        return 1 << (nId - 1) % 32;
    }

    public static int calcByteOffset(int nId) {
        return (nId - 1) / 32;
    }

    @Override
    public int compareTo(Object o) {
        UUID uidThis = this.getUid32();
        UUID uidThat = ((Member)o).getUid32();
        return uidThis.compareTo(uidThat);
    }

    public void configure(ClusterDependencies deps, InetAddress addr, int nPort, int nPortTcpRing, int[] an) {
        this.configure(deps.getMemberIdentity(), addr);
        this.setPort(nPort);
        this.setTcpRingPort(nPortTcpRing);
        this.setMachineId(an[2]);
        this.setEdition(deps.getEdition());
        this.setMode(deps.getMode());
        this.setCpuCount(an[0]);
        this.setSocketCount(an[1]);
    }

    public void configure(MemberIdentity identity, InetAddress addr) {
        try {
            this.setAddress(addr == null ? InetAddresses.getLocalHost() : addr);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.setTimestamp(Base.getSafeTimeMillis());
        this.setClusterName(identity.getClusterName());
        this.setSiteName(identity.getSiteName());
        this.setRackName(identity.getRackName());
        this.setMachineName(identity.getMachineName());
        this.setProcessName(identity.getProcessName());
        this.setMemberName(identity.getMemberName());
        this.setRoleName(identity.getRoleName());
        this.setPriority(identity.getPriority());
    }

    protected void configure(UUID uid) {
        int nMachineId;
        int nPort;
        InetAddress addr;
        Member._assert(uid != null);
        long ldt = uid.getTimestamp();
        byte[] abAddr = uid.getAddress();
        if (this.getId() > 0 || uid.isAddressIncluded()) {
            try {
                addr = InetAddressHelper.getByAddress(abAddr);
                nPort = uid.getPort();
                nMachineId = uid.getCount();
            }
            catch (UnknownHostException e) {
                throw new WrapperException(e);
            }
        } else {
            addr = InetAddressHelper.ADDR_ANY;
            nPort = 0;
            nMachineId = 0;
        }
        this.setTimestamp(ldt);
        this.setAddress(addr);
        this.setPort(nPort);
        this.setMachineId(nMachineId);
        this.setUid32(uid);
    }

    public void configure(Member member, long ldtTimestamp) {
        Member._assert(this.getCpuCount() == 0 && this.getSocketCount() == 0 && member.getCpuCount() > 0 && member.getSocketCount() > 0);
        this.setTimestamp(ldtTimestamp <= 0L ? member.getTimestamp() : ldtTimestamp);
        this.setAddress(member.getAddress());
        this.setPort(member.getPort());
        this.setTcpRingPort(member.getTcpRingPort());
        this.setMachineId(member.getMachineId());
        this.setEdition(member.getEdition());
        this.setMode(member.getMode());
        this.setCpuCount(member.getCpuCount());
        this.setSocketCount(member.getSocketCount());
        this.setClusterName(member.getClusterName());
        this.setSiteName(member.getSiteName());
        this.setRackName(member.getRackName());
        this.setMachineName(member.getMachineName());
        this.setProcessName(member.getProcessName());
        this.setMemberName(member.getMemberName());
        this.setRoleName(member.getRoleName());
        this.setPriority(member.getPriority());
    }

    public void configureDead(int nID, UUID uuid, long ldtDeath) {
        this.setId(nID);
        this.configure(uuid);
        this.setDead(true);
        this.setTimestamp(ldtDeath);
    }

    public void configureTemp(InetSocketAddress addr) {
        this.setAddress(addr.getAddress());
        this.setPort(addr.getPort());
    }

    public void declareZombie() {
        Member._assert(this.isDead());
        this.setTimestamp(Base.getSafeTimeMillis());
        this.setDeaf(true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Member) {
            Member that = (Member)obj;
            return Base.equals(this.getUid32(), that.getUid32());
        }
        return false;
    }

    public static Member findWeakestMember(Set setMembers) {
        long lRateWorst = Long.MAX_VALUE;
        Member memberWorst = null;
        while (true) {
            try {
                for (Member member : setMembers) {
                    long cTotal;
                    long lRate;
                    long cErrors;
                    if (member == null || (cErrors = member.getStatsResent() + member.getStatsRepeated()) <= 0L || (lRate = (cTotal = member.getStatsSent() + member.getStatsReceived()) / cErrors) >= lRateWorst) continue;
                    lRateWorst = lRate;
                    memberWorst = member;
                }
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
        return memberWorst;
    }

    public String formatStats() {
        FlowControl flowControl = this.getFlowControl();
        long ldtNow = Base.getSafeTimeMillis();
        long ldtIn = this.getLastIncomingMillis();
        long ldtOut = this.getLastOutgoingMillis();
        long ldtSlow = this.getLastSlowMillis();
        long ldtHDeath = this.getLastHeuristicDeathMillis();
        double dTxSuccess = this.getStatsPublisherSuccessRate();
        double dRxSuccess = this.getStatsReceiverSuccessRate();
        dTxSuccess = (double)((int)(dTxSuccess * 10000.0)) / 10000.0;
        dRxSuccess = (double)((int)(dRxSuccess * 10000.0)) / 10000.0;
        return "PublisherSuccessRate=" + dTxSuccess + ", ReceiverSuccessRate=" + dRxSuccess + (String)(flowControl == null ? "" : ", " + flowControl.formatStats(true)) + ", LastIn=" + (String)(ldtIn == 0L ? "n/a" : ldtNow - ldtIn + "ms") + ", LastOut=" + (String)(ldtOut == 0L ? "n/a" : ldtNow - ldtOut + "ms") + ", LastSlow=" + (String)(ldtSlow == 0L ? "n/a" : ldtNow - ldtSlow + "ms") + ", LastHeuristicDeath=" + (String)(ldtHDeath == 0L ? "n/a" : ldtNow - ldtHDeath + "ms");
    }

    @Override
    public InetAddress getAddress() {
        return this.__m_Address;
    }

    public int getByteMask() {
        return this.__m_ByteMask;
    }

    public int getByteOffset() {
        return this.__m_ByteOffset;
    }

    @Override
    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public PacketIdentifier getContiguousFromPacketId() {
        return this.__m_ContiguousFromPacketId;
    }

    public PacketIdentifier getContiguousToPacketId() {
        return this.__m_ContiguousToPacketId;
    }

    public int getCpuCount() {
        return this.__m_CpuCount;
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public FlowControl getFlowControl() {
        return this.__m_FlowControl;
    }

    @Override
    public int getId() {
        return this.__m_Id;
    }

    public long getLastHeuristicDeathMillis() {
        return this.__m_LastHeuristicDeathMillis;
    }

    public long getLastIncomingMessageId() {
        return this.__m_LastIncomingMessageId;
    }

    public long getLastIncomingMillis() {
        return this.__m_LastIncomingMillis;
    }

    protected long getLastOutgoingMessageId() {
        return this.__m_LastOutgoingMessageId;
    }

    public long getLastOutgoingMillis() {
        return this.__m_LastOutgoingMillis;
    }

    public long getLastSlowMillis() {
        return this.__m_LastSlowMillis;
    }

    public long getLastTimeoutMillis() {
        return this.__m_LastTimeoutMillis;
    }

    public String getLicenseInfo() {
        return "Edition=" + EDITION_NAME[this.getEdition()] + ", Mode=" + MODE_NAME[this.getMode()] + ", CpuCount=" + this.getCpuCount() + ", SocketCount=" + this.getSocketCount();
    }

    public String getLocationInfo() {
        String sMember;
        String sProcess;
        String sMachine;
        String sRack;
        StringBuffer sb = new StringBuffer();
        String sSite = this.getSiteName();
        if (sSite != null) {
            sb.append(",site:").append(sSite);
        }
        if ((sRack = this.getRackName()) != null) {
            sb.append(",rack:").append(sRack);
        }
        if ((sMachine = this.getMachineName()) != null) {
            sb.append(",machine:").append(sMachine);
        }
        if ((sProcess = this.getProcessName()) != null) {
            sb.append(",process:").append(sProcess);
        }
        if ((sMember = this.getMemberName()) != null) {
            sb.append(",member:").append(sMember);
        }
        return sb.length() == 0 ? "" : sb.substring(1);
    }

    @Override
    public int getMachineId() {
        return this.__m_MachineId;
    }

    @Override
    public String getMachineName() {
        return this.__m_MachineName;
    }

    @Override
    public String getMemberName() {
        return this.__m_MemberName;
    }

    public WindowedArray getMessageIncoming() {
        return this.__m_MessageIncoming;
    }

    public SparseArray getMessagePile() {
        return this.__m_MessagePile;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    public PacketIdentifier getNewestFromPacketId() {
        return this.__m_NewestFromPacketId;
    }

    public PacketIdentifier getNewestToPacketId() {
        return this.__m_NewestToPacketId;
    }

    public int getNextDestinationMessageId() {
        long c = this.getLastOutgoingMessageId();
        this.setLastOutgoingMessageId(++c);
        return Packet.makeTrint(c);
    }

    public Ack getPacketAck() {
        return this.__m_PacketAck;
    }

    @Override
    public int getPort() {
        return this.__m_Port;
    }

    public int getPreferredAckSize() {
        return this.__m_PreferredAckSize;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getPreferredPort() {
        return this.__m_PreferredPort;
    }

    public InetSocketAddress getPreferredSocketAddress() {
        InetSocketAddress addr = this.__m_PreferredSocketAddress;
        if (addr == null) {
            int nPort = this.getPreferredPort();
            if (nPort == 0) {
                return this.getSocketAddress();
            }
            addr = new InetSocketAddress(this.getAddress(), nPort);
            this.setPreferredSocketAddress(addr);
        }
        return addr;
    }

    @Override
    public int getPriority() {
        return this.__m_Priority;
    }

    @Override
    public String getProcessName() {
        return this.__m_ProcessName;
    }

    @Override
    public String getRackName() {
        return this.__m_RackName;
    }

    public SentQueue getRecentPacketQueue() {
        return this.__m_RecentPacketQueue;
    }

    @Override
    public String getRoleName() {
        return this.__m_RoleName;
    }

    @Override
    public String getSiteName() {
        return this.__m_SiteName;
    }

    public InetSocketAddress getSocketAddress() {
        InetSocketAddress addr = this.__m_SocketAddress;
        if (addr == null) {
            addr = new InetSocketAddress(this.getAddress(), this.getPort());
            this.setSocketAddress(addr);
        }
        return addr;
    }

    public int getSocketCount() {
        return this.__m_SocketCount;
    }

    public int[] getStatsCount() {
        return new int[]{this.getCpuCount(), this.getSocketCount()};
    }

    public double getStatsPublisherSuccessRate() {
        long lSent = this.getStatsSent();
        long lResent = this.getStatsResent();
        return lSent == 0L ? 1.0 : 1.0 - (double)lResent / (double)lSent;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public double getStatsReceiverSuccessRate() {
        long lReceived = this.getStatsReceived();
        long lRepeated = this.getStatsRepeated();
        return lReceived == 0L ? 1.0 : 1.0 - (double)lRepeated / (double)lReceived;
    }

    public long getStatsRepeated() {
        return this.__m_StatsRepeated;
    }

    public long getStatsResent() {
        return this.__m_StatsResent;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public int getTcpRingPort() {
        return this.__m_TcpRingPort;
    }

    @Override
    public long getTimestamp() {
        return this.__m_Timestamp;
    }

    public int getTxDebugDropCount() {
        return this.__m_TxDebugDropCount;
    }

    @Override
    public UID getUid() {
        long ldt = this.getUid32().getTimestamp();
        InetAddress addr = this.getAddress();
        int nPort = this.getPort();
        int nMachineId = this.getMachineId();
        int nAddr = (int)(InetAddressHelper.toLong(addr) & 0xFFFFFFFFL);
        int nCount = nPort & 0xFFFF | (nMachineId & 0xFFFF) << 16;
        return new UID(nAddr, ldt, nCount);
    }

    public UUID getUid32() {
        UUID uid = this.__m_Uid32;
        if (uid == null) {
            long ldt = this.getTimestamp();
            InetAddress addr = this.getAddress();
            int nPort = this.getPort();
            int nMachineId = this.getMachineId();
            Member._assert(ldt != 0L);
            uid = new UUID(ldt, addr, nPort, nMachineId);
            this.setUid32(uid);
        }
        return uid;
    }

    @Override
    public UUID getUuid() {
        return this.getUid32();
    }

    public int hashCode() {
        UUID uuid = this.getUid32();
        return uuid == null ? super.hashCode() : uuid.hashCode();
    }

    public void initCommSupport() {
        if (this.getMessageIncoming() == null) {
            WindowedArray waMsg = new WindowedArray();
            waMsg.remove(waMsg.add(null));
            this.setMessageIncoming(waMsg);
            this.setRecentPacketQueue((SentQueue)this._newChild("SentQueue"));
            if (FlowControl.isEnabled()) {
                FlowControl fc = (FlowControl)this._newChild("FlowControl");
                this.setFlowControl(fc);
            }
            this.resetStats();
        }
    }

    public boolean isCollocated(Member member) {
        return member.getAddress().equals(this.getAddress());
    }

    public boolean isDead() {
        return this.__m_Dead;
    }

    public boolean isDeaf() {
        return this.__m_Deaf;
    }

    public boolean isLeaving() {
        return this.__m_Leaving;
    }

    public boolean isTimedOut() {
        return this.getLastTimeoutMillis() != 0L;
    }

    public boolean isZombie() {
        return this.isDead() && this.isDeaf();
    }

    @Override
    public void onInit() {
        if (this.is_Deserialized()) {
            this.configure(this.getUid32());
            int nId = this.getId();
            this.setByteOffset(Member.calcByteOffset(nId));
            this.setByteMask(Member.calcByteMask(nId));
        }
        super.onInit();
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        UUID uid = (UUID)in.readObject(0);
        short nId = in.readShort(1);
        if (nId != 0) {
            this.setId(nId);
        }
        this.configure(uid);
        this.setEdition(in.readInt(2));
        this.setMode(in.readInt(3));
        this.setCpuCount(in.readInt(4));
        this.setSocketCount(in.readInt(5));
        this.setClusterName(in.readString(6));
        this.setSiteName(in.readString(7));
        this.setRackName(in.readString(8));
        this.setMachineName(in.readString(9));
        this.setProcessName(in.readString(10));
        this.setMemberName(in.readString(11));
        this.setRoleName(in.readString(12));
        this.setPriority(in.readInt(13));
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        UUID uid = new UUID(in);
        int nId = in.readUnsignedShort();
        if (nId != 0) {
            this.setId(nId);
        }
        this.configure(uid);
        this.setEdition(ExternalizableHelper.readInt(in));
        this.setMode(ExternalizableHelper.readInt(in));
        this.setCpuCount(ExternalizableHelper.readInt(in));
        this.setSocketCount(ExternalizableHelper.readInt(in));
        this.setClusterName(ExternalizableHelper.readUTF(in));
        this.setSiteName(ExternalizableHelper.readUTF(in));
        this.setRackName(ExternalizableHelper.readUTF(in));
        this.setMachineName(ExternalizableHelper.readUTF(in));
        this.setProcessName(ExternalizableHelper.readUTF(in));
        this.setMemberName(ExternalizableHelper.readUTF(in));
        this.setRoleName(ExternalizableHelper.readUTF(in));
        this.setPriority(ExternalizableHelper.readInt(in));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal((DataInput)in);
    }

    public void resetStats() {
        FlowControl flowControl = this.getFlowControl();
        if (flowControl != null) {
            flowControl.resetStats();
        }
        this.setStatsSent(0L);
        this.setStatsResent(0L);
        this.setStatsReceived(0L);
        this.setStatsRepeated(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    protected void setAddress(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        InetAddress addrOld = this.getAddress();
        Member._assert(addrOld == null || addrOld.equals(addr));
        this.__m_Address = addr;
    }

    protected void setByteMask(int nMask) {
        this.__m_ByteMask = nMask;
    }

    protected void setByteOffset(int nOffset) {
        this.__m_ByteOffset = nOffset;
    }

    protected void setClusterName(String sName) {
        String sNameOld = this.getClusterName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_ClusterName = sName;
    }

    public void setContiguousFromPacketId(PacketIdentifier packetId) {
        this.__m_ContiguousFromPacketId = packetId;
    }

    public void setContiguousToPacketId(PacketIdentifier packetId) {
        this.__m_ContiguousToPacketId = packetId;
    }

    private void setCpuCount(int cCpus) {
        if (cCpus > 0 && this.getCpuCount() == 0) {
            this.__m_CpuCount = cCpus;
        }
    }

    public void setDead(boolean fDead) {
        Member._assert(fDead);
        if (!this.isDead()) {
            this.__m_Dead = fDead;
            this.setTimestamp(Base.getSafeTimeMillis());
        }
        this.setDeaf(false);
    }

    public void setDeaf(boolean fDeaf) {
        this.__m_Deaf = fDeaf;
    }

    private void setEdition(int n) {
        Member._assert(this.getEdition() == 0);
        this.__m_Edition = n;
    }

    protected void setFlowControl(FlowControl flowControl) {
        this.__m_FlowControl = flowControl;
    }

    public void setId(int nId) {
        if (nId <= 0) {
            throw new IllegalArgumentException();
        }
        int nIdOld = this.getId();
        Member._assert(nIdOld == 0 || nId == nIdOld);
        this.__m_Id = nId;
        this.setByteOffset(Member.calcByteOffset(nId));
        this.setByteMask(Member.calcByteMask(nId));
    }

    public void setLastHeuristicDeathMillis(long lMillis) {
        this.__m_LastHeuristicDeathMillis = lMillis;
    }

    public void setLastIncomingMessageId(long cMessages) {
        this.__m_LastIncomingMessageId = cMessages;
    }

    public void setLastIncomingMillis(long cMillis) {
        this.__m_LastIncomingMillis = cMillis;
    }

    protected void setLastOutgoingMessageId(long cMessages) {
        this.__m_LastOutgoingMessageId = cMessages;
    }

    public void setLastOutgoingMillis(long cMillis) {
        this.__m_LastOutgoingMillis = cMillis;
    }

    public void setLastSlowMillis(long lMillis) {
        this.__m_LastSlowMillis = lMillis;
    }

    public void setLastTimeoutMillis(long cTimeoutMillis) {
        this.__m_LastTimeoutMillis = cTimeoutMillis;
    }

    public void setLeaving(boolean fLeaving) {
        this.__m_Leaving = fLeaving;
    }

    protected void setMachineId(int nId) {
        if (nId < 0 || nId > 65535) {
            throw new IllegalArgumentException();
        }
        int nIdOld = this.getMachineId();
        Member._assert(nIdOld == 0 || nId == nIdOld);
        this.__m_MachineId = nId;
    }

    protected void setMachineName(String sName) {
        String sNameOld = this.getMachineName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_MachineName = sName;
    }

    protected void setMemberName(String sName) {
        String sNameOld = this.getMemberName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_MemberName = sName;
    }

    public void setMessageIncoming(WindowedArray waMessage) {
        this.__m_MessageIncoming = waMessage;
    }

    public void setMessagePile(SparseArray map) {
        this.__m_MessagePile = map;
    }

    private void setMode(int n) {
        Member._assert(this.getMode() == 0);
        this.__m_Mode = n;
    }

    public void setNewestFromPacketId(PacketIdentifier packetId) {
        this.__m_NewestFromPacketId = packetId;
    }

    public void setNewestToPacketId(PacketIdentifier packetId) {
        this.__m_NewestToPacketId = packetId;
    }

    public void setPacketAck(Ack packet) {
        this.__m_PacketAck = packet;
    }

    protected void setPort(int nPort) {
        if (nPort < 0 || nPort > 65535) {
            throw new IllegalArgumentException();
        }
        int nPortOld = this.getPort();
        Member._assert(nPortOld == 0 || nPort == nPortOld);
        this.__m_Port = nPort;
    }

    public void setPreferredAckSize(int cPackets) {
        this.__m_PreferredAckSize = cPackets;
    }

    public void setPreferredPacketLength(int cPackets) {
        this.__m_PreferredPacketLength = cPackets;
    }

    public void setPreferredPort(int nPort) {
        if (nPort < 0 || nPort > 65535) {
            throw new IllegalArgumentException();
        }
        int nPortOld = this.getPreferredPort();
        Member._assert(nPortOld == 0 || nPort == nPortOld);
        this.__m_PreferredPort = nPort;
        this.setPreferredSocketAddress(null);
    }

    protected void setPreferredSocketAddress(InetSocketAddress addr) {
        this.__m_PreferredSocketAddress = addr;
    }

    protected void setPriority(int n) {
        this.__m_Priority = Math.min(Math.max(n, 0), 10);
    }

    protected void setProcessName(String sName) {
        String sNameOld = this.getProcessName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_ProcessName = sName;
    }

    protected void setRackName(String sName) {
        String sNameOld = this.getRackName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_RackName = sName;
    }

    protected void setRecentPacketQueue(SentQueue queue) {
        this.__m_RecentPacketQueue = queue;
    }

    protected void setRoleName(String sName) {
        String sNameOld = this.getRoleName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_RoleName = sName;
    }

    protected void setSiteName(String sName) {
        String sNameOld = this.getSiteName();
        Member._assert(sNameOld == null || sNameOld.equals(sName));
        this.__m_SiteName = sName;
    }

    protected void setSocketAddress(InetSocketAddress addr) {
        this.__m_SocketAddress = addr;
    }

    private void setSocketCount(int cSockets) {
        if (cSockets > 0 && this.getSocketCount() == 0) {
            this.__m_SocketCount = cSockets;
        }
    }

    public void setStatsReceived(long cReceived) {
        this.__m_StatsReceived = cReceived;
    }

    public void setStatsRepeated(long cRepeated) {
        this.__m_StatsRepeated = cRepeated;
    }

    public void setStatsResent(long cResent) {
        this.__m_StatsResent = cResent;
    }

    public void setStatsReset(long ldtReset) {
        this.__m_StatsReset = ldtReset;
    }

    public void setStatsSent(long cSent) {
        this.__m_StatsSent = cSent;
    }

    public void setTcpRingPort(int nPort) {
        this.__m_TcpRingPort = nPort;
    }

    protected void setTimestamp(long cMillis) {
        if (cMillis <= 0L) {
            throw new IllegalArgumentException();
        }
        long cMillisOld = this.getTimestamp();
        Member._assert(this.isDead() || this.isDeaf() || cMillisOld == 0L || cMillis == cMillisOld);
        this.__m_Timestamp = cMillis;
    }

    public void setTxDebugDropCount(int cPacket) {
        this.__m_TxDebugDropCount = cPacket;
    }

    protected void setUid32(UUID uid) {
        this.__m_Uid32 = uid;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int nShow) {
        String sRole;
        StringBuffer sb = new StringBuffer();
        sb.append("Member(Id=").append(this.getId()).append(", Timestamp=").append(new Timestamp(this.getTimestamp())).append(", Address=").append(InetAddressHelper.toString(this.getAddress())).append(':').append(this.getPort()).append(", MachineId=").append(this.getMachineId());
        String sLocation = this.getLocationInfo();
        if (sLocation.length() > 0) {
            sb.append(", Location=").append(sLocation);
        }
        if ((sRole = this.getRoleName()) != null && sRole.length() > 0) {
            sb.append(", Role=").append(sRole);
        }
        if ((nShow & 1) != 0) {
            sb.append(", ").append(this.getLicenseInfo());
        }
        if ((nShow & 2) != 0) {
            sb.append(", ").append(this.formatStats());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.getUid32());
        out.writeShort(1, (short)this.getId());
        out.writeInt(2, this.getEdition());
        out.writeInt(3, this.getMode());
        out.writeInt(4, this.getCpuCount());
        out.writeInt(5, this.getSocketCount());
        out.writeString(6, this.getClusterName());
        out.writeString(7, this.getSiteName());
        out.writeString(8, this.getRackName());
        out.writeString(9, this.getMachineName());
        out.writeString(10, this.getProcessName());
        out.writeString(11, this.getMemberName());
        out.writeString(12, this.getRoleName());
        out.writeInt(13, this.getPriority());
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        this.getUid32().writeExternal(out);
        out.writeShort(this.getId());
        ExternalizableHelper.writeInt(out, this.getEdition());
        ExternalizableHelper.writeInt(out, this.getMode());
        ExternalizableHelper.writeInt(out, this.getCpuCount());
        ExternalizableHelper.writeInt(out, this.getSocketCount());
        ExternalizableHelper.writeUTF(out, this.getClusterName());
        ExternalizableHelper.writeUTF(out, this.getSiteName());
        ExternalizableHelper.writeUTF(out, this.getRackName());
        ExternalizableHelper.writeUTF(out, this.getMachineName());
        ExternalizableHelper.writeUTF(out, this.getProcessName());
        ExternalizableHelper.writeUTF(out, this.getMemberName());
        ExternalizableHelper.writeUTF(out, this.getRoleName());
        ExternalizableHelper.writeInt(out, this.getPriority());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    static {
        try {
            String[] a0 = new String[]{"Data Client", "Real-Time Client", "Standard Edition", "Community Edition", "Enterprise Edition", "Grid Edition"};
            EDITION_NAME = a0;
            String[] a1 = new String[]{"Evaluation", "Development", "Production"};
            MODE_NAME = a1;
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Member.__initStatic();
    }

    public static class FlowControl
    extends Net {
        private static transient int __s_AggressionFactor;
        private transient int __m_DeferredPacketCount;
        private transient Queue __m_DeferredQueue;
        private static transient boolean __s_Enabled;
        private static transient int __s_LostPacketThreshold;
        private volatile transient int __m_OutstandingPacketCount;
        private transient int __m_OutstandingPacketHighMark;
        private static transient int __s_OutstandingPacketMaximum;
        private static transient int __s_OutstandingPacketMinimum;
        private transient int __m_OutstandingPacketThreshold;
        private static transient int __s_PacketThreshold;
        private transient boolean __m_Paused;
        private transient long __m_PauseStartMillis;
        private transient int __m_SequentialConfirmedCount;
        private transient int __m_SequentialLostCount;
        private transient long __m_StatsPausedMillis;
        private static transient int __s_SuccessGoal;

        private static void _initStatic$Default() {
            FlowControl.__initStatic();
        }

        private static void __initStatic() {
            try {
                FlowControl.setAggressionFactor(20);
                __s_PacketThreshold = -1;
                FlowControl.setSuccessGoal(200);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
        }

        public FlowControl() {
            this(null, null, true);
        }

        public FlowControl(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this._addChild(new DeferredQueue("DeferredQueue", this, true), "DeferredQueue");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new FlowControl();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Member$FlowControl".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public String formatStats(boolean fVerbose) {
            double dPaused = this.getStatsPauseRate();
            dPaused = (double)((int)(dPaused * 10000.0)) / 10000.0;
            String sStats = "PauseRate=" + dPaused + ", Threshold=" + this.getOutstandingPacketThreshold();
            if (fVerbose) {
                int cDeferred = this.getDeferredQueue().size();
                int cReady = this.getDeferredPacketCount() - cDeferred;
                sStats = sStats + ", Paused=" + this.isPaused() + ", Deferring=" + this.isDeferring() + ", OutstandingPackets=" + this.getOutstandingPacketCount() + ", DeferredPackets=" + cDeferred + ", ReadyPackets=" + cReady;
            }
            return sStats;
        }

        public static int getAggressionFactor() {
            return __s_AggressionFactor;
        }

        public int getDeferredPacketCount() {
            return this.__m_DeferredPacketCount;
        }

        public Queue getDeferredQueue() {
            return this.__m_DeferredQueue;
        }

        public static int getLostPacketThreshold() {
            return __s_LostPacketThreshold;
        }

        public Member getMember() {
            return (Member)this.get_Parent();
        }

        public int getOutstandingPacketCount() {
            return this.__m_OutstandingPacketCount;
        }

        public int getOutstandingPacketHighMark() {
            return this.__m_OutstandingPacketHighMark;
        }

        public static int getOutstandingPacketMaximum() {
            return __s_OutstandingPacketMaximum;
        }

        public static int getOutstandingPacketMinimum() {
            return __s_OutstandingPacketMinimum;
        }

        public int getOutstandingPacketThreshold() {
            return this.__m_OutstandingPacketThreshold;
        }

        private static int getPacketThreshold() {
            return __s_PacketThreshold;
        }

        public long getPauseStartMillis() {
            return this.__m_PauseStartMillis;
        }

        public int getPendingPacketCount() {
            return this.getDeferredQueue().size() + this.getOutstandingPacketCount();
        }

        public int getSequentialConfirmedCount() {
            return this.__m_SequentialConfirmedCount;
        }

        public int getSequentialLostCount() {
            return this.__m_SequentialLostCount;
        }

        public long getStatsPausedMillis() {
            long lMillis = this.__m_StatsPausedMillis;
            if (this.isPaused()) {
                lMillis += Base.getSafeTimeMillis() - this.getPauseStartMillis();
            }
            return lMillis;
        }

        public double getStatsPauseRate() {
            long ldtNow = Base.getSafeTimeMillis();
            long cPausedMillis = this.getStatsPausedMillis();
            return cPausedMillis == 0L ? 0.0 : (double)cPausedMillis / (double)(ldtNow - this.getMember().getStatsReset());
        }

        public static int getSuccessGoal() {
            return __s_SuccessGoal;
        }

        public boolean isAdjustable() {
            return FlowControl.getOutstandingPacketMaximum() != FlowControl.getOutstandingPacketMinimum();
        }

        public boolean isDeferring() {
            return this.getDeferredPacketCount() > 0;
        }

        public static boolean isEnabled() {
            return __s_Enabled;
        }

        public boolean isPaused() {
            return this.__m_Paused;
        }

        @Override
        public void onInit() {
            int cThreshold = FlowControl.getPacketThreshold();
            if (cThreshold < 0) {
                this.setOutstandingPacketThreshold((FlowControl.getOutstandingPacketMaximum() + FlowControl.getOutstandingPacketMinimum()) / 2);
            } else {
                this.setOutstandingPacketThreshold(cThreshold);
            }
            this.setDeferredQueue((DeferredQueue)this._findChild("DeferredQueue"));
            super.onInit();
        }

        public void onPauseStart() {
            this.setPauseStartMillis(Base.getSafeTimeMillis());
            if (FlowControl._isTraceEnabled(9)) {
                FlowControl._trace(String.valueOf(this.getMember()) + " has failed to respond to " + this.getSequentialLostCount() + " packets; declaring this member as paused.", 9);
            }
        }

        public void onPauseStop() {
            int iLogLevel;
            long ldtStart = this.getPauseStartMillis();
            long lDelta = Base.getSafeTimeMillis() - ldtStart;
            int n = lDelta > 1000L ? 2 : (lDelta > 100L ? 6 : (iLogLevel = lDelta > 10L ? 8 : 9));
            if (lDelta > 0L) {
                this.setStatsPausedMillis(this.getStatsPausedMillis() + lDelta);
            }
            if (FlowControl._isTraceEnabled(iLogLevel)) {
                FlowControl._trace("Experienced a " + lDelta + " ms communication delay (probable remote GC) with " + (String)(iLogLevel == 2 ? this.getMember().toString() : "member " + this.getMember().getId()) + "; " + this.getSequentialLostCount() + " packets rescheduled, " + this.formatStats(false), iLogLevel);
            }
        }

        public void resetStats() {
            this.setStatsPausedMillis(0L);
        }

        public static void setAggressionFactor(int iFactor) {
            __s_AggressionFactor = Math.max(1, iFactor);
        }

        public void setDeferredPacketCount(int cPackets) {
            if (cPackets < 0) {
                throw new IllegalStateException("DeferredPacketCount for " + String.valueOf(this.getMember()) + " cannot be negative");
            }
            this.__m_DeferredPacketCount = cPackets;
        }

        public void setDeferredQueue(Queue queue) {
            this.__m_DeferredQueue = queue;
        }

        public static void setEnabled(boolean fEnabled) {
            __s_Enabled = fEnabled;
        }

        public static void setLostPacketThreshold(int nThreshold) {
            __s_LostPacketThreshold = nThreshold;
        }

        public void setOutstandingPacketCount(int cPackets) {
            if (cPackets < 0) {
                throw new IllegalStateException("OutstandingPacketCount for " + String.valueOf(this.getMember()) + " cannot be negative");
            }
            if (cPackets > this.getOutstandingPacketHighMark()) {
                this.setOutstandingPacketHighMark(cPackets);
            }
            this.__m_OutstandingPacketCount = cPackets;
        }

        public void setOutstandingPacketHighMark(int cPackets) {
            this.__m_OutstandingPacketHighMark = cPackets;
        }

        public static void setOutstandingPacketMaximum(int cPackets) {
            __s_OutstandingPacketMaximum = cPackets;
        }

        public static void setOutstandingPacketMinimum(int cPackets) {
            __s_OutstandingPacketMinimum = cPackets;
        }

        public void setOutstandingPacketThreshold(int cPackets) {
            this.__m_OutstandingPacketThreshold = cPackets = Math.max(FlowControl.getOutstandingPacketMinimum(), Math.min(cPackets, FlowControl.getOutstandingPacketMaximum()));
        }

        private static void setPacketThreshold(int cPacketThreshold) {
            __s_PacketThreshold = cPacketThreshold;
        }

        public void setPaused(boolean fPaused) {
            if (fPaused == this.isPaused()) {
                return;
            }
            this.__m_Paused = fPaused;
            if (fPaused) {
                this.onPauseStart();
            } else {
                this.onPauseStop();
            }
        }

        public void setPauseStartMillis(long ldtPauseStartMillis) {
            this.__m_PauseStartMillis = ldtPauseStartMillis;
        }

        public void setSequentialConfirmedCount(int cPackets) {
            this.__m_SequentialConfirmedCount = cPackets;
        }

        public void setSequentialLostCount(int cPackets) {
            this.__m_SequentialLostCount = cPackets;
        }

        public void setStatsPausedMillis(long cMillis) {
            this.__m_StatsPausedMillis = cMillis;
        }

        public static void setSuccessGoal(int iGoal) {
            __s_SuccessGoal = Math.max(1, iGoal);
        }

        @Override
        public String toString() {
            return this.formatStats(true);
        }

        static {
            FlowControl._initStatic$Default();
            try {
                String sGoal = Config.getProperty("coherence.flowcontrol.goal");
                String sAggression = Config.getProperty("coherence.flowcontrol.aggressive");
                String sThreshold = Config.getProperty("coherence.flowcontrol.threshold");
                if (sGoal != null) {
                    FlowControl.setSuccessGoal(Integer.parseInt(sGoal));
                }
                if (sAggression != null) {
                    FlowControl.setAggressionFactor(Integer.parseInt(sAggression));
                }
                if (sThreshold != null) {
                    FlowControl.setPacketThreshold(Integer.parseInt(sThreshold));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static class DeferredQueue
        extends PriorityQueue
        implements Comparator {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public DeferredQueue() {
                this(null, null, true);
            }

            public DeferredQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setSortedElementSet(new TreeSet());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DeferredQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Member$FlowControl$DeferredQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public synchronized boolean add(Object oElement) {
                MessagePacket packet = (MessagePacket)oElement;
                if (!super.add(packet) && packet.getPendingResendSkips() > 0) {
                    packet.setPendingResendSkips(packet.getPendingResendSkips() - 1);
                }
                return this.getSortedElementSet().last() == packet;
            }

            public int compare(Object o1, Object o2) {
                return PacketComparator.compare((MessagePacket)o1, (MessagePacket)o2);
            }

            @Override
            public void onInit() {
                super.onInit();
                this.setComparator(this);
            }

            static {
                DeferredQueue.__initStatic();
            }

            public static class Iterator
            extends Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Member$FlowControl$DeferredQueue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class SentQueue
    extends OptimisticQueue {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public SentQueue() {
            this(null, null, true);
        }

        public SentQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setElementList(new RecyclingLinkedList());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SentQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Member$SentQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public boolean remove(Object oElement) {
            return this.getElementList().remove(oElement);
        }

        static {
            SentQueue.__initStatic();
        }

        public static class Iterator
        extends Queue.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Member$SentQueue$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

