/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import com.oracle.coherence.common.collections.NullableSortedMap;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.internal.net.DemultiplexedSocketProvider;
import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.InetAddressComparator;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.oracle.coherence.common.net.exabus.Depot;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.oracle.coherence.common.net.exabus.spi.Driver;
import com.oracle.coherence.common.net.exabus.util.SimpleDepot;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.Threads;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.TcpRing;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteNameService;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.NameService;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.ServiceConfig;
import com.tangosol.coherence.component.util.ShutdownHook;
import com.tangosol.coherence.component.util.daemon.IpMonitor;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.TransportService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.unit.Millis;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.io.BufferManagerWriteBufferPool;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.internal.net.service.extend.NameServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.tracing.LegacyXmlTracingHelper;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.util.LoggingBridge;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.nio.ByteBufferInputStream;
import com.tangosol.io.nio.ByteBufferOutputStream;
import com.tangosol.license.LicensedObject;
import com.tangosol.license.ProcessorInfo;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.CompositeAddressProvider;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.NameService;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SystemDatagramSocketProvider;
import com.tangosol.net.TcpDatagramSocket;
import com.tangosol.net.TcpDatagramSocketProvider;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.net.internal.SubstitutionSocketAddressProvider;
import com.tangosol.net.management.Registry;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import javax.naming.NamingException;

public class Cluster
extends Net
implements com.tangosol.net.Cluster,
NameService.LookupCallback {
    private String __m_ClusterName;
    private ByteBuffer __m_ClusterNameBuffer;
    private ClusterService __m_ClusterService;
    private ClusterDependencies __m_Dependencies;
    private PublicGuardian __m_Guardian;
    private volatile int __m_GuardRecoverCount;
    private volatile int __m_GuardTerminateCount;
    private transient boolean __m_Halted;
    private IpMonitor __m_IpMonitor;
    private transient Registry __m_Management;
    public static final int MAX_SYSTEM_SERVICE = 1;
    private MessagePublisher __m_MessagePublisher;
    private NameService __m_NameService;
    private NameServiceBridge __m_NameServiceBridge;
    private OperationalContext __m_OperationalContext;
    private PacketListener1 __m_PointListener;
    public static final int POOL_RX_PACKETS = 8192;
    public static final int POOL_TX_PACKETS = 2048;
    private PacketListener1P __m_PreferredListener;
    private PacketPublisher __m_Publisher;
    private PacketReceiver __m_Receiver;
    private transient ResourceRegistry __m_ResourceRegistry;
    private transient long __m_ShutdownTimeout;
    private PacketSpeaker __m_Speaker;
    private Throwable __m_StartException;
    private volatile int __m_State;
    public static final int STATE_EXITED = 6;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_JOINING = 2;
    public static final int STATE_LEAVING = 4;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STOPPING = 5;
    private PacketListenerBT __m_TcpBroadcastListener;
    private ThreadGroup __m_ThreadGroup;
    private TracingShim.Control __m_TracingControl;
    public static final String TRANSPORT_DATAGRAM = "datagram";
    private TransportService __m_TransportService;
    private PacketListenerBU __m_UdpBroadcastListener;
    private List __m_WrapperStreamFactoryList;

    public Cluster() {
        this(null, null, true);
    }

    public Cluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setHalted(false);
            this.setResourceRegistry(new SimpleResourceRegistry());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ClusterService("ClusterService", this, true), "ClusterService");
        this._addChild(new IpMonitor("IpMonitor", this, true), "IpMonitor");
        this._addChild(new NameService("NameService", this, true), "NameService");
        this._addChild(new NameServiceBridge("NameServiceBridge", this, true), "NameServiceBridge");
        this._addChild(new PacketListener1("PacketListener1", this, true), "PacketListener1");
        this._addChild(new PacketListener1P("PacketListener1P", this, true), "PacketListener1P");
        this._addChild(new PacketListenerBT("PacketListenerBT", this, true), "PacketListenerBT");
        this._addChild(new PacketListenerBU("PacketListenerBU", this, true), "PacketListenerBU");
        this._addChild(new PacketPublisher("PacketPublisher", this, true), "PacketPublisher");
        this._addChild(new PacketReceiver("PacketReceiver", this, true), "PacketReceiver");
        this._addChild(new PacketSpeaker("PacketSpeaker", this, true), "PacketSpeaker");
        this._addChild(new PublicGuardian("PublicGuardian", this, true), "PublicGuardian");
        this._addChild(new ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this._addChild(new SocketManager("SocketManager", this, true), "SocketManager");
        this._addChild(new TransportService("TransportService", this, true), "TransportService");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Cluster();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/Cluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    protected void applyWrapperStreamFactories(Grid service, List listNames) {
        List listFilter;
        if (listNames != null && !listNames.isEmpty() && !(listFilter = this.instantiateWrapperStreamFactoryList(listNames)).isEmpty()) {
            service.setWrapperStreamFactoryList(new ImmutableArrayList(listFilter));
        }
        service.setWrapperStreamFactoryAllList(this.getWrapperStreamFactoryList());
    }

    protected void bindService(Grid service) {
        String sServiceType;
        DefaultServiceFailurePolicy policy;
        ClusterDependencies config = this.getDependencies();
        ServiceFailurePolicyBuilder builder = config.getServiceFailurePolicyBuilder();
        ServiceFailurePolicy serviceFailurePolicy = policy = builder == null || service instanceof TransportService ? new DefaultServiceFailurePolicy(1) : builder.realize(new NullParameterResolver(), this.getContextClassLoader(), null);
        if (service instanceof ClusterService) {
            sServiceType = "ClusterService";
        } else {
            service.setCluster(this);
            sServiceType = service.getServiceType();
        }
        service.setThreadGroup(this.getThreadGroup());
        service.setDefaultGuardTimeout(config.getGuardTimeoutMillis());
        service.setServiceFailurePolicy(policy);
        service.setBufferManager(this.getReceiver().getBufferManager());
        this.applyWrapperStreamFactories(service, config.getServiceFilterMap().get(sServiceType));
    }

    protected void checkShutdownPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Cluster.shutdown"));
        }
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    protected void configureBroadcast() {
        ClusterDependencies config = this.getDependencies();
        SocketManager manager = this.getSocketManager();
        SocketManager.UnicastUdpSocket socketU = manager.getUnicastUdpSocket();
        SocketManager.PreferredUnicastUdpSocket socketP = manager.getPreferredUnicastUdpSocket();
        SocketManager.BroadcastUdpSocket socketBU = manager.getBroadcastUdpSocket();
        SocketManager.BroadcastTcpSocket socketBT = manager.getBroadcastTcpSocket();
        PacketPublisher publisher = this.getPublisher();
        AddressProvider provider = config.getWellKnownAddresses();
        if (provider == null) {
            publisher.setMulticastAddress(new InetSocketAddress(config.getGroupAddress(), config.getGroupPort()));
            publisher.setUdpSocketMulticast(socketBU);
        } else {
            CompositeAddressProvider setBroadcast = new CompositeAddressProvider(provider);
            ClusterService service = this.getClusterService();
            service.setBroadcastAddresses(setBroadcast);
            service.setWellKnownAddresses(provider instanceof Set ? (Set)((Object)provider) : new CompositeAddressProvider(provider));
            publisher.setBroadcastAddresses(setBroadcast);
            publisher.setMulticastEnabled(false);
        }
        socketBU.setSoTimeout(config.getClusterHeartbeatDelayMillis());
        int nPortGroup = config.getGroupPort();
        socketBU.setPort(nPortGroup);
        socketBT.setPort(nPortGroup);
        int cbPacketMax = socketU.getPacketLength();
        socketBU.setPacketLength(cbPacketMax);
        socketBT.setPacketLength(cbPacketMax);
        int cbBuffer = socketU.getBufferSentBytes();
        socketBU.setBufferSentBytes(cbBuffer);
        socketBT.setBufferSentBytes(cbBuffer);
        cbBuffer = socketU.getBufferReceivedBytes();
        socketBU.setBufferReceivedBytes(cbBuffer);
        socketBT.setBufferReceivedBytes(cbBuffer);
    }

    protected void configureDaemons() {
        List listFilter;
        DefaultClusterDependencies config = (DefaultClusterDependencies)this.getDependencies();
        SocketManager manager = this.getSocketManager();
        ThreadGroup group = this.getThreadGroup();
        if (group == null) {
            group = new ThreadGroup(this.get_Name());
            group.setDaemon(true);
            this.setThreadGroup(group);
        }
        ClusterService daemonClusterService = this.getClusterService();
        TransportService daemonTransport = this.getTransportService();
        IpMonitor daemonIpMonitor = this.getIpMonitor();
        PublicGuardian daemonGuardian = this.getGuardian();
        daemonClusterService.setCluster(this);
        daemonClusterService.setDependencies(null);
        daemonClusterService.setThreadGroup(group);
        daemonTransport.setThreadGroup(group);
        daemonIpMonitor.setThreadGroup(group);
        daemonGuardian.setThreadGroup(group);
        SocketManager.UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
        SocketManager.PreferredUnicastUdpSocket udpsocketUnicastPref = manager.getPreferredUnicastUdpSocket();
        SocketManager.BroadcastUdpSocket udpsocketUdpBroadcast = manager.getBroadcastUdpSocket();
        SocketManager.BroadcastTcpSocket udpsocketTcpBroadcast = manager.getBroadcastTcpSocket();
        ServerSocketChannel channelTcpRing = manager.getAcceptorChannel().getChannel();
        Member member = daemonClusterService.instantiateMember();
        member.configure(config, config.computeLocalAddress(), udpsocketUnicast.getPort(), channelTcpRing == null ? 0 : channelTcpRing.socket().getLocalPort(), this.getCounters());
        daemonClusterService.setAnnounceMember(member);
        int cbPacket = config.getPacketMaxLength();
        int cbPacketPref = udpsocketUnicastPref.getPacketLength();
        MasterMemberSet setMember = daemonClusterService.getClusterMemberSet();
        setMember.setMaximumPacketLength(cbPacket);
        int cHeartbeatMillis = config.getClusterHeartbeatDelayMillis();
        int cTimeoutMillis = config.getPublisherResendTimeoutMillis();
        int cMillisRepeatDelay = config.getPublisherResendDelayMillis();
        daemonClusterService.setBroadcastTimeoutMillis(Math.max(config.getClusterAnnounceTimeoutMillis(), cMillisRepeatDelay * 3));
        daemonClusterService.setBroadcastRepeatMillis(cMillisRepeatDelay);
        daemonClusterService.setDeliveryTimeoutMillis(cTimeoutMillis);
        daemonClusterService.setMaximumPacketLength(cbPacket);
        daemonClusterService.setTimestampMaxVariance(config.getClusterTimestampMaxVarianceMillis());
        setMember.setRecycleMillis(cTimeoutMillis * 4);
        try {
            ClusterService.TcpRing ring = daemonClusterService.getTcpRing();
            if (config.isTcpRingEnabled()) {
                ring.setEnabled(true);
                ring.setSocketProvider(manager.getTcpRingSocketProvider());
                ring.setServerSocketChannel(manager.getAcceptorChannel().getChannel());
                ring.setRedundancyLevel(Integer.parseInt(Config.getProperty("coherence.tcpRing.redundancyLevel", "1")));
            } else {
                ring.setEnabled(false);
                Cluster._trace("TcpRing has been explicitly disabled, this is not a recommended practice and will result in a minimum death detection time of " + (long)cTimeoutMillis / 1000L + " seconds for failed processes.", 2);
                ring.setSelector(Selector.open());
            }
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        if (this.isTransportServiceEnabled()) {
            DefaultGridDependencies depsTrans = new DefaultGridDependencies();
            depsTrans.setReliableTransport(config.getReliableTransport());
            daemonTransport.setDependencies(depsTrans);
            daemonTransport.setEnabled(true);
        }
        NameService ns = this.getNameService();
        ns.setCluster(this);
        ns.setOperationalContext(this.getOperationalContext());
        ns.configure(CacheFactory.getServiceConfig("NameService"));
        this.getResourceRegistry().registerResource(com.tangosol.net.NameService.class, ns);
        boolean fIpMonitorEnabled = config.isIpMonitorEnabled();
        if (fIpMonitorEnabled) {
            daemonIpMonitor.configure(config, daemonClusterService);
            daemonIpMonitor.setWaitMillis(cHeartbeatMillis);
        } else {
            Cluster._trace("IPMonitor has been explicitly disabled, this is not a recommended practice and will result in a minimum death detection time of " + (long)cTimeoutMillis / 1000L + " seconds for failed machines or networks.", 2);
        }
        daemonGuardian.setWaitMillis(cHeartbeatMillis);
        ActionPolicy policyAction = (ActionPolicy)config.getClusterActionPolicyBuilder().realize(new NullParameterResolver(), this.getContextClassLoader(), null);
        daemonClusterService.setActionPolicy(policyAction);
        daemonClusterService.setHeartbeatDelay(cHeartbeatMillis);
        long cGuardMillis = config.getGuardTimeoutMillis();
        daemonClusterService.setDefaultGuardTimeout(cGuardMillis);
        daemonIpMonitor.setDefaultGuardTimeout(cGuardMillis);
        daemonGuardian.setDefaultGuardTimeout(cGuardMillis);
        if (cGuardMillis > 0L && fIpMonitorEnabled) {
            daemonClusterService.guard(daemonIpMonitor.getGuardable());
            daemonIpMonitor.guard(daemonClusterService.getGuardable());
        }
        PacketListener1 daemonPointListener = this.getPointListener();
        PacketListener1P daemonPreferredListener = this.getPreferredListener();
        PacketListenerBT daemonTcpBroadcastListener = this.getTcpBroadcastListener();
        PacketListenerBU daemonUdpBroadcastListener = this.getUdpBroadcastListener();
        PacketReceiver daemonReceiver = this.getReceiver();
        PacketSpeaker daemonSpeaker = this.getSpeaker();
        PacketPublisher daemonPublisher = this.getPublisher();
        daemonPointListener.setThreadGroup(group);
        daemonPreferredListener.setThreadGroup(group);
        daemonUdpBroadcastListener.setThreadGroup(group);
        daemonTcpBroadcastListener.setThreadGroup(group);
        daemonReceiver.setThreadGroup(group);
        daemonSpeaker.setThreadGroup(group);
        daemonPublisher.setThreadGroup(group);
        daemonPointListener.setPriority(config.getLocalListenerPriority());
        daemonUdpBroadcastListener.setPriority(config.getLocalListenerPriority());
        daemonTcpBroadcastListener.setPriority(config.getLocalListenerPriority());
        daemonPreferredListener.setPriority(config.getLocalListenerPriority());
        daemonReceiver.setPriority(config.getReceiverPriority());
        daemonSpeaker.setPriority(config.getSpeakerPriority());
        daemonPublisher.setPriority(config.getPublisherPriority());
        daemonIpMonitor.setPriority(config.getIpMonitorPriority());
        daemonPointListener.setMemberSet(setMember);
        daemonPreferredListener.setMemberSet(setMember);
        daemonUdpBroadcastListener.setMemberSet(setMember);
        daemonTcpBroadcastListener.setMemberSet(setMember);
        daemonReceiver.setMemberSet(setMember);
        daemonSpeaker.setMemberSet(setMember);
        daemonPublisher.setMemberSet(setMember);
        ByteBuffer bufClusterName = ByteBuffer.allocate(134);
        try {
            DataOutputStream outName = new DataOutputStream(new ByteBufferOutputStream(bufClusterName));
            outName.writeUTF(config.getMemberIdentity().getClusterName());
            outName.close();
            bufClusterName.flip();
            ByteBuffer bufTrim = ByteBuffer.allocate(bufClusterName.remaining());
            bufTrim.put(bufClusterName).flip();
            bufClusterName = bufTrim;
            this.setClusterNameBuffer(bufClusterName);
            daemonPublisher.setClusterNameBuffer(bufClusterName);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        BufferManager bufferManager = BufferManagers.getHeapManager();
        daemonPointListener.setUdpSocket(udpsocketUnicast);
        daemonPointListener.setBufferManager(bufferManager);
        daemonPointListener.setPacketLength(Math.max(cbPacket, cbPacketPref));
        daemonPreferredListener.setUdpSocket(udpsocketUnicastPref);
        daemonPreferredListener.setBufferManager(bufferManager);
        daemonPreferredListener.setPacketLength(cbPacketPref);
        daemonUdpBroadcastListener.setUdpSocket(udpsocketUdpBroadcast);
        daemonUdpBroadcastListener.setBufferManager(bufferManager);
        daemonUdpBroadcastListener.setPacketLength(Math.max(cbPacket, cbPacketPref));
        daemonTcpBroadcastListener.setUdpSocket(udpsocketTcpBroadcast);
        daemonTcpBroadcastListener.setBufferManager(bufferManager);
        daemonTcpBroadcastListener.setPacketLength(Math.max(cbPacket, cbPacketPref));
        daemonReceiver.setClusterService(daemonClusterService);
        daemonReceiver.setAckSendQueue(daemonPublisher.getAckQueue());
        daemonReceiver.setConfirmationQueue(daemonPublisher.getConfirmationQueue());
        daemonReceiver.setBufferManager(bufferManager);
        daemonReceiver.setMaximumPacketLength(cbPacket);
        daemonReceiver.setPreferredPacketLength(cbPacketPref);
        daemonReceiver.setNackEnabled(config.isReceiverNackEnabled());
        daemonReceiver.setPublisher(daemonPublisher);
        if (!daemonTransport.isEnabled() && config.isSpeakerEnabled()) {
            PacketSpeaker.BundlingQueue queueSpeaker = (PacketSpeaker.BundlingQueue)daemonSpeaker.getQueue();
            int nVolume = config.getSpeakerVolumeMinimum();
            try {
                queueSpeaker.setVolumeTunable(nVolume < 0);
                queueSpeaker.setVolumeThreshold(nVolume < 0 ? udpsocketUnicast.getDatagramSocket().getSendBufferSize() / cbPacketPref : nVolume);
                if (queueSpeaker.isBundlingEnabled()) {
                    queueSpeaker.setDeferralThresholdNanos(config.getPacketBundlingThresholdNanos());
                    queueSpeaker.setBundlingAggression(config.getPacketBundlingAggression());
                }
                queueSpeaker.setCloggedCount(config.getPublisherCloggedCount());
                queueSpeaker.setCloggedDelay(config.getPublisherCloggedDelayMillis());
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        daemonPublisher.setUdpSocketUnicast(udpsocketUnicast);
        daemonPublisher.setUdpSocketMulticast(udpsocketUdpBroadcast);
        daemonPublisher.setSendQueue(daemonSpeaker.getQueue());
        daemonPublisher.setMaximumPacketLength(cbPacket);
        daemonPublisher.setPreferredPacketLength(cbPacketPref);
        daemonPublisher.setNackEnabled(config.isReceiverNackEnabled());
        daemonPublisher.setNackDelayMillis(config.getPublisherNackDelayMillis());
        daemonPublisher.setMessageBufferAllocator(new BufferManagerWriteBufferPool(bufferManager));
        if (config.isFlowControlEnabled()) {
            daemonPublisher.setDeferredReadyQueue(new Queue());
            Member.FlowControl.setEnabled(true);
            int iMax = config.getOutstandingPacketMaximum();
            int iMin = config.getOutstandingPacketMinimum();
            Member.FlowControl.setOutstandingPacketMaximum(iMax);
            Member.FlowControl.setOutstandingPacketMinimum(iMin);
            Member.FlowControl.setLostPacketThreshold(config.getLostPacketThreshold());
        }
        daemonPublisher.setResendDelay(config.getPublisherResendDelayMillis());
        daemonPublisher.setResendTimeout(cTimeoutMillis);
        daemonPublisher.setAckDelay(config.getPublisherAckDelayMillis());
        daemonPublisher.setCloggedCount(config.getPublisherCloggedCount());
        daemonPublisher.setCloggedDelay(config.getPublisherCloggedDelayMillis());
        daemonPublisher.setMulticastThreshold((double)config.getPublisherGroupThreshold() / 100.0);
        List<String> listFilterNames = config.getFilterList();
        if (listFilterNames != null && !listFilterNames.isEmpty() && !(listFilter = this.instantiateWrapperStreamFactoryList(listFilterNames)).isEmpty()) {
            this.setWrapperStreamFactoryList(new ImmutableArrayList(listFilter));
        }
        NameServiceBridge nsClient = this.getNameServiceBridge();
        nsClient.setOperationalContext(this.getOperationalContext());
        NameServiceDependencies depsNS = (NameServiceDependencies)this.getNameService().getDependencies();
        TcpAcceptorDependencies depsAccept = (TcpAcceptorDependencies)depsNS.getAcceptorDependencies();
        DefaultTcpInitiatorDependencies depsFNsInit = new DefaultTcpInitiatorDependencies();
        depsFNsInit.setRemoteSocketAddressProviderBuilder(SubstitutionSocketAddressProvider.createBuilder(depsAccept.getLocalAddressProviderBuilder(), InetAddress.getLoopbackAddress(), config.getGroupPort(), 0));
        depsFNsInit.setSocketProviderBuilder(new SocketProviderBuilder(TcpSocketProvider.MULTIPLEXED, false));
        depsFNsInit.setConnectTimeoutMillis(100L);
        depsFNsInit.setRequestSendTimeoutMillis(100L);
        depsFNsInit.setRequestTimeoutMillis(100L);
        DefaultRemoteServiceDependencies depsFNs = new DefaultRemoteServiceDependencies();
        depsFNs.setRemoteServiceName("NameService");
        depsFNs.setInitiatorDependencies(depsFNsInit);
        nsClient.setDependencies(depsFNs);
    }

    protected void configureSockets() {
        int cbBufferSent;
        int cbHeaderSize;
        DefaultClusterDependencies config = (DefaultClusterDependencies)this.getDependencies();
        InetAddress addrLocal = config.computeLocalAddress();
        if (InetAddressHelper.isLoopbackAddress(addrLocal)) {
            Cluster._trace("Local address \"" + InetAddressHelper.toString(addrLocal) + "\" is a loopback address; this cluster node will not connect to nodes located on different machines", 2);
        }
        SocketManager manager = this.getSocketManager();
        SocketProviderBuilder bldrUnicastSocketProvider = config.getUnicastSocketProviderBuilder();
        DatagramSocketProvider provider = bldrUnicastSocketProvider.getDatagramSocketProvider(MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_TCMP_DATAGRAM.getSubPort());
        manager.setUnicastUdpSocketProvider(provider);
        manager.setTcpRingSocketProvider(bldrUnicastSocketProvider.getDemultiplexedSocketProvider(MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_TCP_RING.getSubPort()));
        int cbPacket = config.getPacketMaxLength();
        int cbPacketPref = config.getPacketPreferredLength();
        int n = cbHeaderSize = provider instanceof SystemDatagramSocketProvider ? 48 : 68;
        if (cbPacketPref == 0) {
            int nMTU = 0;
            try {
                nMTU = InetAddressHelper.getLocalMTU(addrLocal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (nMTU == 0) {
                nMTU = InetAddressHelper.getLocalMTU();
            }
            nMTU = Math.min(65535, nMTU);
            cbPacketPref = nMTU - cbHeaderSize;
        }
        if ((cbBufferSent = config.getPublisherSocketBufferSize()) == 0) {
            cbBufferSent = this.isTransportServiceEnabled() || cbPacketPref < 1500 ? Math.max(16 * cbPacketPref, 32768) : (cbPacketPref < 9000 ? 262144 : 524288);
        } else if (cbBufferSent < 0) {
            cbBufferSent *= -cbPacketPref;
        }
        cbBufferSent = Math.max(Math.max(cbPacket, cbPacketPref), cbBufferSent);
        int cbBufferPref = config.getLocalBufferSize();
        if (cbBufferPref == 0) {
            cbBufferPref = this.isTransportServiceEnabled() || cbPacketPref < 1500 ? Math.max(16 * cbPacketPref, 0x200000) : (cbPacketPref < 9000 ? 0x400000 : 0x800000);
        } else if (cbBufferPref < 0) {
            cbBufferPref *= -cbPacketPref;
        }
        cbBufferPref = Math.max(Math.max(cbPacket, cbPacketPref), cbBufferPref);
        int cbBufferGroup = config.getGroupBufferSize();
        if (cbBufferGroup == 0) {
            cbBufferGroup = this.isTransportServiceEnabled() || cbPacketPref < 1500 ? Math.max(16 * cbPacketPref, 0x100000) : (cbPacketPref < 9000 ? 0x200000 : 0x400000);
        } else if (cbBufferGroup < 0) {
            cbBufferGroup *= -cbPacketPref;
        }
        cbBufferGroup = Math.max(Math.max(cbPacket, cbPacketPref), cbBufferGroup);
        SocketManager.UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
        SocketManager.PreferredUnicastUdpSocket udpsocketUnicastPref = manager.getPreferredUnicastUdpSocket();
        SocketManager.BroadcastUdpSocket udpsocketUdpBroadcast = manager.getBroadcastUdpSocket();
        SocketManager.BroadcastTcpSocket udpsocketTcpBroadcast = manager.getBroadcastTcpSocket();
        InetAddress addrDiscovery = config.getLocalDiscoveryAddress();
        InetAddress addrUnicast = config.getLocalAddress();
        if (addrUnicast == null) {
            InetAddress inetAddress = addrUnicast = addrDiscovery.isAnyLocalAddress() && config.getWellKnownAddresses() != null ? addrDiscovery : addrLocal;
        }
        if (InetAddressHelper.isNatLocalAddress(addrUnicast, config.getLocalPort(), config.getLocalPortAutoAdjust())) {
            addrUnicast = InetAddressHelper.ADDR_ANY;
        }
        if (InetAddressHelper.isNatLocalAddress(addrDiscovery, config.getLocalPort(), config.getLocalPortAutoAdjust())) {
            addrDiscovery = InetAddressHelper.ADDR_ANY;
        }
        udpsocketUnicast.setBufferSentBytes(cbBufferSent);
        udpsocketUnicast.setBufferReceivedBytes(cbBufferGroup);
        udpsocketUnicast.setInetAddress(addrUnicast);
        udpsocketUnicast.setPacketLength(Math.max(cbPacket, cbPacketPref));
        udpsocketUnicastPref.setBufferReceivedBytes(cbBufferPref);
        udpsocketUnicastPref.setInetAddress(addrUnicast);
        udpsocketUnicastPref.setPacketLength(cbPacketPref);
        InetAddress addrBroadcast = config.getWellKnownAddresses() == null ? InetAddressHelper.ADDR_ANY : addrDiscovery;
        udpsocketUdpBroadcast.setBufferReceivedBytes(cbBufferGroup);
        udpsocketUdpBroadcast.setInetAddress(addrBroadcast);
        udpsocketUdpBroadcast.setPacketLength(65535);
        udpsocketTcpBroadcast.setBufferReceivedBytes(cbBufferGroup);
        udpsocketTcpBroadcast.setInetAddress(addrBroadcast);
        udpsocketTcpBroadcast.setPacketLength(65535);
        try {
            SocketManager.AcceptorChannel channel = manager.getAcceptorChannel();
            channel.setInetAddress(addrDiscovery);
            channel.setBacklog(config.getTcpBacklog());
            this.getClusterService().getTcpRing().getSocketOptions().copyOptions(config.getTcpRingSocketOptions());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public boolean configureTracing(TracingShim.Dependencies deps) {
        TracingShim.Control control = this.getTracingControl();
        if (control != null) {
            control.close();
            this.setTracingControl(null);
        }
        if (deps == null) {
            return true;
        }
        if (deps.getIdentity() == null) {
            ClusterDependencies config = this.getDependencies();
            MemberIdentity identity = config.getMemberIdentity();
            Object sIdentity = identity.getMemberName();
            if (sIdentity == null) {
                sIdentity = identity.getClusterName() + "." + identity.getRoleName();
            }
            deps = TracingHelper.defaultDependencies(deps).setIdentity((String)sIdentity);
        }
        if ((control = TracingHelper.initialize(deps)) != null) {
            this.setTracingControl(control);
            return true;
        }
        return false;
    }

    public MessageBus createMessageBus(String sServiceType, String sTransport) {
        SocketManager mgrSocket = this.getSocketManager();
        return this.createMessageBus(sServiceType, sTransport, mgrSocket.getDepot(), this.getClusterService().getThisMember().getAddress().getHostAddress(), mgrSocket.getAcceptorChannel().getPort());
    }

    public MessageBus createMessageBus(String sServiceType, String sTransport, Depot depot, String sAddr, int nPort) {
        return this.createMessageBus(sServiceType, sTransport, depot, sAddr, nPort, true);
    }

    public MessageBus createMessageBus(String sServiceType, String sTransport, Depot depot, String sAddr, int nPort, boolean fMultiplexed) {
        if (sTransport != null && !((String)sTransport).isEmpty()) {
            if (((String)sTransport).equals("imb")) {
                sTransport = "tmb";
            } else if (((String)sTransport).equals("imbs")) {
                sTransport = "tmbs";
            }
        }
        String sTransportOrig = sTransport;
        String sPort = Integer.toString(nPort);
        if (sTransport != null && ((String)sTransport).isEmpty()) {
            sTransport = null;
            sTransportOrig = null;
        }
        if (sTransport == null && this.getTransportService().getServiceType().equals(sServiceType)) {
            if (Platform.getPlatform().isExaEnabled()) {
                sTransport = this.getSocketManager().getUnicastUdpSocketProvider().isSecure() ? "tmbs" : "tmb";
            } else {
                Object object = sTransport = this.getSocketManager().getUnicastUdpSocketProvider().isSecure() ? "tmbs" : "tmb";
            }
        }
        while (sTransport != null) {
            if (((String)sTransport).equals("tmb") || ((String)sTransport).equals("tmbs") || ((String)sTransport).equals("sdmb") || ((String)sTransport).equals("sdmbs")) {
                boolean fEphemeral;
                boolean bl = fEphemeral = this.getDependencies().getLocalPort() == 0 && ((String)sTransport).startsWith("sdmb");
                sTransport = (String)sTransport + "://{member-ip}:" + (fEphemeral ? "0.0" : (fMultiplexed ? "{member-port}.0" : "{member-port}"));
            } else if (((String)sTransport).equals(TRANSPORT_DATAGRAM)) {
                throw new IllegalArgumentException("datagram is not a bus transport");
            }
            sTransport = ((String)sTransport).replace("{member-ip}", sAddr);
            sTransport = ((String)sTransport).replace("{member-port}", sPort);
            try {
                return depot.createMessageBus(depot.resolveEndPoint((String)sTransport));
            }
            catch (RuntimeException e) {
                if (sTransportOrig == null) {
                    sTransport = ((String)sTransport).startsWith("sdmbs") ? "tmbs" : (((String)sTransport).startsWith("sdmb") ? "tmb" : null);
                    continue;
                }
                throw e;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service ensureService(String sName, String sType) {
        if (sName == null || sName.length() == 0) {
            throw new IllegalArgumentException("Invalid service name: " + sName);
        }
        Grid service = (Grid)this.getService(sName);
        if (service == null || !service.isRunning()) {
            Cluster cluster = this;
            synchronized (cluster) {
                if (service == null) {
                    service = (Grid)this.getService(sName);
                } else {
                    for (int cTries = 0; cTries < 10; ++cTries) {
                        Grid grid = service;
                        synchronized (grid) {
                            service = (Grid)this.getService(sName);
                            if (service == null || service.isRunning()) {
                                break;
                            }
                        }
                        if (cTries == 9) {
                            throw new IllegalStateException("Failed to unregister: " + String.valueOf(service));
                        }
                        Base.sleep(10 * (cTries + 1));
                    }
                }
                if (service == null) {
                    String sComponent = this.getDependencies().getServiceMap().get(sType);
                    if (sComponent != null) {
                        try {
                            service = (Grid)Cluster._newInstance("Component.Util.Daemon.QueueProcessor.Service.Grid." + sComponent);
                        }
                        catch (SecurityException e) {
                            throw Base.ensureRuntimeException(null, sType + " service: " + e.getMessage());
                        }
                    }
                    if (service == null) {
                        throw new IllegalArgumentException("Unknown service type: " + sType + ":" + sComponent);
                    }
                    service.setServiceName(sName);
                    this.bindService(service);
                }
            }
        }
        if (!service.getServiceType().equals(sType)) {
            throw new IllegalArgumentException("Requested service type \"" + sType + "\", but the existing service has type \"" + service.getServiceType() + "\"");
        }
        return service;
    }

    public void ensureStopped() {
        if (this.getState() != 6) {
            long ldtTimeout = Base.getSafeTimeMillis() + (long)(4 * this.getDependencies().getClusterHeartbeatDelayMillis());
            do {
                try {
                    Blocking.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
                if (this.getState() != 6) continue;
                return;
            } while (Base.getSafeTimeMillis() < ldtTimeout);
            throw new RequestTimeoutException("Timeout while waiting for cluster to stop.");
        }
    }

    public String formatPointToPointStats() {
        MasterMemberSet members = this.getClusterService().getClusterMemberSet();
        Member memberThis = members.getThisMember();
        StringBuffer sb = new StringBuffer();
        try {
            for (Member member : members) {
                if (member == null || member == memberThis) continue;
                sb.append("\nMember=").append(member.getId()).append(", ").append(member.formatStats());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String formatStats() {
        IpMonitor ipMonitor;
        StringBuffer sb = new StringBuffer();
        sb.append("\nPacketPublisher: ").append(this.getPublisher().formatStats()).append("\nPacketSpeaker  : ").append(this.getSpeaker().formatStats()).append("\nPacketReceiver : ").append(this.getReceiver().formatStats());
        if (this.getDependencies().isTcpRingEnabled()) {
            sb.append("\nTcpRing        : ").append(this.getClusterService().getTcpRing().formatStats());
        }
        if ((ipMonitor = this.getIpMonitor()).isStarted()) {
            sb.append("\nIpMonitor      : ").append(ipMonitor.formatStats());
        }
        return sb.toString();
    }

    @Override
    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public ByteBuffer getClusterNameBuffer() {
        return this.__m_ClusterNameBuffer;
    }

    public ClusterService getClusterService() {
        return this.__m_ClusterService;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return null;
    }

    public int[] getCounters() {
        ClusterDependencies config = this.getDependencies();
        int nMachineId = config.getMemberIdentity().getMachineId();
        if (nMachineId == 0) {
            try {
                InetAddress addr = InetAddressHelper.getLocalHost();
                long lAddr = InetAddressHelper.toLong(addr);
                nMachineId = (int)((lAddr & 0xFF000000L) >>> 24 & 0xFFL ^ (lAddr & 0xFF0000L) >>> 16 & 0xFFL ^ (lAddr & 0xFF00L) >>> 8 & 0xFFL) << 8 | (int)(lAddr & 0xFFL) & 0xFF;
            }
            catch (Throwable addr) {
                // empty catch block
            }
            if (nMachineId == 0) {
                nMachineId = 1;
            }
        }
        int nCpu = Runtime.getRuntime().availableProcessors();
        int[] ac = new int[]{nCpu, nCpu, nMachineId};
        LicensedObject.LicenseData[] aLicense = (LicensedObject.LicenseData[])((Cluster)this.get_Module()).getClusterService().get_Feed();
        if (aLicense != null && aLicense.length > 0) {
            ProcessorInfo procinfo = new ProcessorInfo(aLicense[0].uid);
            ac[0] = procinfo.getCpuCount();
            ac[1] = procinfo.getSocketCount();
        }
        return ac;
    }

    @Override
    public ClusterDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public PublicGuardian getGuardian() {
        return this.__m_Guardian;
    }

    public int getGuardRecoverCount() {
        return this.__m_GuardRecoverCount;
    }

    public int getGuardTerminateCount() {
        return this.__m_GuardTerminateCount;
    }

    public IpMonitor getIpMonitor() {
        return this.__m_IpMonitor;
    }

    @Override
    public com.tangosol.net.Member getLocalMember() {
        return this.getClusterService().getClusterMemberSet().getThisMember();
    }

    @Override
    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return this.getClusterService().getClusterMemberSet();
    }

    public MessagePublisher getMessagePublisher() {
        return this.__m_MessagePublisher;
    }

    public NameService getNameService() {
        return this.__m_NameService;
    }

    public NameServiceBridge getNameServiceBridge() {
        return this.__m_NameServiceBridge;
    }

    @Override
    public com.tangosol.net.Member getOldestMember() {
        return this.getClusterService().getClusterOldestMember();
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public PacketListener1 getPointListener() {
        return this.__m_PointListener;
    }

    public PacketListener1P getPreferredListener() {
        return this.__m_PreferredListener;
    }

    public PacketPublisher getPublisher() {
        return this.__m_Publisher;
    }

    public PacketReceiver getReceiver() {
        return this.__m_Receiver;
    }

    @Override
    public Disposable getResource(String sName) {
        return this.getResourceRegistry().getResource(Disposable.class, sName);
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    @Override
    public Service getService(String sName) {
        return this.getClusterService().getService(sName);
    }

    @Override
    public com.tangosol.net.ServiceInfo getServiceInfo(String sName) {
        return this.getClusterService().getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        ArrayList<String> list = new ArrayList<String>();
        ClusterService service = this.getClusterService();
        int cServices = service.getServiceInfoCount();
        for (int i = 0; i < cServices; ++i) {
            ServiceInfo info = service.getServiceInfo(i);
            if (info == null) continue;
            list.add(info.getServiceName());
        }
        return new SimpleEnumerator<String>(list.toArray(new String[list.size()]));
    }

    public long getShutdownTimeout() {
        return this.__m_ShutdownTimeout;
    }

    public SocketManager getSocketManager() {
        return (SocketManager)this._findChild("SocketManager");
    }

    public PacketSpeaker getSpeaker() {
        return this.__m_Speaker;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public int getState() {
        return this.__m_State;
    }

    public PacketListenerBT getTcpBroadcastListener() {
        return this.__m_TcpBroadcastListener;
    }

    public PacketListenerBT getTcpBroadcastListenera() {
        return null;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    @Override
    public long getTimeMillis() {
        return this.getClusterService().getTimestamp();
    }

    public TracingShim.Control getTracingControl() {
        return this.__m_TracingControl;
    }

    public TransportService getTransportService() {
        return this.__m_TransportService;
    }

    public PacketListenerBU getUdpBroadcastListener() {
        return this.__m_UdpBroadcastListener;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public void halt() {
        this.setHalted(true);
        try {
            this.getPublisher().halt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getTransportService().halt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getSocketManager().getBroadcastUdpSocket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getSocketManager().getBroadcastTcpSocket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getNameService().halt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getNameServiceBridge().halt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getSocketManager().releaseSockets();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getClusterService().getTcpRing().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List instantiateWrapperStreamFactoryList(List listNames) {
        ClusterDependencies config = this.getDependencies();
        ArrayList<WrapperStreamFactory> listFilter = new ArrayList<WrapperStreamFactory>();
        Map<String, WrapperStreamFactory> mapFilter = config.getFilterMap();
        for (String sName : listNames) {
            WrapperStreamFactory factory = mapFilter.get(sName);
            if (factory == null) {
                Cluster._trace("Cannot find com.tangosol.io.WrapperStreamFactory for filter-name: " + sName, 1);
                continue;
            }
            listFilter.add(factory);
        }
        return listFilter;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        Filter filterHost = this.getDependencies().getAuthorizedHostFilter();
        try {
            return filterHost == null || filterHost.evaluate(addr);
        }
        catch (Throwable e) {
            Cluster._trace(String.valueOf(filterHost) + " evaluation failed: " + String.valueOf(e), 1);
            return false;
        }
    }

    public boolean isClusterPortBound() {
        return this.getTcpBroadcastListener().isStarted() || this.getNameServiceBridge().isForeignBroadcastBound();
    }

    public boolean isClusterPortSharingEnabled() {
        return this.getDependencies().getPublisherGroupThreshold() >= 100 && !this.getSocketManager().getUnicastUdpSocketProvider().isSecure();
    }

    public boolean isCommEndangered(Member member) {
        long lTrintCutoff = this.getPublisher().getMessageOutgoing().getLastIndex() - 0x100000L;
        PacketIdentifier packetidTo = member.getContiguousToPacketId();
        return packetidTo == null || packetidTo.getFromMessageId() < lTrintCutoff;
    }

    public boolean isHalted() {
        return this.__m_Halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        while (true) {
            switch (this.getState()) {
                case 3: {
                    return true;
                }
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
            Cluster cluster = this;
            synchronized (cluster) {
                try {
                    Blocking.wait(this, 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return this.getState() == 3;
                }
            }
        }
    }

    public boolean isTransportServiceEnabled() {
        return !TRANSPORT_DATAGRAM.equals(this.getDependencies().getReliableTransport());
    }

    @Override
    public Object lookup(String sName2, com.tangosol.net.Cluster cluster, NameService.RequestContext ctx) throws NamingException {
        String sPrefix = "Cluster/";
        if (sName2 != null && sName2.startsWith(sPrefix)) {
            if ((sName2 = sName2.substring(sPrefix.length())).equals("info")) {
                return this.toString();
            }
            if (sName2.equals("version")) {
                return Coherence.VERSION;
            }
            if (sName2.equals("edition")) {
                return Coherence.EDITION_NAMES[((Coherence)Coherence.get_Instance()).getEdition()];
            }
            if (sName2.equals("mode")) {
                return Coherence.MODE_NAMES[((Coherence)Coherence.get_Instance()).getMode()];
            }
            if (sName2.equals("name")) {
                return this.getClusterService().getClusterName();
            }
            if (sName2.equals("size")) {
                return Integer.toString(this.getClusterService().getServiceMemberSet().size());
            }
            if (sName2.equals("foreign")) {
                HashSet<String> setClusters = new HashSet<String>();
                for (String sName2 : this.getNameService().getDirectory().keySet()) {
                    if (!sName2.startsWith(sPrefix = "Cluster/foreign/")) continue;
                    sName2 = sName2.substring(sPrefix.length());
                    setClusters.add(sName2.substring(0, sName2.indexOf(47)));
                }
                return setClusters;
            }
            if (sName2.equals("localMember")) {
                return this.getClusterService().getThisMember();
            }
            if (sName2.equals("localDiscoveryInetAddress")) {
                return this.getDependencies().getLocalDiscoveryAddress();
            }
            if (sName2.equals("localInetAddress")) {
                return this.getClusterService().getThisMember().getAddress();
            }
            if (sName2.equals("IPv4Stack")) {
                return InetAddresses.PreferIPv4Stack;
            }
            if (sName2.equals("multicastInetAddress")) {
                return this.getClusterService().isWkaEnabled() ? null : this.getDependencies().getGroupAddress();
            }
        }
        return null;
    }

    protected void onBroadcastPacket(DatagramSocket socketIn, SocketAddress addrSrc, ByteBuffer buffer) {
        ByteBuffer bufClusterName = this.getClusterNameBuffer();
        int cbName = bufClusterName.remaining();
        int nPos = buffer.position();
        int cbHeader = 4;
        if (buffer.remaining() >= 4 + cbName && Buffers.equals(buffer, nPos + 4, bufClusterName, bufClusterName.position(), cbName)) {
            PacketReceiver.AddressedBuffer bufferAddr = new PacketReceiver.AddressedBuffer();
            bufferAddr.setSourceAddress(addrSrc);
            bufferAddr.setBuffer(buffer);
            this.getReceiver().getQueue().add(bufferAddr);
            PacketListenerBU listenerBU = this.getUdpBroadcastListener();
            if (listenerBU.isInGroup()) {
                listenerBU.resetSuspectGroupTimestamp();
            }
        } else {
            this.onForeignPacket(socketIn, addrSrc, buffer);
        }
    }

    public void onException(Throwable e) {
        int nState = this.getState();
        if (nState < 3) {
            this.setStartException(e);
        }
        if (nState < 5) {
            try {
                Cluster._trace(e, "Stopping cluster due to unhandled exception");
            }
            finally {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onForeignPacket(DatagramSocket socketIn, SocketAddress addrSrc, ByteBuffer buffer) {
        if (this.isClusterPortSharingEnabled()) {
            BufferManager mgr = this.getReceiver().getBufferManager();
            try {
                NameService ns = this.getNameService();
                int nPos = buffer.position();
                int nLim = buffer.limit();
                DataInputStream in = new DataInputStream(new ByteBufferInputStream(buffer));
                int nType = in.readInt();
                String sCluster = in.readUTF();
                int nSource = in.readUnsignedShort();
                short nMsgType = in.readShort();
                int ofCbMsg = buffer.position() - nPos;
                short cbMsg = in.readShort();
                in.close();
                buffer.position(nPos).limit(nLim);
                InetSocketAddress addr = (InetSocketAddress)ns.lookup("Cluster/foreign/" + sCluster + "/Cluster/localAddress");
                if (addr == null) return;
                if (nMsgType == 7) {
                    int nVer;
                    Integer NVer = (Integer)ns.lookup("Cluster/foreign/" + sCluster + "/Cluster/announceVersion");
                    int n = nVer = NVer == null ? 0 : NVer;
                    if (nVer > 0) {
                        InetSocketAddress addrInetSrc = (InetSocketAddress)addrSrc;
                        InetAddress addrIpSrc = addrInetSrc.getAddress();
                        byte[] abIpSrc = addrIpSrc.getAddress();
                        int cbAbIpSrc = abIpSrc.length;
                        int cbAdd = 4 + cbAbIpSrc + 4;
                        ByteBuffer bufNew = mgr.acquire(buffer.remaining() + cbAdd);
                        bufNew.put(buffer).putInt(cbAbIpSrc).put(abIpSrc).putInt(addrInetSrc.getPort()).flip();
                        bufNew.putShort(ofCbMsg, (short)(cbMsg + cbAdd));
                        mgr.release(buffer);
                        buffer = bufNew;
                    }
                }
                socketIn.send(new DatagramPacket(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), addr));
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                mgr.release(buffer);
            }
        } else {
            this.getReceiver().getQueue().add(buffer);
        }
    }

    public void onGuardableRecover() {
        this.setGuardRecoverCount(this.getGuardRecoverCount() + 1);
    }

    public void onGuardableTerminate() {
        this.setGuardTerminateCount(this.getGuardTerminateCount() + 1);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setPointListener((PacketListener1)this._findName("PacketListener1"));
        this.setPreferredListener((PacketListener1P)this._findName("PacketListener1P"));
        this.setTcpBroadcastListener((PacketListenerBT)this._findName("PacketListenerBT"));
        this.setUdpBroadcastListener((PacketListenerBU)this._findName("PacketListenerBU"));
        this.setReceiver((PacketReceiver)this._findName("PacketReceiver"));
        this.setPublisher((PacketPublisher)this._findName("PacketPublisher"));
        this.setSpeaker((PacketSpeaker)this._findName("PacketSpeaker"));
        this.setTransportService((TransportService)this._findName("TransportService"));
        this.setNameService((NameService)this._findName("NameService"));
        this.setNameServiceBridge((NameServiceBridge)this._findName("NameServiceBridge"));
        this.setIpMonitor((IpMonitor)this._findName("IpMonitor"));
        this.setGuardian((PublicGuardian)this._findName("PublicGuardian"));
        this.setMessagePublisher(this.getPublisher());
        this.setClusterService((ClusterService)this._findName("ClusterService"));
        this.setShutdownTimeout(new Millis(Config.getDuration("coherence.shutdown.timeout", new Duration("2m"))).get());
        TransportService svcTransport = this.getTransportService();
        this.getClusterService().ensureServiceInfo(1, svcTransport.getServiceName(), ((Grid)svcTransport).getServiceType());
    }

    public void onMemberJoined(Member member) {
        if (this.getDependencies().isIpMonitorEnabled()) {
            this.getIpMonitor().onMemberJoined(member);
        }
    }

    public void onMemberLeft(Member member) {
        this.getPublisher().onMemberLeft(member);
        this.getReceiver().onMemberLeft(member);
        if (this.getDependencies().isIpMonitorEnabled()) {
            this.getIpMonitor().onMemberLeft(member);
        }
    }

    public void onPacket(PacketListener listener, SocketAddress addrSrc, ByteBuffer buffer) {
        int nType;
        if (buffer.remaining() >= 4 && ((nType = buffer.getInt(buffer.position())) & 0xFFFFFFF0) == 0xDDF00D0) {
            switch (nType) {
                case 232718546: {
                    this.onBroadcastPacket(listener.getUdpSocket().getDatagramSocket(), addrSrc, buffer);
                    return;
                }
                case 232718554: {
                    this.getNameService().onDatagramLookup(listener.getUdpSocket().getDatagramSocket(), addrSrc, buffer);
                    return;
                }
            }
            if (this.getClusterService().getClusterMemberSet().getMember(addrSrc) != null && this.getReceiver().getQueue().add(buffer)) {
                return;
            }
        }
        listener.getBufferManager().release(buffer);
    }

    protected void onStart() {
        ClusterDependencies config = this.getDependencies();
        if (config == null) {
            throw new IllegalArgumentException("Cluster dependencies must be set!");
        }
        if (!config.isTcmpEnabled()) {
            throw new UnsupportedOperationException("TCMP clustering has been disabled; this configuration may only access clustered services via Extend proxies.");
        }
        Security.getInstance();
        this.setClusterName(config.getMemberIdentity().getClusterName());
        XmlElement xmlTracing = CacheFactory.getServiceConfig("$Tracing");
        if (xmlTracing != null) {
            this.configureTracing(LegacyXmlTracingHelper.fromXml(xmlTracing, TracingHelper.defaultDependencies()));
        }
        this.configureSockets();
        this.configureBroadcast();
        try {
            this.getSocketManager().bindSockets();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        this.configureDaemons();
        this.startDaemons();
        this.setState(2);
        this.startSystemServices();
        this.setState(3);
        int nShutdownOption = config.getShutdownHookOption();
        if (nShutdownOption != 0) {
            try {
                ShutdownHook hook = (ShutdownHook)this._findName("ShutdownHook");
                hook.setGraceful(nShutdownOption == 2);
                hook.register();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.getResourceRegistry().registerResource(Guardian.class, this.getGuardian());
    }

    @Override
    public void registerResource(String sName, Disposable disposable) {
        this.getResourceRegistry().registerResource(Disposable.class, sName, disposable);
    }

    public void resetPointToPointStats() {
        try {
            for (Member member : this.getClusterService().getClusterMemberSet()) {
                if (member == null) continue;
                member.resetStats();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void resetStats() {
        this.getPointListener().resetStats();
        this.getPreferredListener().resetStats();
        this.getUdpBroadcastListener().resetStats();
        this.getTcpBroadcastListener().resetStats();
        this.getSpeaker().resetStats();
        this.getPublisher().resetStats();
        this.getReceiver().resetStats();
        this.getClusterService().getTcpRing().resetStats();
        this.setGuardTerminateCount(0);
        this.setGuardRecoverCount(0);
    }

    @Override
    public void resumeService(String sService) {
        this.getClusterService().doServiceQueiscence(sService, true);
    }

    protected void setClusterName(String sClusterName) {
        Cluster._assert(sClusterName != null);
        if (this.getClusterService().isStarted()) {
            throw new IllegalStateException("Cluster name cannot be changed.");
        }
        this.__m_ClusterName = sClusterName;
    }

    protected void setClusterNameBuffer(ByteBuffer sProperty) {
        this.__m_ClusterNameBuffer = sProperty;
    }

    protected void setClusterService(ClusterService daemon) {
        this.__m_ClusterService = daemon;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
    }

    @Override
    public void setDependencies(ClusterDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Cluster dependencies cannot be reset");
        }
        this.__m_Dependencies = new DefaultClusterDependencies(deps).validate();
    }

    protected void setGuardian(PublicGuardian daemon) {
        this.__m_Guardian = daemon;
    }

    protected void setGuardRecoverCount(int cRecover) {
        this.__m_GuardRecoverCount = cRecover;
    }

    protected void setGuardTerminateCount(int cTerminate) {
        this.__m_GuardTerminateCount = cTerminate;
    }

    protected void setHalted(boolean fHalted) {
        this.__m_Halted = fHalted;
    }

    protected void setIpMonitor(IpMonitor daemon) {
        this.__m_IpMonitor = daemon;
    }

    @Override
    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    protected void setMessagePublisher(MessagePublisher publisher) {
        this.__m_MessagePublisher = publisher;
    }

    public void setNameService(NameService serviceName) {
        this.__m_NameService = serviceName;
    }

    public void setNameServiceBridge(NameServiceBridge bridgeService) {
        this.__m_NameServiceBridge = bridgeService;
    }

    public void setOperationalContext(OperationalContext operationalContext) {
        this.__m_OperationalContext = operationalContext;
    }

    protected void setPointListener(PacketListener1 daemon) {
        this.__m_PointListener = daemon;
    }

    protected void setPreferredListener(PacketListener1P daemon) {
        this.__m_PreferredListener = daemon;
    }

    protected void setPublisher(PacketPublisher daemon) {
        this.__m_Publisher = daemon;
    }

    protected void setReceiver(PacketReceiver daemon) {
        this.__m_Receiver = daemon;
    }

    public void setResourceRegistry(ResourceRegistry sProperty) {
        this.__m_ResourceRegistry = sProperty;
    }

    protected void setShutdownTimeout(long lTimeout) {
        this.__m_ShutdownTimeout = lTimeout;
    }

    protected void setSpeaker(PacketSpeaker daemon) {
        this.__m_Speaker = daemon;
    }

    public void setStartException(Throwable e) {
        if (this.getStartException() == null) {
            this.__m_StartException = e;
        }
    }

    protected synchronized void setState(int nState) {
        this.__m_State = nState;
        this.notifyAll();
    }

    protected void setTcpBroadcastListener(PacketListenerBT daemon) {
        this.__m_TcpBroadcastListener = daemon;
    }

    protected void setThreadGroup(ThreadGroup threadgroup) {
        Cluster._assert(this.getState() < 3);
        this.__m_ThreadGroup = threadgroup;
    }

    public void setTracingControl(TracingShim.Control sProperty) {
        this.__m_TracingControl = sProperty;
    }

    protected void setTransportService(TransportService serviceTransport) {
        this.__m_TransportService = serviceTransport;
    }

    protected void setUdpBroadcastListener(PacketListenerBU daemon) {
        this.__m_UdpBroadcastListener = daemon;
    }

    protected void setWrapperStreamFactoryList(List list) {
        this.__m_WrapperStreamFactoryList = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        switch (this.getState()) {
            case 0: {
                this.setState(6);
                break;
            }
            case 1: 
            case 2: {
                this.start();
            }
            case 3: {
                try {
                    this.checkShutdownPermission();
                    this.setState(4);
                    ClusterService svcCluster = this.getClusterService();
                    for (int i = svcCluster.getServiceCount(); i >= 0; --i) {
                        Grid service = svcCluster.getService(i);
                        if (service == null) continue;
                        ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)service).shutdown();
                    }
                }
                finally {
                    this.stop();
                }
            }
            case 4: 
            case 5: {
                while (this.getState() != 6) {
                    try {
                        Blocking.wait(this);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Base.ensureRuntimeException(e);
                    }
                }
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown State=" + this.getState());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void start() {
        Throwable e;
        try {
            switch (this.getState()) {
                case 0: {
                    this.setState(1);
                    try {
                        this.onStart();
                    }
                    catch (RuntimeException e2) {
                        this.setStartException(e2);
                        throw e2;
                    }
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    return;
                }
                case 4: 
                case 5: {
                    throw new IllegalStateException("Cluster is shutting down!");
                }
                case 6: {
                    throw new IllegalStateException("Cluster is dead!");
                }
                default: {
                    throw new IllegalStateException("Unknown State=" + this.getState());
                }
            }
        }
        catch (Throwable e3) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(e3 instanceof Error)) throw (RuntimeException)e3;
            throw (Error)e3;
        }
        do {
            if (this.getState() >= 3) return;
            try {
                Blocking.wait(this);
            }
            catch (InterruptedException e4) {
                Thread.currentThread().interrupt();
                if (this.getStartException() != null) continue;
                throw Base.ensureRuntimeException(e4, "Interrupted while waiting for Cluster start");
            }
        } while ((e = this.getStartException()) == null);
        throw Base.ensureRuntimeException(e);
    }

    protected void startDaemons() {
        ClusterDependencies deps = this.getDependencies();
        if (!this.getTransportService().isEnabled()) {
            this.getPreferredListener().start();
            if (deps.isSpeakerEnabled()) {
                this.getSpeaker().start();
            }
        }
        if (deps.getPublisherGroupThreshold() < 100 && this.getClusterService().getWellKnownAddresses() == null) {
            PacketListenerBU listenerBU = this.getUdpBroadcastListener();
            listenerBU.joinGroup();
            listenerBU.start();
        }
        this.getPointListener().start();
        this.getReceiver().start();
        this.getPublisher().start();
        if (deps.isIpMonitorEnabled()) {
            this.getIpMonitor().start();
        }
    }

    public void startSystemServices() {
        ClusterService svcCluster = this.getClusterService();
        this.bindService(svcCluster);
        svcCluster.start();
        TransportService svcTrans = this.getTransportService();
        if (svcTrans.isEnabled()) {
            this.bindService(svcTrans);
            svcTrans.start();
            this.setMessagePublisher(svcTrans.getMessageHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.getState() != 6) {
            this.checkShutdownPermission();
            this.setState(5);
            try {
                ShutdownHook hook = (ShutdownHook)this._findName("ShutdownHook");
                hook.unregister();
                this.stopDaemons();
                TransportService svcTransport = this.getTransportService();
                if (svcTransport.isRunning()) {
                    ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)svcTransport).stop();
                }
                ClusterService daemonClusterService = this.getClusterService();
                int cServices = daemonClusterService.getServiceCount();
                LinkedList<Thread> listThreads = new LinkedList<Thread>();
                Thread threadThis = Thread.currentThread();
                for (int i = cServices - 1; i > 0; --i) {
                    Grid service = daemonClusterService.getService(i);
                    if (service == null) continue;
                    ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)service).stop();
                    Thread thread = service.getThread();
                    if (thread == null || thread == threadThis) continue;
                    listThreads.add(thread);
                }
                long cMillisMax = this.getShutdownTimeout();
                boolean fInterrupted = false;
                Iterator iter = listThreads.iterator();
                while (cMillisMax > 0L && iter.hasNext()) {
                    Thread thread = (Thread)iter.next();
                    while (thread.isAlive() && !fInterrupted && cMillisMax > 0L) {
                        long lStart = Base.getSafeTimeMillis();
                        try {
                            thread.join(1000L);
                        }
                        catch (InterruptedException e) {
                            fInterrupted = true;
                        }
                        cMillisMax -= Base.getSafeTimeMillis() - lStart;
                    }
                }
                Thread threadCluster = daemonClusterService.getThread();
                cMillisMax = 2 * this.getDependencies().getClusterHeartbeatDelayMillis();
                fInterrupted = false;
                daemonClusterService.stop();
                if (threadCluster != null && threadCluster != threadThis && cMillisMax > 0L) {
                    try {
                        threadCluster.join(cMillisMax);
                    }
                    catch (InterruptedException e) {
                        fInterrupted = true;
                    }
                }
                if (fInterrupted) {
                    threadThis.interrupt();
                }
                this.getSocketManager().releaseSockets();
                this.getResourceRegistry().dispose();
                this.setResourceRegistry(new SimpleResourceRegistry());
            }
            finally {
                this.getSocketManager().releaseSockets();
                TracingShim.Control control = this.getTracingControl();
                if (control != null) {
                    control.close();
                }
                this.setState(6);
            }
        }
    }

    protected void stopDaemons() {
        this.getPointListener().stop();
        this.getPreferredListener().stop();
        this.getReceiver().stop();
        this.getPublisher().stop();
        this.getSpeaker().stop();
        this.getIpMonitor().stop();
        this.getGuardian().stop();
    }

    @Override
    public void suspendService(String sService) {
        this.suspendService(sService, false);
    }

    public void suspendService(String sService, boolean fResumeOnFailover) {
        this.getClusterService().doServiceQueiscence(sService, false, fResumeOnFailover);
    }

    @Override
    public String toString() {
        if (this.getState() == 3) {
            StringBuffer sb = new StringBuffer();
            ClusterDependencies deps = this.getDependencies();
            String sClusterName = this.getClusterName();
            int nClusterPort = this.getDependencies().getGroupPort();
            sb.append("Name=").append(sClusterName.length() == 0 ? "n/a" : sClusterName).append(", ClusterPort=").append(nClusterPort).append("\n\n");
            AddressProvider providerWka = this.getDependencies().getWellKnownAddresses();
            if (providerWka == null) {
                sb.append("Group{Address=").append(InetAddressHelper.toString(deps.getGroupAddress())).append(", TTL=").append(deps.getGroupTimeToLive()).append('}');
            } else if (providerWka instanceof Set) {
                Set setWka = (Set)((Object)providerWka);
                sb.append("WellKnownAddressList(");
                for (InetSocketAddress addr : setWka) {
                    sb.append("\n  ").append(InetAddressHelper.toString(addr.getAddress()));
                    int nPort = addr.getPort();
                    if (nPort == nClusterPort) continue;
                    sb.append(":").append(nPort);
                }
                sb.append("\n  )");
            } else {
                sb.append("WellKnownAddressProvider(").append(providerWka).append(")");
            }
            ClusterService service = this.getClusterService();
            sb.append("\n\n").append(service.getClusterMemberSet()).append("\n\n").append(service.getTcpRing()).append("\n").append(this.getIpMonitor()).append("\n");
            return sb.toString();
        }
        return "Cluster is not running: State=" + this.getState();
    }

    @Override
    public Disposable unregisterResource(String sName) {
        Disposable disposable = this.getResourceRegistry().getResource(Disposable.class, sName);
        this.getResourceRegistry().unregisterResource(Disposable.class, sName);
        return disposable;
    }

    public void waitHeuristicDelivery(int cMillis) {
        PacketPublisher publisher = this.getPublisher();
        Queue queueSend = publisher.getQueue();
        PacketPublisher.ResendQueue queueResend = publisher.getResendQueue();
        Thread.yield();
        int c = cMillis / 10;
        for (int i = 0; !(i >= c || queueSend.isEmpty() && queueResend.isEmpty()); ++i) {
            try {
                Blocking.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (!queueSend.isEmpty() || !queueResend.isEmpty()) {
            Cluster._trace("Shutdown send queue size=" + queueSend.size() + " resend queue size=" + queueResend.size(), 3);
        }
    }

    public void warnDisabledGuardian(String sContext) {
        Cluster._trace("Disabling the service-guardian by setting a timeout of 0 has been deprecated. Instead, please configure a \"service-failure-policy\" of \"logging\" which will perform non-invasive monitoring of Coherence services.\n Configuring the " + sContext + " with a \"logging\" policy with a timeout of 60000ms", 2);
    }

    public static class ClusterService
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Acknowledgement", Acknowledgement.get_CLASS());
            __mapChildren.put("BusEventMessage", BusEventMessage.get_CLASS());
            __mapChildren.put("ConfigRequest", ConfigRequest.get_CLASS());
            __mapChildren.put("ConfigResponse", ConfigResponse.get_CLASS());
            __mapChildren.put("ConfigSync", ConfigSync.get_CLASS());
            __mapChildren.put("ConfigUpdate", ConfigUpdate.get_CLASS());
            __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
            __mapChildren.put("DispatchNotification", DispatchNotification.get_CLASS());
            __mapChildren.put("MemberConfigUpdate", MemberConfigUpdate.get_CLASS());
            __mapChildren.put("MemberHeartbeat", MemberHeartbeat.get_CLASS());
            __mapChildren.put("MemberJoined", MemberJoined.get_CLASS());
            __mapChildren.put("MemberLeaving", MemberLeaving.get_CLASS());
            __mapChildren.put("MemberLeft", MemberLeft.get_CLASS());
            __mapChildren.put("MemberWelcome", MemberWelcome.get_CLASS());
            __mapChildren.put("MemberWelcomeRequest", MemberWelcomeRequest.get_CLASS());
            __mapChildren.put("MemberWelcomeRequestTask", MemberWelcomeRequestTask.get_CLASS());
            __mapChildren.put("NewMemberAnnounce", NewMemberAnnounce.get_CLASS());
            __mapChildren.put("NewMemberAnnounceReply", NewMemberAnnounceReply.get_CLASS());
            __mapChildren.put("NewMemberAnnounceWait", NewMemberAnnounceWait.get_CLASS());
            __mapChildren.put("NewMemberInduct", NewMemberInduct.get_CLASS());
            __mapChildren.put("NewMemberRequestId", NewMemberRequestId.get_CLASS());
            __mapChildren.put("NewMemberRequestIdReject", NewMemberRequestIdReject.get_CLASS());
            __mapChildren.put("NewMemberRequestIdReply", NewMemberRequestIdReply.get_CLASS());
            __mapChildren.put("NewMemberRequestIdWait", NewMemberRequestIdWait.get_CLASS());
            __mapChildren.put("NewMemberTimestampRequest", NewMemberTimestampRequest.get_CLASS());
            __mapChildren.put("NewMemberTimestampResponse", NewMemberTimestampResponse.get_CLASS());
            __mapChildren.put("NewMemberWelcome", NewMemberWelcome.get_CLASS());
            __mapChildren.put("NewMemberWelcomeAnnounce", NewMemberWelcomeAnnounce.get_CLASS());
            __mapChildren.put("NewMemberWelcomeRequest", NewMemberWelcomeRequest.get_CLASS());
            __mapChildren.put("NotifyConnectionClose", NotifyConnectionClose.get_CLASS());
            __mapChildren.put("NotifyConnectionOpen", NotifyConnectionOpen.get_CLASS());
            __mapChildren.put("NotifyIpTimeout", NotifyIpTimeout.get_CLASS());
            __mapChildren.put("NotifyMemberJoined", NotifyMemberJoined.get_CLASS());
            __mapChildren.put("NotifyMemberLeaving", NotifyMemberLeaving.get_CLASS());
            __mapChildren.put("NotifyMemberLeft", NotifyMemberLeft.get_CLASS());
            __mapChildren.put("NotifyMessageReceipt", NotifyMessageReceipt.get_CLASS());
            __mapChildren.put("NotifyPollClosed", NotifyPollClosed.get_CLASS());
            __mapChildren.put("NotifyResponse", NotifyResponse.get_CLASS());
            __mapChildren.put("NotifyServiceAnnounced", NotifyServiceAnnounced.get_CLASS());
            __mapChildren.put("NotifyServiceJoining", NotifyServiceJoining.get_CLASS());
            __mapChildren.put("NotifyServiceLeaving", NotifyServiceLeaving.get_CLASS());
            __mapChildren.put("NotifyServiceLeft", NotifyServiceLeft.get_CLASS());
            __mapChildren.put("NotifyServiceQuiescence", NotifyServiceQuiescence.get_CLASS());
            __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", NotifyStartup.get_CLASS());
            __mapChildren.put("NotifyTcmpTimeout", NotifyTcmpTimeout.get_CLASS());
            __mapChildren.put("PingRequest", PingRequest.get_CLASS());
            __mapChildren.put("ProtocolContext", ProtocolContext.get_CLASS());
            __mapChildren.put("QuorumRollCall", QuorumRollCall.get_CLASS());
            __mapChildren.put("Response", Response.get_CLASS());
            __mapChildren.put("SeniorMemberHeartbeat", SeniorMemberHeartbeat.get_CLASS());
            __mapChildren.put("SeniorMemberKill", SeniorMemberKill.get_CLASS());
            __mapChildren.put("SeniorMemberPanic", SeniorMemberPanic.get_CLASS());
            __mapChildren.put("ServiceJoined", ServiceJoined.get_CLASS());
            __mapChildren.put("ServiceJoining", ServiceJoining.get_CLASS());
            __mapChildren.put("ServiceJoinRequest", ServiceJoinRequest.get_CLASS());
            __mapChildren.put("ServiceLeaving", ServiceLeaving.get_CLASS());
            __mapChildren.put("ServiceLeft", ServiceLeft.get_CLASS());
            __mapChildren.put("ServiceQuiescenceRequest", ServiceQuiescenceRequest.get_CLASS());
            __mapChildren.put("ServiceRegister", ServiceRegister.get_CLASS());
            __mapChildren.put("ServiceRegisterRequest", ServiceRegisterRequest.get_CLASS());
            __mapChildren.put("ServiceUpdateResponse", ServiceUpdateResponse.get_CLASS());
            __mapChildren.put("WitnessRequest", WitnessRequest.get_CLASS());
            __mapChildren.put("WrapperGuardable", WrapperGuardable.get_CLASS());
        }

        public ClusterService() {
            this(null, null, true);
        }

        public ClusterService(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAcceptingClients(false);
                this.setAcceptingOthers(true);
                this.setBroadcastRepeatMillis(256);
                this.setBroadcastTimeoutMillis(32768);
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setMessageClassMap(new HashMap());
                this.setNotifier(new SingleWaiterMultiNotifier());
                this.setOldestPendingRequestSUIDCounter(new AtomicLong());
                this.setResourceRegistry(new SimpleResourceRegistry());
                this.setSerializerMap(new WeakHashMap());
                this.setServiceId(0);
                this.setServiceName("Cluster");
                this.setSuspendPollLimit(new AtomicLong());
                this.setTimestampMaxVariance(10);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new DaemonPool("DaemonPool", this, true), "DaemonPool");
            this._addChild(new EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
            this._addChild(new Guard("Guard", this, true), "Guard");
            this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
            this._addChild(new PollArray("PollArray", this, true), "PollArray");
            this._addChild(new QuorumControl("QuorumControl", this, true), "QuorumControl");
            this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
            this._addChild(new ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
            this._addChild(new TcpRing("TcpRing", this, true), "TcpRing");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ClusterService();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        protected void ensureBroadcastDiscovery() {
            Cluster cluster = (Cluster)this.get_Module();
            NameServiceBridge nsClient = cluster.getNameServiceBridge();
            PacketListenerBT listenerBT = cluster.getTcpBroadcastListener();
            PacketListenerBU listenerBU = cluster.getUdpBroadcastListener();
            if (nsClient.isForeignBroadcastBound()) {
                if (this.getWellKnownAddresses() == null) {
                    listenerBU.joinGroup();
                    listenerBU.tryStart();
                }
            } else if (listenerBT.isStarted() || listenerBT.tryStart()) {
                if (nsClient.isRunning()) {
                    nsClient.shutdown();
                }
                if (this.getWellKnownAddresses() == null) {
                    listenerBU.joinGroup();
                }
                listenerBU.tryStart();
            } else if (nsClient.tryForeignBind() && this.getWellKnownAddresses() == null) {
                listenerBU.joinGroup();
                listenerBU.tryStart();
            }
        }

        @Override
        public boolean ensureDiscovery() {
            Cluster cluster = (Cluster)this.get_Module();
            NameService ns = cluster.getNameService();
            NameServiceBridge nsClient = cluster.getNameServiceBridge();
            PacketListenerBT listenerBT = cluster.getTcpBroadcastListener();
            if (listenerBT.isStarted() && ns.isStarted() || nsClient.isFullyBound()) {
                return true;
            }
            if (nsClient.isForeignBroadcastBound()) {
                if (!ns.isStarted()) {
                    ns.start();
                }
                if (nsClient.tryForeignBind()) {
                    return true;
                }
            } else {
                PacketListenerBU listenerBU = cluster.getUdpBroadcastListener();
                if (this.getServiceMemberSet().getOldestLocalMember() == this.getThisMember() && !listenerBT.isStarted() && !listenerBT.tryStart()) {
                    if (!ns.isStarted()) {
                        ns.start();
                    }
                    return nsClient.tryForeignBind();
                }
                if (listenerBT.isStarted() && (listenerBU.getUdpSocket().getDatagramSocketProvider().isSecure() || listenerBU.isStarted() || listenerBU.tryStart())) {
                    if (!ns.isStarted()) {
                        ns.start();
                    }
                    if (ns.tryClusterBind()) {
                        nsClient.shutdown();
                        return true;
                    }
                }
            }
            return false;
        }

        public void ensureMulticastDiscovery() {
            ServiceMemberSet setMembers = this.getServiceMemberSet();
            Member memberSenior = setMembers.getOldestMember();
            Member memberThis = this.getThisMember();
            PacketListenerBU listenerBU = ((Cluster)this.get_Module()).getUdpBroadcastListener();
            if (!listenerBU.isInGroup()) {
                if (memberThis != memberSenior) {
                    boolean fThisCollocated = memberThis.getMachineId() == memberSenior.getMachineId();
                    for (Member memberNext : setMembers) {
                        boolean fNextOlder;
                        if (memberNext == memberSenior || memberNext == memberThis) continue;
                        boolean fNextCollocated = memberNext.getMachineId() == memberSenior.getMachineId();
                        boolean bl = fNextOlder = setMembers.compareSeniority(memberNext, memberThis) < 0L;
                        if ((!fThisCollocated || fNextCollocated && !fNextOlder) && (fNextCollocated || !fNextOlder)) continue;
                        return;
                    }
                }
                listenerBU.joinGroup();
                if (!listenerBU.isStarted()) {
                    listenerBU.start();
                }
            }
        }

        @Override
        public String getMemberStatsDescription(Member member) {
            MessageHandler.Connection connection;
            EndPoint peer;
            ServiceMemberSet setMember;
            Object s = super.getMemberStatsDescription(member);
            TransportService svc = ((Cluster)this.get_Module()).getTransportService();
            if (svc.isStarted() && (setMember = svc.getServiceMemberSet()) != null && (peer = setMember.getServiceEndPoint(member.getId())) != null && (connection = (MessageHandler.Connection)svc.getMessageHandler().getConnectionMap().get(peer)) != null) {
                s = (String)s + ", " + String.valueOf(connection);
            }
            return s;
        }

        @Override
        public boolean isHeuristicallyDead(Member member) {
            long ldtTimeout;
            MessageHandler.Connection connection;
            EndPoint peer;
            TransportService svc;
            boolean fDead = super.isHeuristicallyDead(member);
            if (!fDead && (svc = ((Cluster)this.get_Module()).getTransportService()).isStarted() && (peer = svc.getServiceMemberSet().getServiceEndPoint(member.getId())) != null && (connection = (MessageHandler.Connection)svc.getMessageHandler().getConnectionMap().get(peer)) != null && (ldtTimeout = connection.getSuspectTimeoutTimestamp()) != 0L && Base.getSafeTimeMillis() > ldtTimeout - (long)(this.getDeliveryTimeoutMillis() - this.getHeuristicTimeoutMillis())) {
                return true;
            }
            return fDead;
        }

        @Override
        public boolean isRecentlyHeuristicallyDead(Member member) {
            MessageHandler.Connection connection;
            EndPoint peer;
            TransportService svc;
            boolean fDead = super.isRecentlyHeuristicallyDead(member);
            if (!fDead && (svc = ((Cluster)this.get_Module()).getTransportService()).isStarted() && (peer = svc.getServiceMemberSet().getServiceEndPoint(member.getId())) != null && (connection = (MessageHandler.Connection)svc.getMessageHandler().getConnectionMap().get(peer)) != null) {
                return connection.getLastHeuristicDeathTimestamp() >= Base.getSafeTimeMillis() - (long)this.getDeliveryTimeoutMillis();
            }
            return fDead;
        }

        @Override
        public void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    cluster.setStartException(e);
                }
                super.onException(e);
            }
            finally {
                if (cluster.getState() < 5) {
                    ClusterService._trace(this.get_Name() + ": stopping cluster.", 1);
                    cluster.stop();
                }
            }
        }

        @Override
        protected void onExit() {
            Cluster cluster = (Cluster)this.getCluster();
            cluster.getTcpBroadcastListener().stop();
            cluster.getUdpBroadcastListener().stop();
            cluster.getNameService().stop();
            cluster.getNameServiceBridge().stop();
            super.onExit();
        }

        @Override
        protected void onMemberLeft(Member member) {
            super.onMemberLeft(member);
            if (member != this.getThisMember()) {
                if (InetAddresses.isLocalAddress(member.getAddress())) {
                    this.ensureDiscovery();
                }
                if (this.getWellKnownAddresses() == null) {
                    this.ensureMulticastDiscovery();
                }
            }
        }

        @Override
        public void onStopRunning() {
            ClusterService._trace("Exiting cluster\n" + String.valueOf(((Cluster)this.get_Module()).getTransportService().getMessageHandler()) + "\n" + Threads.getThreadDump(), 2);
            super.onStopRunning();
        }

        @Override
        public void onTimerAnnouncing() {
            if (this.getBroadcastCounter() >= this.getBroadcastLimit() / 3) {
                this.ensureBroadcastDiscovery();
            }
            super.onTimerAnnouncing();
        }

        @Override
        public void onTimerRunning() {
            this.ensureDiscovery();
            super.onTimerRunning();
        }

        @Override
        public void resetBroadcastCounter(String sReason, DiscoveryMessage msg) {
            PacketListenerBU listenerBU;
            super.resetBroadcastCounter(sReason, msg);
            Cluster cluster = (Cluster)this.get_Module();
            if (cluster.getDependencies().getPublisherGroupThreshold() >= 100 && (listenerBU = cluster.getUdpBroadcastListener()).isInGroup()) {
                listenerBU.leaveGroup();
            }
        }

        @Override
        public synchronized void setState(int nState) {
            Coherence singleton;
            Coherence.Logger logger;
            super.setState(nState);
            if (nState == 2 && (logger = (singleton = (Coherence)Coherence.get_Instance()).getLogger()) != null && logger.getHashCode() == System.identityHashCode(singleton)) {
                int nType = 0;
                int cCpus = 0;
                Object[] aoLic = (Object[])this.get_Feed();
                int c = aoLic.length;
                for (int i = 0; i < c; ++i) {
                    nType = ((LicensedObject.LicenseData)aoLic[i]).nLicenseType;
                    cCpus += ((LicensedObject.LicenseData)aoLic[i]).cCpus;
                }
                logger.setHashCode((new Random().nextInt(77) + Math.max(0, Math.min(cCpus, 76)) * 77 + Math.max(0, nType) * 5929) * 777);
            }
        }

        @Override
        public void setStatsCpu(long cMillis) {
            super.setStatsCpu(cMillis);
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
        }

        static {
            ClusterService.__initStatic();
        }

        public static class Acknowledgement
        extends Grid.Acknowledgement {
            public Acknowledgement() {
                this(null, null, true);
            }

            public Acknowledgement(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Acknowledgement();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$Acknowledgement".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class BusEventMessage
        extends Grid.BusEventMessage {
            public BusEventMessage() {
                this(null, null, true);
            }

            public BusEventMessage(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-21);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BusEventMessage();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$BusEventMessage".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigRequest
        extends Grid.ConfigRequest {
            public ConfigRequest() {
                this(null, null, true);
            }

            public ConfigRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-15);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Grid.ConfigRequest.Poll("Poll", this, true), "Poll");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ConfigRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigResponse
        extends Grid.ConfigResponse {
            public ConfigResponse() {
                this(null, null, true);
            }

            public ConfigResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-16);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ConfigResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigSync
        extends Grid.ConfigSync {
            public ConfigSync() {
                this(null, null, true);
            }

            public ConfigSync(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-17);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigSync();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ConfigSync".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigUpdate
        extends Grid.ConfigUpdate {
            public ConfigUpdate() {
                this(null, null, true);
            }

            public ConfigUpdate(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-18);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigUpdate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ConfigUpdate".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class DispatchEvent
        extends Grid.DispatchEvent {
            public DispatchEvent() {
                this(null, null, true);
            }

            public DispatchEvent(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DispatchEvent();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DispatchEvent".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class DispatchNotification
        extends Grid.DispatchNotification {
            public DispatchNotification() {
                this(null, null, true);
            }

            public DispatchNotification(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DispatchNotification();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DispatchNotification".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberConfigUpdate
        extends Grid.MemberConfigUpdate {
            public MemberConfigUpdate() {
                this(null, null, true);
            }

            public MemberConfigUpdate(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-3);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberConfigUpdate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberConfigUpdate".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberHeartbeat
        extends ClusterService.MemberHeartbeat {
            public MemberHeartbeat() {
                this(null, null, true);
            }

            public MemberHeartbeat(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(33);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberHeartbeat();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberHeartbeat".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberJoined
        extends ClusterService.MemberJoined {
            public MemberJoined() {
                this(null, null, true);
            }

            public MemberJoined(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(4);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberJoined();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberJoined".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberLeaving
        extends ClusterService.MemberLeaving {
            public MemberLeaving() {
                this(null, null, true);
            }

            public MemberLeaving(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(35);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberLeaving();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberLeaving".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberLeft
        extends ClusterService.MemberLeft {
            public MemberLeft() {
                this(null, null, true);
            }

            public MemberLeft(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(36);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberLeft();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberLeft".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberWelcome
        extends Grid.MemberWelcome {
            public MemberWelcome() {
                this(null, null, true);
            }

            public MemberWelcome(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-2);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberWelcome();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberWelcome".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberWelcomeRequest
        extends Grid.MemberWelcomeRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public MemberWelcomeRequest() {
                this(null, null, true);
            }

            public MemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberWelcomeRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberWelcomeRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                MemberWelcomeRequest.__initStatic();
            }

            public static class Poll
            extends Grid.MemberWelcomeRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberWelcomeRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class MemberWelcomeRequestTask
        extends Grid.MemberWelcomeRequestTask {
            public MemberWelcomeRequestTask() {
                this(null, null, true);
            }

            public MemberWelcomeRequestTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberWelcomeRequestTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$MemberWelcomeRequestTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberAnnounce
        extends ClusterService.NewMemberAnnounce {
            public NewMemberAnnounce() {
                this(null, null, true);
            }

            public NewMemberAnnounce(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(7);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberAnnounce();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberAnnounce".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberAnnounceReply
        extends ClusterService.NewMemberAnnounceReply {
            public NewMemberAnnounceReply() {
                this(null, null, true);
            }

            public NewMemberAnnounceReply(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(8);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberAnnounceReply();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberAnnounceReply".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberAnnounceWait
        extends ClusterService.NewMemberAnnounceWait {
            public NewMemberAnnounceWait() {
                this(null, null, true);
            }

            public NewMemberAnnounceWait(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(9);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberAnnounceWait();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberAnnounceWait".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberInduct
        extends ClusterService.NewMemberInduct {
            public NewMemberInduct() {
                this(null, null, true);
            }

            public NewMemberInduct(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(6);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberInduct();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberInduct".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void onReceived() {
                super.onReceived();
                ClusterService svc = (ClusterService)this.get_Parent();
                if (svc.getWellKnownAddresses() == null) {
                    svc.ensureMulticastDiscovery();
                }
                svc.ensureDiscovery();
            }
        }

        public static class NewMemberRequestId
        extends ClusterService.NewMemberRequestId {
            public NewMemberRequestId() {
                this(null, null, true);
            }

            public NewMemberRequestId(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(10);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberRequestId();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberRequestId".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberRequestIdReject
        extends ClusterService.NewMemberRequestIdReject {
            public NewMemberRequestIdReject() {
                this(null, null, true);
            }

            public NewMemberRequestIdReject(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(11);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberRequestIdReject();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberRequestIdReject".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberRequestIdReply
        extends ClusterService.NewMemberRequestIdReply {
            public NewMemberRequestIdReply() {
                this(null, null, true);
            }

            public NewMemberRequestIdReply(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(12);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberRequestIdReply();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberRequestIdReply".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberRequestIdWait
        extends ClusterService.NewMemberRequestIdWait {
            public NewMemberRequestIdWait() {
                this(null, null, true);
            }

            public NewMemberRequestIdWait(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(13);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberRequestIdWait();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberRequestIdWait".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberTimestampRequest
        extends ClusterService.NewMemberTimestampRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public NewMemberTimestampRequest() {
                this(null, null, true);
            }

            public NewMemberTimestampRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(51);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberTimestampRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberTimestampRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                NewMemberTimestampRequest.__initStatic();
            }

            public static class Poll
            extends ClusterService.NewMemberTimestampRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberTimestampRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class NewMemberTimestampResponse
        extends ClusterService.NewMemberTimestampResponse {
            public NewMemberTimestampResponse() {
                this(null, null, true);
            }

            public NewMemberTimestampResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(52);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberTimestampResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberTimestampResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberWelcome
        extends ClusterService.NewMemberWelcome {
            public NewMemberWelcome() {
                this(null, null, true);
            }

            public NewMemberWelcome(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(37);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberWelcome();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberWelcome".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberWelcomeAnnounce
        extends ClusterService.NewMemberWelcomeAnnounce {
            public NewMemberWelcomeAnnounce() {
                this(null, null, true);
            }

            public NewMemberWelcomeAnnounce(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(38);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberWelcomeAnnounce();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberWelcomeAnnounce".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NewMemberWelcomeRequest
        extends ClusterService.NewMemberWelcomeRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public NewMemberWelcomeRequest() {
                this(null, null, true);
            }

            public NewMemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(39);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NewMemberWelcomeRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberWelcomeRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                NewMemberWelcomeRequest.__initStatic();
            }

            public static class Poll
            extends ClusterService.NewMemberWelcomeRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NewMemberWelcomeRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class NotifyConnectionClose
        extends Grid.NotifyConnectionClose {
            public NotifyConnectionClose() {
                this(null, null, true);
            }

            public NotifyConnectionClose(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-24);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyConnectionClose();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyConnectionClose".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyConnectionOpen
        extends Grid.NotifyConnectionOpen {
            public NotifyConnectionOpen() {
                this(null, null, true);
            }

            public NotifyConnectionOpen(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-23);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyConnectionOpen();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyConnectionOpen".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyIpTimeout
        extends ClusterService.NotifyIpTimeout {
            public NotifyIpTimeout() {
                this(null, null, true);
            }

            public NotifyIpTimeout(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(55);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyIpTimeout();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyIpTimeout".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMemberJoined
        extends Grid.NotifyMemberJoined {
            public NotifyMemberJoined() {
                this(null, null, true);
            }

            public NotifyMemberJoined(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-4);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMemberJoined();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyMemberJoined".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMemberLeaving
        extends Grid.NotifyMemberLeaving {
            public NotifyMemberLeaving() {
                this(null, null, true);
            }

            public NotifyMemberLeaving(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-5);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMemberLeaving();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyMemberLeaving".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMemberLeft
        extends ClusterService.NotifyMemberLeft {
            public NotifyMemberLeft() {
                this(null, null, true);
            }

            public NotifyMemberLeft(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-6);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMemberLeft();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyMemberLeft".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMessageReceipt
        extends Grid.NotifyMessageReceipt {
            public NotifyMessageReceipt() {
                this(null, null, true);
            }

            public NotifyMessageReceipt(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-7);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMessageReceipt();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyMessageReceipt".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyPollClosed
        extends Grid.NotifyPollClosed {
            public NotifyPollClosed() {
                this(null, null, true);
            }

            public NotifyPollClosed(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-8);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyPollClosed();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyPollClosed".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyResponse
        extends ClusterService.NotifyResponse {
            public NotifyResponse() {
                this(null, null, true);
            }

            public NotifyResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-20);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceAnnounced
        extends Grid.NotifyServiceAnnounced {
            public NotifyServiceAnnounced() {
                this(null, null, true);
            }

            public NotifyServiceAnnounced(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-9);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceAnnounced();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyServiceAnnounced".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceJoining
        extends Grid.NotifyServiceJoining {
            public NotifyServiceJoining() {
                this(null, null, true);
            }

            public NotifyServiceJoining(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-10);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Grid.NotifyServiceJoining.Poll("Poll", this, true), "Poll");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceJoining();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyServiceJoining".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceLeaving
        extends Grid.NotifyServiceLeaving {
            public NotifyServiceLeaving() {
                this(null, null, true);
            }

            public NotifyServiceLeaving(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-11);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceLeaving();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyServiceLeaving".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceLeft
        extends Grid.NotifyServiceLeft {
            public NotifyServiceLeft() {
                this(null, null, true);
            }

            public NotifyServiceLeft(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-12);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceLeft();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyServiceLeft".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceQuiescence
        extends Grid.NotifyServiceQuiescence {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public NotifyServiceQuiescence() {
                this(null, null, true);
            }

            public NotifyServiceQuiescence(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-22);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceQuiescence();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyServiceQuiescence".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                NotifyServiceQuiescence.__initStatic();
            }

            public static class Poll
            extends Grid.NotifyServiceQuiescence.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyServiceQuiescence$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class NotifyShutdown
        extends ClusterService.NotifyShutdown {
            public NotifyShutdown() {
                this(null, null, true);
            }

            public NotifyShutdown(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-13);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyShutdown();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyShutdown".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyStartup
        extends Grid.NotifyStartup {
            public NotifyStartup() {
                this(null, null, true);
            }

            public NotifyStartup(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-14);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyStartup();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyStartup".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyTcmpTimeout
        extends ClusterService.NotifyTcmpTimeout {
            public NotifyTcmpTimeout() {
                this(null, null, true);
            }

            public NotifyTcmpTimeout(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(54);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyTcmpTimeout();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$NotifyTcmpTimeout".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class PingRequest
        extends Grid.PingRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public PingRequest() {
                this(null, null, true);
            }

            public PingRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(3);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PingRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$PingRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                PingRequest.__initStatic();
            }

            public static class Poll
            extends Grid.PingRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$PingRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ProtocolContext
        extends Grid.ProtocolContext {
            public ProtocolContext() {
                this(null, null, true);
            }

            public ProtocolContext(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ProtocolContext();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ProtocolContext".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class QuorumRollCall
        extends ClusterService.QuorumRollCall {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public QuorumRollCall() {
                this(null, null, true);
            }

            public QuorumRollCall(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(53);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new QuorumRollCall();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$QuorumRollCall".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                QuorumRollCall.__initStatic();
            }

            public static class Poll
            extends ClusterService.QuorumRollCall.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$QuorumRollCall$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class Response
        extends Grid.Response {
            public Response() {
                this(null, null, true);
            }

            public Response(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(2);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Response();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$Response".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class SeniorMemberHeartbeat
        extends ClusterService.SeniorMemberHeartbeat {
            public SeniorMemberHeartbeat() {
                this(null, null, true);
            }

            public SeniorMemberHeartbeat(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(17);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new SeniorMemberHeartbeat();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$SeniorMemberHeartbeat".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class SeniorMemberKill
        extends ClusterService.SeniorMemberKill {
            public SeniorMemberKill() {
                this(null, null, true);
            }

            public SeniorMemberKill(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(40);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new SeniorMemberKill();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$SeniorMemberKill".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class SeniorMemberPanic
        extends ClusterService.SeniorMemberPanic {
            public SeniorMemberPanic() {
                this(null, null, true);
            }

            public SeniorMemberPanic(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(41);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new SeniorMemberPanic();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$SeniorMemberPanic".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ServiceJoined
        extends ClusterService.ServiceJoined {
            public ServiceJoined() {
                this(null, null, true);
            }

            public ServiceJoined(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(49);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceJoined();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceJoined".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ServiceJoining
        extends ClusterService.ServiceJoining {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public ServiceJoining() {
                this(null, null, true);
            }

            public ServiceJoining(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(43);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceJoining();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceJoining".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ServiceJoining.__initStatic();
            }

            public static class Poll
            extends ClusterService.ServiceJoining.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceJoining$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ServiceJoinRequest
        extends ClusterService.ServiceJoinRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public ServiceJoinRequest() {
                this(null, null, true);
            }

            public ServiceJoinRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(42);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceJoinRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceJoinRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ServiceJoinRequest.__initStatic();
            }

            public static class Poll
            extends ClusterService.ServiceJoinRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceJoinRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ServiceLeaving
        extends ClusterService.ServiceLeaving {
            public ServiceLeaving() {
                this(null, null, true);
            }

            public ServiceLeaving(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(44);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceLeaving();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceLeaving".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ServiceLeft
        extends ClusterService.ServiceLeft {
            public ServiceLeft() {
                this(null, null, true);
            }

            public ServiceLeft(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(45);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceLeft();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceLeft".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ServiceQuiescenceRequest
        extends ClusterService.ServiceQuiescenceRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public ServiceQuiescenceRequest() {
                this(null, null, true);
            }

            public ServiceQuiescenceRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(57);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceQuiescenceRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceQuiescenceRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ServiceQuiescenceRequest.__initStatic();
            }

            public static class Poll
            extends ClusterService.ServiceQuiescenceRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceQuiescenceRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ServiceRegister
        extends ClusterService.ServiceRegister {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public ServiceRegister() {
                this(null, null, true);
            }

            public ServiceRegister(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(46);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceRegister();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceRegister".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ServiceRegister.__initStatic();
            }

            public static class Poll
            extends ClusterService.ServiceRegister.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceRegister$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ServiceRegisterRequest
        extends ClusterService.ServiceRegisterRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public ServiceRegisterRequest() {
                this(null, null, true);
            }

            public ServiceRegisterRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(47);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceRegisterRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceRegisterRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ServiceRegisterRequest.__initStatic();
            }

            public static class Poll
            extends ClusterService.ServiceRegisterRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceRegisterRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ServiceUpdateResponse
        extends ClusterService.ServiceUpdateResponse {
            public ServiceUpdateResponse() {
                this(null, null, true);
            }

            public ServiceUpdateResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(48);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceUpdateResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceUpdateResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class WitnessRequest
        extends ClusterService.WitnessRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public WitnessRequest() {
                this(null, null, true);
            }

            public WitnessRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(56);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WitnessRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$WitnessRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                WitnessRequest.__initStatic();
            }

            public static class Poll
            extends ClusterService.WitnessRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$WitnessRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class WrapperGuardable
        extends Grid.WrapperGuardable {
            public WrapperGuardable() {
                this(null, null, true);
            }

            public WrapperGuardable(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WrapperGuardable();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$WrapperGuardable".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class DaemonPool
        extends Grid.DaemonPool {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Daemon", Daemon.get_CLASS());
                __mapChildren.put("ResizeTask", ResizeTask.get_CLASS());
                __mapChildren.put("ScheduleTask", ScheduleTask.get_CLASS());
                __mapChildren.put("StartTask", StartTask.get_CLASS());
                __mapChildren.put("StopTask", StopTask.get_CLASS());
                __mapChildren.put("WorkSlot", WorkSlot.get_CLASS());
                __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
            }

            public DaemonPool() {
                this(null, null, true);
            }

            public DaemonPool(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setAbandonThreshold(8);
                    this.setDaemonCountMax(Integer.MAX_VALUE);
                    this.setDaemonCountMin(1);
                    this.setScheduledTasks(new HashSet());
                    this.setStatsTaskAddCount(new AtomicLong());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DaemonPool();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                DaemonPool.__initStatic();
            }

            public static class Daemon
            extends Grid.DaemonPool.Daemon {
                public Daemon() {
                    this(null, null, true);
                }

                public Daemon(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setDaemonState(0);
                        this.setDefaultGuardRecovery(0.9f);
                        this.setDefaultGuardTimeout(60000L);
                        this.setNotifier(new SingleWaiterMultiNotifier());
                        this.setThreadName("Worker");
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this._addChild(new Guard("Guard", this, true), "Guard");
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Daemon();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$Daemon".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                public static class Guard
                extends Service.DaemonPool.Daemon.Guard {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Abandon", Abandon.get_CLASS());
                    }

                    public Guard() {
                        this(null, null, true);
                    }

                    public Guard(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Guard();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$Daemon$Guard".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        Guard.__initStatic();
                    }

                    public static class Abandon
                    extends Service.DaemonPool.Daemon.Guard.Abandon {
                        public Abandon() {
                            this(null, null, true);
                        }

                        public Abandon(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Abandon();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$Daemon$Guard$Abandon".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }
            }

            public static class ResizeTask
            extends Service.DaemonPool.ResizeTask {
                public ResizeTask() {
                    this(null, null, true);
                }

                public ResizeTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new ResizeTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$ResizeTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class ScheduleTask
            extends Service.DaemonPool.ScheduleTask {
                public ScheduleTask() {
                    this(null, null, true);
                }

                public ScheduleTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new ScheduleTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$ScheduleTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class StartTask
            extends Service.DaemonPool.StartTask {
                public StartTask() {
                    this(null, null, true);
                }

                public StartTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StartTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$StartTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class StopTask
            extends Service.DaemonPool.StopTask {
                public StopTask() {
                    this(null, null, true);
                }

                public StopTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StopTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$StopTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class WorkSlot
            extends Service.DaemonPool.WorkSlot {
                public WorkSlot() {
                    this(null, null, true);
                }

                public WorkSlot(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setIndex(-1);
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new WorkSlot();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$WorkSlot".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class WrapperTask
            extends Service.DaemonPool.WrapperTask {
                public WrapperTask() {
                    this(null, null, true);
                }

                public WrapperTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new WrapperTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$DaemonPool$WrapperTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class EventDispatcher
        extends Grid.EventDispatcher {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Queue", Queue.get_CLASS());
            }

            public EventDispatcher() {
                this(null, null, true);
            }

            public EventDispatcher(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setCloggedCount(1024);
                    this.setCloggedDelay(32);
                    this.setDaemonState(0);
                    this.setDefaultGuardRecovery(0.9f);
                    this.setDefaultGuardTimeout(60000L);
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Service.EventDispatcher.Guard("Guard", this, true), "Guard");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EventDispatcher();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$EventDispatcher".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                EventDispatcher.__initStatic();
            }

            public static class Queue
            extends Service.EventDispatcher.Queue {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public Queue() {
                    this(null, null, true);
                }

                public Queue(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setElementList(new RecyclingLinkedList());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Queue();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$EventDispatcher$Queue".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Queue.__initStatic();
                }

                public static class Iterator
                extends Service.EventDispatcher.Queue.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$EventDispatcher$Queue$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }

        public static class Guard
        extends Grid.Guard {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("StopService", StopService.get_CLASS());
            }

            public Guard() {
                this(null, null, true);
            }

            public Guard(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Guard();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$Guard".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public void recover() {
            }

            static {
                Guard.__initStatic();
            }

            public static class StopService
            extends Grid.Guard.StopService {
                public StopService() {
                    this(null, null, true);
                }

                public StopService(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StopService();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$Guard$StopService".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class PollArray
        extends Grid.PollArray {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("PlaceHolder", PlaceHolder.get_CLASS());
            }

            public PollArray() {
                this(null, null, true);
            }

            public PollArray(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setExpiryMap(new NullableSortedMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PollArray();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$PollArray".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                PollArray.__initStatic();
            }

            public static class PlaceHolder
            extends Grid.PollArray.PlaceHolder {
                public PlaceHolder() {
                    this(null, null, true);
                }

                public PlaceHolder(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setVirtualOffset(-1L);
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new PlaceHolder();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$PollArray$PlaceHolder".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class QuorumControl
        extends ClusterService.QuorumControl {
            public QuorumControl() {
                this(null, null, true);
            }

            public QuorumControl(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new QuorumControl();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$QuorumControl".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void setMoratoriumTimeMillis(long cMoratoriumMillis) {
                super.setMoratoriumTimeMillis(cMoratoriumMillis);
            }

            @Override
            public void setSuicide(boolean fSuicide) {
                super.setSuicide(fSuicide);
            }
        }

        public static class ServiceConfig
        extends Grid.ServiceConfig {
            public ServiceConfig() {
                this(null, null, true);
            }

            public ServiceConfig(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setPendingConfigUpdates(new LinkedList());
                    this.setPendingPolls(new LiteMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new ServiceConfig.ConfigListener("ConfigListener", this, true), "ConfigListener");
                this._addChild(new Map("Map", this, true), "Map");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceConfig();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public static class Map
            extends Grid.ServiceConfig.Map {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("EntrySet", EntrySet.get_CLASS());
                    __mapChildren.put("KeySet", KeySet.get_CLASS());
                    __mapChildren.put("Values", Values.get_CLASS());
                }

                public Map() {
                    this(null, null, true);
                }

                public Map(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Map();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Map.__initStatic();
                }

                public static class EntrySet
                extends Grid.ServiceConfig.Map.EntrySet {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Entry", Entry.get_CLASS());
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public EntrySet() {
                        this(null, null, true);
                    }

                    public EntrySet(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new EntrySet();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$EntrySet".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected java.util.Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        EntrySet.__initStatic();
                    }

                    public static class Entry
                    extends Grid.ServiceConfig.Map.EntrySet.Entry {
                        public Entry() {
                            this(null, null, true);
                        }

                        public Entry(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Entry();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$EntrySet$Entry".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }

                    public static class Iterator
                    extends Grid.ServiceConfig.Map.EntrySet.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$EntrySet$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class KeySet
                extends Grid.ServiceConfig.Map.KeySet {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public KeySet() {
                        this(null, null, true);
                    }

                    public KeySet(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new KeySet();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$KeySet".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected java.util.Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        KeySet.__initStatic();
                    }

                    public static class Iterator
                    extends Grid.ServiceConfig.Map.KeySet.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$KeySet$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class Values
                extends Grid.ServiceConfig.Map.Values {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public Values() {
                        this(null, null, true);
                    }

                    public Values(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Values();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$Values".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected java.util.Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        Values.__initStatic();
                    }

                    public static class Iterator
                    extends Grid.ServiceConfig.Map.Values.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$ServiceConfig$Map$Values$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }
            }
        }

        public static class TcpRing
        extends ClusterService.TcpRing {
            public TcpRing() {
                this(null, null, true);
            }

            public TcpRing(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBuddies(new HashMap());
                    this.setEnabled(true);
                    this.setSocketOptions(new SocketOptions());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new TcpRing.MemberMonitor("MemberMonitor", this, true), "MemberMonitor");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new TcpRing();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ClusterService$TcpRing".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onException(Exception e) {
                ((Cluster)this.get_Module()).onException(e);
            }
        }
    }

    public static class IpMonitor
    extends com.tangosol.coherence.component.util.daemon.IpMonitor {
        public IpMonitor() {
            this(null, null, true);
        }

        public IpMonitor(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new IpMonitor();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$IpMonitor".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        public static class Guard
        extends IpMonitor.Guard {
            public Guard() {
                this(null, null, true);
            }

            public Guard(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this._addChild(new StopIpMonitor("StopIpMonitor", this, true), "StopIpMonitor");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Guard();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$IpMonitor$Guard".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void terminate() {
                super.terminate();
                Daemon.sleep(3000L);
                IpMonitor daemon = (IpMonitor)this.get_Parent();
                if (daemon.getDaemonState() != 4) {
                    Guard._trace("Failed to terminate IpMonitor. IpMonitor state: " + daemon.getDaemonState(), 1);
                    daemon.getService().getServiceFailurePolicy().onServiceFailed((Cluster)this.get_Module());
                }
            }

            public static class StopIpMonitor
            extends IpMonitor.Guard.StopIpMonitor {
                public StopIpMonitor() {
                    this(null, null, true);
                }

                public StopIpMonitor(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StopIpMonitor();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$IpMonitor$Guard$StopIpMonitor".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class NameService
    extends com.tangosol.coherence.component.util.NameService
    implements ConnectionFilter {
        private ServerSocket __m_ClusterSocket;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("RequestContext", RequestContext.get_CLASS());
        }

        public NameService() {
            this(null, null, true);
        }

        public NameService(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBinderMap(new ConcurrentHashMap());
                this.setDirectory(new ConcurrentHashMap());
                this.setLookupCallbacks(new SafeLinkedList());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new TcpAcceptor("TcpAcceptor", this, true), "TcpAcceptor");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NameService();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void checkConnection(Connection connection) throws ConnectionException {
            if (connection instanceof com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection) {
                com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection connectionImpl = (com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection)connection;
                String sService = connectionImpl.getServiceName();
                if (sService != null && !sService.equals(this.getServiceName())) {
                    throw new ConnectionException("connection rejected, service mismatch");
                }
                String sCluster = connectionImpl.getClusterName();
                if (sCluster != null && !sCluster.equals(this.getCluster().getClusterName())) {
                    try {
                        Integer nPort = (Integer)this.lookup("Cluster/foreign/" + sCluster + "/NameService/localPort");
                        if (nPort != null) {
                            Object[] addrRedirect = new Object[]{connectionImpl.getSocket().getLocalAddress().getHostAddress(), MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_NAME_SERVICE.getPort(nPort)};
                            connectionImpl.setRedirect(true);
                            connectionImpl.setRedirectList(Collections.singletonList(addrRedirect));
                        }
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                    throw new ConnectionException("connection rejected, cluster mismatch");
                }
            }
        }

        public ServerSocket getClusterSocket() {
            return this.__m_ClusterSocket;
        }

        public void halt() {
            try {
                TcpUtil.close(this.getClusterSocket());
                TcpUtil.close(this.getAcceptor().getProcessor().getServerSocket());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean isStarted() {
            return this.getAcceptor().isStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDatagramLookup(DatagramSocket socketIn, SocketAddress addrSrc, ByteBuffer buffer) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                ClusterService service = cluster.getClusterService();
                ByteBuffer bufClusterName = cluster.getClusterNameBuffer();
                int nPos = buffer.position();
                int nLim = buffer.limit();
                int cbRequest = buffer.remaining();
                DataInputStream in = new DataInputStream(new ByteBufferInputStream(buffer));
                in.readInt();
                String sClusterName = in.readUTF();
                if (sClusterName.isEmpty() || sClusterName.equals(cluster.getClusterName())) {
                    int cAttempt = in.readUnsignedByte();
                    int cLimit = in.readUnsignedByte();
                    int cbAddr = in.readUnsignedByte();
                    if (!(cbAddr != 0 && cbAddr != 4 && cbAddr != 16 || !service.isAcceptingClients() || cAttempt == 0 || service.getClusterOldestMember() != service.getThisMember() && cAttempt < Math.min(3, cLimit / 3))) {
                        int nPort;
                        InetAddress addr;
                        if (cbAddr == 0) {
                            in.readInt();
                            InetSocketAddress addrSrcInet = (InetSocketAddress)addrSrc;
                            addr = addrSrcInet.getAddress();
                            nPort = addrSrcInet.getPort();
                        } else {
                            byte[] abAddr = new byte[cbAddr];
                            in.readFully(abAddr);
                            addr = InetAddress.getByAddress(abAddr);
                            nPort = in.readInt();
                        }
                        String sKey = in.readUTF();
                        Binary binMember = new Binary(in);
                        Member memberClient = binMember.length() == 0 ? null : (Member)ExternalizableHelper.fromBinary(binMember, this.getSerializer());
                        InetSocketAddress addrThis = service.getThisMember().getSocketAddress();
                        RequestContext context = new RequestContext();
                        context.setMember(memberClient);
                        context.setAcceptAddress(addrThis.getAddress());
                        context.setSourceAddress(addr);
                        Object oResult = this.lookup(sKey, context);
                        Binary binResult = oResult == null ? null : ExternalizableHelper.toBinary(oResult, this.getSerializer());
                        byte[] abAddrThis = addrThis.getAddress().getAddress();
                        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(cbRequest + (binResult == null ? 0 : binResult.length()));
                        DataOutputStream out = new DataOutputStream(outBytes);
                        out.writeInt(232718554);
                        out.write(bufClusterName.array());
                        out.write(0);
                        out.write(0);
                        out.write(abAddrThis.length);
                        out.write(abAddrThis);
                        out.writeInt(addrThis.getPort());
                        out.writeUTF(sKey);
                        if (binResult == null) {
                            out.writeInt(0);
                        } else if (binResult.length() > 1024) {
                            out.writeInt(-1);
                        } else {
                            binResult.writeExternal(out);
                        }
                        out.flush();
                        byte[] abReply = outBytes.toByteArray();
                        socketIn.send(new DatagramPacket(abReply, abReply.length, addr, nPort));
                    }
                } else {
                    buffer.position(nPos).limit(nLim);
                    cluster.onForeignPacket(socketIn, addrSrc, buffer);
                    buffer = null;
                }
            }
            catch (Exception e) {
                NameService._trace("Failure while parsing NS datagram lookup request, dropping request " + String.valueOf(e), 3);
                NameService._trace(e);
            }
            finally {
                if (buffer != null) {
                    cluster.getReceiver().getBufferManager().release(buffer);
                }
            }
        }

        @Override
        public void onInit() {
            super.onInit();
            this.addLookupCallback((Cluster)this.get_Module());
            this.addLookupCallback(new ProxyService.LookupCallback());
            this.addLookupCallback(new Connector.LookupCallback());
            ((TcpAcceptor)this._findChild("TcpAcceptor")).setConnectionFilter(this);
        }

        public void setClusterSocket(ServerSocket socketCluster) {
            this.__m_ClusterSocket = socketCluster;
        }

        public boolean tryClusterBind() {
            ServerSocketChannel channel = null;
            try {
                TcpAcceptor acceptor = (TcpAcceptor)this.getAcceptor();
                SocketProvider provider = acceptor.getSocketProvider();
                channel = provider.openServerSocketChannel();
                channel.configureBlocking(false);
                ServerSocket socket = channel.socket();
                acceptor.getSocketOptions().apply(socket);
                socket.bind(new InetSocketAddress32(this.getLocalAddress(), MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_NAME_SERVICE.getPort(((Cluster)this.get_Module()).getDependencies().getGroupPort())));
                channel.register(acceptor.getProcessor().getSelector(), 16);
                NameService._trace("NameService now listening for connections on " + provider.getAddressString(socket), 3);
                this.setClusterSocket(socket);
                return true;
            }
            catch (IOException e) {
                TcpUtil.close(channel);
                return false;
            }
        }

        static {
            NameService.__initStatic();
        }

        public static class RequestContext
        extends NameService.RequestContext {
            public RequestContext() {
                this(null, null, true);
            }

            public RequestContext(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new RequestContext();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$RequestContext".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class TcpAcceptor
        extends NameService.TcpAcceptor {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("BufferPool", BufferPool.get_CLASS());
                __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
                __mapChildren.put("MessageBuffer", MessageBuffer.get_CLASS());
                __mapChildren.put("MessageFactory", MessageFactory.get_CLASS());
                __mapChildren.put("Queue", Queue.get_CLASS());
                __mapChildren.put("TcpConnection", TcpConnection.get_CLASS());
            }

            public TcpAcceptor() {
                this(null, null, true);
            }

            public TcpAcceptor(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setConnectionPendingSet(new SafeHashSet());
                    this.setConnectionSet(new SafeHashSet());
                    this.setDaemonState(0);
                    this.setDefaultGuardRecovery(0.9f);
                    this.setDefaultGuardTimeout(60000L);
                    this.setDefaultLimitBytes(100000000L);
                    this.setDefaultLimitLength(60000);
                    this.setDefaultNominalBytes(2000000L);
                    this.setDefaultNominalLength(2000);
                    this.setDefaultSuspectBytes(10000000L);
                    this.setDefaultSuspectLength(10000);
                    this.setNotifier(new SingleWaiterMultiNotifier());
                    this.setProtocolMap(new HashMap());
                    this.setReceiverMap(new HashMap());
                    this.setRequestTimeout(30000L);
                    this.setSerializerMap(new WeakHashMap());
                    this.setSocketOptions(new SocketOptions());
                    this.setSuspectProtocolEnabled(true);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new DaemonPool("DaemonPool", this, true), "DaemonPool");
                this._addChild(new EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
                this._addChild(new Guard("Guard", this, true), "Guard");
                this._addChild(new Protocol("Protocol", this, true), "Protocol");
                this._addChild(new TcpProcessor("TcpProcessor", this, true), "TcpProcessor");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new TcpAcceptor();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected void bind(ServerSocket socket, SocketAddress addr, int nBacklog) throws IOException {
                InetSocketAddress32 addr32 = (InetSocketAddress32)addr;
                int nPort = addr32.getPort();
                if (MultiplexedSocketProvider.getBasePort(nPort) == 0) {
                    addr = new InetSocketAddress32(addr32.getAddress(), MultiplexedSocketProvider.getPort(((Cluster)this.get_Module()).getSocketManager().getAcceptorChannel().getPort(), MultiplexedSocketProvider.getSubPort(nPort)));
                }
                super.bind(socket, addr, nBacklog);
            }

            static {
                TcpAcceptor.__initStatic();
            }

            public static class BufferPool
            extends NameService.TcpAcceptor.BufferPool {
                public BufferPool() {
                    this(null, null, true);
                }

                public BufferPool(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setBufferSize(2048);
                        this.setBufferType(0);
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new BufferPool();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$BufferPool".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class DispatchEvent
            extends NameService.TcpAcceptor.DispatchEvent {
                public DispatchEvent() {
                    this(null, null, true);
                }

                public DispatchEvent(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new DispatchEvent();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DispatchEvent".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class MessageBuffer
            extends NameService.TcpAcceptor.MessageBuffer {
                public MessageBuffer() {
                    this(null, null, true);
                }

                public MessageBuffer(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new MessageBuffer();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageBuffer".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class MessageFactory
            extends NameService.TcpAcceptor.MessageFactory {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("AcceptChannel", AcceptChannel.get_CLASS());
                    __mapChildren.put("AcceptChannelRequest", AcceptChannelRequest.get_CLASS());
                    __mapChildren.put("AcceptChannelResponse", AcceptChannelResponse.get_CLASS());
                    __mapChildren.put("CloseChannel", CloseChannel.get_CLASS());
                    __mapChildren.put("CloseConnection", CloseConnection.get_CLASS());
                    __mapChildren.put("CreateChannel", CreateChannel.get_CLASS());
                    __mapChildren.put("EncodedMessage", EncodedMessage.get_CLASS());
                    __mapChildren.put("NotifyChannelClosed", NotifyChannelClosed.get_CLASS());
                    __mapChildren.put("NotifyConnectionClosed", NotifyConnectionClosed.get_CLASS());
                    __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
                    __mapChildren.put("NotifyStartup", NotifyStartup.get_CLASS());
                    __mapChildren.put("OpenChannel", OpenChannel.get_CLASS());
                    __mapChildren.put("OpenChannelRequest", OpenChannelRequest.get_CLASS());
                    __mapChildren.put("OpenChannelResponse", OpenChannelResponse.get_CLASS());
                    __mapChildren.put("OpenConnection", OpenConnection.get_CLASS());
                    __mapChildren.put("OpenConnectionRequest", OpenConnectionRequest.get_CLASS());
                    __mapChildren.put("OpenConnectionResponse", OpenConnectionResponse.get_CLASS());
                    __mapChildren.put("PingRequest", PingRequest.get_CLASS());
                    __mapChildren.put("PingResponse", PingResponse.get_CLASS());
                    __mapChildren.put("Response", Response.get_CLASS());
                }

                public MessageFactory() {
                    this(null, null, true);
                }

                public MessageFactory(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new MessageFactory();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    MessageFactory.__initStatic();
                }

                public static class AcceptChannel
                extends NameService.TcpAcceptor.MessageFactory.AcceptChannel {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public AcceptChannel() {
                        this(null, null, true);
                    }

                    public AcceptChannel(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new AcceptChannel();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$AcceptChannel".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        AcceptChannel.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.AcceptChannel.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$AcceptChannel$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class AcceptChannelRequest
                extends NameService.TcpAcceptor.MessageFactory.AcceptChannelRequest {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public AcceptChannelRequest() {
                        this(null, null, true);
                    }

                    public AcceptChannelRequest(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new AcceptChannelRequest();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$AcceptChannelRequest".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        AcceptChannelRequest.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.AcceptChannelRequest.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$AcceptChannelRequest$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class AcceptChannelResponse
                extends NameService.TcpAcceptor.MessageFactory.AcceptChannelResponse {
                    public AcceptChannelResponse() {
                        this(null, null, true);
                    }

                    public AcceptChannelResponse(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new AcceptChannelResponse();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$AcceptChannelResponse".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class CloseChannel
                extends NameService.TcpAcceptor.MessageFactory.CloseChannel {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public CloseChannel() {
                        this(null, null, true);
                    }

                    public CloseChannel(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new CloseChannel();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$CloseChannel".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        CloseChannel.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.CloseChannel.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$CloseChannel$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class CloseConnection
                extends NameService.TcpAcceptor.MessageFactory.CloseConnection {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public CloseConnection() {
                        this(null, null, true);
                    }

                    public CloseConnection(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new CloseConnection();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$CloseConnection".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        CloseConnection.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.CloseConnection.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$CloseConnection$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class CreateChannel
                extends NameService.TcpAcceptor.MessageFactory.CreateChannel {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public CreateChannel() {
                        this(null, null, true);
                    }

                    public CreateChannel(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new CreateChannel();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$CreateChannel".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        CreateChannel.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.CreateChannel.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$CreateChannel$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class EncodedMessage
                extends NameService.TcpAcceptor.MessageFactory.EncodedMessage {
                    public EncodedMessage() {
                        this(null, null, true);
                    }

                    public EncodedMessage(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new EncodedMessage();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$EncodedMessage".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class NotifyChannelClosed
                extends NameService.TcpAcceptor.MessageFactory.NotifyChannelClosed {
                    public NotifyChannelClosed() {
                        this(null, null, true);
                    }

                    public NotifyChannelClosed(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new NotifyChannelClosed();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$NotifyChannelClosed".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class NotifyConnectionClosed
                extends NameService.TcpAcceptor.MessageFactory.NotifyConnectionClosed {
                    public NotifyConnectionClosed() {
                        this(null, null, true);
                    }

                    public NotifyConnectionClosed(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new NotifyConnectionClosed();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$NotifyConnectionClosed".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class NotifyShutdown
                extends NameService.TcpAcceptor.MessageFactory.NotifyShutdown {
                    public NotifyShutdown() {
                        this(null, null, true);
                    }

                    public NotifyShutdown(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new NotifyShutdown();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$NotifyShutdown".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class NotifyStartup
                extends NameService.TcpAcceptor.MessageFactory.NotifyStartup {
                    public NotifyStartup() {
                        this(null, null, true);
                    }

                    public NotifyStartup(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new NotifyStartup();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$NotifyStartup".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class OpenChannel
                extends NameService.TcpAcceptor.MessageFactory.OpenChannel {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public OpenChannel() {
                        this(null, null, true);
                    }

                    public OpenChannel(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new OpenChannel();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenChannel".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        OpenChannel.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.OpenChannel.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenChannel$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class OpenChannelRequest
                extends NameService.TcpAcceptor.MessageFactory.OpenChannelRequest {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public OpenChannelRequest() {
                        this(null, null, true);
                    }

                    public OpenChannelRequest(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new OpenChannelRequest();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenChannelRequest".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        OpenChannelRequest.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.OpenChannelRequest.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenChannelRequest$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class OpenChannelResponse
                extends NameService.TcpAcceptor.MessageFactory.OpenChannelResponse {
                    public OpenChannelResponse() {
                        this(null, null, true);
                    }

                    public OpenChannelResponse(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new OpenChannelResponse();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenChannelResponse".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class OpenConnection
                extends NameService.TcpAcceptor.MessageFactory.OpenConnection {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public OpenConnection() {
                        this(null, null, true);
                    }

                    public OpenConnection(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new OpenConnection();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenConnection".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        OpenConnection.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.OpenConnection.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenConnection$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class OpenConnectionRequest
                extends NameService.TcpAcceptor.MessageFactory.OpenConnectionRequest {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public OpenConnectionRequest() {
                        this(null, null, true);
                    }

                    public OpenConnectionRequest(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new OpenConnectionRequest();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenConnectionRequest".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        OpenConnectionRequest.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.OpenConnectionRequest.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenConnectionRequest$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class OpenConnectionResponse
                extends NameService.TcpAcceptor.MessageFactory.OpenConnectionResponse {
                    public OpenConnectionResponse() {
                        this(null, null, true);
                    }

                    public OpenConnectionResponse(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new OpenConnectionResponse();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$OpenConnectionResponse".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class PingRequest
                extends NameService.TcpAcceptor.MessageFactory.PingRequest {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Status", Status.get_CLASS());
                    }

                    public PingRequest() {
                        this(null, null, true);
                    }

                    public PingRequest(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new PingRequest();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$PingRequest".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        PingRequest.__initStatic();
                    }

                    public static class Status
                    extends NameService.TcpAcceptor.MessageFactory.PingRequest.Status {
                        public Status() {
                            this(null, null, true);
                        }

                        public Status(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Status();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$PingRequest$Status".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class PingResponse
                extends NameService.TcpAcceptor.MessageFactory.PingResponse {
                    public PingResponse() {
                        this(null, null, true);
                    }

                    public PingResponse(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new PingResponse();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$PingResponse".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class Response
                extends NameService.TcpAcceptor.MessageFactory.Response {
                    public Response() {
                        this(null, null, true);
                    }

                    public Response(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Response();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$MessageFactory$Response".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class Queue
            extends NameService.TcpAcceptor.Queue {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public Queue() {
                    this(null, null, true);
                }

                public Queue(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setElementList(new RecyclingLinkedList());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Queue();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$Queue".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Queue.__initStatic();
                }

                public static class Iterator
                extends NameService.TcpAcceptor.Queue.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$Queue$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class TcpConnection
            extends NameService.TcpAcceptor.TcpConnection {
                public TcpConnection() {
                    this(null, null, true);
                }

                public TcpConnection(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setChannelArray(new SparseArray());
                        this.setChannelPendingArray(new SparseArray());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new TcpConnection();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$TcpConnection".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class DaemonPool
            extends NameService.TcpAcceptor.DaemonPool {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Daemon", Daemon.get_CLASS());
                    __mapChildren.put("ResizeTask", ResizeTask.get_CLASS());
                    __mapChildren.put("ScheduleTask", ScheduleTask.get_CLASS());
                    __mapChildren.put("StartTask", StartTask.get_CLASS());
                    __mapChildren.put("StopTask", StopTask.get_CLASS());
                    __mapChildren.put("WorkSlot", WorkSlot.get_CLASS());
                    __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
                }

                public DaemonPool() {
                    this(null, null, true);
                }

                public DaemonPool(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setAbandonThreshold(8);
                        this.setDaemonCountMax(Integer.MAX_VALUE);
                        this.setDaemonCountMin(1);
                        this.setScheduledTasks(new HashSet());
                        this.setStatsTaskAddCount(new AtomicLong());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new DaemonPool();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    DaemonPool.__initStatic();
                }

                public static class Daemon
                extends NameService.TcpAcceptor.DaemonPool.Daemon {
                    public Daemon() {
                        this(null, null, true);
                    }

                    public Daemon(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        try {
                            this.setDaemonState(0);
                            this.setDefaultGuardRecovery(0.9f);
                            this.setDefaultGuardTimeout(60000L);
                            this.setNotifier(new SingleWaiterMultiNotifier());
                            this.setThreadName("Worker");
                        }
                        catch (Exception e) {
                            throw new WrapperException(e);
                        }
                        this._addChild(new Guard("Guard", this, true), "Guard");
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Daemon();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$Daemon".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    public static class Guard
                    extends NameService.TcpAcceptor.DaemonPool.Daemon.Guard {
                        private static ListMap __mapChildren;

                        private static void __initStatic() {
                            __mapChildren = new ListMap();
                            __mapChildren.put("Abandon", Abandon.get_CLASS());
                        }

                        public Guard() {
                            this(null, null, true);
                        }

                        public Guard(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Guard();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$Daemon$Guard".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }

                        @Override
                        protected Map get_ChildClasses() {
                            return __mapChildren;
                        }

                        static {
                            Guard.__initStatic();
                        }

                        public static class Abandon
                        extends NameService.TcpAcceptor.DaemonPool.Daemon.Guard.Abandon {
                            public Abandon() {
                                this(null, null, true);
                            }

                            public Abandon(String sName, Component compParent, boolean fInit) {
                                super(sName, compParent, false);
                                if (fInit) {
                                    this.__init();
                                }
                            }

                            @Override
                            public void __init() {
                                this.__initPrivate();
                                this.set_Constructed(true);
                            }

                            @Override
                            protected void __initPrivate() {
                                super.__initPrivate();
                            }

                            public static Component get_Instance() {
                                return new Abandon();
                            }

                            public static Class get_CLASS() {
                                Class<?> clz;
                                try {
                                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$Daemon$Guard$Abandon".replace('/', '.'));
                                }
                                catch (ClassNotFoundException e) {
                                    throw new NoClassDefFoundError(e.getMessage());
                                }
                                return clz;
                            }

                            private Component get_Module() {
                                return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                            }
                        }
                    }
                }

                public static class ResizeTask
                extends NameService.TcpAcceptor.DaemonPool.ResizeTask {
                    public ResizeTask() {
                        this(null, null, true);
                    }

                    public ResizeTask(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new ResizeTask();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$ResizeTask".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class ScheduleTask
                extends NameService.TcpAcceptor.DaemonPool.ScheduleTask {
                    public ScheduleTask() {
                        this(null, null, true);
                    }

                    public ScheduleTask(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new ScheduleTask();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$ScheduleTask".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class StartTask
                extends NameService.TcpAcceptor.DaemonPool.StartTask {
                    public StartTask() {
                        this(null, null, true);
                    }

                    public StartTask(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new StartTask();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$StartTask".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class StopTask
                extends NameService.TcpAcceptor.DaemonPool.StopTask {
                    public StopTask() {
                        this(null, null, true);
                    }

                    public StopTask(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new StopTask();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$StopTask".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class WorkSlot
                extends NameService.TcpAcceptor.DaemonPool.WorkSlot {
                    public WorkSlot() {
                        this(null, null, true);
                    }

                    public WorkSlot(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        try {
                            this.setIndex(-1);
                        }
                        catch (Exception e) {
                            throw new WrapperException(e);
                        }
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new WorkSlot();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$WorkSlot".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class WrapperTask
                extends NameService.TcpAcceptor.DaemonPool.WrapperTask {
                    public WrapperTask() {
                        this(null, null, true);
                    }

                    public WrapperTask(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new WrapperTask();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$DaemonPool$WrapperTask".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class EventDispatcher
            extends NameService.TcpAcceptor.EventDispatcher {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Queue", Queue.get_CLASS());
                }

                public EventDispatcher() {
                    this(null, null, true);
                }

                public EventDispatcher(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setCloggedCount(1024);
                        this.setCloggedDelay(32);
                        this.setDaemonState(0);
                        this.setDefaultGuardRecovery(0.9f);
                        this.setDefaultGuardTimeout(60000L);
                        this.setNotifier(new SingleWaiterMultiNotifier());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this._addChild(new Guard("Guard", this, true), "Guard");
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new EventDispatcher();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$EventDispatcher".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    EventDispatcher.__initStatic();
                }

                public static class Queue
                extends NameService.TcpAcceptor.EventDispatcher.Queue {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public Queue() {
                        this(null, null, true);
                    }

                    public Queue(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        try {
                            this.setElementList(new RecyclingLinkedList());
                        }
                        catch (Exception e) {
                            throw new WrapperException(e);
                        }
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Queue();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$EventDispatcher$Queue".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        Queue.__initStatic();
                    }

                    public static class Iterator
                    extends NameService.TcpAcceptor.EventDispatcher.Queue.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$EventDispatcher$Queue$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class Guard
                extends Service.EventDispatcher.Guard {
                    public Guard() {
                        this(null, null, true);
                    }

                    public Guard(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Guard();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$EventDispatcher$Guard".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class Guard
            extends Daemon.Guard {
                public Guard() {
                    this(null, null, true);
                }

                public Guard(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Guard();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$Guard".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class Protocol
            extends Peer.Protocol {
                public Protocol() {
                    this(null, null, true);
                }

                public Protocol(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setVersionCurrent(3);
                        this.setVersionSupported(2);
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Protocol();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$Protocol".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class TcpProcessor
            extends NameService.TcpAcceptor.TcpProcessor {
                public TcpProcessor() {
                    this(null, null, true);
                }

                public TcpProcessor(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setDaemonState(0);
                        this.setDefaultGuardRecovery(0.9f);
                        this.setDefaultGuardTimeout(60000L);
                        this.setNotifier(new SingleWaiterMultiNotifier());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this._addChild(new Guard("Guard", this, true), "Guard");
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new TcpProcessor();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$TcpProcessor".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                public static class Guard
                extends Daemon.Guard {
                    public Guard() {
                        this(null, null, true);
                    }

                    public Guard(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Guard();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameService$TcpAcceptor$TcpProcessor$Guard".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }
    }

    public static class NameServiceBridge
    extends RemoteNameService {
        private volatile boolean __m_ForeignBroadcastBound;
        private volatile boolean __m_ForeignNSBound;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("InterruptTask", InterruptTask.get_CLASS());
        }

        public NameServiceBridge() {
            this(null, null, true);
        }

        public NameServiceBridge(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMemberListeners(new Listeners());
                this.setResourceRegistry(new SimpleResourceRegistry());
                this.setServiceListeners(new Listeners());
                this.setServiceName("NameServiceBridge");
                this.setServiceVersion("1");
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NameServiceBridge();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameServiceBridge".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public void halt() {
            try {
                ((TcpInitiator.TcpConnection)((TcpInitiator)this.getInitiator()).getConnection()).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean isForeignBroadcastBound() {
            return this.__m_ForeignBroadcastBound;
        }

        public boolean isForeignNSBound() {
            return this.__m_ForeignNSBound;
        }

        public boolean isFullyBound() {
            return this.isForeignBroadcastBound() && this.isForeignNSBound();
        }

        @Override
        protected synchronized void setChannel(Channel channel) {
            this.setForeignBroadcastBound(false);
            this.setForeignNSBound(false);
            super.setChannel(channel);
        }

        protected void setForeignBroadcastBound(boolean fBound) {
            this.__m_ForeignBroadcastBound = fBound;
        }

        protected void setForeignNSBound(boolean fBound) {
            this.__m_ForeignNSBound = fBound;
        }

        @Override
        public synchronized void start() {
            if (!this.isRunning()) {
                this.doStart();
            }
        }

        public boolean tryForeignBind() {
            block28: {
                if (this.isFullyBound()) {
                    return true;
                }
                Cluster cluster = (Cluster)this.get_Module();
                boolean fJoined = cluster.getClusterService().getState() >= 2;
                try {
                    if (!this.isRunning()) {
                        this.start();
                    }
                    String sNameThis = cluster.getClusterName();
                    String sNameOther = (String)this.lookup("Cluster/name");
                    InetAddress addrDiscThis = cluster.getDependencies().getLocalDiscoveryAddress();
                    InetAddress addrDiscThat = (InetAddress)this.lookup("Cluster/localDiscoveryInetAddress");
                    InetAddress addrNSThis = cluster.getNameService().getLocalAddress();
                    InetAddress addrNSThat = (InetAddress)this.lookup("NameService/localInetAddress");
                    boolean fIpv4This = InetAddresses.PreferIPv4Stack;
                    Boolean FIpv4That = (Boolean)this.lookup("Cluster/IPv4Stack");
                    if (sNameThis.equals(sNameOther)) {
                        if (fJoined) {
                            this.setForeignBroadcastBound(true);
                            this.setForeignNSBound(true);
                            return true;
                        }
                        if (!Base.equals(this.lookup("Cluster/multicastInetAddress"), cluster.getClusterService().isWkaEnabled() ? null : cluster.getDependencies().getGroupAddress())) {
                            NameServiceBridge._trace("there appears to be other members of the cluster '" + sNameOther + "' already running with an incompatible network configuration, aborting join with " + String.valueOf(this.lookup("Cluster/info")), 1);
                            cluster.getClusterService().onStopJoining();
                        } else {
                            cluster.getClusterService().resetBroadcastCounter("there appears to be other members of the cluster '" + sNameOther + "' already running likely with an incompatible network configuration, retrying to join with " + String.valueOf(this.lookup("Cluster/info")), null);
                        }
                        break block28;
                    }
                    if (!cluster.isClusterPortSharingEnabled()) {
                        NameServiceBridge._trace("this cluster '" + sNameThis + "' does not support port sharing and there is another cluster '" + sNameOther + "' already bound to the cluster port '" + cluster.getDependencies().getGroupPort() + "' on this machine. " + String.valueOf(this.lookup("Cluster/info")), 1);
                        if (fJoined) {
                            cluster.getClusterService().onStopRunning();
                        } else {
                            cluster.getClusterService().onStopJoining();
                        }
                        return false;
                    }
                    if (InetAddressComparator.INSTANCE.compare(addrDiscThis, addrDiscThat) != 0) {
                        NameServiceBridge._trace("this cluster '" + sNameThis + "' is configured with a local discovery address of '" + String.valueOf(addrDiscThis) + "' which is not compatible with cluster '" + sNameOther + "' which is using '" + String.valueOf(addrDiscThat) + "' and currently hosting the shared cluster port '" + cluster.getDependencies().getGroupPort() + "', in order to share a cluster port the discovery addresses must be equal. " + String.valueOf(this.lookup("Cluster/info")), 1);
                        if (fJoined) {
                            cluster.getClusterService().onStopRunning();
                        } else {
                            cluster.getClusterService().onStopJoining();
                        }
                        return false;
                    }
                    if (InetAddressComparator.INSTANCE.compare(addrNSThis, addrNSThat) != 0) {
                        NameServiceBridge._trace("this cluster '" + sNameThis + "' is configured with a local NameService address of '" + String.valueOf(addrNSThis) + "' which is not compatible with cluster '" + sNameOther + "' which is using '" + String.valueOf(addrNSThat) + "' and currently hosting the shared cluster port '" + cluster.getDependencies().getGroupPort() + "', in order to share a cluster port the NameService addresses must be equal. " + String.valueOf(this.lookup("Cluster/info")), 1);
                        if (fJoined) {
                            cluster.getClusterService().onStopRunning();
                        } else {
                            cluster.getClusterService().onStopJoining();
                        }
                        return false;
                    }
                    if ((FIpv4That == null || FIpv4That != fIpv4This) && (addrDiscThis.isAnyLocalAddress() || addrNSThis.isAnyLocalAddress())) {
                        NameServiceBridge._trace("this JVM for cluster '" + sNameThis + "' is" + (fIpv4This ? " not" : "") + " configured to allow IPv6 which differs from the configurtion of the local JVM for cluster '" + sNameOther + "' which is currently hosting the shared cluster port. In order to share a cluster port this setting must be equal. The java.net.preferIPv4Stack system propery can be used to restrict IPv6 support. " + String.valueOf(this.lookup("Cluster/info")), 1);
                        if (fJoined) {
                            cluster.getClusterService().onStopRunning();
                        } else {
                            cluster.getClusterService().onStopJoining();
                        }
                        return false;
                    }
                    String sBindPoint = null;
                    try {
                        if (!this.isForeignBroadcastBound()) {
                            InetSocketAddress addrLocal = (InetSocketAddress)cluster.getSocketManager().getUnicastUdpSocket().getDatagramSocket().getLocalSocketAddress();
                            if (addrLocal.getAddress().isAnyLocalAddress()) {
                                addrLocal = new InetSocketAddress(InetAddress.getLoopbackAddress(), addrLocal.getPort());
                            }
                            sBindPoint = "Cluster/foreign/" + sNameThis + "/Cluster/localAddress";
                            this.bind(sBindPoint, addrLocal);
                            this.bind("Cluster/foreign/" + sNameThis + "/Cluster/announceVersion", 1);
                            this.setForeignBroadcastBound(true);
                        }
                        if (fJoined && !this.isForeignNSBound()) {
                            sBindPoint = "Cluster/foreign/" + sNameThis + "/NameService/localPort";
                            this.bind(sBindPoint, MultiplexedSocketProvider.getBasePort(cluster.getNameService().getAcceptor().getProcessor().getServerSocket().getLocalPort()));
                            this.setForeignNSBound(true);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if (!fJoined) {
                            Object oBind = this.lookup(sBindPoint);
                            if (oBind == null) {
                                cluster.getClusterService().resetBroadcastCounter("there is another cluster '" + sNameOther + "' already bound to the cluster port '" + cluster.getDependencies().getGroupPort() + "' on this machine and it does not appear to support port sharing.  " + String.valueOf(this.lookup("Cluster/info")), null);
                            } else {
                                cluster.getClusterService().resetBroadcastCounter("there appears to be other member of the cluster '" + sNameOther + "' already running likely with an incompatible network configuration, retrying to join with " + String.valueOf(oBind), null);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (fJoined) break block28;
                    int nPort = cluster.getDependencies().getGroupPort();
                    cluster.getClusterService().resetBroadcastCounter("there appears to be an unresponsive or non-Coherence process bound to the cluster-port '" + nPort + "' on this machine, retrying join after " + String.valueOf(e) + (String)(InetAddresses.isEphemeral(nPort) ? ". The port '" + nPort + "' appears to be in the ephemeral port range on this machine and thus may have been randomly assigned to another process. See your OS documentation on how to check the range and either adjust the range or your cluster port selection such that the port is outside the ephemeral range." : ""), null);
                }
            }
            return false;
        }

        static {
            NameServiceBridge.__initStatic();
        }

        public static class InterruptTask
        extends RemoteNameService.InterruptTask {
            public InterruptTask() {
                this(null, null, true);
            }

            public InterruptTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new InterruptTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$NameServiceBridge$InterruptTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class PacketListener1
    extends PacketListener {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public PacketListener1() {
            this(null, null, true);
        }

        public PacketListener1(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketListener1();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListener1".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        @Override
        protected void onPacket(SocketAddress addrSource, ByteBuffer bufPacket) {
            ((Cluster)this.get_Module()).onPacket(this, addrSource, bufPacket);
        }

        static {
            PacketListener1.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListener1$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListener1$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class PacketListener1P
    extends PacketListener {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public PacketListener1P() {
            this(null, null, true);
        }

        public PacketListener1P(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketListener1P();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListener1P".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        @Override
        protected void onPacket(SocketAddress addrSource, ByteBuffer bufPacket) {
            ((Cluster)this.get_Module()).onPacket(this, addrSource, bufPacket);
        }

        static {
            PacketListener1P.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListener1P$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListener1P$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class PacketListenerBT
    extends PacketListener {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public PacketListenerBT() {
            this(null, null, true);
        }

        public PacketListenerBT(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketListenerBT();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListenerBT".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            int nState = cluster.getState();
            if (nState < 4) {
                try {
                    if (nState < 3) {
                        super.onException(e);
                    }
                }
                finally {
                    cluster.onException(e);
                }
            }
        }

        @Override
        protected void onPacket(SocketAddress addrSource, ByteBuffer bufPacket) {
            ((Cluster)this.get_Module()).onPacket(this, addrSource, bufPacket);
        }

        static {
            PacketListenerBT.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListenerBT$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListenerBT$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class PacketListenerBU
    extends PacketListener {
        private boolean __m_InGroup;
        private boolean __m_SuspectBinding;
        private long __m_SuspectGroupTimestamp;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public PacketListenerBU() {
            this(null, null, true);
        }

        public PacketListenerBU(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketListenerBU();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListenerBU".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureBinding() {
            boolean fRebound = false;
            if (this.isSuspectBinding()) {
                ((SocketManager.BroadcastUdpSocket)this.getUdpSocket()).rebind();
                this.setSuspectBinding(false);
                fRebound = true;
            } else if (((Cluster)this.get_Module()).getTcpBroadcastListener().isStarted()) {
                this.setSuspectBinding(true);
                ByteBuffer bufTest = ByteBuffer.allocate(4);
                bufTest.putInt(1952805748).flip();
                DatagramSocket socket = this.getUdpSocket().getDatagramSocket();
                InetAddress addrLocal = socket.getLocalAddress();
                if (addrLocal == null || addrLocal.isAnyLocalAddress()) {
                    addrLocal = InetAddress.getLoopbackAddress();
                }
                try {
                    socket.send(new DatagramPacket(bufTest.array(), bufTest.limit(), addrLocal, socket.getLocalPort()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.isInGroup() && (fRebound || Base.getSafeTimeMillis() > this.getSuspectGroupTimestamp())) {
                if (!fRebound) {
                    PacketListenerBU._trace("Scheduled senior member heartbeat is overdue; rejoining multicast group.", 9);
                }
                try {
                    this.leaveGroup();
                }
                finally {
                    this.joinGroup();
                }
            }
        }

        public long getSuspectGroupTimestamp() {
            return this.__m_SuspectGroupTimestamp;
        }

        public boolean isInGroup() {
            return this.__m_InGroup;
        }

        public boolean isSuspectBinding() {
            return this.__m_SuspectBinding;
        }

        public void joinGroup() {
            block3: {
                MulticastSocket socket = (MulticastSocket)this.getUdpSocket().getDatagramSocket();
                try {
                    if (!this.isInGroup()) {
                        this.setInGroup(true);
                        Cluster cluster = (Cluster)this.get_Module();
                        ClusterDependencies config = cluster.getDependencies();
                        InetAddress addrMcast = config.getLocalDiscoveryAddress();
                        socket.joinGroup(new InetSocketAddress(config.getGroupAddress(), config.getGroupPort()), addrMcast == null ? null : NetworkInterface.getByInetAddress(addrMcast));
                        this.resetSuspectGroupTimestamp();
                    }
                }
                catch (IOException e) {
                    if (socket.isClosed()) break block3;
                    this.getUdpSocket().onException(e);
                }
            }
        }

        public void leaveGroup() {
            block3: {
                MulticastSocket socket = (MulticastSocket)this.getUdpSocket().getDatagramSocket();
                if (this.isInGroup()) {
                    try {
                        this.setInGroup(false);
                        Cluster cluster = (Cluster)this.get_Module();
                        socket.leaveGroup(new InetSocketAddress(cluster.getDependencies().getGroupAddress(), cluster.getDependencies().getGroupPort()), null);
                    }
                    catch (IOException e) {
                        if (socket.isClosed()) break block3;
                        this.getUdpSocket().onException(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onEnter() {
            super.onEnter();
            DatagramSocket socket = this.getUdpSocket().getDatagramSocket();
            int cbPacket = this.getPacketLength();
            int cMillis = 0;
            try {
                try {
                    cMillis = socket.getSoTimeout();
                    socket.setSoTimeout(1);
                    DatagramPacket p = new DatagramPacket(new byte[cbPacket], cbPacket);
                    while (true) {
                        socket.receive(p);
                    }
                }
                catch (IOException p) {
                    try {
                        socket.setSoTimeout(cMillis);
                    }
                    catch (IOException e) {
                        this.onException(e);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    socket.setSoTimeout(cMillis);
                }
                catch (IOException e) {
                    this.onException(e);
                }
                throw throwable;
            }
            this.setWaitMillis(cMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            int nState = cluster.getState();
            if (nState < 4) {
                try {
                    if (nState < 3) {
                        super.onException(e);
                    }
                }
                finally {
                    cluster.onException(e);
                }
            }
        }

        @Override
        protected void onInterval() {
            super.onInterval();
            this.ensureBinding();
        }

        @Override
        protected void onPacket(SocketAddress addrSource, ByteBuffer bufPacket) {
            Cluster cluster = (Cluster)this.get_Module();
            if (this.isSuspectBinding() && bufPacket.remaining() >= 4) {
                if (this.isInGroup()) {
                    if (bufPacket.remaining() == 4 && bufPacket.getInt(bufPacket.position()) == 1952805748) {
                        this.setSuspectBinding(false);
                    }
                } else {
                    this.setSuspectBinding(false);
                }
            }
            cluster.onPacket(this, addrSource, bufPacket);
        }

        public void resetSuspectGroupTimestamp() {
            this.setSuspectGroupTimestamp(Base.getSafeTimeMillis() + Math.max(1000L, (long)(((Cluster)this.get_Module()).getDependencies().getClusterHeartbeatDelayMillis() * 3)));
        }

        protected void setInGroup(boolean fGroup) {
            this.__m_InGroup = fGroup;
        }

        public void setSuspectBinding(boolean fBinding) {
            this.__m_SuspectBinding = fBinding;
        }

        public void setSuspectGroupTimestamp(long fBinding) {
            this.__m_SuspectGroupTimestamp = fBinding;
        }

        static {
            PacketListenerBU.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListenerBU$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketListenerBU$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class PacketPublisher
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher {
        public PacketPublisher() {
            this(null, null, true);
        }

        public PacketPublisher(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAckdPacketListTemp(new RecyclingLinkedList());
                this.setCloggedCount(1024);
                this.setCloggedDelay(32);
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setLostPacketListTemp(new RecyclingLinkedList());
                this.setMulticastEnabled(true);
                this.setMulticastThreshold(0.25);
                this.setNotifier(new SingleWaiterMultiNotifier());
                this.setSingleMemberSetTemp(new SingleMemberSet());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new AckQueue("AckQueue", this, true), "AckQueue");
            this._addChild(new ConfirmationQueue("ConfirmationQueue", this, true), "ConfirmationQueue");
            this._addChild(new InQueue("InQueue", this, true), "InQueue");
            this._addChild(new PacketPublisher.OutgoingMessageArray("OutgoingMessageArray", this, true), "OutgoingMessageArray");
            this._addChild(new ResendQueue("ResendQueue", this, true), "ResendQueue");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketPublisher();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void halt() {
            super.halt();
        }

        @Override
        public void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        @Override
        public void onSlowPacket(MessagePacket packet) {
            ClusterService service = ((Cluster)this.get_Module()).getClusterService();
            int nToId = packet.getToId();
            if (nToId != 0) {
                service.verifyMemberSlow(this.getMember(nToId), packet);
            } else {
                DependentMemberSet setToMember = packet.getToMemberSet();
                if (setToMember != null) {
                    for (Member member : setToMember) {
                        service.verifyMemberSlow(member, packet);
                    }
                }
            }
        }

        @Override
        public void onUndeliverablePacket(MessagePacket packet) {
            ClusterService service = ((Cluster)this.get_Module()).getClusterService();
            ActualMemberSet setLate = null;
            int nToId = packet.getToId();
            if (nToId != 0) {
                Member member = this.getMember(nToId);
                if (member != null) {
                    setLate = new ActualMemberSet();
                    ((MemberSet)setLate).add(member);
                }
            } else {
                DependentMemberSet setToMember = packet.getToMemberSet();
                if (setToMember != null && !((MemberSet)setToMember).isEmpty()) {
                    setLate = new ActualMemberSet();
                    ((MemberSet)setLate).addAll((Collection)setToMember);
                }
            }
            if (setLate != null) {
                service.doNotifyTcmpTimeout((MessagePacket)packet.clone(), setLate);
            }
        }

        public static class AckQueue
        extends PacketPublisher.AckQueue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public AckQueue() {
                this(null, null, true);
            }

            public AckQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBatchSize(1);
                    this.setDelayMillis(10);
                    this.setElementList(new RecyclingLinkedList());
                    this.setHeadElementList(new RecyclingLinkedList());
                    this.setHeadLock(new Object());
                    this.setLastKnownReadyIndex(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new AckQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$AckQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                AckQueue.__initStatic();
            }

            public static class Iterator
            extends PacketPublisher.AckQueue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$AckQueue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ConfirmationQueue
        extends PacketPublisher.ConfirmationQueue {
            public ConfirmationQueue() {
                this(null, null, true);
            }

            public ConfirmationQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBatchSize(1);
                    this.setDelegate(new ConcurrentLinkedQueue());
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfirmationQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$ConfirmationQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class InQueue
        extends PacketPublisher.InQueue {
            public InQueue() {
                this(null, null, true);
            }

            public InQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBatchSize(1);
                    this.setDelegate(new ConcurrentLinkedQueue());
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new PacketAdapter("PacketAdapter", this, true), "PacketAdapter");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new InQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$InQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public static class PacketAdapter
            extends PacketPublisher.InQueue.PacketAdapter {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public PacketAdapter() {
                    this(null, null, true);
                }

                public PacketAdapter(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setElementList(new RecyclingLinkedList());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new PacketAdapter();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$InQueue$PacketAdapter".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    PacketAdapter.__initStatic();
                }

                public static class Iterator
                extends PacketPublisher.InQueue.PacketAdapter.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$InQueue$PacketAdapter$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }

        public static class ResendQueue
        extends PacketPublisher.ResendQueue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public ResendQueue() {
                this(null, null, true);
            }

            public ResendQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                    this.setResendMillis(400);
                    this.setTimeoutMillis(20000);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ResendQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$ResendQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ResendQueue.__initStatic();
            }

            public static class Iterator
            extends PacketPublisher.ResendQueue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketPublisher$ResendQueue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class PacketReceiver
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver {
        private ClusterService __m_ClusterService;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("AddressedBuffer", AddressedBuffer.get_CLASS());
        }

        public PacketReceiver() {
            this(null, null, true);
        }

        public PacketReceiver(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new InQueue("InQueue", this, true), "InQueue");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketReceiver();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketReceiver".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public ClusterService getClusterService() {
            return this.__m_ClusterService;
        }

        @Override
        public Grid getService(int i) {
            return this.getClusterService().getService(i);
        }

        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        public void setClusterService(ClusterService serviceCluster) {
            this.__m_ClusterService = serviceCluster;
        }

        static {
            PacketReceiver.__initStatic();
        }

        public static class AddressedBuffer
        extends PacketReceiver.AddressedBuffer {
            public AddressedBuffer() {
                this(null, null, true);
            }

            public AddressedBuffer(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new AddressedBuffer();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketReceiver$AddressedBuffer".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class InQueue
        extends PacketReceiver.InQueue {
            public InQueue() {
                this(null, null, true);
            }

            public InQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBatchSize(1);
                    this.setDelegate(new ConcurrentLinkedQueue());
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new InQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketReceiver$InQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class PacketSpeaker
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("BundlingQueue", BundlingQueue.get_CLASS());
            __mapChildren.put("InQueue", InQueue.get_CLASS());
        }

        public PacketSpeaker() {
            this(null, null, true);
        }

        public PacketSpeaker(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PacketSpeaker();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        protected void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        static {
            PacketSpeaker.__initStatic();
        }

        public static class BundlingQueue
        extends PacketSpeaker.BundlingQueue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
                __mapChildren.put("TargetQueue", TargetQueue.get_CLASS());
            }

            public BundlingQueue() {
                this(null, null, true);
            }

            public BundlingQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBatchSize(4);
                    this.setBundlingEnabled(true);
                    this.setCloggedCount(1024);
                    this.setCloggedDelay(32);
                    this.setElementList(new RecyclingLinkedList());
                    this.setTargetMap(new SafeHashMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BundlingQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker$BundlingQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                BundlingQueue.__initStatic();
            }

            public static class Iterator
            extends PacketSpeaker.BundlingQueue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker$BundlingQueue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class TargetQueue
            extends PacketSpeaker.BundlingQueue.TargetQueue {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public TargetQueue() {
                    this(null, null, true);
                }

                public TargetQueue(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setElementList(new RecyclingLinkedList());
                        this.setHeadElementList(new RecyclingLinkedList());
                        this.setHeadLock(new Object());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new TargetQueue();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker$BundlingQueue$TargetQueue".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    TargetQueue.__initStatic();
                }

                public static class Iterator
                extends PacketSpeaker.BundlingQueue.TargetQueue.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker$BundlingQueue$TargetQueue$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }

        public static class InQueue
        extends PacketSpeaker.InQueue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public InQueue() {
                this(null, null, true);
            }

            public InQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBatchSize(1);
                    this.setElementList(new RecyclingLinkedList());
                    this.setHeadElementList(new RecyclingLinkedList());
                    this.setHeadLock(new Object());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new InQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker$InQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                InQueue.__initStatic();
            }

            public static class Iterator
            extends PacketSpeaker.InQueue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PacketSpeaker$InQueue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class PublicGuardian
    extends Daemon {
        public PublicGuardian() {
            this(null, null, true);
        }

        public PublicGuardian(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PublicGuardian();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PublicGuardian".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ensureStarted() {
            Cluster cluster = (Cluster)this.get_Module();
            if (cluster.isRunning() && !this.isStarted()) {
                PublicGuardian publicGuardian = this;
                synchronized (publicGuardian) {
                    if (cluster.isRunning() && !this.isStarted()) {
                        this.start();
                        cluster.getClusterService().guard(this.getGuardable());
                    }
                }
            }
        }

        @Override
        public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
            this.ensureStarted();
            if (guardable instanceof Grid.Guard) {
                Grid service = (Grid)((Grid.Guard)guardable).get_Parent();
                guardable = service.instantiateWrapperGuardable(guardable);
            } else {
                guardable = ((Cluster)this.get_Module()).getClusterService().instantiateWrapperGuardable(guardable);
            }
            return super.guard(guardable, cMillis, flPctRecover);
        }

        public static class Guard
        extends Daemon.Guard {
            public Guard() {
                this(null, null, true);
            }

            public Guard(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Guard();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$PublicGuardian$Guard".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ShutdownHook
    extends com.tangosol.coherence.component.util.ShutdownHook {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("UnregisterAction", UnregisterAction.get_CLASS());
        }

        public ShutdownHook() {
            this(null, null, true);
        }

        public ShutdownHook(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ShutdownHook();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ShutdownHook".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void run() {
            if (this.getThread() == null) {
                return;
            }
            try {
                Cluster cluster = (Cluster)this.get_Module();
                if (cluster.getState() == 3) {
                    if (this.isGraceful()) {
                        ShutdownHook._trace(this.get_Name() + ": shutting down cluster node", 3);
                        cluster.shutdown();
                    } else {
                        ShutdownHook._trace(this.get_Name() + ": stopping cluster node", 3);
                        cluster.stop();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static {
            ShutdownHook.__initStatic();
        }

        public static class UnregisterAction
        extends ShutdownHook.UnregisterAction {
            public UnregisterAction() {
                this(null, null, true);
            }

            public UnregisterAction(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new UnregisterAction();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$ShutdownHook$UnregisterAction".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class SocketManager
    extends Util {
        private volatile transient Depot __m_Depot;
        private SocketProvider __m_TcpRingSocketProvider;
        private DatagramSocketProvider __m_UnicastUdpSocketProvider;

        public SocketManager() {
            this(null, null, true);
        }

        public SocketManager(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this._addChild(new AcceptorChannel("AcceptorChannel", this, true), "AcceptorChannel");
            this._addChild(new BroadcastTcpSocket("BroadcastTcpSocket", this, true), "BroadcastTcpSocket");
            this._addChild(new BroadcastUdpSocket("BroadcastUdpSocket", this, true), "BroadcastUdpSocket");
            this._addChild(new PreferredUnicastUdpSocket("PreferredUnicastUdpSocket", this, true), "PreferredUnicastUdpSocket");
            this._addChild(new UnicastUdpSocket("UnicastUdpSocket", this, true), "UnicastUdpSocket");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new SocketManager();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$SocketManager".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void bindSockets() throws IOException {
            Object sAddr;
            Cluster cluster = (Cluster)this.get_Module();
            ClusterDependencies config = cluster.getDependencies();
            AcceptorChannel acceptorChannel = this.getAcceptorChannel();
            UnicastUdpSocket udpSocket = this.getUnicastUdpSocket();
            InetAddress addrInet = udpSocket.getInetAddress();
            DatagramSocketProvider provider = this.getUnicastUdpSocketProvider();
            boolean fTransportSvc = cluster.isTransportServiceEnabled();
            boolean fBound = false;
            if (!InetAddresses.isLocalAddress(addrInet)) {
                throw new IOException(String.valueOf(addrInet) + " is not a local address");
            }
            int nPort = config.getLocalPort();
            if (nPort == 0 && config.getGroupPort() != 8088 && config.getWellKnownAddresses() != null && cluster.getClusterService().getWellKnownAddresses().contains(new InetSocketAddress(addrInet, 8088))) {
                nPort = 8088;
            }
            IOException eLast = null;
            int nPortMin = nPort;
            int nPortAdjustMax = config.isLocalPortAutoAdjust() ? config.getLocalPortAutoAdjust() : nPort + (fTransportSvc ? 0 : 1);
            fBound = false;
            do {
                ServerSocketChannel channelTcp = null;
                try {
                    acceptorChannel.setPort(nPort);
                    channelTcp = acceptorChannel.instantiateChannel();
                    acceptorChannel.setChannel(channelTcp);
                    acceptorChannel.open();
                    fBound = true;
                }
                catch (IOException e1) {
                    eLast = e1;
                    if (channelTcp == null) continue;
                    try {
                        channelTcp.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            } while (!fBound && nPort != 0 && ++nPort <= nPortAdjustMax);
            if (fBound) {
                fBound = false;
                try {
                    udpSocket.setPort(nPort == 0 ? acceptorChannel.getPort() : nPort);
                    udpSocket.open();
                    fBound = true;
                }
                catch (IOException e1) {
                    eLast = e1;
                    nPort = nPortMin;
                    while (true) {
                        try {
                            udpSocket.setPort(nPort);
                            udpSocket.open();
                            fBound = true;
                        }
                        catch (IOException e2) {
                            eLast = e2;
                            if (!fBound && nPort != 0 && ++nPort <= nPortAdjustMax) continue;
                        }
                        break;
                    }
                }
            }
            if (fBound && !fTransportSvc) {
                fBound = false;
                if (nPort > 0 && nPort < nPortAdjustMax) {
                    ++nPort;
                }
                PreferredUnicastUdpSocket udpSocketPref = this.getPreferredUnicastUdpSocket();
                do {
                    try {
                        udpSocketPref.setPort(nPort);
                        udpSocketPref.open();
                        fBound = true;
                    }
                    catch (IOException e1) {
                        eLast = e1;
                    }
                } while (!fBound && nPort != 0 && ++nPort <= nPortAdjustMax);
            }
            if (fBound) {
                InetSocketAddress addrBind = (InetSocketAddress)udpSocket.getDatagramSocket().getLocalSocketAddress();
                sAddr = addrBind.toString();
                if (addrBind.getAddress().isAnyLocalAddress()) {
                    try {
                        sAddr = InetAddress.getLocalHost().getHostName() + ":" + addrBind.getPort();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            } else {
                if (config.isLocalPortAutoAdjust()) {
                    throw new IOException(String.valueOf(provider) + " unable to find available port(s) within " + nPortMin + ".." + Math.max(0, nPort - 1), eLast);
                }
                throw new IOException(String.valueOf(provider) + " failed to bind to configured port " + nPortMin + ". Note, that port auto-adjust feature has been explicitly disabled", eLast);
            }
            SocketManager._trace("TCMP bound to " + (String)sAddr + " using " + String.valueOf(provider), 3);
            if (cluster.getClusterService().getWellKnownAddresses() == null) {
                this.getBroadcastUdpSocket().open();
            }
        }

        public void configure(DatagramSocket socket) throws IOException {
            ClusterDependencies config = ((Cluster)this.get_Module()).getDependencies();
            if (socket instanceof TcpDatagramSocket) {
                TcpDatagramSocket datagram = (TcpDatagramSocket)socket;
                datagram.setPacketMagic(0xDDF00D0, -16);
                datagram.setSocketOptions(config.getTcpDatagramSocketOptions());
                datagram.setListenBacklog(config.getTcpBacklog());
            } else if (socket instanceof MulticastSocket) {
                MulticastSocket socketMulti = (MulticastSocket)socket;
                InetAddress addrUnicast = this.getUnicastUdpSocket().getInetAddress();
                socketMulti.setTimeToLive(config.getGroupTimeToLive());
                InetAddress addrGroup = config.getGroupInterface();
                if (addrGroup == null || addrGroup.isAnyLocalAddress()) {
                    addrGroup = config.getPublisherGroupThreshold() < 100 || addrUnicast.isLoopbackAddress() ? addrUnicast : null;
                }
                if (addrGroup != null && !InetAddresses.isNatLocalAddress(addrGroup, config.getLocalPort(), config.getLocalPortAutoAdjust())) {
                    socketMulti.setInterface(addrGroup);
                }
            }
        }

        public void configure(ServerSocket socket) throws IOException {
            ((Cluster)this.get_Module()).getClusterService().getTcpRing().getSocketOptions().apply(socket);
        }

        public AcceptorChannel getAcceptorChannel() {
            return (AcceptorChannel)this._findChild("AcceptorChannel");
        }

        public BroadcastTcpSocket getBroadcastTcpSocket() {
            return (BroadcastTcpSocket)this._findChild("BroadcastTcpSocket");
        }

        public BroadcastUdpSocket getBroadcastUdpSocket() {
            return (BroadcastUdpSocket)this._findChild("BroadcastUdpSocket");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Depot getDepot() {
            Depot depot = this.__m_Depot;
            if (depot == null) {
                SocketManager socketManager = this;
                synchronized (socketManager) {
                    depot = this.__m_Depot;
                    if (depot == null) {
                        Cluster cluster = (Cluster)this.get_Module();
                        ClusterDependencies config = cluster.getDependencies();
                        SimpleDepot.DefaultDependencies depsDepot = new SimpleDepot.DefaultDependencies().setSSLSettings(config.getUnicastSocketProviderBuilder().getSSLSettings());
                        HashMap<String, Driver> mapDrivers = new HashMap<String, Driver>(depsDepot.getDrivers());
                        for (Map.Entry entry : mapDrivers.entrySet()) {
                            Driver driver = (Driver)entry.getValue();
                            if (!(driver instanceof SocketBusDriver)) continue;
                            SocketBusDriver.Dependencies depsSocket = ((SocketBusDriver)driver).getDependencies();
                            entry.setValue(new SocketBusDriver(new SocketBusDriver.DefaultDependencies(depsSocket).setLogger(LoggingBridge.createBridge()).setDefaultAckTimeoutMillis(config.getIpMonitorTimeoutMillis() * (long)config.getIpMonitorAttempts()).setAckFatalTimeoutMillis(0L).setSocketReconnectLimit(Integer.MAX_VALUE)));
                        }
                        depsDepot.setDrivers(mapDrivers);
                        depot = new SimpleDepot(depsDepot);
                        this.setDepot(depot);
                    }
                }
            }
            return depot;
        }

        public PreferredUnicastUdpSocket getPreferredUnicastUdpSocket() {
            return (PreferredUnicastUdpSocket)this._findChild("PreferredUnicastUdpSocket");
        }

        public SocketProvider getTcpRingSocketProvider() {
            return this.__m_TcpRingSocketProvider;
        }

        public UnicastUdpSocket getUnicastUdpSocket() {
            return (UnicastUdpSocket)this._findChild("UnicastUdpSocket");
        }

        public DatagramSocketProvider getUnicastUdpSocketProvider() {
            return this.__m_UnicastUdpSocketProvider;
        }

        public void releaseSockets() {
            this.getUnicastUdpSocket().close();
            this.getPreferredUnicastUdpSocket().close();
            this.getAcceptorChannel().close();
        }

        public void setDepot(Depot depot) {
            this.__m_Depot = depot;
        }

        public void setTcpRingSocketProvider(SocketProvider pSocketProvider) {
            this.__m_TcpRingSocketProvider = pSocketProvider;
        }

        public void setUnicastUdpSocketProvider(DatagramSocketProvider providerSocket) {
            this.__m_UnicastUdpSocketProvider = providerSocket;
        }

        public static class AcceptorChannel
        extends Component {
            private int __m_Backlog;
            private ServerSocketChannel __m_Channel;
            private InetAddress __m_InetAddress;
            private Object __m_Lock;
            private int __m_Port;

            public AcceptorChannel() {
                this(null, null, true);
            }

            public AcceptorChannel(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setBacklog(0);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new AcceptorChannel();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$SocketManager$AcceptorChannel".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                Object object = this.getLock();
                synchronized (object) {
                    ServerSocketChannel channel = this.getChannel();
                    if (channel != null && channel.isOpen()) {
                        try {
                            channel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.setChannel(null);
                }
            }

            public int getBacklog() {
                return this.__m_Backlog;
            }

            public ServerSocketChannel getChannel() {
                return this.__m_Channel;
            }

            public Cluster getCluster() {
                return (Cluster)this.get_Module();
            }

            public InetAddress getInetAddress() {
                return this.__m_InetAddress;
            }

            public Object getLock() {
                Object lock = this.__m_Lock;
                return lock == null ? this : lock;
            }

            public int getPort() {
                return this.__m_Port;
            }

            public SocketProvider getProvider() {
                return ((SocketManager)this.get_Parent()).getTcpRingSocketProvider();
            }

            public ServerSocketChannel instantiateChannel() throws IOException {
                ServerSocketChannel channel = this.getProvider().openServerSocketChannel();
                ServerSocket socket = channel.socket();
                try {
                    channel.configureBlocking(false);
                    ((SocketManager)this.get_Parent()).configure(socket);
                    int nPort = this.getPort();
                    socket.bind(new InetSocketAddress(this.getInetAddress(), nPort), this.getBacklog());
                    if (nPort == 0) {
                        this.setPort(socket.getLocalPort());
                    }
                }
                catch (BindException e) {
                    channel.close();
                    throw e;
                }
                return channel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerSocketChannel open() throws IOException {
                Object object = this.getLock();
                synchronized (object) {
                    ServerSocketChannel channel = this.getChannel();
                    if (channel == null || !channel.isOpen()) {
                        channel = this.instantiateChannel();
                        this.setChannel(channel);
                    }
                    return channel;
                }
            }

            public void setBacklog(int cBacklog) {
                this.__m_Backlog = cBacklog;
            }

            public void setChannel(ServerSocketChannel channel) {
                this.__m_Channel = channel;
            }

            public void setInetAddress(InetAddress address) {
                this.__m_InetAddress = address;
            }

            protected void setLock(Object oLock) {
                this.__m_Lock = oLock;
            }

            public void setPort(int nPort) {
                this.__m_Port = nPort;
            }
        }

        public static class BroadcastTcpSocket
        extends com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket {
            public BroadcastTcpSocket() {
                this(null, null, true);
            }

            public BroadcastTcpSocket(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setIgnoreSendErrors(false);
                    this.setPacketLength(0);
                    this.setRxDebugDropRate(0);
                    this.setSoTimeout(-1);
                    this.setTxDebugDropRate(0);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BroadcastTcpSocket();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$SocketManager$BroadcastTcpSocket".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Cluster getCluster() {
                return (Cluster)this.get_Module();
            }

            @Override
            public DatagramSocketProvider getDatagramSocketProvider() {
                DatagramSocketProvider provider = ((SocketManager)this.get_Parent()).getUnicastUdpSocketProvider();
                if (provider instanceof TcpDatagramSocketProvider) {
                    return provider;
                }
                return new TcpDatagramSocketProvider(new TcpDatagramSocketProvider.DefaultDependencies().setDelegateSocketProvider(new DemultiplexedSocketProvider(TcpSocketProvider.MULTIPLEXED, MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_TCMP_DATAGRAM.getSubPort())));
            }

            @Override
            protected void initializeDatagramSocket(DatagramSocket socket) throws IOException {
                ((SocketManager)this.get_Parent()).configure(socket);
                super.initializeDatagramSocket(socket);
            }

            @Override
            public DatagramSocket instantiateDatagramSocket() throws IOException {
                return super.instantiateDatagramSocket();
            }

            @Override
            protected void onInterruptedIOException(InterruptedIOException eException) {
            }

            @Override
            public void setDatagramSocket(DatagramSocket socket) {
                super.setDatagramSocket(socket);
            }

            @Override
            protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
                if (!this.getCluster().isTransportServiceEnabled() || cbActualSize < cbMinimumSize) {
                    super.validateBufferSize(sBufferName, cbActualSize, cbRequestedSize, cbMinimumSize);
                }
            }
        }

        public static class BroadcastUdpSocket
        extends com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket {
            public BroadcastUdpSocket() {
                this(null, null, true);
            }

            public BroadcastUdpSocket(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setIgnoreSendErrors(false);
                    this.setPacketLength(0);
                    this.setRxDebugDropRate(0);
                    this.setSoTimeout(-1);
                    this.setTxDebugDropRate(0);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BroadcastUdpSocket();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$SocketManager$BroadcastUdpSocket".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Cluster getCluster() {
                return (Cluster)this.get_Module();
            }

            @Override
            public DatagramSocketProvider getDatagramSocketProvider() {
                return ((SocketManager)this.get_Parent()).getUnicastUdpSocketProvider();
            }

            @Override
            protected void initializeDatagramSocket(DatagramSocket socket) throws IOException {
                ((SocketManager)this.get_Parent()).configure(socket);
                super.initializeDatagramSocket(socket);
            }

            @Override
            public DatagramSocket instantiateDatagramSocket() throws IOException {
                return this.getDatagramSocketProvider().openMulticastSocket();
            }

            @Override
            protected void onInterruptedIOException(InterruptedIOException eException) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rebind() {
                Object object = this.getLock();
                synchronized (object) {
                    DatagramSocket socketNew = null;
                    try {
                        socketNew = this.instantiateDatagramSocket();
                        this.initializeDatagramSocket(socketNew);
                        this.bind(socketNew);
                        this.getDatagramSocket().close();
                        this.setDatagramSocket(socketNew);
                    }
                    catch (IOException e) {
                        socketNew.close();
                        this.onException(e);
                    }
                }
            }

            @Override
            public void setDatagramSocket(DatagramSocket socket) {
                super.setDatagramSocket(socket);
            }

            @Override
            protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
                if (!this.getCluster().isTransportServiceEnabled() || cbActualSize < cbMinimumSize) {
                    super.validateBufferSize(sBufferName, cbActualSize, cbRequestedSize, cbMinimumSize);
                }
            }
        }

        public static class PreferredUnicastUdpSocket
        extends com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket {
            public PreferredUnicastUdpSocket() {
                this(null, null, true);
            }

            public PreferredUnicastUdpSocket(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setIgnoreSendErrors(false);
                    this.setPacketLength(0);
                    this.setRxDebugDropRate(0);
                    this.setSoTimeout(-1);
                    this.setTxDebugDropRate(0);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PreferredUnicastUdpSocket();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$SocketManager$PreferredUnicastUdpSocket".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Cluster getCluster() {
                return (Cluster)this.get_Module();
            }

            @Override
            public DatagramSocketProvider getDatagramSocketProvider() {
                return ((SocketManager)this.get_Parent()).getUnicastUdpSocketProvider();
            }

            @Override
            protected void initializeDatagramSocket(DatagramSocket socket) throws IOException {
                ((SocketManager)this.get_Parent()).configure(socket);
                super.initializeDatagramSocket(socket);
            }

            @Override
            public DatagramSocket instantiateDatagramSocket() throws IOException {
                return super.instantiateDatagramSocket();
            }

            @Override
            protected void onInterruptedIOException(InterruptedIOException eException) {
            }

            @Override
            public void setDatagramSocket(DatagramSocket socket) {
                super.setDatagramSocket(socket);
            }

            @Override
            protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
                if (!this.getCluster().isTransportServiceEnabled() || cbActualSize < cbMinimumSize) {
                    super.validateBufferSize(sBufferName, cbActualSize, cbRequestedSize, cbMinimumSize);
                }
            }
        }

        public static class UnicastUdpSocket
        extends com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket {
            public UnicastUdpSocket() {
                this(null, null, true);
            }

            public UnicastUdpSocket(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setIgnoreSendErrors(false);
                    this.setPacketLength(0);
                    this.setRxDebugDropRate(0);
                    this.setSoTimeout(-1);
                    this.setTxDebugDropRate(0);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new UnicastUdpSocket();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$SocketManager$UnicastUdpSocket".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Cluster getCluster() {
                return (Cluster)this.get_Module();
            }

            @Override
            public DatagramSocketProvider getDatagramSocketProvider() {
                return ((SocketManager)this.get_Parent()).getUnicastUdpSocketProvider();
            }

            @Override
            protected void initializeDatagramSocket(DatagramSocket socket) throws IOException {
                ((SocketManager)this.get_Parent()).configure(socket);
                super.initializeDatagramSocket(socket);
            }

            @Override
            public DatagramSocket instantiateDatagramSocket() throws IOException {
                return super.instantiateDatagramSocket();
            }

            @Override
            protected void onInterruptedIOException(InterruptedIOException eException) {
            }

            @Override
            public void setDatagramSocket(DatagramSocket socket) {
                super.setDatagramSocket(socket);
            }

            @Override
            protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
                if (!this.getCluster().isTransportServiceEnabled() || cbActualSize < cbMinimumSize) {
                    super.validateBufferSize(sBufferName, cbActualSize, cbRequestedSize, cbMinimumSize);
                }
            }
        }
    }

    public static class TransportService
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.TransportService {
        private boolean __m_Enabled;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Acknowledgement", Acknowledgement.get_CLASS());
            __mapChildren.put("BusEventMessage", BusEventMessage.get_CLASS());
            __mapChildren.put("ConfigRequest", ConfigRequest.get_CLASS());
            __mapChildren.put("ConfigResponse", ConfigResponse.get_CLASS());
            __mapChildren.put("ConfigSync", ConfigSync.get_CLASS());
            __mapChildren.put("ConfigUpdate", ConfigUpdate.get_CLASS());
            __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
            __mapChildren.put("DispatchNotification", DispatchNotification.get_CLASS());
            __mapChildren.put("Heartbeat", Heartbeat.get_CLASS());
            __mapChildren.put("MemberConfigUpdate", MemberConfigUpdate.get_CLASS());
            __mapChildren.put("MemberJoined", MemberJoined.get_CLASS());
            __mapChildren.put("MemberWelcome", MemberWelcome.get_CLASS());
            __mapChildren.put("MemberWelcomeRequest", MemberWelcomeRequest.get_CLASS());
            __mapChildren.put("MemberWelcomeRequestTask", MemberWelcomeRequestTask.get_CLASS());
            __mapChildren.put("MessageHandler", MessageHandler.get_CLASS());
            __mapChildren.put("NotifyConnectionClose", NotifyConnectionClose.get_CLASS());
            __mapChildren.put("NotifyConnectionOpen", NotifyConnectionOpen.get_CLASS());
            __mapChildren.put("NotifyMemberJoined", NotifyMemberJoined.get_CLASS());
            __mapChildren.put("NotifyMemberLeaving", NotifyMemberLeaving.get_CLASS());
            __mapChildren.put("NotifyMemberLeft", NotifyMemberLeft.get_CLASS());
            __mapChildren.put("NotifyMessageReceipt", NotifyMessageReceipt.get_CLASS());
            __mapChildren.put("NotifyPollClosed", NotifyPollClosed.get_CLASS());
            __mapChildren.put("NotifyResponse", NotifyResponse.get_CLASS());
            __mapChildren.put("NotifyServiceAnnounced", NotifyServiceAnnounced.get_CLASS());
            __mapChildren.put("NotifyServiceJoining", NotifyServiceJoining.get_CLASS());
            __mapChildren.put("NotifyServiceLeaving", NotifyServiceLeaving.get_CLASS());
            __mapChildren.put("NotifyServiceLeft", NotifyServiceLeft.get_CLASS());
            __mapChildren.put("NotifyServiceQuiescence", NotifyServiceQuiescence.get_CLASS());
            __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
            __mapChildren.put("NotifyStartup", NotifyStartup.get_CLASS());
            __mapChildren.put("PingRequest", PingRequest.get_CLASS());
            __mapChildren.put("ProtocolContext", ProtocolContext.get_CLASS());
            __mapChildren.put("Response", Response.get_CLASS());
            __mapChildren.put("WrapperGuardable", WrapperGuardable.get_CLASS());
        }

        public TransportService() {
            this(null, null, true);
        }

        public TransportService(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setMessageClassMap(new HashMap());
                this.setNotifier(new SingleWaiterMultiNotifier());
                this.setOldestPendingRequestSUIDCounter(new AtomicLong());
                this.setResourceRegistry(new SimpleResourceRegistry());
                this.setSerializerMap(new WeakHashMap());
                this.setServiceName("TransportService");
                this.setSuspendPollLimit(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new DaemonPool("DaemonPool", this, true), "DaemonPool");
            this._addChild(new EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
            this._addChild(new Guard("Guard", this, true), "Guard");
            this._addChild(new Grid.MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
            this._addChild(new PollArray("PollArray", this, true), "PollArray");
            this._addChild(new Grid.ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
            this._addChild(new ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TransportService();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void halt() {
            ((MessageHandler)this.getMessageHandler()).halt();
            super.halt();
        }

        public boolean isEnabled() {
            return this.__m_Enabled;
        }

        @Override
        public void onException(Throwable e) {
            Cluster cluster = (Cluster)this.get_Module();
            try {
                if (cluster.getState() < 3) {
                    super.onException(e);
                }
            }
            finally {
                cluster.onException(e);
            }
        }

        public void setEnabled(boolean fEnabled) {
            this.__m_Enabled = fEnabled;
        }

        @Override
        public void stop() {
            Cluster cluster = (Cluster)this.getCluster();
            if (this.isAcceptingClients() && cluster.getState() < 4) {
                TransportService._trace("Requested to stop transport service.", 1);
                cluster.stop();
            } else {
                super.stop();
            }
        }

        static {
            TransportService.__initStatic();
        }

        public static class Acknowledgement
        extends Grid.Acknowledgement {
            public Acknowledgement() {
                this(null, null, true);
            }

            public Acknowledgement(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Acknowledgement();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$Acknowledgement".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class BusEventMessage
        extends Grid.BusEventMessage {
            public BusEventMessage() {
                this(null, null, true);
            }

            public BusEventMessage(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-21);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new BusEventMessage();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$BusEventMessage".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigRequest
        extends Grid.ConfigRequest {
            public ConfigRequest() {
                this(null, null, true);
            }

            public ConfigRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-15);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Grid.ConfigRequest.Poll("Poll", this, true), "Poll");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ConfigRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigResponse
        extends Grid.ConfigResponse {
            public ConfigResponse() {
                this(null, null, true);
            }

            public ConfigResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-16);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ConfigResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigSync
        extends Grid.ConfigSync {
            public ConfigSync() {
                this(null, null, true);
            }

            public ConfigSync(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-17);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigSync();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ConfigSync".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ConfigUpdate
        extends Grid.ConfigUpdate {
            public ConfigUpdate() {
                this(null, null, true);
            }

            public ConfigUpdate(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-18);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ConfigUpdate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ConfigUpdate".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class DispatchEvent
        extends Grid.DispatchEvent {
            public DispatchEvent() {
                this(null, null, true);
            }

            public DispatchEvent(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DispatchEvent();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DispatchEvent".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class DispatchNotification
        extends Grid.DispatchNotification {
            public DispatchNotification() {
                this(null, null, true);
            }

            public DispatchNotification(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DispatchNotification();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DispatchNotification".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class Heartbeat
        extends TransportService.Heartbeat {
            public Heartbeat() {
                this(null, null, true);
            }

            public Heartbeat(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(33);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Heartbeat();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$Heartbeat".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberConfigUpdate
        extends Grid.MemberConfigUpdate {
            public MemberConfigUpdate() {
                this(null, null, true);
            }

            public MemberConfigUpdate(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-3);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberConfigUpdate();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MemberConfigUpdate".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberJoined
        extends Grid.MemberJoined {
            public MemberJoined() {
                this(null, null, true);
            }

            public MemberJoined(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(4);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberJoined();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MemberJoined".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberWelcome
        extends Grid.MemberWelcome {
            public MemberWelcome() {
                this(null, null, true);
            }

            public MemberWelcome(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-2);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberWelcome();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MemberWelcome".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MemberWelcomeRequest
        extends Grid.MemberWelcomeRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public MemberWelcomeRequest() {
                this(null, null, true);
            }

            public MemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberWelcomeRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MemberWelcomeRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                MemberWelcomeRequest.__initStatic();
            }

            public static class Poll
            extends Grid.MemberWelcomeRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MemberWelcomeRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class MemberWelcomeRequestTask
        extends Grid.MemberWelcomeRequestTask {
            public MemberWelcomeRequestTask() {
                this(null, null, true);
            }

            public MemberWelcomeRequestTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MemberWelcomeRequestTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MemberWelcomeRequestTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class MessageHandler
        extends TransportService.MessageHandler {
            private ClusterService __m_ClusterService;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Connection", Connection.get_CLASS());
            }

            public MessageHandler() {
                this(null, null, true);
            }

            public MessageHandler(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setConnectionMap(new SafeHashMap());
                    this.setGlobalBacklogMonitor(new Object());
                    this.setStatsBusBytesOutBuffered(new AtomicLong());
                    this.setStatsDrainOverflowDuration(new LongAdder());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new EventCollector("EventCollector", this, true), "EventCollector");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new MessageHandler();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MessageHandler".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public int compareImportance(Member member) {
                return this.getClusterService().compareImportance(member);
            }

            public ClusterService getClusterService() {
                return this.__m_ClusterService;
            }

            @Override
            public Grid getServiceById(int nSvcId) {
                return this.getClusterService().getService(nSvcId);
            }

            public void halt() {
                this.getMessageBus().close();
            }

            @Override
            public void onInit() {
                super.onInit();
                this.setClusterService((ClusterService)((Cluster)this.get_Module())._findChild("ClusterService"));
            }

            public void setClusterService(ClusterService serviceCluster) {
                this.__m_ClusterService = serviceCluster;
            }

            static {
                MessageHandler.__initStatic();
            }

            public static class Connection
            extends TransportService.MessageHandler.Connection {
                public Connection() {
                    this(null, null, true);
                }

                public Connection(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Connection();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MessageHandler$Connection".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class EventCollector
            extends TransportService.MessageHandler.EventCollector {
                public EventCollector() {
                    this(null, null, true);
                }

                public EventCollector(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new EventCollector();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$MessageHandler$EventCollector".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class NotifyConnectionClose
        extends Grid.NotifyConnectionClose {
            public NotifyConnectionClose() {
                this(null, null, true);
            }

            public NotifyConnectionClose(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-24);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyConnectionClose();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyConnectionClose".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyConnectionOpen
        extends Grid.NotifyConnectionOpen {
            public NotifyConnectionOpen() {
                this(null, null, true);
            }

            public NotifyConnectionOpen(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-23);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyConnectionOpen();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyConnectionOpen".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMemberJoined
        extends Grid.NotifyMemberJoined {
            public NotifyMemberJoined() {
                this(null, null, true);
            }

            public NotifyMemberJoined(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-4);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMemberJoined();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyMemberJoined".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMemberLeaving
        extends Grid.NotifyMemberLeaving {
            public NotifyMemberLeaving() {
                this(null, null, true);
            }

            public NotifyMemberLeaving(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-5);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMemberLeaving();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyMemberLeaving".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMemberLeft
        extends Grid.NotifyMemberLeft {
            public NotifyMemberLeft() {
                this(null, null, true);
            }

            public NotifyMemberLeft(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-6);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMemberLeft();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyMemberLeft".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyMessageReceipt
        extends Grid.NotifyMessageReceipt {
            public NotifyMessageReceipt() {
                this(null, null, true);
            }

            public NotifyMessageReceipt(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-7);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyMessageReceipt();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyMessageReceipt".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyPollClosed
        extends Grid.NotifyPollClosed {
            public NotifyPollClosed() {
                this(null, null, true);
            }

            public NotifyPollClosed(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-8);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyPollClosed();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyPollClosed".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyResponse
        extends Grid.NotifyResponse {
            public NotifyResponse() {
                this(null, null, true);
            }

            public NotifyResponse(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-20);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyResponse();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyResponse".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceAnnounced
        extends Grid.NotifyServiceAnnounced {
            public NotifyServiceAnnounced() {
                this(null, null, true);
            }

            public NotifyServiceAnnounced(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-9);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceAnnounced();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyServiceAnnounced".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceJoining
        extends Grid.NotifyServiceJoining {
            public NotifyServiceJoining() {
                this(null, null, true);
            }

            public NotifyServiceJoining(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-10);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Grid.NotifyServiceJoining.Poll("Poll", this, true), "Poll");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceJoining();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyServiceJoining".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceLeaving
        extends Grid.NotifyServiceLeaving {
            public NotifyServiceLeaving() {
                this(null, null, true);
            }

            public NotifyServiceLeaving(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-11);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceLeaving();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyServiceLeaving".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceLeft
        extends Grid.NotifyServiceLeft {
            public NotifyServiceLeft() {
                this(null, null, true);
            }

            public NotifyServiceLeft(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-12);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceLeft();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyServiceLeft".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyServiceQuiescence
        extends Grid.NotifyServiceQuiescence {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public NotifyServiceQuiescence() {
                this(null, null, true);
            }

            public NotifyServiceQuiescence(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-22);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyServiceQuiescence();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyServiceQuiescence".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                NotifyServiceQuiescence.__initStatic();
            }

            public static class Poll
            extends Grid.NotifyServiceQuiescence.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyServiceQuiescence$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class NotifyShutdown
        extends Grid.NotifyShutdown {
            public NotifyShutdown() {
                this(null, null, true);
            }

            public NotifyShutdown(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-13);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyShutdown();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyShutdown".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class NotifyStartup
        extends Grid.NotifyStartup {
            public NotifyStartup() {
                this(null, null, true);
            }

            public NotifyStartup(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(-14);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new NotifyStartup();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$NotifyStartup".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class PingRequest
        extends Grid.PingRequest {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Poll", Poll.get_CLASS());
            }

            public PingRequest() {
                this(null, null, true);
            }

            public PingRequest(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(3);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PingRequest();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$PingRequest".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                PingRequest.__initStatic();
            }

            public static class Poll
            extends Grid.PingRequest.Poll {
                public Poll() {
                    this(null, null, true);
                }

                public Poll(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Poll();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$PingRequest$Poll".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ProtocolContext
        extends Grid.ProtocolContext {
            public ProtocolContext() {
                this(null, null, true);
            }

            public ProtocolContext(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ProtocolContext();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ProtocolContext".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class Response
        extends Grid.Response {
            public Response() {
                this(null, null, true);
            }

            public Response(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setMessageType(2);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Response();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$Response".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class WrapperGuardable
        extends Grid.WrapperGuardable {
            public WrapperGuardable() {
                this(null, null, true);
            }

            public WrapperGuardable(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WrapperGuardable();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$WrapperGuardable".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class DaemonPool
        extends Grid.DaemonPool {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Daemon", Daemon.get_CLASS());
                __mapChildren.put("ResizeTask", ResizeTask.get_CLASS());
                __mapChildren.put("ScheduleTask", ScheduleTask.get_CLASS());
                __mapChildren.put("StartTask", StartTask.get_CLASS());
                __mapChildren.put("StopTask", StopTask.get_CLASS());
                __mapChildren.put("WorkSlot", WorkSlot.get_CLASS());
                __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
            }

            public DaemonPool() {
                this(null, null, true);
            }

            public DaemonPool(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setAbandonThreshold(8);
                    this.setDaemonCountMax(Integer.MAX_VALUE);
                    this.setDaemonCountMin(1);
                    this.setScheduledTasks(new HashSet());
                    this.setStatsTaskAddCount(new AtomicLong());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new DaemonPool();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                DaemonPool.__initStatic();
            }

            public static class Daemon
            extends Grid.DaemonPool.Daemon {
                public Daemon() {
                    this(null, null, true);
                }

                public Daemon(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setDaemonState(0);
                        this.setDefaultGuardRecovery(0.9f);
                        this.setDefaultGuardTimeout(60000L);
                        this.setNotifier(new SingleWaiterMultiNotifier());
                        this.setThreadName("Worker");
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this._addChild(new Guard("Guard", this, true), "Guard");
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Daemon();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$Daemon".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                public static class Guard
                extends Service.DaemonPool.Daemon.Guard {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Abandon", Abandon.get_CLASS());
                    }

                    public Guard() {
                        this(null, null, true);
                    }

                    public Guard(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Guard();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$Daemon$Guard".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        Guard.__initStatic();
                    }

                    public static class Abandon
                    extends Service.DaemonPool.Daemon.Guard.Abandon {
                        public Abandon() {
                            this(null, null, true);
                        }

                        public Abandon(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Abandon();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$Daemon$Guard$Abandon".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }
            }

            public static class ResizeTask
            extends Service.DaemonPool.ResizeTask {
                public ResizeTask() {
                    this(null, null, true);
                }

                public ResizeTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new ResizeTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$ResizeTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class ScheduleTask
            extends Service.DaemonPool.ScheduleTask {
                public ScheduleTask() {
                    this(null, null, true);
                }

                public ScheduleTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new ScheduleTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$ScheduleTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class StartTask
            extends Service.DaemonPool.StartTask {
                public StartTask() {
                    this(null, null, true);
                }

                public StartTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StartTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$StartTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class StopTask
            extends Service.DaemonPool.StopTask {
                public StopTask() {
                    this(null, null, true);
                }

                public StopTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StopTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$StopTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class WorkSlot
            extends Service.DaemonPool.WorkSlot {
                public WorkSlot() {
                    this(null, null, true);
                }

                public WorkSlot(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setIndex(-1);
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new WorkSlot();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$WorkSlot".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }

            public static class WrapperTask
            extends Service.DaemonPool.WrapperTask {
                public WrapperTask() {
                    this(null, null, true);
                }

                public WrapperTask(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new WrapperTask();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$DaemonPool$WrapperTask".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class EventDispatcher
        extends Grid.EventDispatcher {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Queue", Queue.get_CLASS());
            }

            public EventDispatcher() {
                this(null, null, true);
            }

            public EventDispatcher(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setCloggedCount(1024);
                    this.setCloggedDelay(32);
                    this.setDaemonState(0);
                    this.setDefaultGuardRecovery(0.9f);
                    this.setDefaultGuardTimeout(60000L);
                    this.setNotifier(new SingleWaiterMultiNotifier());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Service.EventDispatcher.Guard("Guard", this, true), "Guard");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new EventDispatcher();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$EventDispatcher".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                EventDispatcher.__initStatic();
            }

            public static class Queue
            extends Service.EventDispatcher.Queue {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public Queue() {
                    this(null, null, true);
                }

                public Queue(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setElementList(new RecyclingLinkedList());
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Queue();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$EventDispatcher$Queue".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Queue.__initStatic();
                }

                public static class Iterator
                extends Service.EventDispatcher.Queue.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$EventDispatcher$Queue$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }

        public static class Guard
        extends Grid.Guard {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("StopService", StopService.get_CLASS());
            }

            public Guard() {
                this(null, null, true);
            }

            public Guard(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Guard();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$Guard".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Guard.__initStatic();
            }

            public static class StopService
            extends Grid.Guard.StopService {
                public StopService() {
                    this(null, null, true);
                }

                public StopService(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new StopService();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$Guard$StopService".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class PollArray
        extends Grid.PollArray {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("PlaceHolder", PlaceHolder.get_CLASS());
            }

            public PollArray() {
                this(null, null, true);
            }

            public PollArray(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setExpiryMap(new NullableSortedMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PollArray();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$PollArray".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                PollArray.__initStatic();
            }

            public static class PlaceHolder
            extends Grid.PollArray.PlaceHolder {
                public PlaceHolder() {
                    this(null, null, true);
                }

                public PlaceHolder(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    try {
                        this.setVirtualOffset(-1L);
                    }
                    catch (Exception e) {
                        throw new WrapperException(e);
                    }
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new PlaceHolder();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$PollArray$PlaceHolder".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ServiceConfig
        extends Grid.ServiceConfig {
            public ServiceConfig() {
                this(null, null, true);
            }

            public ServiceConfig(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setPendingConfigUpdates(new LinkedList());
                    this.setPendingPolls(new LiteMap());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new ServiceConfig.ConfigListener("ConfigListener", this, true), "ConfigListener");
                this._addChild(new Map("Map", this, true), "Map");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ServiceConfig();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public static class Map
            extends Grid.ServiceConfig.Map {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("EntrySet", EntrySet.get_CLASS());
                    __mapChildren.put("KeySet", KeySet.get_CLASS());
                    __mapChildren.put("Values", Values.get_CLASS());
                }

                public Map() {
                    this(null, null, true);
                }

                public Map(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Map();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Map.__initStatic();
                }

                public static class EntrySet
                extends Grid.ServiceConfig.Map.EntrySet {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Entry", Entry.get_CLASS());
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public EntrySet() {
                        this(null, null, true);
                    }

                    public EntrySet(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new EntrySet();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$EntrySet".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected java.util.Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        EntrySet.__initStatic();
                    }

                    public static class Entry
                    extends Grid.ServiceConfig.Map.EntrySet.Entry {
                        public Entry() {
                            this(null, null, true);
                        }

                        public Entry(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Entry();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$EntrySet$Entry".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }

                    public static class Iterator
                    extends Grid.ServiceConfig.Map.EntrySet.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$EntrySet$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class KeySet
                extends Grid.ServiceConfig.Map.KeySet {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public KeySet() {
                        this(null, null, true);
                    }

                    public KeySet(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new KeySet();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$KeySet".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected java.util.Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        KeySet.__initStatic();
                    }

                    public static class Iterator
                    extends Grid.ServiceConfig.Map.KeySet.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$KeySet$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }

                public static class Values
                extends Grid.ServiceConfig.Map.Values {
                    private static ListMap __mapChildren;

                    private static void __initStatic() {
                        __mapChildren = new ListMap();
                        __mapChildren.put("Iterator", Iterator.get_CLASS());
                    }

                    public Values() {
                        this(null, null, true);
                    }

                    public Values(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Values();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$Values".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }

                    @Override
                    protected java.util.Map get_ChildClasses() {
                        return __mapChildren;
                    }

                    static {
                        Values.__initStatic();
                    }

                    public static class Iterator
                    extends Grid.ServiceConfig.Map.Values.Iterator {
                        public Iterator() {
                            this(null, null, true);
                        }

                        public Iterator(String sName, Component compParent, boolean fInit) {
                            super(sName, compParent, false);
                            if (fInit) {
                                this.__init();
                            }
                        }

                        @Override
                        public void __init() {
                            this.__initPrivate();
                            this.set_Constructed(true);
                        }

                        @Override
                        protected void __initPrivate() {
                            super.__initPrivate();
                        }

                        public static Component get_Instance() {
                            return new Iterator();
                        }

                        public static Class get_CLASS() {
                            Class<?> clz;
                            try {
                                clz = Class.forName("com.tangosol.coherence/component/net/Cluster$TransportService$ServiceConfig$Map$Values$Iterator".replace('/', '.'));
                            }
                            catch (ClassNotFoundException e) {
                                throw new NoClassDefFoundError(e.getMessage());
                            }
                            return clz;
                        }

                        private Component get_Module() {
                            return this.get_Parent().get_Parent().get_Parent().get_Parent().get_Parent();
                        }
                    }
                }
            }
        }
    }
}

