/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.application.console;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Data;
import com.tangosol.coherence.component.application.Console;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.jmxHelper.HttpAdapter;
import com.tangosol.coherence.component.net.jmxHelper.ServerConnector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.transactionCache.Local;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.dslquery.QueryPlus;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.dev.component.ComponentClassLoader;
import com.tangosol.dev.component.NullStorage;
import com.tangosol.internal.net.logging.DefaultLoggingDependencies;
import com.tangosol.internal.net.logging.LegacyXmlLoggingHelper;
import com.tangosol.internal.net.management.DefaultGatewayDependencies;
import com.tangosol.internal.net.management.LegacyXmlGatewayHelper;
import com.tangosol.internal.util.MapBackupHelper;
import com.tangosol.internal.util.ObjectFormatter;
import com.tangosol.internal.util.listener.VersionAwareListeners;
import com.tangosol.io.ReadBuffer;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.InvocationService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.SimplePartitionKey;
import com.tangosol.net.security.SimpleHandler;
import com.tangosol.run.jca.SimpleValidator;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.CompositeKey;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.PrimitiveSparseArray;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.UID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.Versionable;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.QueryRecorder;
import com.tangosol.util.comparator.ChainedComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ConditionalExtractor;
import com.tangosol.util.extractor.DeserializationAccelerator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.FilterTrigger;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.AsynchronousProcessor;
import com.tangosol.util.processor.ConditionalProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.security.auth.Subject;

public class Coherence
extends Console {
    private static transient String __s_BuildNumber;
    private static transient SafeCluster __s_Cluster;
    private transient List __m_CommandHistory;
    private static volatile boolean __s_ConfigurationLoaded;
    public static final String COPYRIGHT = "Copyright (c) 2000, 2024, Oracle and/or its affiliates. All rights reserved.";
    public static final String DEFAULT_EDITION = "GE";
    public static final String DEFAULT_MODE = "development";
    private int __m_Edition;
    public static final String[] EDITION_NAMES;
    public static final String FILE_CFG_CERTIFICATE = "tangosol.cer";
    public static final String FILE_CFG_COHERENCE = "/tangosol-coherence.xml";
    public static final String FILE_CFG_COHERENCE_OVERRIDE = "/tangosol-coherence-override.xml";
    private transient Map __m_Filters;
    private static transient boolean __s_LicenseLoaded;
    private transient Logger __m_Logger;
    private transient AtomicReference __m_LoggerRef;
    private transient NamedCache __m_Map;
    private int __m_Mode;
    public static final String[] MODE_NAMES;
    private PersistenceToolsHelper __m_PersistenceToolsHelper;
    private transient String __m_Product;
    private boolean __m_Script;
    private ScriptEngine __m_ScriptEngine;
    private transient CacheService __m_Service;
    private static Map __s_ServiceConfigMap;
    private transient boolean __m_Stop;
    public static final String TITLE = "Oracle Coherence";
    private static transient ThreadLocal __s_TloCluster;
    public static final String VERSION;
    public static final int VERSION_INT;
    public static final String VERSION_INTERNAL;
    private static ListMap __mapChildren;

    private static void _initStatic$Default() {
        Coherence.__initStatic();
    }

    private static void __initStatic() {
        try {
            Coherence.setServiceConfigMap(new SafeHashMap());
            __s_TloCluster = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        __mapChildren = new ListMap();
        __mapChildren.put("CacheItem", CacheItem.get_CLASS());
        __mapChildren.put("Logger", Logger.get_CLASS());
        __mapChildren.put("Worker", Worker.get_CLASS());
    }

    public Coherence() {
        this(null, null, true);
    }

    public Coherence(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        if (__singleton != null) {
            throw new IllegalStateException("A singleton for \"Coherence\" has already been set");
        }
        __singleton = this;
        this.__initPrivate();
        try {
            this.setCommandHistory(new LinkedList());
            this.setLoggerRef(new AtomicReference());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        Component singleton = __singleton;
        if (singleton == null) {
            singleton = new Coherence();
        } else if (!(singleton instanceof Coherence)) {
            throw new IllegalStateException("A singleton for \"com.tangosol.coherence.component.application.console.Coherence\" has already been set to a different type");
        }
        return singleton;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected Set applyFilter(String sFilter, boolean fKeysOnly, Comparator comparator, int nPage) {
        try {
            LimitFilter filterLimit;
            Filter filter = (Filter)this.getFilters().get(sFilter);
            Set<Object> setEntry = null;
            if (filter instanceof LimitFilter) {
                filterLimit = (LimitFilter)filter;
                if (nPage >= 0) {
                    filterLimit.setPage(nPage);
                }
                filterLimit.setComparator(comparator);
            }
            setEntry = fKeysOnly ? this.getMap().keySet(filter) : (comparator != null ? this.getMap().entrySet(filter, comparator) : this.getMap().entrySet(filter));
            if (filter instanceof LimitFilter && nPage < 0) {
                filterLimit = (LimitFilter)filter;
                if (setEntry.size() < filterLimit.getPageSize()) {
                    filterLimit.setPage(0);
                } else {
                    filterLimit.nextPage();
                }
            }
            return setEntry;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected static String calculateAttribute(String sAttr) {
        String MODE = "{mode}";
        if (sAttr.indexOf("{mode}") >= 0) {
            XmlElement xmlLicense = (XmlElement)Coherence.getServiceConfigMap().get("$License");
            sAttr = Base.replace(sAttr, "{mode}", xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE));
        }
        while (sAttr.startsWith("{") && sAttr.endsWith("}")) {
            String sDefault;
            String sPropName;
            int ofDefault = sAttr.indexOf(32);
            int cchLength = sAttr.length();
            if (ofDefault < 0) {
                sDefault = sPropName = sAttr.substring(1, cchLength - 1);
            } else {
                sPropName = sAttr.substring(1, ofDefault);
                sDefault = sAttr.substring(ofDefault + 1, cchLength - 1);
            }
            sAttr = Config.getProperty(sPropName, sDefault);
        }
        return sAttr;
    }

    protected Object convertArgument(String sParam) {
        String sValue;
        int ofStart = sParam.indexOf(123);
        if (ofStart == 0) {
            if (sParam.equals("{cluster}")) {
                return Coherence.getSafeCluster();
            }
            if (sParam.startsWith("{composite:")) {
                String sArgs = sParam.substring(11, sParam.length() - 1).trim();
                int iSplit = sArgs.indexOf(44);
                return new CompositeKey<Object, Object>(this.convertArgument(sArgs.substring(0, iSplit).trim()), this.convertArgument(sArgs.substring(iSplit + 1).trim()));
            }
            if (sParam.equals("{Date}")) {
                return new Date(Base.getSafeTimeMillis());
            }
            if (sParam.equals("{date}")) {
                return new Date(Coherence.getSafeCluster().getTimeMillis());
            }
            if (sParam.equals("{map}")) {
                return this.getMap();
            }
            if (sParam.equals("{com.tangosol.net.Member}")) {
                return Coherence.getSafeCluster().getLocalMember();
            }
            if (sParam.startsWith("{partition:")) {
                Integer NPart = (Integer)this.convertArgument(sParam.substring(11, sParam.length() - 1));
                return SimplePartitionKey.getPartitionKey(NPart);
            }
            if (sParam.equals("{random}")) {
                return Base.getRandom().nextInt();
            }
            if (sParam.equals("{result}")) {
                return ((ThreadLocal)this.get_Sink()).get();
            }
            if (sParam.equals("{service}")) {
                return this.getService();
            }
            if (sParam.equals("{time}")) {
                return Coherence.getSafeCluster().getTimeMillis();
            }
            if (sParam.endsWith("}")) {
                sValue = sParam.substring(1, sParam.length() - 1);
                if (sValue.charAt(0) == '#') {
                    int ofIter = sValue.indexOf(32);
                    String sIter = sValue.substring(1, ofIter);
                    int cIters = Integer.parseInt(sIter);
                    if (ofIter > 0) {
                        Object[] aoValue = new Object[cIters];
                        sValue = sValue.substring(ofIter + 1);
                        for (int i = 0; i < cIters; ++i) {
                            String s = sValue.indexOf(35) >= 0 ? Base.replace(sValue, "#", String.valueOf(i)) : sValue;
                            aoValue[i] = this.convertArgument(s);
                        }
                        return new ImmutableArrayList(aoValue);
                    }
                } else {
                    if (sValue.indexOf(44) >= 0) {
                        Object[] aoValue = sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString(sValue, ','));
                        return new ImmutableArrayList(aoValue);
                    }
                    if (sValue.startsWith("filter:")) {
                        String sFilter = sValue.substring(sValue.indexOf(58) + 1);
                        return (Filter)this.getFilters().get(sFilter);
                    }
                }
            } else {
                throw new RuntimeException("Unbalanced {} in parameter: " + sParam + "; quotes may need to be used");
            }
        }
        if (ofStart >= 0) {
            int ofEnd;
            int cR;
            String[][] aasReplace = null;
            try {
                SafeCluster cluster = Coherence.getSafeCluster();
                long dtTime = cluster.getTimeMillis();
                com.tangosol.net.Member member = cluster.getLocalMember();
                aasReplace = new String[][]{{"{Date}", String.valueOf(new Date(Base.getSafeTimeMillis()))}, {"{date}", String.valueOf(new Date(dtTime))}, {"{random}", String.valueOf(Base.getRandom().nextInt())}, {"{result}", String.valueOf(((ThreadLocal)this.get_Sink()).get())}, {"{time}", String.valueOf(dtTime)}, {"{com.tangosol.net.Member}", String.valueOf(member)}, {"{member}", member == null ? "0" : String.valueOf(member.getId())}};
            }
            catch (Exception cluster) {
                // empty catch block
            }
            int n = cR = aasReplace == null ? 0 : aasReplace.length;
            for (int iR = 0; iR < cR; ++iR) {
                void asReplace = aasReplace[iR];
                sParam = Base.replace(sParam, (String)asReplace[0], (String)asReplace[1]);
            }
            int ofBegin = sParam.indexOf("{random:");
            if (ofBegin >= 0 && (ofEnd = sParam.indexOf(125, ofBegin)) > ofBegin) {
                int iMax;
                String sMax = sParam.substring(ofBegin + "{random:".length(), ofEnd);
                int ofRnd = sMax.indexOf(44);
                if (ofRnd >= 0) {
                    int iofRnd = ofRnd;
                    ofRnd = Integer.parseInt(sMax.substring(0, ofRnd));
                    sMax = sMax.substring(iofRnd + 1);
                }
                int n2 = iMax = sMax.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(sMax);
                int iRand = iMax > 0 ? Base.getRandom().nextInt(iMax) : (iMax < 0 ? (int)((double)(-iMax) * Base.getRandom().nextDouble() * Base.getRandom().nextDouble()) : (int)Math.abs(2.147483647E9 * Base.getRandom().nextGaussian()));
                sParam = Base.replace(sParam, sParam.substring(ofBegin, ofEnd + 1), String.valueOf(iRand + ofRnd));
            }
        }
        if (sParam.startsWith("[") || sParam.startsWith("Set[") || sParam.startsWith("List[") || sParam.startsWith("PSA[")) {
            if (sParam.equals("[null]")) {
                return null;
            }
            if (sParam.equals("[true]")) {
                return Boolean.TRUE;
            }
            if (sParam.equals("[false]")) {
                return Boolean.FALSE;
            }
            if (sParam.endsWith("]")) {
                Object[] aoValue;
                sValue = sParam.substring(sParam.indexOf(91) + 1, sParam.length() - 1);
                String[] asElements = Base.parseDelimitedString(sValue, ',');
                if (sParam.startsWith("PSA[")) {
                    PrimitiveSparseArray la = new PrimitiveSparseArray();
                    int c = asElements.length;
                    for (int i = 0; i < c; ++i) {
                        String[] asValue = Base.parseDelimitedString(asElements[i], ':');
                        la.setPrimitive(Long.parseLong(asValue[0]), Long.parseLong(asValue[1]));
                    }
                    return la;
                }
                Object[] objectArray = aoValue = sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(asElements);
                return sParam.startsWith("Set") ? new ImmutableArrayList(aoValue).getSet() : (sParam.startsWith("List") ? new ImmutableArrayList(aoValue).getList() : aoValue);
            }
        } else {
            if (sParam.startsWith("0x")) {
                return new Binary(Base.parseHex(sParam));
            }
            if (sParam.endsWith("l")) {
                try {
                    return Long.valueOf(sParam.substring(0, sParam.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (sParam.endsWith("f")) {
                try {
                    return Float.valueOf(sParam.substring(0, sParam.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (sParam.endsWith("d")) {
                try {
                    return Double.valueOf(sParam.substring(0, sParam.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else {
                if (sParam.length() == 2 && sParam.charAt(0) == '\\') {
                    return Character.valueOf(sParam.charAt(1));
                }
                if (sParam.startsWith(" ")) {
                    return sParam.trim();
                }
                if (Character.isDigit(sParam.charAt(0))) {
                    try {
                        return Integer.valueOf(sParam);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return sParam;
    }

    public Object[] convertArguments(String[] asParam) {
        int cParams = asParam == null ? 0 : asParam.length;
        Object[] aoParam = new Object[cParams];
        Class clzUniform = null;
        for (int i = 0; i < cParams; ++i) {
            Class clzParam;
            String sParam = asParam[i];
            Object oParam = this.convertArgument(sParam);
            Class clazz = clzParam = oParam == null ? Object.class : oParam.getClass();
            clzUniform = i == 0 ? clzParam : (clzUniform == clzParam ? clzUniform : null);
            aoParam[i] = oParam;
            if (oParam == sParam) continue;
            asParam[i] = String.valueOf(oParam);
        }
        if (clzUniform != null) {
            Object[] aoParamTyped = (Object[])Array.newInstance(clzUniform, cParams);
            aoParam = Arrays.copyOf(aoParam, cParams, aoParamTyped.getClass());
        }
        return aoParam;
    }

    protected Object createReader() {
        Object reader = null;
        Object jlineReaderBldr = null;
        try {
            Class<?> clzJLineReaderBldr = Class.forName("org.jline.reader.LineReaderBuilder");
            jlineReaderBldr = ClassHelper.invokeStatic(clzJLineReaderBldr, "builder", null);
        }
        catch (Exception e) {
            return new InputStreamReader(System.in);
        }
        try {
            File fileHistory = new File(".coh-history");
            if (!fileHistory.exists()) {
                fileHistory.createNewFile();
            }
            Class<?> clzJLineReader = Class.forName("org.jline.reader.LineReader");
            String fieldHistoryFile = (String)clzJLineReader.getField("HISTORY_FILE").get(clzJLineReader);
            ClassHelper.invoke(jlineReaderBldr, "variable", new Object[]{fieldHistoryFile, fileHistory});
            return ClassHelper.invoke(jlineReaderBldr, "build", null);
        }
        catch (Exception e) {
            System.out.println("failed to setup Jline history: " + String.valueOf(e));
            return new InputStreamReader(System.in);
        }
    }

    @Override
    public void debugOutput(String message, int severity) {
        Logger logger = this.ensureRunningLogger();
        try {
            if (logger.isEnabled(severity)) {
                logger.log(severity, message);
            }
        }
        catch (Throwable error) {
            System.err.println("<Error>: Failed to write a log message");
        }
    }

    @Override
    public void debugOutput(Throwable e) {
        Logger logger = this.ensureRunningLogger();
        try {
            if (logger.isEnabled(1)) {
                logger.log(1, e);
            }
        }
        catch (Throwable error) {
            System.err.println("<Error>: Failed to write a log message");
        }
    }

    public static Message displayMessage(ReadBuffer buf, InetSocketAddress addr, ClusterService.SeniorMemberHeartbeat msgPrevHeartbeat) throws IOException {
        ClusterService.SeniorMemberHeartbeat msgCurHeartbeat;
        Broadcast packet = (Broadcast)Broadcast.instantiate(buf.getBufferInput(), 0);
        Message msg = new ClusterService().instantiateMessage(packet.getMessageType());
        msg.setDeserializationRequired(true);
        msg.setMessageType(packet.getMessageType());
        msg.setMessagePartCount(1);
        msg.setPacket(0, packet);
        ReadBuffer.BufferInput input = packet.getReadBuffer().getBufferInput();
        msg.readInternal(input);
        msg.read(input);
        ClusterService.SeniorMemberHeartbeat seniorMemberHeartbeat = msgCurHeartbeat = msg instanceof ClusterService.SeniorMemberHeartbeat ? (ClusterService.SeniorMemberHeartbeat)msg : null;
        if (msgCurHeartbeat != null && msgPrevHeartbeat != null && packet.getFromId() == msgPrevHeartbeat.getPacket(0).getFromId() && msgCurHeartbeat.getMemberSet().toString().equals(msgPrevHeartbeat.getMemberSet().toString())) {
            long lLastRecvTimestamp = msgCurHeartbeat.getLastReceivedMillis();
            String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
            Base.out("Message \"SeniorMemberHeartbeat\" (no change) LastRecvTimestamp=" + sLastRecvTimestamp);
        } else {
            Base.out(msg);
        }
        return msgCurHeartbeat;
    }

    protected void doAggregate(Object[] aoParam, boolean fSilent) {
        InvocableMap.EntryAggregator aggregator;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Coherence._trace("Aggregator name must be specified");
            return;
        }
        Object oTarget = aoParam[0];
        String sAggregator = (String)aoParam[1];
        ValueExtractor extractor = null;
        if (cParams > 2) {
            String sMethod = (String)aoParam[2];
            extractor = sMethod == null || sMethod.equals("none") ? NullImplementation.getValueExtractor() : sMethod;
        }
        try {
            Object[] objectArray;
            Class<?> clzAggregator = Class.forName("com.tangosol.util.aggregator." + sAggregator);
            if (extractor == null) {
                objectArray = ClassHelper.VOID;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = extractor;
            }
            aggregator = (InvocableMap.EntryAggregator)ClassHelper.newInstance(clzAggregator, objectArray);
        }
        catch (Throwable e) {
            Coherence.printException("Invalid aggregator format: " + sAggregator + " " + Coherence.toString(extractor) + "\n", e);
            return;
        }
        Object oResult = oTarget instanceof Filter || oTarget == null ? map.aggregate((Filter)oTarget, aggregator) : (oTarget instanceof Collection ? map.aggregate((Collection)oTarget, aggregator) : (oTarget.equals("*") ? map.aggregate(map.keySet(), aggregator) : map.aggregate(Collections.singleton(oTarget), aggregator)));
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (!fSilent) {
            Coherence._trace(String.valueOf(oResult));
        }
    }

    protected void doBackup(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Coherence._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            File file = new File(asParam[0]);
            FileOutputStream streamFile = new FileOutputStream(file);
            DataOutputStream streamData = new DataOutputStream(new BufferedOutputStream(streamFile, 32768));
            MapBackupHelper.writeMap(streamData, map);
            streamData.close();
            streamFile.close();
            if (!fSilent) {
                Coherence._trace(map.size() + " entries written to " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            }
        }
        catch (IOException e) {
            Coherence._trace("Failed to backup: " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBatch(String[] asParam, boolean fSilent) throws InterruptedException {
        if (asParam.length == 0) {
            Coherence._trace("File name is expected");
            return;
        }
        String sFile = asParam[0];
        InputStreamReader readerRaw = null;
        try {
            String sCmd;
            readerRaw = new FileReader(sFile);
            BufferedReader reader = new BufferedReader(readerRaw);
            while ((sCmd = reader.readLine()) != null) {
                if (sCmd.length() <= 0) continue;
                if (!fSilent) {
                    Coherence._trace(">>> " + sCmd);
                }
                if (sCmd.startsWith("//")) continue;
                this.processCommand(sCmd);
            }
        }
        catch (IOException e) {
            Coherence._trace("Failed to read the batch file: " + String.valueOf(e));
        }
        finally {
            try {
                readerRaw.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void doBulkPut(String[] asParam, boolean fSilent) {
        if (!this.isMapValid()) {
            return;
        }
        int cIters = 1000;
        int cbData = 1000;
        String sKey = "0";
        try {
            cIters = Integer.parseInt(asParam[0]);
            cbData = Integer.parseInt(asParam[1]);
            sKey = asParam[2];
        }
        catch (Exception e) {
            Coherence._trace("Assuming iterations=" + cIters + ", size=" + cbData);
        }
        int iFirst = 0;
        try {
            iFirst = Integer.parseInt(sKey);
            sKey = "{result}";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else if ("async".equals(sBatch)) {
                cBatch = -1;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        NamedCache cache = this.getMap();
        AsyncNamedCache cacheAsync = null;
        List listFutures = Collections.emptyList();
        if (cBatch < 0) {
            cacheAsync = cache.async();
            listFutures = new ArrayList();
        }
        cBatch = Math.abs(cBatch);
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (!fSilent) {
            Coherence._trace(String.valueOf(new Date()) + ": adding " + cIters + " items (starting with #" + iFirst + ") each " + cbData + " bytes ...");
        }
        int nOrigin = 0;
        try {
            nOrigin = this.getService().getCluster().getLocalMember().getId();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        HashMap<Object, byte[]> mapBatch = cBatch > 0 ? new HashMap<Object, byte[]>(cBatch) : null;
        Random random = new Random();
        ThreadLocal tlSink = (ThreadLocal)this.get_Sink();
        Object oResult = tlSink.get();
        long lBegin = Base.getSafeTimeMillis();
        int iLast = iFirst + cIters;
        int cB = 0;
        for (int i = iFirst; i < iLast; ++i) {
            Object oVal;
            Object oKey;
            tlSink.set(i);
            if (cbData > 0) {
                byte[] ab = new byte[cbData];
                ab[0] = (byte)random.nextInt();
                oKey = this.convertArgument(sKey);
                oVal = ab;
            } else {
                CacheItem item = new CacheItem();
                item.setIndex(i);
                item.setOrigin(nOrigin);
                oKey = cbData < 0 ? item : this.convertArgument(sKey);
                oVal = item;
            }
            if (cBatch > 0) {
                mapBatch.put(oKey, (byte[])oVal);
                if (++cB != cBatch && i + 1 != iLast) continue;
                if (cacheAsync == null) {
                    cache.putAll(mapBatch);
                } else {
                    listFutures.add(cacheAsync.putAll(mapBatch));
                }
                mapBatch.clear();
                cB = 0;
                continue;
            }
            cache.put(oKey, oVal);
        }
        tlSink.set(oResult);
        if (!fSilent) {
            if (!listFutures.isEmpty()) {
                try {
                    CompletableFuture.allOf((CompletableFuture[])listFutures.toArray()).get();
                }
                catch (Throwable i) {
                    // empty catch block
                }
            }
            long lElapsed = Base.getSafeTimeMillis() - lBegin;
            if (cbData == 0) {
                cbData = 480;
            }
            double dThrouK = (double)cIters * (double)(cbData += 4) / (double)lElapsed;
            double dThrouI = (double)cIters * 1000.0 / (double)lElapsed;
            Coherence._trace(String.valueOf(new Date()) + ": done putting (" + lElapsed + "ms, " + (int)dThrouK + "KB/sec, " + (int)dThrouI + " items/sec)");
        }
    }

    protected void doBulkRemove(String[] asParam, boolean fSilent) {
        if (!this.isMapValid()) {
            return;
        }
        int cIters = 1000;
        try {
            cIters = Integer.parseInt(asParam[0]);
        }
        catch (Exception e) {
            Coherence._trace("Assuming iterations=" + cIters);
        }
        int iFirst = 0;
        String sKey = asParam[2];
        try {
            iFirst = Integer.parseInt(sKey);
            sKey = "{result}";
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (!fSilent) {
            Coherence._trace(String.valueOf(new Date()) + ": removing " + cIters + " items (starting with #" + iFirst + ")");
        }
        boolean fResult = false;
        Set setAll = this.getMap().keySet();
        HashSet<Object> setBatch = cBatch > 0 ? new HashSet<Object>() : null;
        long lBegin = Base.getSafeTimeMillis();
        ThreadLocal tlSink = (ThreadLocal)this.get_Sink();
        Object oResult = tlSink.get();
        int iLast = iFirst + cIters;
        int cB = 0;
        for (int i = iFirst; i < iLast; ++i) {
            tlSink.set(i);
            Object oKey = this.convertArgument(sKey);
            if (cBatch > 0) {
                setBatch.add(oKey);
                if (cB++ != cBatch) continue;
                fResult |= setAll.removeAll(setBatch);
                setBatch.clear();
                cB = 0;
                continue;
            }
            fResult |= setAll.remove(oKey);
        }
        if (cBatch > 1 && !setBatch.isEmpty()) {
            fResult |= setAll.removeAll(setBatch);
        }
        tlSink.set(oResult);
        long lElapsed = Base.getSafeTimeMillis() - lBegin;
        if (!fSilent) {
            Coherence._trace(String.valueOf(new Date()) + ": done removing; result=" + fResult + " (" + lElapsed + "ms)");
        }
    }

    protected void doCache(String[] asParam, boolean fSilent) {
        boolean fCQC;
        ConfigurableCacheFactory factory = CacheFactory.getConfigurableCacheFactory();
        String sName = asParam[0];
        boolean fUnique = asParam.length > 1 && asParam[1].equals("unique");
        boolean fBinary = asParam.length > 1 && asParam[1].equals("binary");
        boolean bl = fCQC = asParam.length > 1 && this.getFilters().containsKey(asParam[1]);
        ClassLoader loader = fUnique ? this.getUniqueClassLoader() : (fBinary ? NullImplementation.getClassLoader() : null);
        NamedCache cache = CacheFactory.getCache(sName, loader);
        Object sPrompt = cache.getCacheName();
        if (fCQC) {
            cache = new ContinuousQueryCache(cache, (Filter)this.getFilters().get(asParam[1]));
            sPrompt = "CQC-" + (String)sPrompt;
        }
        this.getLogger().setPrompt((String)sPrompt);
        this.setService(cache.getCacheService());
        this.setMap(cache);
        if (!fSilent) {
            if (factory instanceof DefaultConfigurableCacheFactory) {
                DefaultConfigurableCacheFactory dccf = (DefaultConfigurableCacheFactory)factory;
                DefaultConfigurableCacheFactory.CacheInfo info = dccf.findSchemeMapping(sName);
                Coherence._trace(String.valueOf(dccf.resolveScheme(info)));
            } else if (factory instanceof ExtensibleConfigurableCacheFactory) {
                ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)factory;
                Coherence._trace(AccessController.doPrivileged(new ObjectFormatter().asPrivilegedAction("Cache Configuration: " + sName, eccf.getCacheConfig().findSchemeByCacheName(sName), eccf.getParameterResolver(sName, null, null))));
            }
        }
    }

    protected void doCacheFactory(String[] asParam, boolean fSilent) {
        ConfigurableCacheFactory factory;
        int cParams = asParam.length;
        switch (cParams) {
            case 2: {
                System.setProperty("scope-name", asParam[1]);
            }
            case 1: {
                factory = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(asParam[0], Base.getContextClassLoader());
                CacheFactory.setConfigurableCacheFactory(factory);
            }
        }
        if (!fSilent) {
            factory = CacheFactory.getConfigurableCacheFactory();
            XmlElement xmlConfig = null;
            if (factory instanceof DefaultConfigurableCacheFactory) {
                xmlConfig = ((DefaultConfigurableCacheFactory)factory).getConfig();
            } else if (factory instanceof ExtensibleConfigurableCacheFactory) {
                xmlConfig = ((ExtensibleConfigurableCacheFactory)factory).getResourceRegistry().getResource(XmlElement.class, "legacy-cache-config");
            }
            if (xmlConfig != null) {
                Coherence._trace(xmlConfig.getSafeElement("caching-scheme-mapping").toString());
            }
        }
    }

    protected void doConnector(String[] asParam, boolean fSilent) throws InterruptedException {
        int cParams = asParam.length;
        if (cParams == 0) {
            Coherence._trace("Command: connector (listener | publisher) [(unicast | multicast | p2p <ip:port> | member <id> | *) [on | off | drop <drop ratio> | pause <pause ratio> | delay <delay>]]");
            return;
        }
        Member member = null;
        HashSet<InetSocketAddress> setAddr = null;
        boolean CHANNEL_ADV = true;
        int CHANNEL_PREF = 2;
        int CHANNEL_BROAD_UDP = 4;
        int CHANNEL_BROAD_TCP = 8;
        int CHANNEL_MULTI = 16;
        int nChannels = 31;
        if (cParams >= 2) {
            char chParam = asParam[1].charAt(0);
            switch (chParam) {
                case 'u': {
                    nChannels = 15;
                    break;
                }
                case 'm': {
                    if (asParam[1].startsWith("mu")) {
                        nChannels = 16;
                        break;
                    }
                    try {
                        int nMember = Integer.parseInt(asParam[2]);
                        com.tangosol.coherence.component.net.Cluster cluster = Coherence.getSafeCluster().getCluster();
                        member = ((MemberSet)cluster.getMemberSet()).getMember(nMember);
                        setAddr = new HashSet();
                        setAddr.add(member.getSocketAddress());
                        break;
                    }
                    catch (Exception e) {
                        Coherence._trace(e);
                        return;
                    }
                }
                case 'p': {
                    setAddr = new HashSet<InetSocketAddress>();
                    for (int i = 2; i < cParams; ++i) {
                        String sParam = asParam[i];
                        if (sParam.endsWith(",")) {
                            sParam = sParam.substring(0, sParam.length() - 1);
                        } else {
                            i = cParams;
                        }
                        try {
                            int iColon = sParam.indexOf(58);
                            if (iColon == -1) {
                                Coherence._trace("address must include port");
                                return;
                            }
                            InetAddress ipAddr = iColon == 0 ? InetAddress.getLocalHost() : InetAddress.getByName(sParam.substring(0, iColon));
                            int nPort = Integer.parseInt(sParam.substring(iColon + 1));
                            setAddr.add(new InetSocketAddress(ipAddr, nPort));
                            continue;
                        }
                        catch (Exception e) {
                            Coherence._trace(e);
                            return;
                        }
                    }
                    break;
                }
            }
        }
        int cAddr = setAddr == null ? 0 : setAddr.size();
        float flRate = -1.0f;
        boolean fPause = false;
        boolean fDelay = false;
        if (cParams >= cAddr + 3) {
            String sRate = asParam[cAddr + 2];
            flRate = sRate.equals("off") ? 1.0f : (sRate.equals("on") ? 0.0f : (sRate.equals("drop") || sRate.equals("pause") ? (cParams >= cAddr + 4 ? Float.parseFloat(asParam[cAddr + 3]) : -1.0f) : (sRate.equals("delay") ? 0.0f : -1.0f)));
            fPause = sRate.equals("pause") && flRate > 0.0f && flRate < 1.0f;
            fDelay = sRate.equals("delay");
            if (flRate < 0.0f || flRate > 1.0f) {
                Coherence._trace("Ratio should be within [0.0, 1.0] interval");
                return;
            }
        }
        if (fDelay && member != null) {
            com.tangosol.coherence.component.net.Cluster cluster = Coherence.getSafeCluster().getCluster();
            long nDelay = Base.parseTime(asParam[cAddr + 3]);
            int nResendDelay = cluster.getDependencies().getPublisherResendDelayMillis();
            int nDropCount = (int)Math.ceil((float)nDelay / (float)nResendDelay);
            Coherence._trace("Each packet sent to member " + String.valueOf(member) + " will be dropped " + nDropCount + " times.");
            member.setTxDebugDropCount(nDropCount);
            return;
        }
        long lPause = (long)(10000.0f * flRate);
        int iDropRate = fPause ? 100000 : (int)(flRate * 100000.0f);
        while (true) {
            for (int nChannel = 1; nChannel <= 16; nChannel <<= 1) {
                boolean fTx;
                String sDirection;
                if ((nChannels & nChannel) == 0) continue;
                String sTarget = (this.getMap() == null ? "&" : "&getCacheService.getService.") + "getCluster";
                if (asParam[0].startsWith("l")) {
                    sDirection = "Rx";
                    fTx = false;
                    switch (nChannel) {
                        case 1: {
                            sTarget = sTarget + ".getPointListener";
                            break;
                        }
                        case 2: {
                            sTarget = sTarget + ".getPreferredListener";
                            break;
                        }
                        case 4: {
                            sTarget = sTarget + ".getUdpBroadcastListener";
                            break;
                        }
                        case 8: {
                            sTarget = sTarget + ".getTcpBroadcastListener";
                            break;
                        }
                        case 16: {
                            sTarget = sTarget + ".getUdpBroadcastListener";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown listener channel " + nChannel);
                        }
                    }
                    sTarget = sTarget + ".getUdpSocket";
                } else {
                    sDirection = "Tx";
                    fTx = true;
                    sTarget = sTarget + ".getPublisher" + (nChannel == 16 ? ".getUdpSocketMulticast" : ".getUdpSocketUnicast");
                }
                if (flRate == -1.0f) {
                    this.processCommand(sTarget);
                    continue;
                }
                UdpSocket socket = (UdpSocket)this.processCommand("@" + sTarget);
                if (socket != null) {
                    if (fTx) {
                        socket.setTxDebugDropAddresses(setAddr);
                    } else {
                        socket.setRxDebugDropAddresses(setAddr);
                    }
                }
                this.processCommand("@" + sTarget + ".set" + sDirection + "DebugDropRate " + iDropRate);
            }
            if (!fPause) break;
            ((ThreadLocal)this.get_Sink()).set(null);
            Blocking.sleep(lPause);
            lPause = 10000L - lPause;
            iDropRate = Math.abs(iDropRate - 100000);
        }
    }

    protected void doExplain(String[] asParam, boolean fSilent) {
        String sFilter = asParam[0];
        boolean fTrace = asParam.length > 1 && asParam[1].equals("trace");
        Filter filter = (Filter)this.getFilters().get(sFilter);
        if (filter != null) {
            QueryRecorder recorder = new QueryRecorder(fTrace ? QueryRecorder.RecordType.TRACE : QueryRecorder.RecordType.EXPLAIN);
            Object oResult = this.getMap().aggregate(filter, recorder);
            if (!fSilent) {
                Coherence._trace(String.valueOf(oResult));
            }
        }
    }

    protected void doFilter(Object[] aoParam, boolean fSilent) {
        Map mapFilter = this.getFilters();
        int cParams = aoParam.length;
        String sFilterName = (String)aoParam[0];
        String sFilterType = (String)aoParam[1];
        Object[] aoFilterParam = new Object[cParams - 2];
        try {
            for (int i = 2; i < cParams; ++i) {
                Object oParam = aoParam[i];
                String sParam = String.valueOf(oParam);
                Filter filter = (Filter)mapFilter.get(sParam);
                if (filter != null) {
                    oParam = filter;
                } else if (sParam.equals(".")) {
                    oParam = IdentityExtractor.INSTANCE;
                } else if (sParam.startsWith("!")) {
                    oParam = this.convertArgument(sParam.substring(1));
                    oParam = oParam == null ? new KeyExtractor((ValueExtractor)null) : new KeyExtractor((String)oParam);
                } else if (sFilterType.equals("Partitioned") && oParam instanceof Integer) {
                    DistributedCacheService service = (DistributedCacheService)this.getMap().getCacheService();
                    PartitionSet parts = new PartitionSet(service.getPartitionCount());
                    parts.add((Integer)oParam);
                    oParam = parts;
                }
                aoFilterParam[i - 2] = oParam;
            }
            if (sFilterType.equals("All") || sFilterType.equals("Any")) {
                int cFilters = aoFilterParam.length;
                Filter[] aFilter = new Filter[cFilters];
                System.arraycopy(aoFilterParam, 0, aFilter, 0, cFilters);
                aoFilterParam = new Object[]{aFilter};
            }
            Class<?> clzFilter = Class.forName("com.tangosol.util.filter." + sFilterType + "Filter");
            Filter filter = (Filter)ClassHelper.newInstance(clzFilter, aoFilterParam);
            mapFilter.put(sFilterName, filter);
            if (!fSilent) {
                Coherence._trace(String.valueOf(filter));
            }
        }
        catch (Throwable e) {
            Coherence.printException("Invalid filter format: ", e);
        }
    }

    protected Object doFunction(String sFunction, Object[] aoParam, boolean fSilent) {
        Object oTarget = null;
        boolean fSetTarget = true;
        if (sFunction.startsWith("&&") || sFunction.startsWith("&!")) {
            fSetTarget = sFunction.startsWith("&&");
            sFunction = sFunction.substring(2);
            oTarget = ((ThreadLocal)this.get_Sink()).get();
        } else if (sFunction.startsWith("&/")) {
            try {
                String sClass = sFunction.substring(2);
                int ofClz = sClass.indexOf(46);
                sFunction = sClass.substring(ofClz + 1);
                sClass = sClass.substring(0, ofClz).replace('/', '.');
                try {
                    oTarget = Class.forName(sClass);
                }
                catch (ClassNotFoundException e) {
                    oTarget = Class.forName("java.lang." + sClass);
                }
            }
            catch (Exception e) {
                Coherence._trace("Invalid format: " + String.valueOf(e));
                return e;
            }
        } else if (sFunction.startsWith("&{")) {
            int ofTarget = sFunction.indexOf(125);
            if (ofTarget > 0) {
                oTarget = this.convertArgument(sFunction.substring(1, ++ofTarget));
                if (sFunction.length() > ofTarget && sFunction.charAt(ofTarget) == '.') {
                    ++ofTarget;
                }
                sFunction = sFunction.substring(ofTarget);
            }
        } else if (sFunction.startsWith("&~")) {
            sFunction = sFunction.substring(2);
            oTarget = this;
        } else {
            sFunction = sFunction.substring(1);
            oTarget = this.getMap();
            if (oTarget == null) {
                oTarget = Coherence.getSafeCluster();
            }
        }
        if (sFunction.length() > 0) {
            oTarget = Coherence.processFunction(oTarget, sFunction, fSilent, aoParam);
        } else {
            Coherence.processFunction(oTarget, "toString", fSilent, aoParam);
        }
        if (fSetTarget) {
            ((ThreadLocal)this.get_Sink()).set(oTarget);
        }
        return oTarget;
    }

    protected void doHistory(String[] asParam, boolean fSilent) throws InterruptedException {
        List listCommands = this.getCommandHistory();
        String sPattern = null;
        int nLimit = -1;
        switch (asParam.length) {
            case 0: {
                break;
            }
            case 1: {
                if (asParam[0].equals("clear")) {
                    if (listCommands != null) {
                        listCommands.clear();
                    }
                    return;
                }
                if (asParam[0].equals("on")) {
                    if (listCommands == null) {
                        this.setCommandHistory(new LinkedList());
                    }
                    return;
                }
                if (asParam[0].equals("off")) {
                    this.setCommandHistory(null);
                    return;
                }
                try {
                    nLimit = Integer.parseInt(asParam[0]);
                }
                catch (NumberFormatException e) {
                    sPattern = asParam[0];
                }
                break;
            }
            case 2: {
                sPattern = asParam[0];
                nLimit = Integer.parseInt(asParam[1]);
                break;
            }
            default: {
                Coherence._trace("history ([<pattern>] [<limit>]) | (['on' | 'off' | 'clear'])");
                return;
            }
        }
        if (fSilent || listCommands == null) {
            return;
        }
        if (nLimit < 0) {
            nLimit = Integer.MAX_VALUE;
        }
        int cCommands = listCommands.size();
        if (sPattern == null) {
            int iCmd = Math.max(0, cCommands - nLimit);
            ListIterator iter = listCommands.listIterator(iCmd);
            while (iter.hasNext()) {
                Coherence._trace("  " + ++iCmd + "  " + String.valueOf(iter.next()));
            }
        } else {
            LinkedList<CallSite> listOut = new LinkedList<CallSite>();
            int cMatches = 0;
            int iCmd = cCommands;
            HashSet<String> setMatch = new HashSet<String>();
            Iterator iter = listCommands.listIterator(cCommands);
            while (iter.hasPrevious() && cMatches < nLimit) {
                String sCmd = (String)iter.previous();
                if ((sCmd.startsWith(sPattern) || sCmd.matches(sPattern)) && !setMatch.contains(sCmd)) {
                    setMatch.add(sCmd);
                    listOut.add(0, (CallSite)((Object)("  " + iCmd + "  " + sCmd)));
                    ++cMatches;
                }
                --iCmd;
            }
            iter = listOut.iterator();
            while (iter.hasNext()) {
                Coherence._trace((String)iter.next());
            }
        }
        Coherence._trace("\nenter !<index> to reissue a command");
    }

    protected void doIndex(String[] asParam, boolean fSilent) {
        AbstractExtractor extractor;
        boolean fFwd;
        String sMethod = asParam[0];
        boolean fRemove = asParam.length > 1 && asParam[1].equals("remove");
        Filter filter = asParam.length > 2 ? (Filter)this.getFilters().get(asParam[2]) : null;
        boolean bl = fFwd = asParam.length > 3 && Boolean.getBoolean(asParam[3]);
        if (sMethod.startsWith("!")) {
            extractor = new KeyExtractor(sMethod.substring(1));
        } else {
            AbstractExtractor abstractExtractor = sMethod.equals(".") ? IdentityExtractor.INSTANCE : (sMethod.equals("~") ? new DeserializationAccelerator() : (extractor = sMethod.indexOf(46) < 0 ? new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod)));
        }
        if (filter != null) {
            extractor = new ConditionalExtractor(filter, extractor, fFwd);
        }
        if (fRemove) {
            this.getMap().removeIndex(extractor);
        } else {
            this.getMap().addIndex(extractor, true, new SafeComparator(null));
        }
    }

    protected void doInvoke(String sService, String[] asParam, boolean fSilent) {
        InvocationService srvc;
        block18: {
            try {
                srvc = (InvocationService)CacheFactory.getService(sService);
            }
            catch (IllegalArgumentException e) {
                srvc = (InvocationService)Coherence.getCluster().getService(sService);
                if (srvc != null) break block18;
                throw e;
            }
        }
        int cParams = asParam.length;
        if (cParams == 0) {
            return;
        }
        String sCommand = asParam[0];
        String sTarget = cParams >= 2 ? asParam[1] : "all";
        boolean fAsync = cParams >= 3 && asParam[2].startsWith("a");
        int iPriority = cParams >= 4 ? Integer.parseInt(asParam[3]) : 0;
        long cTimeout = cParams >= 5 ? Long.parseLong(asParam[4]) : 0L;
        CacheItem task = new CacheItem();
        task.setInvokeCommand(sCommand);
        task.setSchedulingPriority(iPriority);
        task.setExecutionTimeoutMillis(cTimeout);
        Set setMember = null;
        if (!sTarget.equals("all")) {
            setMember = srvc.getInfo().getServiceMembers();
            if (sTarget.equals("other")) {
                setMember.remove(Coherence.getSafeCluster().getLocalMember());
            } else if (sTarget.equals("senior")) {
                setMember.clear();
                setMember.add(srvc.getInfo().getOldestMember());
            } else {
                setMember.clear();
                Set setAll = srvc.getInfo().getServiceMembers();
                try {
                    int nMember = Integer.parseInt(sTarget);
                    for (Member member : setAll) {
                        if (member.getId() != nMember) continue;
                        setMember.add(member);
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    Coherence._trace("Unknown target: " + sTarget);
                    return;
                }
            }
        }
        if (fAsync) {
            srvc.execute(task, setMember, fSilent ? null : (Worker)this._newChild("Worker"));
        } else {
            TreeMap mapResult = srvc.query(task, setMember);
            if (!fSilent) {
                if (mapResult.isEmpty()) {
                    Coherence._trace("No results");
                } else {
                    if (mapResult.size() > 1) {
                        mapResult = new TreeMap(mapResult);
                    }
                    for (Member member : mapResult.keySet()) {
                        Object oResult = mapResult.get(member);
                        Coherence._trace("Member " + (member == null ? "Proxy" : String.valueOf(member.getId())) + ", Result=" + (String)(oResult instanceof Throwable ? String.valueOf(oResult) + "\n" + Coherence.getStackTrace((Throwable)oResult) : String.valueOf(oResult)));
                    }
                }
            }
        }
    }

    protected void doJmx(String[] asParam) {
        String sName;
        int cParams = asParam.length;
        int nPort = 8082;
        String sUrl = "";
        try {
            if (cParams > 0) {
                nPort = Integer.parseInt(asParam[0]);
            }
        }
        catch (NumberFormatException e) {
            sUrl = asParam[0];
        }
        boolean fStart = cParams <= 1 || !asParam[1].equals("stop");
        String string = sName = sUrl.length() == 0 ? "Adapter" : "Connector";
        if (fStart) {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                Coherence._trace("Already started: " + String.valueOf(wrapper));
                return;
            }
            try {
                wrapper = sUrl.length() == 0 ? new HttpAdapter() : new ServerConnector();
            }
            catch (NoClassDefFoundError e) {
                Coherence._trace("JMX library is not on a classpath; only remote management is allowed");
                return;
            }
            try {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).start(nPort, Coherence.getSafeCluster());
                } else {
                    ((ServerConnector)wrapper).start(sUrl, Coherence.getSafeCluster());
                }
            }
            catch (RuntimeException e) {
                if (cParams > 1) {
                    Coherence._trace(e);
                } else {
                    Coherence._trace(e.getMessage());
                }
                return;
            }
            this._addChild(wrapper, sName);
            ((ThreadLocal)this.get_Sink()).set(wrapper);
            Coherence._trace("Installed: " + String.valueOf(wrapper));
        } else {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).stop();
                } else {
                    ((ServerConnector)wrapper).stop();
                }
                this._removeChild(wrapper);
            }
        }
    }

    protected void doList(String[] asParam, boolean fSilent) {
        Set setEntry;
        NamedCache map = this.getMap();
        int cParams = asParam.length;
        if (cParams > 0) {
            String sName = asParam[0];
            if (this.getFilters().containsKey(sName)) {
                Base comparator = null;
                int nPage = -1;
                if (cParams > 1) {
                    String[] asMethod = Base.parseDelimitedString(asParam[1], ',');
                    int cMethods = asMethod.length;
                    if (cMethods > 1) {
                        Comparator[] acomp = new Comparator[cMethods];
                        for (int i = 0; i < cMethods; ++i) {
                            String sMethod = asMethod[i];
                            acomp[i] = sMethod.startsWith("!") ? new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod);
                        }
                        comparator = new ChainedComparator(acomp);
                    } else if (asMethod[0].equals("null")) {
                        comparator = new SafeComparator(null);
                    } else {
                        String sMethod = asMethod[0];
                        Base base = comparator = sMethod.startsWith("!") ? new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod);
                    }
                    if (cParams > 2 && asParam[2].startsWith("desc")) {
                        comparator = new InverseComparator(comparator);
                    }
                    if (cParams > 3) {
                        nPage = Integer.parseInt(asParam[3]);
                    }
                }
                setEntry = this.applyFilter(sName, false, (Comparator)((Object)comparator), nPage);
            } else {
                map = this.getService().ensureCache(sName, null);
                setEntry = map.entrySet();
            }
        } else {
            setEntry = map.entrySet();
        }
        int cSize = setEntry.size();
        int cLimit = Math.min(cSize, 50);
        int c = 0;
        for (Map.Entry entry : setEntry) {
            if (c++ >= cLimit || fSilent) continue;
            Coherence._trace(String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue()));
        }
        if (cLimit < cSize && !fSilent) {
            Coherence._trace("Only " + cLimit + " out of total " + cSize + " items were printed");
        }
        if (c != cSize) {
            Coherence._trace("Iterator returned " + c + " items");
        }
        ((ThreadLocal)this.get_Sink()).set(setEntry);
    }

    protected void doListen(String sSource, boolean fStop, Filter filter, Object oKey, boolean fLite, Long LVersion, PrimitiveSparseArray laVersions) {
        NamedCache map = this.getMap();
        CacheService service = map.getCacheService();
        ObservableMap mapListen = map;
        if (sSource.equals("local")) {
            BackingMapManager mgr = service.getBackingMapManager();
            if (mgr == null) {
                Coherence._trace("Service " + service.getInfo().getServiceName() + " does not have BackingMapManager; use coherence-cache-config.xml and 'cache' command to create a cache");
                return;
            }
            String sCacheName = map.getCacheName();
            try {
                mapListen = (ObservableMap)ClassHelper.invoke(mgr, "getBackingMap", new Object[]{sCacheName});
            }
            catch (ClassCastException e) {
                Coherence._trace("Local storage for cache: " + sCacheName + " is not observable; use coherence-cache-config.xml to configure");
                return;
            }
            catch (Exception e) {
                Coherence._trace("Service " + service.getInfo().getServiceName() + " uses unsupported BackingMapManager: " + mgr.getClass().getName());
                return;
            }
            if (mapListen == null) {
                Coherence._trace("Local storage for cache: " + sCacheName + " is missing");
                return;
            }
        }
        String sWorker = "Worker!" + sSource;
        Worker worker = (Worker)this._findChild(sWorker);
        if (fStop) {
            if (sSource.startsWith("trigger")) {
                int nAction = sSource.endsWith("remove") ? 2 : (sSource.endsWith("ignore") ? 1 : 0);
                mapListen.removeMapListener(new MapTriggerListener(new FilterTrigger(filter, nAction)));
            } else if (worker == null) {
                Coherence._trace("No listener to stop");
            } else {
                if (sSource.equals("members")) {
                    service.removeMemberListener(worker);
                } else if (sSource.equals("master")) {
                    service.getCluster().ensureService("Cluster", "Cluster").removeMemberListener(worker);
                } else if (sSource.equals("service")) {
                    service.removeServiceListener(worker);
                } else if (sSource.equals("partition")) {
                    ((PartitionedService)((Object)service)).removePartitionListener(worker);
                } else if (sSource.equals("interceptor")) {
                    CacheFactory.getConfigurableCacheFactory().getInterceptorRegistry().unregisterEventInterceptor(worker.getInterceptorId());
                } else {
                    MapListener listener = worker;
                    if (sSource.endsWith("-sync")) {
                        listener = new MapListenerSupport.WrapperSynchronousListener(listener);
                    } else if (sSource.endsWith("-priming")) {
                        listener = new MapListenerSupport.WrapperPrimingListener(listener);
                    } else if (sSource.endsWith("-versioned")) {
                        listener = VersionAwareListeners.createListener(listener);
                    }
                    if (oKey == null) {
                        mapListen.removeMapListener(listener, filter);
                    } else if (oKey instanceof Set) {
                        mapListen.removeMapListener(listener, new InKeySetFilter(null, (Set)oKey));
                    } else {
                        mapListen.removeMapListener(listener, oKey);
                    }
                }
                int cRefCount = worker.getRefCount() - 1;
                if (cRefCount == 0) {
                    this._removeChild(worker);
                } else {
                    worker.setRefCount(cRefCount);
                }
            }
        } else if (sSource.startsWith("trigger")) {
            int nAction = sSource.endsWith("remove") ? 2 : (sSource.endsWith("ignore") ? 1 : 0);
            mapListen.addMapListener(new MapTriggerListener(new FilterTrigger(filter, nAction)));
        } else {
            if (worker == null) {
                worker = new Worker();
                this._addChild(worker, sWorker);
                if (sSource.charAt(0) == '@') {
                    worker.setSilent(true);
                }
            }
            if (sSource.equals("members")) {
                service.addMemberListener(worker);
            } else if (sSource.equals("master")) {
                service.getCluster().ensureService("Cluster", "Cluster").addMemberListener(worker);
            } else if (sSource.equals("service")) {
                service.addServiceListener(worker);
            } else if (sSource.equals("partition")) {
                ((PartitionedService)((Object)service)).addPartitionListener(worker);
            } else if (sSource.equals("interceptor")) {
                if (oKey instanceof String) {
                    worker.setEventTypes(new ImmutableArrayList(((String)oKey).split(",")));
                }
                String sId = CacheFactory.getConfigurableCacheFactory().getInterceptorRegistry().registerEventInterceptor(worker);
                worker.setInterceptorId(sId);
            } else {
                MapListener listener = worker;
                if (sSource.endsWith("-sync")) {
                    listener = new MapListenerSupport.WrapperSynchronousListener(listener);
                } else if (sSource.endsWith("-priming")) {
                    listener = new MapListenerSupport.WrapperPrimingListener(listener);
                } else if (sSource.endsWith("-versioned")) {
                    if (filter != null) {
                        laVersions = laVersions == null ? new PrimitiveSparseArray() : laVersions;
                    } else {
                        Long l = LVersion = LVersion == null ? Long.valueOf(0L) : LVersion;
                    }
                }
                if (oKey instanceof Set) {
                    filter = new InKeySetFilter(null, (Set)oKey);
                    oKey = null;
                }
                if (LVersion != null && service instanceof PartitionedService) {
                    int iPart = ((PartitionedService)((Object)service)).getKeyPartitioningStrategy().getKeyPartition(oKey);
                    laVersions = new PrimitiveSparseArray();
                    laVersions.setPrimitive(iPart, LVersion);
                }
                if (laVersions != null) {
                    listener = VersionAwareListeners.createListener(listener, laVersions);
                }
                if (oKey == null) {
                    mapListen.addMapListener(listener, filter, fLite);
                } else {
                    mapListen.addMapListener(listener, oKey, fLite);
                }
            }
            worker.setRefCount(worker.getRefCount() + 1);
        }
    }

    protected void doLog(Object[] aoParam, boolean fSilent) {
        int cParams = aoParam.length;
        String sMsg = null;
        int cchMsg = 50;
        if (cParams >= 1) {
            if (aoParam[0] instanceof Number) {
                cchMsg = ((Number)aoParam[0]).intValue();
                cchMsg = Math.max(1, cchMsg);
            } else {
                sMsg = String.valueOf(aoParam[0]);
                cchMsg = sMsg.length();
            }
        }
        if (sMsg == null) {
            sMsg = Base.dup('*', cchMsg);
        }
        int cIters = 1;
        if (cParams >= 2 && aoParam[1] instanceof Number) {
            cIters = ((Number)aoParam[1]).intValue();
        }
        cIters = Math.max(1, cIters);
        int nLevel = 3;
        if (cParams >= 3 && aoParam[2] instanceof Number) {
            nLevel = ((Number)aoParam[2]).intValue();
        }
        if (!fSilent) {
            Coherence._trace("Logging " + cIters + " messages of " + cchMsg + " characters at level " + nLevel + ":");
        }
        if (cIters == 1) {
            Coherence._trace(sMsg, nLevel);
        } else {
            for (int i = 1; i <= cIters; ++i) {
                Coherence._trace(i + ":" + sMsg, nLevel);
            }
        }
    }

    protected void doPersistence(String[] asParam, boolean fSilent) {
        String sOp = asParam[0];
        PersistenceToolsHelper helper = this.getPersistenceToolsHelper();
        String oResult = "Success";
        if (helper == null) {
            helper = new PersistenceToolsHelper();
            this.setPersistenceToolsHelper(helper);
        }
        try {
            if ("force".equals(sOp)) {
                helper.invokeOperation("forceRecovery", asParam[1], null, null);
                return;
            }
            if (!this.isMapValid()) {
                oResult = null;
                return;
            }
            CacheService service = this.getService();
            String sServiceName = service.getInfo().getServiceName();
            String sSnapshotName = null;
            String sOperation = null;
            int cParams = asParam.length;
            if ("list".equals(sOp)) {
                String[] asSnapshots;
                boolean fArchived = cParams == 2 && "archived".equals(asParam[1]);
                Coherence._trace((fArchived ? "Archived s" : "S") + "napshots for service " + sServiceName);
                String[] stringArray = asSnapshots = fArchived ? helper.listArchivedSnapshots(sServiceName) : helper.listSnapshots(sServiceName);
                if (asSnapshots != null) {
                    for (int i = 0; i < asSnapshots.length; ++i) {
                        Coherence._trace("    " + asSnapshots[i]);
                    }
                }
                oResult = null;
            } else {
                int i = 1;
                if ("create".equals(sOp)) {
                    sOperation = "createSnapshot";
                } else if ("recover".equals(sOp)) {
                    sOperation = "recoverSnapshot";
                } else if ("archive".equals(sOp)) {
                    sOperation = "archiveSnapshot";
                } else if ("remove".equals(sOp)) {
                    sOperation = cParams == 2 ? "removeSnapshot" : (cParams == 3 && "archived".equals(asParam[1]) ? "removeArchivedSnapshot" : null);
                    i = cParams == 3 ? 2 : 1;
                } else if ("retrieve".equals(sOp)) {
                    sOperation = cParams == 3 && "archived".equals(asParam[1]) ? "retrieveArchivedSnapshot" : null;
                    i = 2;
                } else {
                    Coherence._trace("Invalid persistence/snapshot command");
                    return;
                }
                sSnapshotName = asParam[i];
                if (!fSilent) {
                    Coherence._trace("Issuing " + sOperation + " for service " + sServiceName + " and snapshot " + sSnapshotName);
                }
                helper.invokeOperationWithWait(sOperation, sSnapshotName, sServiceName);
            }
        }
        catch (Exception e) {
            oResult = e.getMessage();
        }
        if (!fSilent && oResult != null) {
            Coherence._trace(oResult.toString());
        }
        ((ThreadLocal)this.get_Sink()).set(oResult);
    }

    protected void doProcess(Object[] aoParam, boolean fAsync, boolean fSilent) {
        Object oResult;
        InvocableMap.EntryProcessor processor;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Coherence._trace("Processor name must be specified");
            return;
        }
        int iParam = 0;
        Object oTarget = aoParam[iParam++];
        Filter filter = aoParam[iParam] instanceof Filter ? (Filter)aoParam[iParam++] : null;
        String sProcessor = (String)aoParam[iParam++];
        Object[] aoProcessorParam = new Object[cParams -= iParam];
        if (cParams > 0) {
            System.arraycopy(aoParam, iParam, aoProcessorParam, 0, cParams);
        }
        try {
            Class<?> clzProcessor = Class.forName("com.tangosol.util.processor." + sProcessor);
            processor = (ConditionalProcessor)ClassHelper.newInstance(clzProcessor, aoProcessorParam);
        }
        catch (Throwable e) {
            Coherence.printException("Invalid processor format: " + sProcessor + " " + Coherence.toString(aoProcessorParam) + "\n", e);
            return;
        }
        if (filter != null) {
            processor = new ConditionalProcessor(filter, processor);
        }
        if (fAsync) {
            processor = new AsynchronousProcessor(processor);
        }
        Object object = oTarget instanceof Filter || oTarget == null ? map.invokeAll((Filter)oTarget, processor) : (oTarget instanceof Collection ? map.invokeAll((Collection)oTarget, processor) : (oResult = oTarget.equals("*") ? map.invokeAll(map.keySet(), processor) : map.invoke(oTarget, processor)));
        if (fAsync) {
            oResult = processor;
        }
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (!fSilent) {
            Coherence._trace(String.valueOf(oResult));
        }
    }

    protected void doReissueCommand(int nCmd, String sRemainder, boolean fSilent) throws InterruptedException {
        List list = this.getCommandHistory();
        if (list == null) {
            Coherence._trace("history is off");
            return;
        }
        if (nCmd <= 0 || nCmd > list.size()) {
            Coherence._trace("history index out of range");
            return;
        }
        Object sCmd = (String)list.get(nCmd - 1);
        if (sRemainder != null && sRemainder.length() > 0) {
            sCmd = (String)(fSilent ? "@" + (String)sCmd : sCmd) + " " + sRemainder;
            this.recordCommand((String)sCmd);
        } else if (fSilent) {
            sCmd = "@" + (String)sCmd;
        }
        Coherence._trace("reissuing: " + (String)sCmd);
        this.processCommand((String)sCmd);
    }

    protected void doRepeat(String sCmd, int cIter, boolean fForce) throws InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        int cch = sCmd.length();
        int ofPrev = 0;
        while (ofPrev < cch) {
            int ofNext;
            if (sCmd.charAt(ofPrev) == '{') {
                ++ofPrev;
                ofNext = sCmd.lastIndexOf(125);
            } else {
                ofNext = sCmd.indexOf(59, ofPrev);
            }
            if (ofNext < 0) {
                list.add(sCmd.substring(ofPrev));
                break;
            }
            list.add(sCmd.substring(ofPrev, ofNext));
            ofPrev = ofNext + 1;
        }
        int cCmds = list.size();
        String[] asCmd = list.toArray(new String[cCmds]);
        block1: for (int i = 0; i < cIter; ++i) {
            ((ThreadLocal)this.get_Sink()).set(i);
            for (int j = 0; j < cCmds; ++j) {
                Object oResult;
                sCmd = asCmd[j].trim();
                if (sCmd.length() <= 0 || !((oResult = this.processCommand(sCmd)) instanceof Throwable)) continue;
                if (!fForce) break block1;
                continue block1;
            }
        }
    }

    protected void doRestore(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Coherence._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            File file = new File(asParam[0]);
            FileInputStream streamFile = new FileInputStream(file);
            DataInputStream streamData = new DataInputStream(new BufferedInputStream(streamFile, 32768));
            int cBlock = Integer.MAX_VALUE;
            if (asParam.length > 1) {
                try {
                    cBlock = Integer.parseInt(asParam[1]);
                    Coherence._assert(cBlock > 0);
                }
                catch (Exception e) {
                    Coherence._trace("Invalid block size");
                    return;
                }
            }
            int cEntries = MapBackupHelper.readMap(streamData, map, cBlock, loader);
            if (!fSilent) {
                Coherence._trace(cEntries + " entries restored from " + file.getAbsolutePath());
            }
            streamData.close();
            streamFile.close();
        }
        catch (IOException e) {
            Coherence._trace("Failed to restore: " + String.valueOf(e));
        }
    }

    protected void doScan(String[] asParam) {
        int iFirst = 1;
        int cIters = 1000;
        try {
            iFirst = Integer.parseInt(asParam[0]);
            cIters = Integer.parseInt(asParam[1]);
        }
        catch (NumberFormatException e) {
            Coherence._trace("Assuming first=" + iFirst + ", iterations=" + cIters);
        }
        NamedCache map = this.getMap();
        int iGapStart = 0;
        int iGapEnd = 0;
        int iLast = iFirst + cIters;
        for (int i = iFirst; i < iLast; ++i) {
            if (!map.containsKey(i)) {
                iGapStart = i;
                iGapEnd = i;
                while (++i < iLast && !map.containsKey(i)) {
                    iGapEnd = i;
                }
                if (iGapStart == iGapEnd) {
                    Coherence._trace("\nMissing item: " + iGapStart);
                } else {
                    Coherence._trace("\nMissing items: " + iGapStart + " .. " + iGapEnd);
                }
            }
            if (i <= iGapStart + 1000 || i % 1000 != 0) continue;
            System.out.print("\b\b\b\b\b\b\b" + i);
            System.out.flush();
        }
    }

    protected void doScript(String sCmd, boolean fSilent) {
        ScriptEngine engine = this.getScriptEngine();
        NamedCache cache = this.getMap();
        engine.put("cluster", Coherence.getSafeCluster());
        engine.put("service", this.getService());
        engine.put("map", cache);
        if (sCmd.length() == 0) {
            this.setScript(true);
            this.getLogger().setPrompt(this.getLogger().getPrompt() + " [script]");
        } else if (sCmd.equals("bye")) {
            this.setScript(false);
            this.getLogger().setPrompt(cache == null ? "?" : cache.getCacheName());
        } else {
            Object oResult;
            String sPrefix = "with (imports) {\n";
            String sPostfix = "\n}\n";
            try {
                oResult = engine.eval(sPrefix + sCmd + sPostfix);
            }
            catch (Exception e) {
                oResult = e.getMessage();
                fSilent = false;
            }
            if (!fSilent) {
                Coherence._trace(Coherence.toString(oResult));
            }
        }
    }

    protected Object doSecure(String[] asParam, boolean fSilent) throws InterruptedException {
        Subject subject;
        PrivilegedAction action;
        int cParams = asParam.length;
        if (cParams < 3) {
            return null;
        }
        String sName = asParam[0];
        char[] acPwd = asParam[1].toCharArray();
        Object sCmd = asParam[2];
        for (int i = 3; i < cParams; ++i) {
            sCmd = (String)sCmd + " " + asParam[i];
        }
        boolean fImpersonate = false;
        if (sName.startsWith("hack_")) {
            fImpersonate = true;
            sName = sName.substring("hack_".length());
        }
        try {
            SimpleHandler handler = new SimpleHandler(sName, acPwd);
            action = Security.createPrivilegedAction(this.getClass().getMethod("processCommand", String.class), this, new Object[]{sCmd});
            subject = (Subject)ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), "login", new Object[]{handler});
        }
        catch (Throwable e) {
            Coherence.printException(null, e);
            return null;
        }
        if (fImpersonate) {
            subject = Security.getInstance().impersonate(subject, sName, asParam[0]);
        }
        try {
            return ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), "runAs", new Object[]{subject, action});
        }
        catch (Throwable e) {
            Throwable eOrig = e;
            while (true) {
                if (e instanceof WrapperException) {
                    e = ((WrapperException)e).getOriginalException();
                    continue;
                }
                if (!(e instanceof InvocationTargetException)) break;
                e = eOrig = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof AccessControlException) {
                Coherence._trace("Permission rejected: " + String.valueOf(((AccessControlException)e).getPermission()), 1);
            }
            Coherence._trace(eOrig);
            return null;
        }
    }

    protected void doServer(String[] asParam) {
        try {
            DefaultCacheServer.startServerDaemon();
        }
        catch (Throwable e) {
            Coherence._trace("Error in starting DefaultCacheServer: " + e.getMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTransaction(String sFunction, String[] asParam) {
        if (sFunction.equals("begin")) {
            String sConcur = asParam[0];
            String sIsolation = asParam[1];
            int nTimeout = 20;
            try {
                nTimeout = Integer.parseInt(asParam[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.txStart(switch (sConcur.charAt(0)) {
                case 'E', 'e' -> 3;
                case 'O', 'o' -> 2;
                default -> 1;
            }, switch (sIsolation.charAt(0)) {
                case 'C', 'c' -> 1;
                case 'R', 'r' -> 2;
                default -> 3;
            }, nTimeout);
        } else if (sFunction.equals("commit")) {
            try {
                ((TransactionMap)((Object)this.getMap())).prepare();
                ((TransactionMap)((Object)this.getMap())).commit();
            }
            finally {
                this.txEnd();
            }
        } else if (sFunction.equals("rollback")) {
            ((TransactionMap)((Object)this.getMap())).rollback();
            this.txEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Logger ensureRunningLogger() {
        Logger logger = this.getLogger();
        if (!logger.isStarted()) {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                if (!logger.isStarted() && !logger.isConfigured()) {
                    try {
                        logger.setConfigured(true);
                        logger.setDependencies(LegacyXmlLoggingHelper.fromXml(Coherence.getServiceConfig("$Logger"), new DefaultLoggingDependencies()));
                        logger.start();
                    }
                    catch (RuntimeException e) {
                        this.setLogger(null);
                        throw e;
                    }
                    catch (Error e) {
                        this.setLogger(null);
                        throw e;
                    }
                }
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get_Sink() {
        ThreadLocal oSink = super.get_Sink();
        if (oSink == null) {
            Coherence coherence = this;
            synchronized (coherence) {
                oSink = super.get_Sink();
                if (oSink == null) {
                    oSink = new ThreadLocal();
                    this.set_Sink(oSink);
                }
            }
        }
        return oSink;
    }

    public static String getBuildNumber() {
        return __s_BuildNumber;
    }

    public static SafeCluster getCluster() {
        return __s_Cluster;
    }

    protected static Attributes getCoherenceAttributes(InputStream in) throws IOException {
        Attributes attrs = new Manifest(in).getMainAttributes();
        String sGroupId = attrs.getValue("Implementation-GroupId");
        return sGroupId == null || !sGroupId.startsWith("com.oracle.coherence") ? null : attrs;
    }

    public List getCommandHistory() {
        return this.__m_CommandHistory;
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public Map getFilters() {
        HashMap mapFilter = this.__m_Filters;
        if (mapFilter == null) {
            mapFilter = new HashMap();
            this.setFilters(mapFilter);
        }
        return mapFilter;
    }

    protected Object getHistory(Object oReader) {
        if (!(oReader instanceof Reader)) {
            try {
                return ClassHelper.invoke(oReader, "getHistory", ClassHelper.VOID);
            }
            catch (Exception e) {
                System.out.println("failed to flush history: " + String.valueOf(e));
            }
        }
        return null;
    }

    public static TransactionMap getLocalTransaction(NamedCache cache) {
        Local mapTx = new Local();
        mapTx.initialize(cache);
        return mapTx;
    }

    public Logger getLogger() {
        Logger logger;
        AtomicReference refLogger = this.getLoggerRef();
        while ((logger = (Logger)refLogger.get()) == null && !refLogger.compareAndSet(null, logger = (Logger)this._newChild("Logger"))) {
        }
        return logger;
    }

    protected AtomicReference getLoggerRef() {
        return this.__m_LoggerRef;
    }

    public NamedCache getMap() {
        return this.__m_Map;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    public PersistenceToolsHelper getPersistenceToolsHelper() {
        return this.__m_PersistenceToolsHelper;
    }

    public String getProduct() {
        return this.__m_Product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SafeCluster getSafeCluster() {
        SafeCluster cluster = Coherence.getCluster();
        if (cluster == null && (cluster = (SafeCluster)Coherence.getTloCluster().get()) == null) {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                cluster = Coherence.getCluster();
                if (cluster == null) {
                    cluster = new SafeCluster();
                    Coherence.getTloCluster().set(cluster);
                    try {
                        ((Coherence)Coherence.get_Instance()).ensureRunningLogger();
                        cluster.ensureDependencies();
                        DefaultGatewayDependencies dependencies = LegacyXmlGatewayHelper.fromXml(Coherence.getServiceConfig("$Management"), new DefaultGatewayDependencies());
                        Gateway mgmt = Gateway.createGateway(dependencies, cluster);
                        cluster.setManagement(mgmt);
                        Coherence.setCluster(cluster);
                    }
                    finally {
                        Coherence.getTloCluster().set(null);
                    }
                }
            }
        }
        return cluster;
    }

    public ScriptEngine getScriptEngine() {
        ScriptEngine engine = this.__m_ScriptEngine;
        if (engine == null) {
            String sInit = "var imports = new JavaImporter(java.lang, com.tangosol.net,com.tangosol.util,com.tangosol.util.extractor, com.tangosol.util.filter, com.tangosol.util.processor,com.tangosol.util.aggregator)\n";
            engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.put("coherence", this);
            try {
                engine.eval(sInit);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
            this.setScriptEngine(engine);
        }
        return engine;
    }

    public CacheService getService() {
        return this.__m_Service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlElement getServiceConfig(String sServiceType) {
        Map mapConfig = Coherence.getServiceConfigMap();
        Class clazz = Coherence.get_CLASS();
        synchronized (clazz) {
            if (!Coherence.isConfigurationLoaded()) {
                ((Coherence)Coherence.get_Instance()).ensureRunningLogger();
                if (!Coherence.isConfigurationLoaded()) {
                    Coherence.loadConfiguration();
                    Coherence.setConfigurationLoaded(true);
                    Coherence.validateEnvironment();
                }
            }
        }
        XmlElement xml = (XmlElement)mapConfig.get(sServiceType);
        return xml == null ? null : (XmlElement)xml.clone();
    }

    protected static Map getServiceConfigMap() {
        return __s_ServiceConfigMap;
    }

    protected CacheService getSimpleCache(String sServiceName) {
        sServiceName = sServiceName == null || sServiceName.length() == 0 ? "Default" : sServiceName;
        Cluster cluster = CacheFactory.ensureCluster();
        CacheService service = (CacheService)cluster.ensureService(sServiceName, "SimpleCache");
        if (!service.isRunning()) {
            service.configure(Coherence.getServiceConfig("SimpleCache"));
            service.start();
        }
        return service;
    }

    private static ThreadLocal getTloCluster() {
        return __s_TloCluster;
    }

    protected ClassLoader getUniqueClassLoader() {
        return new ComponentClassLoader(this.getClass().getClassLoader(), new NullStorage());
    }

    public static boolean isConfigurationLoaded() {
        return __s_ConfigurationLoaded;
    }

    @Override
    public boolean isDebugOutputEnabled(int iSeverity) {
        Logger logger = this.getLogger();
        return logger == null ? super.isDebugOutputEnabled(iSeverity) : logger.isEnabled(iSeverity);
    }

    private static boolean isLicenseLoaded() {
        return __s_LicenseLoaded;
    }

    protected boolean isMapValid() {
        if (this.getMap() == null) {
            Coherence._trace("Please specify the current map using \"cache\" or \"map\" command");
            return false;
        }
        return true;
    }

    public boolean isScript() {
        return this.__m_Script;
    }

    public boolean isStop() {
        return this.__m_Stop;
    }

    protected static void loadConfiguration() {
        Coherence.get_Instance();
        if (Config.getBoolean("coherence.debug.operational.config")) {
            StringBuilder sbTrace = new StringBuilder("Loading Coherence operational configuration, call stack:\n");
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stackTrace.length; ++i) {
                sbTrace.append("\tat ").append(stackTrace[i]).append("\n");
            }
            Coherence._trace(sbTrace.toString());
        }
        Map mapConfig = Coherence.getServiceConfigMap();
        XmlDocument xmlCoherence = XmlHelper.loadResource(FILE_CFG_COHERENCE, "operational configuration", Coherence.get_CLASS().getClassLoader());
        Coherence.replaceSystemProperties(xmlCoherence);
        XmlElement xmlLicense = xmlCoherence.ensureElement("license-config");
        String sModeDescription = Coherence.resolveMode(xmlLicense);
        mapConfig.put("$License", xmlLicense.clone());
        Coherence.loadOverrides(xmlCoherence, new HashSet());
        String sEditionDesc = Coherence.resolveEdition(xmlLicense);
        Coherence._trace("\nOracle Coherence Version " + VERSION + " Build " + Coherence.getBuildNumber() + "\n " + sEditionDesc + ": " + sModeDescription + " mode\nCopyright (c) 2000, 2024, Oracle and/or its affiliates. All rights reserved.\n");
        Coherence.logEnvironment();
        XmlElement xmlCluster = xmlCoherence.ensureElement("cluster-config");
        XmlElement xmlLogging = xmlCoherence.getSafeElement("logging-config");
        XmlElement xmlTracing = xmlCoherence.getSafeElement("tracing-config");
        XmlElement xmlFactory = xmlCoherence.getSafeElement("configurable-cache-factory-config");
        XmlElement xmlBuilder = xmlCoherence.getSafeElement("cache-factory-builder-config");
        XmlElement xmlSecurity = xmlCoherence.getSafeElement("security-config");
        XmlElement xmlManagement = xmlCoherence.getSafeElement("management-config");
        XmlElement xmlFederation = xmlCoherence.getSafeElement("federation-config");
        xmlCluster.ensureElement("edition-name").setString(xmlLicense.getSafeElement("edition-name").getString());
        xmlCluster.ensureElement("license-mode").setString(xmlLicense.getSafeElement("license-mode").getString());
        mapConfig.put("Cluster", XmlHelper.mergeSchema((XmlElement)xmlCluster.clone(), xmlCoherence));
        mapConfig.put("$License", XmlHelper.mergeSchema((XmlElement)xmlLicense.clone(), xmlCoherence));
        mapConfig.put("$Logger", XmlHelper.mergeSchema((XmlElement)xmlLogging.clone(), xmlCoherence));
        mapConfig.put("$Tracing", XmlHelper.mergeSchema((XmlElement)xmlTracing.clone(), xmlCoherence));
        mapConfig.put("$CacheFactory", XmlHelper.mergeSchema((XmlElement)xmlFactory.clone(), xmlCoherence));
        mapConfig.put("$CacheFactoryBuilder", XmlHelper.mergeSchema((XmlElement)xmlBuilder.clone(), xmlCoherence));
        mapConfig.put("$Security", XmlHelper.mergeSchema((XmlElement)xmlSecurity.clone(), xmlCoherence));
        mapConfig.put("$Management", XmlHelper.mergeSchema((XmlElement)xmlManagement.clone(), xmlCoherence));
        mapConfig.put("$Federation", XmlHelper.mergeSchema((XmlElement)xmlFederation.clone(), xmlCoherence));
        Iterator iter = xmlCoherence.getSafeElement("cluster-config/services").getElements("service");
        while (iter.hasNext()) {
            XmlElement xmlSvc = (XmlElement)iter.next();
            String sSvcType = xmlSvc.getSafeElement("service-type").getString("service");
            SimpleElement xmlParams = new SimpleElement(sSvcType);
            XmlHelper.transformInitParams(xmlParams, xmlSvc.getSafeElement("init-params"));
            XmlHelper.mergeSchema(xmlParams, xmlCoherence);
            mapConfig.put(sSvcType, xmlParams);
        }
    }

    protected static void loadLicenses(XmlElement xml, String sLicenseFile) {
        Signature signature;
        XmlDocument xmlLicenses;
        String sXml;
        URL url;
        InputStream stream = null;
        String sUrl = null;
        ClassLoader loader = Coherence.get_CLASS().getClassLoader();
        if (loader == null) {
            loader = Base.getContextClassLoader();
        }
        if ((url = loader.getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stream == null && (url = LicensedObject.class.getClassLoader().getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stream == null) {
            String sErrorMsg = "Edition file (" + sLicenseFile + ") is missing from the Oracle Coherence libraries";
            Coherence._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        sUrl = url.toString();
        try {
            sXml = new String(Base.read(stream), StandardCharsets.ISO_8859_1);
        }
        catch (IOException e) {
            throw new WrapperException(e, "An exception occurred while reading the license data");
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (sXml == null || sXml.length() == 0) {
            String sErrorMsg = "Edition data (" + sUrl + ") is missing or empty.";
            Coherence._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Coherence._trace("Loaded edition data from \"" + sUrl + "\"", 6);
        try {
            xmlLicenses = new SimpleParser().parseXml(sXml);
        }
        catch (IOException e) {
            throw new WrapperException(e, "An exception occurred while parsing the license data");
        }
        xml.ensureElement("license-list").getElementList().addAll(xmlLicenses.getElementList());
        if (Coherence.isLicenseLoaded()) {
            return;
        }
        Coherence.setLicenseLoaded(true);
        InputStream streamCert = null;
        try {
            streamCert = loader.getResourceAsStream(FILE_CFG_CERTIFICATE);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(streamCert);
            signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(cert.getPublicKey());
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error during license validation");
        }
        finally {
            if (streamCert != null) {
                try {
                    streamCert.close();
                }
                catch (IOException iOException) {}
            }
        }
        ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
        Iterator iter = xmlLicenses.getElements("license");
        while (iter.hasNext()) {
            int ofColon;
            XmlElement xmlLicense = (XmlElement)iter.next();
            String sLicensee = xmlLicense.getSafeElement("licensee").getString(null);
            String sAgreement = xmlLicense.getSafeElement("agreement").getString(null);
            String sMode = xmlLicense.getSafeElement("type").getString(null);
            String sFromDate = xmlLicense.getSafeElement("from-date").getString(null);
            String sToDate = xmlLicense.getSafeElement("to-date").getString(null);
            String sRenewDate = xmlLicense.getSafeElement("maintenance-renewal-date").getString(null);
            int cSeats = xmlLicense.getSafeElement("max-seats").getInt();
            int cUsers = xmlLicense.getSafeElement("max-users").getInt();
            String sSite = xmlLicense.getSafeElement("site").getString(null);
            int cServers = xmlLicense.getSafeElement("max-servers").getInt();
            int cSockets = xmlLicense.getSafeElement("max-sockets").getInt();
            int cCores = xmlLicense.getSafeElement("max-cpus").getInt();
            String sUid = xmlLicense.getSafeElement("id").getString(null);
            String sKey = xmlLicense.getSafeElement("key").getString(null);
            String sSig = xmlLicense.getSafeElement("signature").getString(null);
            String sClass = null;
            String sSoftware = null;
            String sEdition = null;
            if (sUid == null) {
                String sMsg = "You are using an out-of-date license format; please contact Oracle to obtain a replacement license.";
                Coherence._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            UID uid = new UID(sUid);
            long lDateFrom = sFromDate == null ? 0L : Coherence.parseDate(sFromDate);
            long lDateTo = sToDate == null ? 0L : Coherence.parseDate(sToDate);
            long lDateRenew = sRenewDate == null ? 0L : Coherence.parseDate(sRenewDate);
            int nMode = -1;
            if (sMode != null && sMode.length() > 0) {
                switch (sMode.charAt(0)) {
                    case 'e': {
                        nMode = 0;
                        break;
                    }
                    case 'd': {
                        nMode = 1;
                        break;
                    }
                    case 'p': {
                        nMode = 2;
                    }
                }
            }
            if (nMode < 0) {
                String sErrorMsg = "Invalid license mode: \"" + sMode + "\"";
                Coherence._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
            if (sSig == null) {
                if (sKey == null) {
                    continue;
                }
            } else {
                sSoftware = xmlLicense.getSafeElement("software").getString();
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(sSoftware).append(sLicensee).append(sAgreement == null ? "" : sAgreement).append(nMode).append(lDateFrom).append(lDateTo).append(lDateRenew).append(cSeats).append(cUsers).append(sSite).append(cServers).append(cSockets).append(cCores).append(uid);
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    DataOutputStream streamSig = new DataOutputStream(streamRaw);
                    streamSig.writeUTF(sb.toString());
                    signature.update(streamRaw.toByteArray());
                    if (!signature.verify(Base.parseHex(sSig))) {
                        String sMsg = "The " + sSoftware + " license signature is not valid, please contact Oracle.";
                        System.err.println(sMsg);
                        Coherence._trace(sMsg, 1);
                        continue;
                    }
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, "Error validating license signature for " + sSoftware);
                }
                if (sSoftware.endsWith(": Grid Edition")) {
                    sEdition = DEFAULT_EDITION;
                    sClass = "com.tangosol.license.CoherenceDataGridEdition";
                } else if (sSoftware.endsWith(": Enterprise Edition") || sSoftware.endsWith(": Application Edition")) {
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sSoftware.endsWith(": Community Edition")) {
                    sEdition = "CE";
                    sClass = "com.tangosol.license.CoherenceCommunityEdition";
                } else if (sSoftware.endsWith(": Standard Edition") || sSoftware.endsWith(": Caching Edition")) {
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else if (sSoftware.endsWith(": Compute Client")) {
                    sEdition = "CC";
                    sClass = "com.tangosol.license.CoherenceComputeClient";
                } else if (sSoftware.endsWith(": Real-Time Client")) {
                    sEdition = "RTC";
                    sClass = "com.tangosol.license.CoherenceRealTimeClient";
                } else if (sSoftware.endsWith(": Data Client")) {
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            if (sClass == null && sKey != null) {
                try {
                    sClass = new Binary(Base.parseHex(sKey.substring(9, sKey.length() - 1))).getBufferInput().readUTF();
                }
                catch (IOException e) {
                    continue;
                }
                if (sClass.endsWith(".CoherenceEnterprise")) {
                    sSoftware = "Oracle Coherence: Enterprise Edition";
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sClass.endsWith(".Coherence")) {
                    sSoftware = "Oracle Coherence: Standard Edition";
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else {
                    if (!sClass.endsWith(".CoherenceLocal") && !sClass.endsWith(".ClientAccess")) continue;
                    sSoftware = "Oracle Coherence: Data Client";
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            boolean fOem = sLicensee.startsWith("OEM:");
            String sApp = null;
            if (fOem && (ofColon = (sLicensee = sLicensee.substring(4)).lastIndexOf(58)) > 0) {
                sApp = sLicensee.substring(ofColon + 1);
                sLicensee = sLicensee.substring(0, ofColon);
            }
            list.add(new LicensedObject.LicenseData(sSoftware, sEdition, sLicensee, fOem, sAgreement, nMode, sClass, sSite, sApp, lDateFrom, lDateTo, lDateRenew, cSeats, cUsers, cServers, cSockets, cCores, uid));
        }
        LicensedObject.setLicenseData(list.toArray(new LicensedObject.LicenseData[0]));
    }

    protected static void loadOverrides(XmlElement xml, Set setOverrides) {
        block9: {
            String ATTR_OVERRIDE = "xml-override";
            String ATTR_ID = "id";
            XmlValue attr = xml.getAttribute("xml-override");
            if (attr != null) {
                xml.setAttribute("xml-override", null);
                String sOverride = Coherence.calculateAttribute(attr.getString());
                try {
                    URL url;
                    XmlDocument xmlOverride = null;
                    File file = new File(sOverride);
                    if (file.exists() && file.isDirectory()) {
                        sOverride = new File(file, FILE_CFG_COHERENCE_OVERRIDE).getPath();
                    }
                    if ((url = Resources.findFileOrResourceOrDefault(sOverride, Coherence.get_CLASS().getClassLoader())) != null) {
                        xmlOverride = XmlHelper.loadXml(url);
                        Coherence._trace("Loaded operational overrides from \"" + String.valueOf(url) + "\"", 3);
                    }
                    if (xmlOverride == null) {
                        Coherence._trace("Optional configuration override \"" + sOverride + "\" is not specified", 3);
                        break block9;
                    }
                    if (xmlOverride.getName().equals(xml.getName())) {
                        Coherence.replaceSystemProperties(xmlOverride);
                        XmlValue attrOverride = xmlOverride.getAttribute("xml-override");
                        if (attrOverride == null || setOverrides.add(attrOverride.getString())) {
                            Coherence.loadOverrides(xmlOverride, setOverrides);
                            XmlHelper.overrideElement(xml, xmlOverride, "id");
                            break block9;
                        }
                        throw new IOException("Document \"" + sOverride + "\" is cyclically referenced by the 'xml-override' attribute of element '" + xml.getName() + "'");
                    }
                    throw new IOException("Root name mismatch in the document: " + sOverride + "; expected name: \"" + xml.getName() + "\"");
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, "Failed to apply the element override: " + sOverride);
                }
            }
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            Coherence.loadOverrides((XmlElement)iter.next(), new HashSet(setOverrides));
        }
    }

    protected static void logEnvironment() {
        String sSpecName = System.getProperty("java.specification.name");
        String sSpecVendor = System.getProperty("java.specification.vendor");
        String sSpecVersion = System.getProperty("java.specification.version");
        String sJavaVersion = System.getProperty("java.version");
        String sVendorName = System.getProperty("java.vendor");
        String sVendorVersion = System.getProperty("java.vendor.version");
        String sVmVendorUrl = System.getProperty("java.vendor.url");
        String sVmName = System.getProperty("java.vm.name");
        String sVmVendor = System.getProperty("java.vm.vendor");
        String sVmVersion = System.getProperty("java.vm.version");
        String sRtName = System.getProperty("java.runtime.name");
        String sRtVersion = System.getProperty("java.runtime.version");
        String sJavaHome = System.getProperty("java.home");
        String sOsName = System.getProperty("os.name");
        String sOsVersion = System.getProperty("os.version");
        String sOsArchitecture = System.getProperty("os.arch");
        StringBuilder sb = new StringBuilder("\n\n");
        sb.append("java.version: " + sJavaVersion).append('\n').append("java.home: " + sJavaHome).append("\n\n").append("Java Specification:").append('\n').append("- java.specification.name: " + sSpecName).append('\n').append("- java.specification.vendor: " + sSpecVendor).append('\n').append("- java.specification.version: " + sSpecVersion).append('\n').append("Java Vendor:").append('\n').append("- java.vendor: " + sVendorName).append('\n').append("- java.vendor.version: " + sVendorVersion).append('\n').append("- java.vendor.url: " + sVmVendorUrl).append('\n').append("Java Virtual Machine:").append('\n').append("- java.vm.name: " + sVmName).append('\n').append("- java.vm.vendor: " + sVmVendor).append('\n').append("- java.vm.version: " + sVmVersion).append('\n').append("Java Runtime Environment:").append('\n').append("- java.runtime.name: " + sRtName).append('\n').append("- java.runtime.version: " + sRtVersion).append('\n').append("Operating System:").append('\n').append("- os.name: " + sOsName).append('\n').append("- os.version: " + sOsVersion).append('\n').append("- os.arch: " + sOsArchitecture).append('\n');
        Coherence._trace(sb.toString(), 6);
    }

    public static void main(String[] asArgs) {
        Coherence.setArgument(asArgs);
        ((Coherence)Coherence.get_Instance()).run();
    }

    public static String[] parseArguments(String sArguments) {
        if (sArguments.length() == 0) {
            return new String[0];
        }
        char[] ach = sArguments.toCharArray();
        int cch = ach.length;
        boolean fEsc = false;
        boolean fQuote = false;
        char chQuote = '\u0000';
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        block16: for (int ofCur = 0; ofCur < cch; ++ofCur) {
            char ch = ach[ofCur];
            if (fEsc) {
                switch (ch) {
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case ' ': {
                        sb.append(' ');
                        break;
                    }
                    default: {
                        sb.append('\\').append(ch);
                    }
                }
                fEsc = false;
                continue;
            }
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (fQuote) {
                        if (ch == chQuote) {
                            fQuote = false;
                            continue block16;
                        }
                        sb.append(ch);
                        continue block16;
                    }
                    fQuote = true;
                    chQuote = ch;
                    continue block16;
                }
                case ' ': {
                    if (fQuote) {
                        sb.append(' ');
                        continue block16;
                    }
                    if (sb.length() <= 0) continue block16;
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue block16;
                }
                case '\\': {
                    fEsc = true;
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (fQuote) {
            throw new IllegalArgumentException("Unmatched quote (" + chQuote + ") in command: " + sArguments);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static long parseDate(String s) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        String[] asParts = Base.parseDelimitedString(s, '-');
        return Date.UTC(Integer.parseInt(asParts[0]) - 1900, Integer.parseInt(asParts[1]) - 1, Integer.parseInt(asParts[2]), 0, 0, 0);
    }

    public static int parseEditionName(String sEdition) {
        if (sEdition != null) {
            String[] asEdition = EDITION_NAMES;
            int c = asEdition.length;
            for (int i = 0; i < c; ++i) {
                if (!sEdition.equals(asEdition[i])) continue;
                return i;
            }
        }
        Coherence._trace("Unknown edition: " + sEdition, 2);
        return 0;
    }

    public static int parseModeName(String sMode) {
        if (sMode != null) {
            String[] asMode = MODE_NAMES;
            int c = asMode.length;
            for (int i = 0; i < c; ++i) {
                if (!sMode.equals(asMode[i])) continue;
                return i;
            }
        }
        Coherence._trace("Unknown mode: " + sMode, 2);
        return 1;
    }

    public static void printException(String sPrefix, Throwable e) {
        Object oPartial;
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (sPrefix == null) {
            Coherence._trace(e);
        } else {
            Coherence._trace(sPrefix + Coherence.getStackTrace(e), 1);
        }
        if (e instanceof RequestTimeoutException && (oPartial = ((RequestTimeoutException)e).getPartialResult()) != null) {
            Coherence._trace("Partial result: " + String.valueOf(oPartial));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object processCommand(String sCmd) throws InterruptedException {
        block191: {
            block219: {
                block218: {
                    block217: {
                        block216: {
                            block215: {
                                block214: {
                                    block213: {
                                        block212: {
                                            block211: {
                                                block210: {
                                                    block209: {
                                                        block208: {
                                                            block207: {
                                                                block206: {
                                                                    block205: {
                                                                        block204: {
                                                                            block203: {
                                                                                block202: {
                                                                                    block201: {
                                                                                        block200: {
                                                                                            block199: {
                                                                                                block198: {
                                                                                                    block197: {
                                                                                                        block196: {
                                                                                                            block195: {
                                                                                                                block194: {
                                                                                                                    block193: {
                                                                                                                        block192: {
                                                                                                                            block190: {
                                                                                                                                service = this.getService();
                                                                                                                                map = this.getMap();
                                                                                                                                oResult = null;
                                                                                                                                fSilent = false;
                                                                                                                                if (sCmd.charAt(0) == '@') {
                                                                                                                                    fSilent = true;
                                                                                                                                    sCmd = sCmd.substring(1);
                                                                                                                                }
                                                                                                                                if (this.isScript()) {
                                                                                                                                    this.doScript(sCmd, fSilent);
                                                                                                                                    return null;
                                                                                                                                }
                                                                                                                                ofFunction = sCmd.indexOf(32);
                                                                                                                                if (ofFunction < 0) {
                                                                                                                                    sFunction = sCmd;
                                                                                                                                    sCmd = "";
                                                                                                                                } else {
                                                                                                                                    sFunction = sCmd.substring(0, ofFunction);
                                                                                                                                    sCmd = sCmd.substring(ofFunction + 1).trim();
                                                                                                                                }
                                                                                                                                if (sFunction.startsWith("#")) {
                                                                                                                                    sIter = sFunction.substring(1);
                                                                                                                                    fForce = false;
                                                                                                                                    if (sIter.startsWith("#")) {
                                                                                                                                        sIter = sIter.substring(1);
                                                                                                                                        fForce = true;
                                                                                                                                    }
                                                                                                                                    try {
                                                                                                                                        cIter = Integer.parseInt(sIter);
                                                                                                                                        this.doRepeat(sCmd, cIter, fForce);
                                                                                                                                    }
                                                                                                                                    catch (NumberFormatException e) {
                                                                                                                                        Coherence._trace("invalid counter: " + sIter);
                                                                                                                                    }
                                                                                                                                    return null;
                                                                                                                                }
                                                                                                                                asParam = Coherence.parseArguments(sCmd);
                                                                                                                                cParams = asParam.length;
                                                                                                                                v0 = aoParam = sFunction.startsWith("bulk") != false ? null : this.convertArguments(asParam);
                                                                                                                                if (sFunction.startsWith("!")) {
                                                                                                                                    if (sFunction.length() == 1) {
                                                                                                                                        this.doHistory(asParam, fSilent);
                                                                                                                                    } else {
                                                                                                                                        nCmd = Integer.parseInt(sFunction.substring(1));
                                                                                                                                        this.doReissueCommand(nCmd, sCmd, fSilent);
                                                                                                                                    }
                                                                                                                                    return null;
                                                                                                                                }
                                                                                                                                if (!sFunction.startsWith("&")) break block190;
                                                                                                                                oResult = this.doFunction(sFunction, aoParam, fSilent);
                                                                                                                                break block191;
                                                                                                                            }
                                                                                                                            if (!sFunction.equals("lock") && !sFunction.equals("unlock")) break block192;
                                                                                                                            if (this.isMapValid()) {
                                                                                                                                oResult = this.doFunction("&" + sFunction, aoParam, fSilent);
                                                                                                                            }
                                                                                                                            break block191;
                                                                                                                        }
                                                                                                                        if (!sFunction.equals("bye")) break block193;
                                                                                                                        CacheFactory.shutdown();
                                                                                                                        this.setStop(true);
                                                                                                                        break block191;
                                                                                                                    }
                                                                                                                    if (sFunction.equals("echo")) {
                                                                                                                        Coherence._trace(Arrays.deepToString(aoParam));
                                                                                                                        return aoParam;
                                                                                                                    }
                                                                                                                    if (!sFunction.equals("help")) break block194;
                                                                                                                    Coherence._trace("The commands are:");
                                                                                                                    Coherence._trace("  aggregate ('{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <aggregator-name> [<extractor>]");
                                                                                                                    Coherence._trace("  assert <value>");
                                                                                                                    Coherence._trace("  backup <path>");
                                                                                                                    Coherence._trace("  batch <path>");
                                                                                                                    Coherence._trace("  bulkput <# of iterations> <block size> <start key> [<batch size> | all]");
                                                                                                                    Coherence._trace("  bulkremove <# of iterations> <start key> [all]");
                                                                                                                    Coherence._trace("  bye");
                                                                                                                    Coherence._trace("  cachefactory [<path>]");
                                                                                                                    Coherence._trace("  cache <name>");
                                                                                                                    Coherence._trace("  cohql [<paramValue>]*");
                                                                                                                    Coherence._trace("  clear");
                                                                                                                    Coherence._trace("  destroy");
                                                                                                                    Coherence._trace("  explain <filter name> [trace]");
                                                                                                                    Coherence._trace("  filter <name> <type> [(<accessor> <value>) | [<paramValue>]+]");
                                                                                                                    Coherence._trace("  get <key>");
                                                                                                                    Coherence._trace("  hash");
                                                                                                                    Coherence._trace("  help");
                                                                                                                    Coherence._trace("  history ([<pattern>] [<limit>]) | (['on' | 'off' | 'clear'])");
                                                                                                                    Coherence._trace("  inc <key> [<increment>]");
                                                                                                                    Coherence._trace("  invoke <command> [('all' | 'other' | 'senior' | <id>) [('async' | 'sync')]]");
                                                                                                                    Coherence._trace("  index <accessor> [add | remove]");
                                                                                                                    Coherence._trace("  jmx [(<port> | <url>) [('start' | 'stop')]]");
                                                                                                                    Coherence._trace("  kill");
                                                                                                                    Coherence._trace("  list [<map name> | <filter name> [<accessor> [asc | desc]]]");
                                                                                                                    Coherence._trace("  listen [('start' | 'stop') [('cluster' | 'interceptor' | 'local' | 'members' | 'trigger' | 'partition')]] [<filter> | <key> | <event-types>] [<lite>]");
                                                                                                                    Coherence._trace("  lock <key>");
                                                                                                                    Coherence._trace("  log (<size> | <message>) [<iterations> [<level>]]");
                                                                                                                    Coherence._trace("  maps");
                                                                                                                    Coherence._trace("  memory");
                                                                                                                    Coherence._trace("  process (<key> | '{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <processor-name> [<paramValue>]+");
                                                                                                                    Coherence._trace("  profile <command>");
                                                                                                                    Coherence._trace("  put <key> <value>");
                                                                                                                    Coherence._trace("  release");
                                                                                                                    Coherence._trace("  remove <key>");
                                                                                                                    Coherence._trace("  restore <path>");
                                                                                                                    Coherence._trace("  resume [all]");
                                                                                                                    Coherence._trace("  runAs <name> <password> <command>");
                                                                                                                    Coherence._trace("  server [<path-to-gar>] [<app-name>]");
                                                                                                                    Coherence._trace("  service");
                                                                                                                    Coherence._trace("  services");
                                                                                                                    Coherence._trace("  size [<filter name>]");
                                                                                                                    Coherence._trace("  sleep [interval]");
                                                                                                                    Coherence._trace("  snapshot [create | archive | recover | remove] <snapshot-name>");
                                                                                                                    Coherence._trace("  snapshot list [archived]");
                                                                                                                    Coherence._trace("  snapshot [remove | retrieve] archived <snapshot-name>");
                                                                                                                    Coherence._trace("  stats [cluster | service | p2p] [reset]");
                                                                                                                    Coherence._trace("  suspend [all]");
                                                                                                                    Coherence._trace("  truncate");
                                                                                                                    Coherence._trace("  unlock <key>");
                                                                                                                    Coherence._trace("  waitkey <start key> <stop key>");
                                                                                                                    Coherence._trace("  who | cluster");
                                                                                                                    Coherence._trace("  whoami | service");
                                                                                                                    Coherence._trace("  worker <command>");
                                                                                                                    Coherence._trace("  #<repeat count> <command>");
                                                                                                                    Coherence._trace("  &<functionName> [<paramValue>]*");
                                                                                                                    Coherence._trace("  !<history index>");
                                                                                                                    break block191;
                                                                                                                }
                                                                                                                if (!sFunction.equals("aggregate")) break block195;
                                                                                                                if (this.isMapValid()) {
                                                                                                                    this.doAggregate(aoParam, fSilent);
                                                                                                                }
                                                                                                                break block191;
                                                                                                            }
                                                                                                            if (!sFunction.equals("assert")) break block196;
                                                                                                            if (cParams >= 1 && !(sValue = String.valueOf(aoParam[0])).equals(sResult = String.valueOf(((ThreadLocal)this.get_Sink()).get()))) {
                                                                                                                sMsg = "Assertion failed: expected=\"" + sValue + "\"; actual=\"" + sResult + "\"";
                                                                                                                Coherence._trace(sMsg, 1);
                                                                                                                oResult = new RuntimeException(sMsg);
                                                                                                            }
                                                                                                            break block191;
                                                                                                        }
                                                                                                        if (!sFunction.equals("backup")) break block197;
                                                                                                        this.doBackup(asParam, fSilent);
                                                                                                        break block191;
                                                                                                    }
                                                                                                    if (!sFunction.equals("batch")) break block198;
                                                                                                    this.doBatch(asParam, fSilent);
                                                                                                    break block191;
                                                                                                }
                                                                                                if (!sFunction.equals("bulkput")) break block199;
                                                                                                this.doBulkPut(asParam, fSilent);
                                                                                                break block191;
                                                                                            }
                                                                                            if (!sFunction.equals("bulkremove")) break block200;
                                                                                            this.doBulkRemove(asParam, fSilent);
                                                                                            break block191;
                                                                                        }
                                                                                        if (!sFunction.equals("cachefactory")) break block201;
                                                                                        this.doCacheFactory(asParam, fSilent);
                                                                                        break block191;
                                                                                    }
                                                                                    if (!sFunction.equals("cache") && !sFunction.equals("map")) break block202;
                                                                                    if (cParams > 0) {
                                                                                        this.doCache(asParam, fSilent);
                                                                                    } else {
                                                                                        Coherence._trace(String.valueOf(map));
                                                                                    }
                                                                                    break block191;
                                                                                }
                                                                                if (!sFunction.equals("cohql")) break block203;
                                                                                QueryPlus.main(asParam);
                                                                                break block191;
                                                                            }
                                                                            if (!sFunction.equals("clear")) break block204;
                                                                            if (this.isMapValid()) {
                                                                                map.clear();
                                                                            }
                                                                            break block191;
                                                                        }
                                                                        if (!sFunction.equals("truncate")) break block205;
                                                                        if (this.isMapValid()) {
                                                                            map.truncate();
                                                                        }
                                                                        break block191;
                                                                    }
                                                                    if (!sFunction.equals("cluster") && !sFunction.equals("who")) break block206;
                                                                    Coherence._trace(String.valueOf(Coherence.getSafeCluster()));
                                                                    break block191;
                                                                }
                                                                if (!sFunction.equals("connector")) break block207;
                                                                this.doConnector(asParam, fSilent);
                                                                break block191;
                                                            }
                                                            if (!sFunction.equals("destroy")) break block208;
                                                            if (this.isMapValid()) {
                                                                CacheFactory.destroyCache(map);
                                                            }
                                                            break block191;
                                                        }
                                                        if (!sFunction.equals("explain")) break block209;
                                                        if (this.isMapValid()) {
                                                            this.doExplain(asParam, fSilent);
                                                        }
                                                        break block191;
                                                    }
                                                    if (!sFunction.equals("filter")) break block210;
                                                    if (this.isMapValid()) {
                                                        this.doFilter(aoParam, fSilent);
                                                    }
                                                    break block191;
                                                }
                                                if (!sFunction.equals("filters")) break block211;
                                                Coherence._trace("filters = " + String.valueOf(this.getFilters()));
                                                break block191;
                                            }
                                            if (!sFunction.equals("get")) break block212;
                                            if (this.isMapValid() && cParams >= 1) {
                                                oResult = map.get(aoParam[0]);
                                                ((ThreadLocal)this.get_Sink()).set(oResult);
                                                if (!fSilent) {
                                                    Coherence._trace(Coherence.toString(oResult));
                                                }
                                            }
                                            break block191;
                                        }
                                        if (!sFunction.equals("hash")) break block213;
                                        if (!this.isMapValid()) {
                                            return null;
                                        }
                                        iHash = 0;
                                        for (K oKey : map.keySet()) {
                                            oVal = map.get(oKey);
                                            if (oVal instanceof byte[]) {
                                                ab = (byte[])oVal;
                                                c = ab.length;
                                                for (i = 0; i < c; ++i) {
                                                    iHash += ab[i];
                                                }
                                                continue;
                                            }
                                            if (oVal == null) continue;
                                            iHash += oVal.hashCode();
                                        }
                                        Coherence._trace("hash=" + iHash);
                                        break block191;
                                    }
                                    if (!sFunction.equals("history")) break block214;
                                    this.doHistory(asParam, fSilent);
                                    break block191;
                                }
                                if (sFunction.equals("inc")) {
                                    if (!this.isMapValid()) {
                                        return null;
                                    }
                                    oKey = aoParam[0];
                                    cInc = 1;
                                    try {
                                        cInc = Integer.parseInt(asParam[1]);
                                    }
                                    catch (Exception oVal) {
                                        // empty catch block
                                    }
                                    v1 = fLock = cParams <= 2 || asParam[2].startsWith("o") == false;
                                    if (fLock) {
                                        map.lock(oKey, -1L);
                                    }
                                    try {
                                        oVal /* !! */  = map.get(oKey);
                                        v2 = sVal = fSilent != false ? null : String.valueOf(oVal /* !! */ );
                                        if (oVal /* !! */  instanceof Versionable) {
                                            ver = (Versionable)oVal /* !! */ ;
                                            for (i = 0; i < cInc; ++i) {
                                                ver.incrementVersion();
                                            }
                                        } else {
                                            nVal = 0;
                                            try {
                                                nVal = Integer.parseInt(String.valueOf(oVal /* !! */ ));
                                            }
                                            catch (Exception i) {
                                                // empty catch block
                                            }
                                            oVal /* !! */  = nVal + cInc;
                                        }
                                        map.put(oKey, oVal /* !! */ );
                                        if (!fSilent) {
                                            Coherence._trace("incremented " + String.valueOf(oKey) + " from " + sVal + " to " + String.valueOf(oVal /* !! */ ));
                                        }
                                        ((ThreadLocal)this.get_Sink()).set(oVal /* !! */ );
                                    }
                                    finally {
                                        if (fLock) {
                                            map.unlock(oKey);
                                        }
                                    }
                                }
                                if (!sFunction.equals("index")) break block215;
                                if (!this.isMapValid()) {
                                    return null;
                                }
                                this.doIndex(asParam, fSilent);
                                break block191;
                            }
                            if (!sFunction.equals("iterate")) break block216;
                            cItems = 0;
                            iter = (Iterator)((ThreadLocal)this.get_Sink()).get();
                            while (iter.hasNext()) {
                                fLock = iter.next();
                                ++cItems;
                            }
                            if (!fSilent) {
                                Coherence._trace(cItems + " items");
                            }
                            break block191;
                        }
                        if (!sFunction.startsWith("invoke")) break block217;
                        ofName = sFunction.indexOf(58);
                        sName = ofName < 0 ? "InvocationService" : sFunction.substring(ofName + 1);
                        this.doInvoke(sName, asParam, fSilent);
                        break block191;
                    }
                    if (!sFunction.equals("jmx")) break block218;
                    this.doJmx(asParam);
                    break block191;
                }
                if (!sFunction.equals("kill")) break block219;
                if (cParams <= 0) ** GOTO lbl310
                if (asParam[0].equals("all")) {
                    CacheFactory.shutdown();
                } else {
                    svcCluster = Coherence.getSafeCluster().getCluster().getClusterService();
                    setMember = svcCluster.getClusterMemberSet();
                    member = setMember.getMember(Integer.parseInt(asParam[0]));
                    if (svcCluster.getThisMember().equals(member)) {
                        Coherence.getSafeCluster().shutdown();
                    } else {
                        svcCluster.doMemberLeft(member);
                        return null;
lbl310:
                        // 1 sources

                        if (service == null) {
                            Coherence.getSafeCluster().shutdown();
                        } else {
                            service.shutdown();
                        }
                    }
                }
                this.setService(null);
                this.setMap(null);
                this.getLogger().setPrompt("?");
                break block191;
            }
            if (sFunction.equals("script")) {
                this.doScript(sCmd, fSilent);
            } else if (sFunction.equals("snapshot") || sFunction.equals("persistence")) {
                if (cParams == 0) {
                    Coherence._trace("Please provide correct arguments to persistence/snapshot command");
                } else {
                    this.doPersistence(asParam, fSilent);
                }
            } else if (sFunction.equals("suspend") || sFunction.equals("resume")) {
                svcCluster = Coherence.getSafeCluster().getCluster().getClusterService();
                fResume = sFunction.equals("resume");
                sName = service == null || asParam.length > 0 && asParam[0].equals("all") != false ? svcCluster.getServiceName() : ((Grid)((SafeService)service).getService()).getServiceName();
                svcCluster.doServiceQueiscence(sName, fResume);
            } else if (sFunction.equals("list")) {
                if (this.isMapValid()) {
                    this.doList(asParam, fSilent);
                }
            } else if (sFunction.equals("listen")) {
                fStop = cParams >= 1 && asParam[0].equals("stop") != false;
                sSource = cParams >= 2 ? asParam[1] : "global";
                oKey = null;
                filter = null;
                fLite = false;
                LVersion = null;
                laVersions = null;
                if (cParams >= 3 && (filter = (Filter)this.getFilters().get(asParam[2])) == null) {
                    oKey = aoParam[2];
                }
                if (cParams >= 4) {
                    fLite = asParam[3].equals("lite");
                    iPos = fLite != false ? 4 : 3;
                    LVersion = aoParam[iPos] instanceof Long != false ? (Long)aoParam[iPos] : null;
                    laVersions = aoParam[iPos] instanceof PrimitiveSparseArray != false ? (PrimitiveSparseArray)aoParam[iPos] : null;
                }
                this.doListen(sSource, fStop, filter, oKey, fLite, LVersion, laVersions);
            } else if (sFunction.equals("log")) {
                this.doLog(aoParam, fSilent);
            } else if (sFunction.equals("maps")) {
                enumS = CacheFactory.ensureCluster().getServiceNames();
                while (enumS.hasMoreElements()) {
                    sName = enumS.nextElement();
                    srv = Coherence.getSafeCluster().getService(sName);
                    if (!(srv instanceof CacheService) || !srv.isRunning()) continue;
                    rc = (CacheService)srv;
                    enumC = rc.getCacheNames();
                    while (enumC.hasMoreElements()) {
                        Coherence._trace(srv.getInfo().getServiceName() + ":" + String.valueOf(enumC.nextElement()));
                    }
                }
            } else if (sFunction.equals("memory")) {
                rt = Runtime.getRuntime();
                rt.gc();
                lTotal = rt.totalMemory();
                lFree = rt.freeMemory();
                Coherence._trace("total=" + lTotal / 1000L + "K (" + lTotal + ")");
                Coherence._trace("free =" + lFree / 1000L + "K (" + lFree + ")");
                try {
                    LMax = (Long)ClassHelper.invoke(rt, "maxMemory", ClassHelper.VOID);
                    Coherence._trace("max  =" + LMax / 1000L + "K (" + LMax + ")");
                }
                catch (Throwable LMax) {
                    // empty catch block
                }
                oResult = lFree;
            } else if (sFunction.equals("new")) {
                if (cParams > 0) {
                    try {
                        sClass = asParam[0];
                        if (sClass.startsWith("Component")) {
                            oResult = Coherence._newInstance(sClass);
                        } else {
                            clz = Class.forName(sClass);
                            if (cParams > 1) {
                                ao = new Object[cParams - 1];
                                System.arraycopy(aoParam, 1, ao, 0, cParams - 1);
                                oResult = ClassHelper.newInstance(clz, ao);
                            } else {
                                oResult = clz.newInstance();
                            }
                        }
                    }
                    catch (Exception e) {
                        Coherence.printException(null, e);
                    }
                }
                if (!fSilent) {
                    Coherence._trace(Coherence.toString(oResult));
                }
                ((ThreadLocal)this.get_Sink()).set(oResult);
            } else if (sFunction.startsWith("process")) {
                if (this.isMapValid()) {
                    this.doProcess(aoParam, sFunction.equals("processAsync"), fSilent);
                }
            } else if (sFunction.equals("profile")) {
                lBegin = Base.getSafeTimeMillis();
                this.processCommand(sCmd);
                lElapsed = Base.getSafeTimeMillis() - lBegin;
                Coherence._trace("Elapsed " + lElapsed + "ms");
            } else if (sFunction.equals("put")) {
                if (this.isMapValid() && cParams >= 2) {
                    oResult = map.put(aoParam[0], aoParam[1]);
                    if (!fSilent) {
                        Coherence._trace(Coherence.toString(oResult));
                    }
                }
            } else if (sFunction.equals("release")) {
                if (this.isMapValid()) {
                    CacheFactory.releaseCache(map);
                }
            } else if (sFunction.equals("remove")) {
                if (this.isMapValid() && cParams >= 1) {
                    oResult = map.remove(aoParam[0]);
                    ((ThreadLocal)this.get_Sink()).set(oResult);
                    if (!fSilent) {
                        Coherence._trace(Coherence.toString(oResult));
                    }
                }
            } else if (sFunction.equals("restore")) {
                this.doRestore(asParam, fSilent);
            } else if (sFunction.equalsIgnoreCase("runAs")) {
                oResult = this.doSecure(asParam, fSilent);
            } else if (sFunction.equals("scan")) {
                if (this.isMapValid()) {
                    this.doScan(asParam);
                }
            } else if (sFunction.equals("server")) {
                this.doServer(asParam);
            } else if (sFunction.equals("service") || sFunction.equals("whoami")) {
                if (service == null) {
                    this.processCommand("who");
                } else {
                    Coherence._trace(String.valueOf(service));
                    Coherence._trace(String.valueOf(service.getInfo().getServiceMembers()));
                }
            } else if (sFunction.equals("services")) {
                e = CacheFactory.ensureCluster().getServiceNames();
                while (e.hasMoreElements()) {
                    sName = e.nextElement();
                    info = Coherence.getSafeCluster().getServiceInfo(sName);
                    if (info == null) continue;
                    Coherence._trace(info.toString());
                }
            } else if (sFunction.equals("sleep")) {
                lMillis = 1L;
                try {
                    lMillis = Long.parseLong(asParam[0]);
                }
                catch (NumberFormatException info) {
                    // empty catch block
                }
                oKey = null;
                if (cParams > 1) {
                    if (!this.isMapValid()) {
                        return null;
                    }
                    oKey = aoParam[1];
                }
                try {
                    lStart = Base.getSafeTimeMillis();
                    if (oKey != null) {
                        map.lock(oKey, -1L);
                    }
                    if (lMillis > 0L) {
                        Blocking.sleep(lMillis);
                        lStop = Base.getSafeTimeMillis();
                    } else {
                        do {
                            for (i = 0; i < 100; ++i) {
                            }
                            Thread.yield();
                        } while ((lStop = Base.getSafeTimeMillis()) < lStart - lMillis);
                    }
                    if (fSilent) ** GOTO lbl661
                    Coherence._trace("Elapsed " + (lStop - lStart) + "ms");
                }
                catch (InterruptedException e) {
                    Coherence._trace("Sleep was interrupted; re-setting the interrupt flag...", 3);
                    Thread.currentThread().interrupt();
                    if (fSilent) ** GOTO lbl661
                    throw Base.ensureRuntimeException(e);
                }
                finally {
                    if (oKey != null) {
                        map.unlock(oKey);
                    }
                }
            } else if (sFunction.equals("size")) {
                if (!this.isMapValid()) {
                    return null;
                }
                if (cParams > 0) {
                    sName = asParam[0];
                    if (this.getFilters().containsKey(sName)) {
                        nPage = -1;
                        if (cParams > 1) {
                            nPage = Integer.parseInt(asParam[1]);
                        }
                        setEntry = this.applyFilter(sName, true, null, nPage);
                    } else {
                        map = CacheFactory.getCache(sName);
                        setEntry = map.entrySet();
                    }
                } else {
                    setEntry = map.entrySet();
                }
                cSize = setEntry.size();
                if (!fSilent) {
                    Coherence._trace(String.valueOf(cSize));
                }
                ((ThreadLocal)this.get_Sink()).set(setEntry);
            } else if (sFunction.equals("stats")) {
                fCluster = true;
                fP2p = false;
                fReset = false;
                iNext = 0;
                if (cParams > iNext && asParam[iNext].equals("service")) {
                    fCluster = false;
                    ++iNext;
                } else if (cParams > iNext && asParam[iNext].equals("p2p")) {
                    fCluster = false;
                    fP2p = true;
                    ++iNext;
                }
                if (cParams > iNext && asParam[iNext].equals("reset")) {
                    fReset = true;
                }
                v3 = sSilent = fSilent != false ? "@" : "";
                if (fCluster) {
                    v4 = sTarget = this.getMap() == null ? "&" : "&getCacheService.getService.";
                    if (fReset) {
                        this.processCommand("@" + sTarget + "getCluster.resetStats");
                    }
                    oResult = this.processCommand(sSilent + sTarget + "getCluster.formatStats");
                } else if (fP2p) {
                    v5 = sTarget = this.getMap() == null ? "&" : "&getCacheService.getService.";
                    if (fReset) {
                        this.processCommand("@" + sTarget + "getCluster.resetPointToPointStats");
                    }
                    oResult = this.processCommand(sSilent + sTarget + "getCluster.formatPointToPointStats");
                } else if (this.isMapValid()) {
                    if (fReset) {
                        this.processCommand("@&getCacheService.getService.resetStats");
                    }
                    oResult = this.processCommand(sSilent + "&getCacheService.getService.formatStats [true]");
                }
            } else if (sFunction.equals("sum")) {
                if (!this.isMapValid()) {
                    return null;
                }
                cSum = 0L;
                cNums = 0;
                cNots = 0;
                for (V oVal : map.values()) {
                    if (oVal instanceof Number) {
                        ++cNums;
                        cSum += ((Number)oVal).longValue();
                        continue;
                    }
                    if (oVal instanceof Versionable) {
                        oVer = ((Versionable)oVal).getVersionIndicator();
                        if (oVer instanceof Number) {
                            ++cNums;
                            cSum += ((Number)oVer).longValue();
                            continue;
                        }
                        ++cNots;
                        continue;
                    }
                    ++cNots;
                }
                if (!fSilent) {
                    Coherence._trace("sum=" + cSum + " (" + cNums + " values were numbers, " + cNots + " were not)");
                }
                oResult = cSum;
                ((ThreadLocal)this.get_Sink()).set(oResult);
            } else if (sFunction.equals("waitkey")) {
                if (!this.isMapValid()) {
                    return null;
                }
                oKeyStart = aoParam[0];
                oKeyStop = aoParam[1];
                Coherence._trace("waiting for key: " + String.valueOf(oKeyStart));
                while (!map.containsKey(oKeyStart)) {
                    Blocking.sleep(10L);
                }
                Coherence._trace("waiting for key: " + String.valueOf(oKeyStop));
                lBegin = Base.getSafeTimeMillis();
                while (!map.containsKey(oKeyStop)) {
                    Blocking.sleep(10L);
                }
                lElapsed = Base.getSafeTimeMillis() - lBegin;
                Coherence._trace(String.valueOf(new Date()) + ": done (" + lElapsed + "ms)");
            } else if (sFunction.equals("worker")) {
                sName = null;
                worker = null;
                try {
                    sName = "Worker!" + Integer.parseInt(asParam[0]);
                    worker = (Worker)this._findChild(sName);
                    if (worker == null) {
                        Coherence._trace(sName + " has been terminated.");
                        return null;
                    }
                    if (!fSilent) {
                        Coherence._trace(worker.toString());
                    }
                }
                catch (RuntimeException lBegin) {
                    // empty catch block
                }
                if (worker == null) {
                    fWait = cParams == 1 && asParam[0].equals("wait") != false;
                    for (i = 0; i < 1000; ++i) {
                        sName = "Worker!" + i;
                        worker = (Worker)this._findChild(sName);
                        if (worker == null) {
                            if (cParams <= 0 || fWait) continue;
                            break;
                        }
                        if (fWait) {
                            worker.getThread().join();
                            continue;
                        }
                        if (cParams != 0) continue;
                        Coherence._trace(worker.toString());
                    }
                    if (!fWait && cParams > 0) {
                        worker = new Worker();
                        this._addChild(worker, sName);
                        worker.setThreadName(sName);
                        worker.getQueue().add(sCmd);
                        worker.start();
                    }
                }
                ((ThreadLocal)this.get_Sink()).set(worker == null ? Worker.getWorkerGroup() : worker);
            } else if (sFunction.equals("begin") || sFunction.equals("commit") || sFunction.equals("rollback")) {
                if (this.isMapValid()) {
                    this.doTransaction(sFunction, asParam);
                }
            } else if (sFunction.equals("pause")) {
                cluster = Coherence.getSafeCluster();
                member = (Member)cluster.getLocalMember();
                while (member.getId() == 0) {
                    Coherence._trace("pausing input; waiting to join cluster");
                    Blocking.sleep(1000L);
                    member = (Member)cluster.getLocalMember();
                }
                file = new File("member" + member.getId());
                Coherence._trace("pausing input; create file " + String.valueOf(file) + " to continue");
                while (!file.exists()) {
                    Blocking.sleep(1000L);
                }
                file.delete();
            } else {
                Coherence._trace("Unknown command: \"" + sFunction + "\"\nPrint \"help\" for command list");
            }
        }
        return oResult;
    }

    public static Object processFunction(Object target, String sFunction, boolean fSilent, Object[] aoParam) {
        boolean fLast = false;
        try {
            do {
                boolean fTryStatic;
                boolean fTryInstance;
                String sMethod = sFunction;
                int ofNext = sFunction.indexOf(46);
                if (ofNext == -1) {
                    ofNext = sFunction.length();
                    fLast = true;
                } else {
                    sMethod = sFunction.substring(0, ofNext);
                    sFunction = sFunction.substring(ofNext + 1);
                }
                int nIx = -1;
                int ofIx = sMethod.indexOf(91);
                if (ofIx != -1) {
                    nIx = Integer.parseInt(sMethod.substring(ofIx + 1, sMethod.indexOf(93)));
                    sMethod = sMethod.substring(0, ofIx);
                }
                if (sMethod.endsWith("lock") && aoParam.length > 0 && "*".equals(aoParam[0])) {
                    aoParam[0] = ConcurrentMap.LOCK_ALL;
                }
                boolean bl = fTryInstance = !(fTryStatic = target instanceof Class);
                if (fTryStatic) {
                    try {
                        target = ClassHelper.invokeStatic((Class)target, sMethod, fLast ? aoParam : ClassHelper.VOID);
                    }
                    catch (NoSuchMethodException e) {
                        fTryInstance = true;
                    }
                }
                if (fTryInstance) {
                    target = ClassHelper.invoke(target, sMethod, fLast ? aoParam : ClassHelper.VOID);
                }
                if (nIx >= 0) {
                    target = Array.get(target, nIx);
                }
                if (fLast) {
                    if (fSilent) continue;
                    Coherence._trace(Coherence.toString(target));
                    continue;
                }
                if (target != null) continue;
                if (!fSilent) {
                    Coherence._trace("Exception: " + sMethod + " returned null");
                }
                break;
            } while (!fLast);
        }
        catch (Throwable e) {
            target = e;
            Coherence.printException(null, e);
        }
        return target;
    }

    protected String readLine(Object oReader, Object oHistory) throws Exception {
        if (oReader instanceof Reader) {
            char[] ach = new char[256];
            int cch = ((Reader)oReader).read(ach);
            return cch <= 1 ? "" : new String(ach).trim();
        }
        String sLine = (String)ClassHelper.invoke(oReader, "readLine", null);
        ClassHelper.invoke(oReader, "redrawLine", null);
        ClassHelper.invoke(oReader, "flush", null);
        return sLine;
    }

    protected void recordCommand(String sCmd) throws InterruptedException {
        List list = this.getCommandHistory();
        if (list == null || sCmd.startsWith("history") || sCmd.startsWith("!") || !list.isEmpty() && list.get(list.size() - 1).equals(sCmd)) {
            return;
        }
        list.add(sCmd);
    }

    protected static void replaceSystemProperties(XmlElement xml) {
        XmlHelper.replaceSystemProperties(xml, "system-property");
    }

    public static String resolveEdition(XmlElement xmlLicense) {
        String sDescription;
        String sLicenseFile;
        String sEdition = xmlLicense.getSafeElement("edition-name").getString(DEFAULT_EDITION);
        int nEdition = 0;
        if (sEdition.equalsIgnoreCase("ge") || sEdition.equalsIgnoreCase("grid") || sEdition.equalsIgnoreCase("dge")) {
            sLicenseFile = "coherence-grid.xml";
            sEdition = DEFAULT_EDITION;
            sDescription = "Grid Edition";
            nEdition = 5;
        } else if (sEdition.equalsIgnoreCase("ee") || sEdition.equalsIgnoreCase("enterprise") || sEdition.equalsIgnoreCase("ae")) {
            sLicenseFile = "coherence-enterprise.xml";
            sEdition = "EE";
            sDescription = "Enterprise Edition";
            nEdition = 4;
        } else if (sEdition.equalsIgnoreCase("ce") || sEdition.equalsIgnoreCase("community")) {
            sLicenseFile = "coherence-community.xml";
            sEdition = "CE";
            sDescription = "Community Edition";
            nEdition = 3;
        } else if (sEdition.equalsIgnoreCase("se") || sEdition.equalsIgnoreCase("standard")) {
            sLicenseFile = "coherence-standard.xml";
            sEdition = "SE";
            sDescription = "Standard Edition";
            nEdition = 2;
        } else if (sEdition.equalsIgnoreCase("rtc") || sEdition.equalsIgnoreCase("realtime") || sEdition.equalsIgnoreCase("cc") || sEdition.equalsIgnoreCase("compute")) {
            sLicenseFile = "coherence-rtc.xml";
            sEdition = "RTC";
            sDescription = "Real-Time Client";
            nEdition = 1;
        } else if (sEdition.equalsIgnoreCase("dc") || sEdition.equalsIgnoreCase("client")) {
            sLicenseFile = "coherence-client.xml";
            sEdition = "DC";
            sDescription = "Data Client";
            nEdition = 0;
        } else {
            String sErrorMsg = "Invalid \"edition-name\" specified: \"" + sEdition + "\" (valid editions are GE/EE/SE/RTC/DC)";
            Coherence._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Coherence.loadLicenses(xmlLicense, sLicenseFile);
        LicensedObject.LicenseData[] aLicense = LicensedObject.getLicenseData();
        Coherence._assert(aLicense != null);
        Coherence app = (Coherence)Coherence.get_Instance();
        app.setEdition(nEdition);
        app.setProduct("Oracle Coherence " + sEdition);
        xmlLicense.ensureElement("edition-name").setString(sEdition);
        return sDescription;
    }

    protected static String resolveMode(XmlElement xmlLicense) {
        int nMode = 0;
        String sMode = xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE);
        String sDescription = switch (sMode.length() > 0 ? (int)sMode.charAt(0) : 63) {
            case 69, 101 -> {
                nMode = 0;
                yield "Evaluation";
            }
            case 68, 100 -> {
                nMode = 1;
                yield "Development";
            }
            case 80, 112 -> {
                nMode = 2;
                yield "Production";
            }
            default -> {
                String sErrorMsg = "Invalid \"mode\" specified: \"" + sMode + "\" (valid modes are eval/dev/prod)";
                Coherence._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
        };
        sMode = MODE_NAMES[nMode];
        ((Coherence)Coherence.get_Instance()).setMode(nMode);
        xmlLicense.ensureElement("license-mode").setString(sMode);
        return sDescription;
    }

    @Override
    public void run() {
        super.run();
        Object sCmd = "";
        String[] asArg = Coherence.getArgument();
        if (asArg.length > 0) {
            sCmd = asArg[0].startsWith("@") ? asArg[0].substring(1) : "cache " + asArg[0];
            int c = asArg.length;
            for (int i = 1; i < c; ++i) {
                sCmd = (String)sCmd + " " + asArg[i];
            }
            CacheFactory.getCluster();
        } else {
            CacheFactory.ensureCluster();
        }
        Object oReader = this.createReader();
        Object oHistory = this.getHistory(oReader);
        this.ensureRunningLogger().setPrompt("?");
        while (true) {
            if (((String)sCmd).length() > 0) {
                try {
                    this.recordCommand((String)sCmd);
                    this.processCommand((String)sCmd);
                }
                catch (Throwable e) {
                    Coherence.printException(null, e);
                }
            }
            if (this.isStop()) {
                this.setStop(false);
                return;
            }
            try {
                Logger logger = this.getLogger();
                Blocking.sleep(50L);
                logger.setCommandPrompt(true);
                sCmd = this.readLine(oReader, oHistory);
                logger.setCommandPrompt(false);
                logger.setPendingLineFeed(false);
                continue;
            }
            catch (IOException e) {
                System.out.println("Shutting down due to " + String.valueOf(e));
                CacheFactory.shutdown();
                this.setStop(true);
                return;
            }
            catch (InvocationTargetException e) {
                System.out.println("Shutting down due to " + String.valueOf(e));
                CacheFactory.shutdown();
                this.setStop(true);
                return;
            }
            catch (Exception e) {
                System.out.println("resetting reader due to " + String.valueOf(e));
                oReader = this.createReader();
                sCmd = "";
                this.ensureRunningLogger();
                continue;
            }
            break;
        }
    }

    protected static void setBuildNumber(String s) {
        __s_BuildNumber = s;
    }

    protected static void setCluster(SafeCluster cluster) {
        __s_Cluster = cluster;
    }

    protected void setCommandHistory(List list) {
        this.__m_CommandHistory = list;
    }

    protected static void setConfigurationLoaded(boolean fLoaded) {
        __s_ConfigurationLoaded = fLoaded;
    }

    private void setEdition(int nEdition) {
        this.__m_Edition = nEdition;
    }

    protected void setFilters(Map map) {
        this.__m_Filters = map;
    }

    private static void setLicenseLoaded(boolean fLoaded) {
        if (fLoaded) {
            __s_LicenseLoaded = fLoaded;
        }
    }

    public void setLogger(Logger logger) {
        Logger loggerPrev;
        AtomicReference refLogger = this.getLoggerRef();
        do {
            if ((loggerPrev = (Logger)refLogger.get()) != logger) continue;
            return;
        } while (!refLogger.compareAndSet(loggerPrev, logger));
        if (loggerPrev != null) {
            loggerPrev.shutdown();
        }
    }

    protected void setLoggerRef(AtomicReference logger) {
        this.__m_LoggerRef = logger;
    }

    public static void setLoggingLevel(Integer ILevel) {
        Coherence app = (Coherence)Coherence.get_Instance();
        Logger logger = app.getLogger();
        logger.setLevel(ILevel);
    }

    protected void setMap(NamedCache map) {
        this.__m_Map = map;
    }

    private void setMode(int nMode) {
        this.__m_Mode = nMode;
    }

    public void setPersistenceToolsHelper(PersistenceToolsHelper helperTools) {
        this.__m_PersistenceToolsHelper = helperTools;
    }

    protected void setProduct(String sProduct) {
        Coherence._assert(this.getProduct() == null || this.getProduct().equals(sProduct));
        this.__m_Product = sProduct;
        this.getLogger().setLogParameters(null);
    }

    protected void setScript(boolean fScript) {
        this.__m_Script = fScript;
    }

    protected void setScriptEngine(ScriptEngine engine) {
        this.__m_ScriptEngine = engine;
    }

    protected void setService(CacheService service) {
        this.__m_Service = service;
    }

    public static void setServiceConfig(String sServiceType, XmlElement xmlCfg) {
        SafeCluster cluster;
        Coherence app;
        Logger logger;
        if (Coherence.getServiceConfig(sServiceType) == null) {
            throw new IllegalArgumentException("Unknown service type: " + sServiceType);
        }
        Coherence.getServiceConfigMap().put(sServiceType, xmlCfg.clone());
        if ("$Logger".equals(sServiceType) && (logger = (app = (Coherence)Coherence.get_Instance()).getLogger()).isStarted()) {
            app.setLogger(null);
        }
        if ("$Management".equals(sServiceType) && !(cluster = Coherence.getSafeCluster()).isRunning()) {
            Gateway mgmt = Gateway.createGateway(LegacyXmlGatewayHelper.fromXml(xmlCfg, new DefaultGatewayDependencies()), cluster);
            cluster.setManagement(mgmt);
        }
    }

    protected static void setServiceConfigMap(Map map) {
        __s_ServiceConfigMap = map;
    }

    protected void setStop(boolean fStop) {
        this.__m_Stop = fStop;
    }

    private static void setTloCluster(ThreadLocal tloCluster) {
        __s_TloCluster = tloCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        SafeCluster cluster;
        Class clazz = Coherence.get_CLASS();
        synchronized (clazz) {
            cluster = Coherence.getCluster();
        }
        try {
            if (cluster != null) {
                cluster.dispose();
            }
        }
        finally {
            clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                if (Coherence.getCluster() == cluster) {
                    Coherence.setCluster(null);
                    Coherence.getServiceConfigMap().clear();
                    Coherence.setConfigurationLoaded(false);
                    ((Coherence)Coherence.get_Instance()).setLogger(null);
                }
            }
        }
    }

    public static String toString(Object oResult) {
        Class<?> clzArrayType;
        int MAX_TRACE = 50;
        String BEGIN = " {\n ";
        String NEXT = "\n ";
        String END = "\n }";
        Class<?> clazz = clzArrayType = oResult == null ? null : oResult.getClass().getComponentType();
        if (clzArrayType == null) {
            if (oResult instanceof Iterator) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName());
                Iterator iter = (Iterator)oResult;
                if (iter.hasNext()) {
                    sb.append(" {\n ");
                    for (int i = 0; iter.hasNext() && i < 50; ++i) {
                        sb.append(Coherence.toString(iter.next()));
                        if (!iter.hasNext()) continue;
                        sb.append("\n ");
                    }
                    if (iter.hasNext()) {
                        sb.append("...");
                    }
                    sb.append("\n }");
                }
                return sb.toString();
            }
            if (oResult instanceof Enumeration) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName()).append(" {\n ");
                Enumeration e = (Enumeration)oResult;
                for (int i = 0; e.hasMoreElements() && i < 50; ++i) {
                    sb.append(Coherence.toString(e.nextElement()));
                    if (!e.hasMoreElements()) continue;
                    sb.append("\n ");
                }
                if (e.hasMoreElements()) {
                    sb.append("...");
                }
                sb.append("\n }");
                return sb.toString();
            }
            if (oResult instanceof Class) {
                return Base.toString((Class)oResult);
            }
            return String.valueOf(oResult);
        }
        int c = Array.getLength(oResult);
        StringBuffer sb = new StringBuffer();
        sb.append(clzArrayType.getName()).append('[').append(c).append(']');
        if (c > 0) {
            sb.append(" {\n ");
            int cTrace = Math.min(c, 50);
            for (int i = 0; i < cTrace; ++i) {
                if (i > 0) {
                    sb.append("\n ");
                }
                sb.append(Coherence.toString(Array.get(oResult, i)));
            }
            if (c > cTrace) {
                sb.append(", ...");
            }
            sb.append("\n }");
        }
        return sb.toString();
    }

    protected void txEnd() {
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            NamedCache cache = (NamedCache)((TransactionMap)((Object)map)).getBaseMap();
            this.setMap(cache);
            Logger logger = this.getLogger();
            logger.setPrompt(logger.getPrompt().substring(3));
        }
    }

    protected void txStart(int nConcur, int nIsolation, int nTimeout) {
        TransactionMap mapTx;
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            mapTx = (TransactionMap)((Object)map);
        } else {
            mapTx = CacheFactory.getLocalTransaction(map);
            mapTx.setConcurrency(nConcur);
            mapTx.setTransactionIsolation(nIsolation);
            mapTx.setTransactionTimeout(nTimeout);
            mapTx.setValidator(new SimpleValidator());
            this.setMap((NamedCache)((Object)mapTx));
            Logger logger = this.getLogger();
            logger.setPrompt("Tx-" + logger.getPrompt());
        }
        mapTx.begin();
    }

    protected static void validateEnvironment() {
        String sVMName = System.getProperty("java.vm.name", "");
        String sOSName = System.getProperty("os.name", "");
        String sOSArch = System.getProperty("os.arch", "");
        String sDataModel = System.getProperty("sun.arch.data.model", "");
        if (sOSName.contains("SunOS") && sOSArch.contains("sparc") && sVMName.contains("HotSpot") && sVMName.contains("Client VM") && sDataModel.equals("32")) {
            String sMsg = "Coherence requires the 32-bit Hotspot JVM to be run in server mode on Solaris-sparc. Include the '-server' option on the command line to run the server JVM.";
            Coherence._trace(sMsg, 1);
            throw new RuntimeException(sMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        EDITION_NAMES = new String[]{"DC", "RTC", "SE", "CE", "EE", DEFAULT_EDITION};
        MODE_NAMES = new String[]{"eval", "dev", "prod"};
        Coherence._initStatic$Default();
        InputStream in = null;
        Object sVersion = null;
        String sVersionPrefix = "";
        String sDesc = null;
        try {
            URL url = Resources.findResource(FILE_CFG_COHERENCE, Coherence.get_CLASS().getClassLoader());
            if (url != null) {
                in = url.openStream();
                XmlDocument xmlDoc = new SimpleParser(false).parseXml(in);
                XmlElement xmlCfg = xmlDoc.getSafeElement("license-config");
                Coherence.setBuildNumber(xmlCfg.getSafeElement("build-number").getString());
                sDesc = xmlCfg.getSafeElement("build-description").getString();
                sVersion = xmlCfg.getSafeElement("version").getString();
                sVersionPrefix = xmlCfg.getSafeElement("version-prefix").getString();
                sVersionPrefix = sVersionPrefix == null || sVersionPrefix.isEmpty() ? "" : sVersionPrefix + ".";
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception url) {}
        }
        if (sVersion == null || ((String)sVersion).isEmpty()) {
            System.err.println("Oracle Coherence: The build information could not be located in the file /tangosol-coherence.xml; some functionality may be disabled");
            sVersion = "n/a";
            Coherence.setBuildNumber("n/a");
        }
        if (sDesc != null && !sDesc.isEmpty()) {
            sVersion = (String)sVersion + " " + sDesc;
        }
        VERSION = sVersion;
        VERSION_INTERNAL = sVersionPrefix + (String)sVersion;
        VERSION_INT = ServiceMemberSet.parseVersion((String)sVersion);
    }

    public static class CacheItem
    extends Data
    implements Invocable,
    PriorityTask,
    Versionable {
        private long __m_ExecutionTimeoutMillis;
        private int __m_Index;
        private String __m_InvokeCommand;
        private transient boolean __m_Local;
        private int __m_Origin;
        private transient Object __m_Result;
        private int __m_SchedulingPriority;
        private transient InvocationService __m_Service;
        private Comparable __m_VersionIndicator;

        public CacheItem() {
            this(null, null, true);
        }

        public CacheItem(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setLocal(true);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CacheItem();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$CacheItem".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public int compareTo(Object o) {
            CacheItem that = (CacheItem)o;
            return Integer.compare(this.getIndex(), that.getIndex());
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheItem) {
                CacheItem that = (CacheItem)obj;
                return this.getIndex() == that.getIndex() && this.getOrigin() == that.getOrigin();
            }
            return false;
        }

        @Override
        public long getExecutionTimeoutMillis() {
            return this.__m_ExecutionTimeoutMillis;
        }

        public int getIndex() {
            return this.__m_Index;
        }

        public String getInvokeCommand() {
            return this.__m_InvokeCommand;
        }

        public int getOrigin() {
            return this.__m_Origin;
        }

        @Override
        public long getRequestTimeoutMillis() {
            return 0L;
        }

        @Override
        public Object getResult() {
            return this.__m_Result;
        }

        @Override
        public int getSchedulingPriority() {
            return this.__m_SchedulingPriority;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        public synchronized Comparable getVersionIndicator() {
            Comparable version = this.__m_VersionIndicator;
            if (version == null) {
                version = Long.valueOf(0L);
                this.setVersionIndicator(version);
            }
            return version;
        }

        public int hashCode() {
            return this.getIndex() * this.getOrigin();
        }

        @Override
        public synchronized void incrementVersion() {
            this.setVersionIndicator(Long.valueOf((Long)this.getVersionIndicator() + 1L));
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        public boolean isLocal() {
            return this.__m_Local;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if ("ReadException".equals(this.getInvokeCommand())) {
                throw new IOException("Test exception");
            }
        }

        @Override
        public void run() {
            String sCommand = this.getInvokeCommand();
            if ("exception".equals(sCommand)) {
                throw new RuntimeException("Test exception");
            }
            sCommand = Base.replace(sCommand, "{target}", String.valueOf(this.getService().getCluster().getLocalMember().getId()));
            sCommand = Base.replace(sCommand, "{context}", String.valueOf(this.getService().getUserContext()));
            try {
                Coherence app = (Coherence)Coherence.get_Instance();
                Object oResult = app.processCommand(sCommand);
                this.setResult(oResult == null || oResult instanceof Serializable ? oResult : oResult.getClass().getName());
            }
            catch (Throwable e) {
                this.setResult(e);
            }
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
        }

        public void setExecutionTimeoutMillis(long cMillis) {
            this.__m_ExecutionTimeoutMillis = cMillis;
        }

        public void setIndex(int i) {
            this.__m_Index = i;
        }

        public void setInvokeCommand(String oKey) {
            this.__m_InvokeCommand = oKey;
        }

        public void setLocal(boolean fLocal) {
            this.__m_Local = fLocal;
        }

        public void setOrigin(int i) {
            this.__m_Origin = i;
        }

        protected void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        public void setSchedulingPriority(int iPriority) {
            this.__m_SchedulingPriority = iPriority;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        public void setVersionIndicator(Comparable lVersion) {
            this.__m_VersionIndicator = lVersion;
        }

        @Override
        public String toString() {
            return "CacheItem{Index=" + this.getIndex() + ", Origin=" + this.getOrigin() + ", Local=" + this.isLocal() + ", Version=" + String.valueOf(this.getVersionIndicator()) + "}";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            if ("WriteException".equals(this.getInvokeCommand())) {
                throw new IOException("Test exception");
            }
            out.defaultWriteObject();
        }
    }

    public static class Logger
    extends com.tangosol.coherence.component.util.daemon.queueProcessor.Logger {
        private boolean __m_CommandPrompt;
        private boolean __m_Configured;
        private Method __m_DMSActiveContextMethod;
        private volatile boolean __m_DMSErrored;
        private transient int __m_HashCode;
        private long __m_LastPromptTimeMillis;
        private transient Object[] __m_LogParameters;
        private Constructor __m_ODLRecordConstructor;
        private Method __m_ODLRecordGetCtxMethod;
        private Method __m_ODLRecordInitMethod;
        private boolean __m_PendingLineFeed;
        private boolean __m_PendingPrompt;
        private String __m_Prompt;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public Logger() {
            this(null, null, true);
        }

        public Logger(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setFormat("{date} Oracle Coherence {version} <{level}> (thread={thread}): {text}");
                this.setLevel(10);
                this.setLimit(65536);
                this.setNotifier(new SingleWaiterMultiNotifier());
                this.setOverflowed(false);
                String[] a0 = new String[]{"{logRecord}", "{uptime}", "{thread}", "{member}", "{role}", "{location}", "{product}", "{version}"};
                this.setParameters(a0);
                this.setPriority(3);
                this.setWaitMillis(5000L);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
            this._addChild(new ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public long getDefaultWaitMillis() {
            return 500L;
        }

        public static Component get_Instance() {
            return new Logger();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Logger".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean checkDiagnosability() {
            try {
                Method methDMSActiveCtx = this.getDMSActiveContextMethod();
                return methDMSActiveCtx != null && !this.isDMSErrored() && methDMSActiveCtx.invoke(null, (Object[])null) != null;
            }
            catch (Exception e) {
                this.setDMSErrored(true);
                System.err.println("Oracle Diagnostic Logging was discovered but accessing expected methods was unsuccessful.");
                e.printStackTrace();
                return false;
            }
        }

        @Override
        protected Object[] collectLogParameters() {
            Object[] aoParam = this.getLogParameters();
            try {
                int nMemberOld;
                Coherence app = (Coherence)this.get_Module();
                SafeCluster cluster = app.getCluster();
                Member member = cluster == null || !cluster.isRunning() ? null : (Member)cluster.getLocalMember();
                int nMemberNew = member == null ? 0 : member.getId();
                int n = nMemberOld = aoParam == null ? -1 : (Integer)aoParam[0];
                if (nMemberNew != nMemberOld) {
                    aoParam = member == null ? new Object[]{Base.makeInteger(0), null, null, app.getProduct()} : new Object[]{Base.makeInteger(nMemberNew), member.getRoleName(), member.getLocationInfo(), app.getProduct()};
                    this.setLogParameters(aoParam);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return aoParam;
        }

        @Override
        protected String formatLogRecord(String sFormat, LogRecord logRecord) {
            String sMessage = super.formatLogRecord(sFormat, logRecord);
            String sECID = null;
            Method methODLGetCtx = this.getODLRecordGetCtxMethod();
            if (methODLGetCtx != null && logRecord.getClass() == methODLGetCtx.getDeclaringClass()) {
                try {
                    Object oCtx = methODLGetCtx.invoke((Object)logRecord, (Object[])null);
                    if (oCtx != null) {
                        sECID = (String)ClassHelper.invoke(oCtx, "getECID", null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sMessage = Base.replace(sMessage, "{ecid}", this.formatParameter("{ecid}", sECID));
            return sMessage;
        }

        @Override
        protected String formatParameter(String sParamName, Object oParamValue) {
            if (sParamName != null && sParamName.length() > 3) {
                switch (sParamName.charAt(1)) {
                    case 'e': {
                        if (!sParamName.equals("{ecid}")) break;
                        return oParamValue == null ? "n/a" : (String)oParamValue;
                    }
                    case 'm': {
                        if (!sParamName.equals("{member}")) break;
                        int nMember = oParamValue instanceof Integer ? (Integer)oParamValue : 0;
                        return nMember == 0 ? "n/a" : String.valueOf(nMember);
                    }
                    case 'l': 
                    case 'r': {
                        if (!sParamName.equals("{role}") && !sParamName.equals("{location}")) break;
                        return oParamValue == null ? "" : (String)oParamValue;
                    }
                    case 'p': {
                        if (!sParamName.equals("{product}")) break;
                        String sProduct = (String)oParamValue;
                        return sProduct == null ? Coherence.TITLE : sProduct;
                    }
                    case 'v': {
                        if (!sParamName.equals("{version}")) break;
                        return VERSION;
                    }
                }
            }
            return super.formatParameter(sParamName, oParamValue);
        }

        protected Method getDMSActiveContextMethod() {
            return this.__m_DMSActiveContextMethod;
        }

        public int getHashCode() {
            int nHash = this.__m_HashCode;
            return nHash == 0 ? System.identityHashCode(this.get_Module()) : nHash;
        }

        protected long getLastPromptTimeMillis() {
            return this.__m_LastPromptTimeMillis;
        }

        public Object[] getLogParameters() {
            return this.__m_LogParameters;
        }

        protected Constructor getODLRecordConstructor() {
            return this.__m_ODLRecordConstructor;
        }

        protected Method getODLRecordGetCtxMethod() {
            return this.__m_ODLRecordGetCtxMethod;
        }

        protected Method getODLRecordInitMethod() {
            return this.__m_ODLRecordInitMethod;
        }

        public String getPrompt() {
            return this.__m_Prompt;
        }

        @Override
        public String getThreadName() {
            return super.getThreadName() + "@" + this.getHashCode() + " " + VERSION;
        }

        @Override
        protected LogRecord instantiateLogRecord(Level level, String sMessage) {
            if (this.checkDiagnosability()) {
                try {
                    Constructor consLogRecord = this.getODLRecordConstructor();
                    Method methInitLogCtx = this.getODLRecordInitMethod();
                    if (consLogRecord != null && methInitLogCtx != null) {
                        LogRecord logRecord = (LogRecord)consLogRecord.newInstance(level, sMessage);
                        methInitLogCtx.invoke((Object)logRecord, (Object[])null);
                        return logRecord;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.instantiateLogRecord(level, sMessage);
        }

        public boolean isCommandPrompt() {
            return this.__m_CommandPrompt;
        }

        public boolean isConfigured() {
            return this.__m_Configured;
        }

        protected boolean isDMSErrored() {
            return this.__m_DMSErrored;
        }

        public boolean isPendingLineFeed() {
            return this.__m_PendingLineFeed;
        }

        protected boolean isPendingPrompt() {
            return this.__m_PendingPrompt;
        }

        @Override
        public void onInit() {
            super.onInit();
            this.setPrompt("?");
            Class<?> clzDMSCtx = null;
            Class<?> clzODLLogRec = null;
            ClassLoader loader = Logger.get_CLASS().getClassLoader();
            try {
                clzDMSCtx = Class.forName("oracle.dms.context.DMSContextManager", false, loader);
                clzODLLogRec = Class.forName("oracle.core.ojdl.logging.ODLLogRecord", false, loader);
                Class[] aclzParams = new Class[]{};
                Method methActiveCtx = clzDMSCtx.getMethod("getActiveContext", aclzParams);
                Method methInitCtx = clzODLLogRec.getMethod("initLoggingContext", aclzParams);
                Method methGetCtx = clzODLLogRec.getMethod("getLoggingContext", aclzParams);
                Constructor<?> consLogRec = clzODLLogRec.getConstructor(Level.class, String.class);
                this.setDMSActiveContextMethod(methActiveCtx);
                this.setODLRecordInitMethod(methInitCtx);
                this.setODLRecordGetCtxMethod(methGetCtx);
                this.setODLRecordConstructor(consLogRec);
            }
            catch (ClassNotFoundException aclzParams) {
            }
            catch (NoSuchMethodException e) {
                System.err.println("Oracle Diagnostic Logging was discovered but expected methods were not found.");
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void onInterval() {
            super.onInterval();
            Coherence coh = (Coherence)this.get_Module();
            if (coh.getCluster() != null || !this.getQueue().isEmpty()) return;
            Class<Coherence> clazz = Coherence.class;
            synchronized (Coherence.class) {
                if (coh.getCluster() != null) return;
                coh.setLogger(null);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onLog() {
            super.onLog();
            if (this.isPendingLineFeed()) {
                PrintStream out;
                PrintStream printStream = out = System.out;
                synchronized (printStream) {
                    out.println();
                }
                this.setPendingLineFeed(false);
            }
            this.setPendingPrompt(this.isCommandPrompt());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNotify() {
            long lCurrent;
            super.onNotify();
            if (this.isPendingPrompt() && (lCurrent = Base.getSafeTimeMillis()) > this.getLastPromptTimeMillis() + this.getWaitMillis()) {
                PrintStream out;
                PrintStream printStream = out = System.out;
                synchronized (printStream) {
                    out.print("\nMap (" + this.getPrompt() + "): ");
                    out.flush();
                }
                this.setPendingPrompt(false);
                this.setPendingLineFeed(true);
                this.setLastPromptTimeMillis(lCurrent);
            }
        }

        public void setCommandPrompt(boolean fPrompt) {
            this.__m_CommandPrompt = fPrompt;
            this.setPendingPrompt(fPrompt);
            this.setLastPromptTimeMillis(0L);
            this.setWaitMillis(fPrompt ? this.getDefaultWaitMillis() : 5000L);
            this.getNotifier().signal();
        }

        public void setConfigured(boolean fConfigured) {
            this.__m_Configured = fConfigured;
        }

        protected void setDMSActiveContextMethod(Method methodContext) {
            this.__m_DMSActiveContextMethod = methodContext;
        }

        protected void setDMSErrored(boolean fErrored) {
            this.__m_DMSErrored = fErrored;
        }

        public void setHashCode(int n) {
            this.__m_HashCode = n;
            Thread thread = this.getThread();
            if (thread != null) {
                thread.setName(this.getThreadName());
            }
        }

        protected void setLastPromptTimeMillis(long nTime) {
            this.__m_LastPromptTimeMillis = nTime;
        }

        public void setLogParameters(Object[] aoParameters) {
            this.__m_LogParameters = aoParameters;
        }

        protected void setODLRecordConstructor(Constructor consLogRec) {
            this.__m_ODLRecordConstructor = consLogRec;
        }

        protected void setODLRecordGetCtxMethod(Method methGetCtx) {
            this.__m_ODLRecordGetCtxMethod = methGetCtx;
        }

        protected void setODLRecordInitMethod(Method methInit) {
            this.__m_ODLRecordInitMethod = methInit;
        }

        public void setPendingLineFeed(boolean fPending) {
            this.__m_PendingLineFeed = fPending;
        }

        protected void setPendingPrompt(boolean fPending) {
            this.__m_PendingPrompt = fPending;
        }

        public void setPrompt(String sPrompt) {
            this.__m_Prompt = sPrompt;
        }

        @Override
        public synchronized void shutdown() {
            super.shutdown();
            if (this.isCommandPrompt()) {
                System.out.println();
            }
        }

        static {
            Logger.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Logger$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Logger$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class ShutdownHook
        extends Logger.ShutdownHook {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("UnregisterAction", UnregisterAction.get_CLASS());
            }

            public ShutdownHook() {
                this(null, null, true);
            }

            public ShutdownHook(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ShutdownHook();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Logger$ShutdownHook".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                ShutdownHook.__initStatic();
            }

            public static class UnregisterAction
            extends Logger.ShutdownHook.UnregisterAction {
                public UnregisterAction() {
                    this(null, null, true);
                }

                public UnregisterAction(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new UnregisterAction();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Logger$ShutdownHook$UnregisterAction".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class Worker
    extends QueueProcessor
    implements InvocationObserver,
    MemberListener,
    EventDispatcherAwareInterceptor,
    PartitionListener,
    MapListener,
    ServiceListener {
        private Set __m_EventTypes;
        private String __m_InterceptorId;
        private transient int __m_RefCount;
        private transient boolean __m_Silent;
        private static transient ThreadGroup __s_WorkerGroup;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public Worker() {
            this(null, null, true);
        }

        public Worker(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Worker();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Worker".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public void entryDeleted(MapEvent e) {
            this.process(e);
        }

        public void entryInserted(MapEvent e) {
            this.process(e);
        }

        public void entryUpdated(MapEvent e) {
            this.process(e);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapListener)) {
                return false;
            }
            return obj != null && super.equals(MapListenerSupport.unwrap((MapListener)obj));
        }

        public Set getEventTypes() {
            return this.__m_EventTypes;
        }

        public String getInterceptorId() {
            return this.__m_InterceptorId;
        }

        public int getRefCount() {
            return this.__m_RefCount;
        }

        public static synchronized ThreadGroup getWorkerGroup() {
            ThreadGroup group = __s_WorkerGroup;
            if (group == null || group.isDestroyed()) {
                group = new ThreadGroup("Worker");
                Worker.setWorkerGroup(group);
            }
            return group;
        }

        @Override
        public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            Set setListenEvents = this.getEventTypes();
            LiteSet<Enum> setRetained = new LiteSet<Enum>();
            if (setListenEvents != null && !setListenEvents.isEmpty()) {
                Set<Enum> setSupportedEvents = dispatcher.getSupportedTypes();
                for (Enum eventType : setSupportedEvents) {
                    if (!setListenEvents.contains(eventType.name())) continue;
                    setRetained.add(eventType);
                }
            }
            if (!setRetained.isEmpty()) {
                dispatcher.addEventInterceptor(sIdentifier, this, setRetained, true);
            }
        }

        @Override
        public void invocationCompleted() {
            if (!this.isSilent()) {
                Worker._trace("Received \"invocationCompleted\" notification", 3);
            }
        }

        public boolean isSilent() {
            return this.__m_Silent;
        }

        @Override
        public void memberCompleted(com.tangosol.net.Member member, Object oResult) {
            if (!this.isSilent()) {
                Worker._trace("Received \"memberCompleted\" notification for " + String.valueOf(member) + "\nresult=" + String.valueOf(oResult), 3);
            }
        }

        @Override
        public void memberFailed(com.tangosol.net.Member member, Throwable eFailure) {
            if (!this.isSilent()) {
                Worker._trace("Received \"memberFailed\" notification for " + String.valueOf(member) + "\nexception=" + String.valueOf(eFailure), 3);
            }
        }

        @Override
        public void memberJoined(MemberEvent e) {
            this.process(e);
        }

        @Override
        public void memberLeaving(MemberEvent e) {
            this.process(e);
        }

        @Override
        public void memberLeft(com.tangosol.net.Member member) {
            Worker._trace("Received \"memberLeft\" notification for " + String.valueOf(member), 3);
        }

        @Override
        public void memberLeft(MemberEvent e) {
            this.process(e);
        }

        @Override
        public void onEvent(Event evt) {
            if (!this.isSilent()) {
                Worker._trace("Received interceptor event: " + String.valueOf(evt), 3);
            }
        }

        @Override
        protected void onExit() {
            super.onExit();
            this.get_Parent()._removeChild(this);
        }

        @Override
        protected void onNotify() {
            super.onNotify();
            String sCmd = (String)this.getQueue().remove();
            try {
                Coherence app = (Coherence)this.get_Module();
                app.processCommand(sCmd);
                if (app.isStop()) {
                    System.exit(0);
                }
                this.setExiting(true);
            }
            catch (InterruptedException e) {
                Worker._trace("Thread " + this.getThreadName() + " has been interrupted", 3);
                this.setExiting(true);
            }
        }

        @Override
        public void onPartitionEvent(PartitionEvent evt) {
            if (!this.isSilent()) {
                Worker._trace("Received " + String.valueOf(evt), 3);
            }
        }

        protected void process(MemberEvent evtMember) {
            if (!this.isSilent()) {
                Service service = evtMember.getService();
                Worker._trace("Received event for " + String.valueOf(service) + "\n" + String.valueOf(evtMember), 3);
            }
        }

        protected void process(MapEvent evtMap) {
            Object oValue;
            Object oKey;
            Map map = (Map)evtMap.getSource();
            String sName = "Map=" + map.getClass().getName();
            if (map instanceof NamedCache) {
                sName = "Cache=" + ((NamedCache)map).getCacheName();
            }
            if (!this.isSilent()) {
                Worker._trace(this.get_Name() + ": received event for " + sName + "\n" + String.valueOf(evtMap), 3);
            }
            if ("exception".equals(oKey = evtMap.getKey())) {
                throw new RuntimeException("Test exception");
            }
            if ("stack".equals(oKey)) {
                Worker._trace(Worker.get_StackTrace(), 3);
            }
            if ("command".equals(oKey) && (oValue = evtMap.getNewValue()) instanceof String) {
                try {
                    String sCommand = (String)oValue;
                    ((Coherence)this.get_Module()).processCommand(sCommand.replace(',', ';'));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WrapperException(e);
                }
            }
        }

        protected void process(ServiceEvent evtService) {
            if (!this.isSilent()) {
                com.tangosol.util.Service service = evtService.getService();
                Worker._trace("Received event for " + String.valueOf(service) + "\n" + String.valueOf(evtService), 3);
            }
        }

        @Override
        public void serviceStarted(ServiceEvent e) {
            this.process(e);
        }

        @Override
        public void serviceStarting(ServiceEvent e) {
            this.process(e);
        }

        @Override
        public void serviceStopped(ServiceEvent e) {
            this.process(e);
        }

        @Override
        public void serviceStopping(ServiceEvent e) {
            this.process(e);
        }

        public void setEventTypes(Set setTypes) {
            this.__m_EventTypes = setTypes;
        }

        public void setInterceptorId(String sId) {
            this.__m_InterceptorId = sId;
        }

        public void setRefCount(int c) {
            this.__m_RefCount = c;
        }

        public void setSilent(boolean fSilent) {
            this.__m_Silent = fSilent;
        }

        public static void setWorkerGroup(ThreadGroup group) {
            __s_WorkerGroup = group;
        }

        @Override
        public synchronized void start() {
            this.setThreadGroup(Worker.getWorkerGroup());
            super.start();
        }

        @Override
        public String toString() {
            return this.get_Name() + (String)(this.isStarted() ? " started at " + String.valueOf(new Date(this.getStartTimestamp())) : (this.getRefCount() > 0 ? " listening, count=" + this.getRefCount() : " not running"));
        }

        static {
            Worker.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Worker$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/application/console/Coherence$Worker$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }
}

