/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.repository;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.repository.Accelerated;
import com.oracle.coherence.repository.EntityFactory;
import com.oracle.coherence.repository.Indexed;
import com.tangosol.net.NamedMap;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.DeserializationAccelerator;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.function.Remote;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public abstract class AbstractRepositoryBase<ID, T, M> {
    private volatile boolean m_fInitialized;

    protected abstract ID getId(T var1);

    protected abstract Class<? extends T> getEntityType();

    protected abstract M getMap();

    abstract NamedMap<ID, T> getNamedMap();

    protected void ensureInitialized() {
        if (!this.m_fInitialized) {
            this.createIndices();
            this.m_fInitialized = true;
        }
    }

    protected void createIndices() {
        NamedMap namedMap = this.getNamedMap();
        Class entityType = this.getEntityType();
        if (this.getClass().isAnnotationPresent(Accelerated.class) || entityType.isAnnotationPresent(Accelerated.class)) {
            Logger.info("Configuring deserialization accelerator for " + this.getClass().getName());
            namedMap.addIndex(new DeserializationAccelerator());
        }
        Stream.of(entityType.getMethods()).filter(m -> m.isAnnotationPresent(Indexed.class)).forEach(m -> {
            try {
                Indexed idx = m.getAnnotation(Indexed.class);
                boolean fOrdered = idx.ordered();
                Comparator comparator = Comparator.class.equals(idx.comparator()) ? null : (Comparator)ClassHelper.newInstance(idx.comparator(), null);
                String sIndexMsg = "Creating index %s::%s (ordered=%b, comparator=%s)";
                Logger.info(() -> String.format(sIndexMsg, entityType.getSimpleName(), m.getName(), fOrdered, comparator));
                namedMap.addIndex(ValueExtractor.forMethod(m), fOrdered, comparator);
            }
            catch (Exception e) {
                throw Exceptions.ensureRuntimeException(e);
            }
        });
    }

    static <ID, T, U> InvocableMap.EntryProcessor<ID, T, Void> updaterProcessor(ValueUpdater<? super T, ? super U> updater, U value, EntityFactory<? super ID, ? extends T> factory) {
        return entry -> {
            Object entity = entry.getValue();
            if (entity == null && factory != null) {
                entity = factory.create((Object)entry.getKey());
            }
            updater.update((Object)entity, (Object)value);
            entry.setValue(entity);
            return null;
        };
    }

    static <ID, T, R> InvocableMap.EntryProcessor<ID, T, R> updateFunctionProcessor(Remote.Function<? super T, ? extends R> updater, EntityFactory<? super ID, ? extends T> factory) {
        return entry -> {
            Object entity = entry.getValue();
            if (entity == null && factory != null) {
                entity = factory.create((Object)entry.getKey());
            }
            Object result = updater.apply(entity);
            entry.setValue(entity);
            return result;
        };
    }

    static <ID, T, U, R> InvocableMap.EntryProcessor<ID, T, R> updateBiFunctionProcessor(Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value, EntityFactory<? super ID, ? extends T> factory) {
        return entry -> {
            Object entity = entry.getValue();
            if (entity == null && factory != null) {
                entity = factory.create((Object)entry.getKey());
            }
            Object result = updater.apply((Object)entity, (Object)value);
            entry.setValue(entity);
            return result;
        };
    }

    protected MapListener<? super ID, ? super T> instantiateMapListener(Listener<? super T> delegate) {
        return new MapListenerAdapter(delegate);
    }

    public void addListener(Listener<? super T> listener) {
        this.getNamedMap().addMapListener(this.instantiateMapListener(listener));
    }

    public void removeListener(Listener<? super T> listener) {
        this.getNamedMap().removeMapListener(this.instantiateMapListener(listener));
    }

    public void addListener(ID id, Listener<? super T> listener) {
        this.getNamedMap().addMapListener(this.instantiateMapListener(listener), id, false);
    }

    public void removeListener(ID id, Listener<? super T> listener) {
        this.getNamedMap().removeMapListener(this.instantiateMapListener(listener), id);
    }

    public void addListener(Filter<?> filter, Listener<? super T> listener) {
        if (!(filter instanceof MapEventFilter)) {
            filter = new MapEventFilter(7, filter);
        }
        this.getNamedMap().addMapListener(this.instantiateMapListener(listener), filter, false);
    }

    public void removeListener(Filter<?> filter, Listener<? super T> listener) {
        if (!(filter instanceof MapEventFilter)) {
            filter = new MapEventFilter(7, filter);
        }
        this.getNamedMap().removeMapListener(this.instantiateMapListener(listener), filter);
    }

    public Listener.Builder<T> listener() {
        return Listener.builder();
    }

    protected static class MapListenerAdapter<ID, T>
    implements MapListener<ID, T> {
        private final Listener<? super T> m_listener;

        MapListenerAdapter(Listener<? super T> listener) {
            this.m_listener = listener;
        }

        @Override
        public void entryInserted(MapEvent<ID, T> mapEvent) {
            this.m_listener.onInserted(mapEvent.getNewValue());
        }

        @Override
        public void entryUpdated(MapEvent<ID, T> mapEvent) {
            this.m_listener.onUpdated(mapEvent.getOldValue(), mapEvent.getNewValue());
        }

        @Override
        public void entryDeleted(MapEvent<ID, T> mapEvent) {
            this.m_listener.onRemoved(mapEvent.getOldValue());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapListenerAdapter that = (MapListenerAdapter)o;
            return this.m_listener.equals(that.m_listener);
        }

        public int hashCode() {
            return Objects.hash(this.m_listener);
        }
    }

    public static interface Listener<T> {
        default public void onInserted(T entity) {
        }

        default public void onUpdated(T oldEntity, T newEntity) {
        }

        default public void onRemoved(T entity) {
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private Consumer<T> m_onInsert;
            private BiConsumer<T, T> m_onUpdate;
            private Consumer<T> m_onRemove;

            public Listener<T> build() {
                return new DefaultListener<T>(this.m_onInsert, this.m_onUpdate, this.m_onRemove);
            }

            public Builder<T> onInsert(Consumer<T> eventHandler) {
                this.m_onInsert = this.addHandler(this.m_onInsert, eventHandler);
                return this;
            }

            public Builder<T> onUpdate(Consumer<T> eventHandler) {
                this.m_onUpdate = this.addHandler(this.m_onUpdate, (T tOld, T tNew) -> eventHandler.accept(tNew));
                return this;
            }

            public Builder<T> onUpdate(BiConsumer<T, T> eventHandler) {
                this.m_onUpdate = this.addHandler(this.m_onUpdate, eventHandler);
                return this;
            }

            public Builder<T> onRemove(Consumer<T> eventHandler) {
                this.m_onRemove = this.addHandler(this.m_onRemove, eventHandler);
                return this;
            }

            public Builder<T> onEvent(Consumer<T> eventHandler) {
                this.onInsert(eventHandler);
                this.onUpdate(eventHandler);
                this.onRemove(eventHandler);
                return this;
            }

            private Consumer<T> addHandler(Consumer<T> handlerChain, Consumer<T> handler) {
                return handlerChain == null ? handler : handlerChain.andThen(handler);
            }

            private BiConsumer<T, T> addHandler(BiConsumer<T, T> handlerChain, BiConsumer<T, T> handler) {
                return handlerChain == null ? handler : handlerChain.andThen(handler);
            }
        }
    }

    static class DefaultListener<T>
    implements Listener<T> {
        private final Consumer<T> m_onInsert;
        private final BiConsumer<T, T> m_onUpdate;
        private final Consumer<T> m_onRemove;

        DefaultListener(Consumer<T> onInsert, BiConsumer<T, T> onUpdate, Consumer<T> onRemove) {
            this.m_onInsert = onInsert;
            this.m_onUpdate = onUpdate;
            this.m_onRemove = onRemove;
        }

        @Override
        public void onInserted(T entity) {
            if (this.m_onInsert != null) {
                this.m_onInsert.accept(entity);
            }
        }

        @Override
        public void onUpdated(T entityOld, T entityNew) {
            if (this.m_onUpdate != null) {
                this.m_onUpdate.accept(entityOld, entityNew);
            }
        }

        @Override
        public void onRemoved(T entity) {
            if (this.m_onRemove != null) {
                this.m_onRemove.accept(entity);
            }
        }
    }
}

