/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.repository;

import com.oracle.coherence.repository.AbstractRepositoryBase;
import com.oracle.coherence.repository.EntityFactory;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Aggregators;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.Processors;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.comparator.ExtractorComparator;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import com.tangosol.util.stream.RemoteCollectors;
import com.tangosol.util.stream.RemoteStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractRepository<ID, T>
extends AbstractRepositoryBase<ID, T, NamedMap<ID, T>> {
    @Override
    NamedMap<ID, T> getNamedMap() {
        return (NamedMap)this.getMap();
    }

    public T save(T entity) {
        this.getMapInternal().putAll(Collections.singletonMap(this.getId(entity), entity));
        return entity;
    }

    public void saveAll(Collection<? extends T> colEntities) {
        this.saveAll(colEntities.stream());
    }

    public void saveAll(Stream<? extends T> strEntities) {
        this.getMapInternal().putAll(strEntities.collect(Collectors.toMap(this::getId, v -> v)));
    }

    public T get(ID id) {
        return (T)this.getMapInternal().get(id);
    }

    public boolean exists(ID id) {
        return this.getMapInternal().containsKey(id);
    }

    public <R> R get(ID id, ValueExtractor<? super T, ? extends R> extractor) {
        return this.getMapInternal().invoke(id, Processors.extract(extractor));
    }

    public Collection<T> getAll() {
        return this.getMapInternal().values();
    }

    public <R> Map<ID, R> getAll(ValueExtractor<? super T, ? extends R> extractor) {
        return this.getAll(Filters.always(), extractor);
    }

    public Collection<T> getAll(Collection<? extends ID> colIds) {
        return this.getMapInternal().getAll(colIds).values();
    }

    public <R> Map<ID, R> getAll(Collection<? extends ID> colIds, ValueExtractor<? super T, ? extends R> extractor) {
        return this.getMapInternal().invokeAll(colIds, Processors.extract(extractor));
    }

    public Collection<T> getAll(Filter<?> filter) {
        return this.getMapInternal().values(filter);
    }

    public <R> Map<ID, R> getAll(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return this.getMapInternal().invokeAll(filter, Processors.extract(extractor));
    }

    public <R extends Comparable<? super R>> Collection<T> getAllOrderedBy(ValueExtractor<? super T, ? extends R> orderBy) {
        return this.getAllOrderedBy(Filters.always(), Remote.comparator(orderBy));
    }

    public <R extends Comparable<? super R>> Collection<T> getAllOrderedBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> orderBy) {
        return this.getAllOrderedBy(filter, Remote.comparator(orderBy));
    }

    public Collection<T> getAllOrderedBy(Remote.Comparator<? super T> orderBy) {
        return this.getMapInternal().values(Filters.always(), orderBy);
    }

    public Collection<T> getAllOrderedBy(Filter<?> filter, Remote.Comparator<? super T> orderBy) {
        return this.getMapInternal().values(filter, orderBy);
    }

    public <U> void update(ID id, ValueUpdater<? super T, ? super U> updater, U value) {
        this.update(id, updater, value, null);
    }

    public <U> void update(ID id, ValueUpdater<? super T, ? super U> updater, U value, EntityFactory<? super ID, ? extends T> factory) {
        this.getMapInternal().invoke(id, AbstractRepository.updaterProcessor(updater, value, factory));
    }

    public <R> R update(ID id, Remote.Function<? super T, ? extends R> updater) {
        return this.update(id, updater, null);
    }

    public <R> R update(ID id, Remote.Function<? super T, ? extends R> updater, EntityFactory<? super ID, ? extends T> factory) {
        return this.getMapInternal().invoke(id, AbstractRepository.updateFunctionProcessor(updater, factory));
    }

    public <U, R> R update(ID id, Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value) {
        return this.update(id, updater, value, null);
    }

    public <U, R> R update(ID id, Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value, EntityFactory<? super ID, ? extends T> factory) {
        return this.getMapInternal().invoke(id, AbstractRepository.updateBiFunctionProcessor(updater, value, factory));
    }

    public <U> void updateAll(Filter<?> filter, ValueUpdater<? super T, ? super U> updater, U value) {
        this.getMapInternal().invokeAll(filter, AbstractRepository.updaterProcessor(updater, value, null));
    }

    public <R> Map<ID, R> updateAll(Filter<?> filter, Remote.Function<? super T, ? extends R> updater) {
        return this.getMapInternal().invokeAll(filter, AbstractRepository.updateFunctionProcessor(updater, null));
    }

    public <U, R> Map<ID, R> updateAll(Filter<?> filter, Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value) {
        return this.getMapInternal().invokeAll(filter, AbstractRepository.updateBiFunctionProcessor(updater, value, null));
    }

    public boolean removeById(ID id) {
        return this.getMapInternal().invoke(id, Processors.remove());
    }

    public T removeById(ID id, boolean fReturn) {
        return (T)this.getMapInternal().invoke(id, Processors.remove(fReturn));
    }

    public boolean remove(T entity) {
        return this.removeById(this.getId(entity));
    }

    public T remove(T entity, boolean fReturn) {
        return this.removeById(this.getId(entity), fReturn);
    }

    public boolean removeAllById(Collection<? extends ID> colIds) {
        Map<ID, Boolean> mapResults = this.getMapInternal().invokeAll(colIds, Processors.remove());
        for (boolean fResult : mapResults.values()) {
            if (!fResult) continue;
            return true;
        }
        return false;
    }

    public Map<ID, T> removeAllById(Collection<? extends ID> colIds, boolean fReturn) {
        return this.getMapInternal().invokeAll(colIds, Processors.remove(fReturn));
    }

    public boolean removeAll(Collection<? extends T> colEntities) {
        return this.removeAll(colEntities.stream());
    }

    public Map<ID, T> removeAll(Collection<? extends T> colEntities, boolean fReturn) {
        return this.removeAll(colEntities.stream(), fReturn);
    }

    public boolean removeAll(Stream<? extends T> strEntities) {
        return this.removeAllById(strEntities.map(this::getId).collect(Collectors.toSet()));
    }

    public Map<ID, T> removeAll(Stream<? extends T> strEntities, boolean fReturn) {
        return this.removeAllById(strEntities.map(this::getId).collect(Collectors.toSet()), fReturn);
    }

    public boolean removeAll(Filter<?> filter) {
        Map mapResults = this.getMapInternal().invokeAll(filter, Processors.remove());
        for (boolean fResult : mapResults.values()) {
            if (!fResult) continue;
            return true;
        }
        return false;
    }

    public Map<ID, T> removeAll(Filter<?> filter, boolean fReturn) {
        return this.getMapInternal().invokeAll(filter, Processors.remove(fReturn));
    }

    public RemoteStream<T> stream() {
        return this.getMapInternal().stream().map(Map.Entry::getValue);
    }

    public RemoteStream<T> stream(Collection<? extends ID> colIds) {
        return this.getMapInternal().stream(colIds).map(Map.Entry::getValue);
    }

    public RemoteStream<T> stream(Filter<?> filter) {
        return this.getMapInternal().stream(filter).map(Map.Entry::getValue);
    }

    public long count() {
        return ((Integer)this.getMapInternal().aggregate(Aggregators.count())).intValue();
    }

    public long count(Filter<?> filter) {
        return ((Integer)this.getMapInternal().aggregate(filter, Aggregators.count())).intValue();
    }

    public int max(Remote.ToIntFunction<? super T> extractor) {
        return ((Long)this.getMapInternal().aggregate(Aggregators.max(extractor))).intValue();
    }

    public int max(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return ((Long)this.getMapInternal().aggregate(filter, Aggregators.max(extractor))).intValue();
    }

    public long max(Remote.ToLongFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public long max(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public double max(Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public double max(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public BigDecimal max(Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public BigDecimal max(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public <R extends Comparable<? super R>> R max(Remote.ToComparableFunction<? super T, R> extractor) {
        return (R)((Comparable)this.getMapInternal().aggregate(Aggregators.max(extractor)));
    }

    public <R extends Comparable<? super R>> R max(Filter<?> filter, Remote.ToComparableFunction<? super T, R> extractor) {
        return (R)((Comparable)this.getMapInternal().aggregate(filter, Aggregators.max(extractor)));
    }

    public <R extends Comparable<? super R>> Optional<T> maxBy(ValueExtractor<? super T, ? extends R> extractor) {
        return this.stream().reduce(Remote.BinaryOperator.maxBy(Remote.Comparator.comparing(extractor)));
    }

    public <R extends Comparable<? super R>> Optional<T> maxBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return this.stream(filter).reduce(Remote.BinaryOperator.maxBy(Remote.Comparator.comparing(extractor)));
    }

    public int min(Remote.ToIntFunction<? super T> extractor) {
        return ((Long)this.getMapInternal().aggregate(Aggregators.min(extractor))).intValue();
    }

    public int min(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return ((Long)this.getMapInternal().aggregate(filter, Aggregators.min(extractor))).intValue();
    }

    public long min(Remote.ToLongFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public long min(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public double min(Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public double min(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public BigDecimal min(Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public BigDecimal min(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public <R extends Comparable<? super R>> R min(Remote.ToComparableFunction<? super T, R> extractor) {
        return (R)((Comparable)this.getMapInternal().aggregate(Aggregators.min(extractor)));
    }

    public <R extends Comparable<? super R>> R min(Filter<?> filter, Remote.ToComparableFunction<? super T, R> extractor) {
        return (R)((Comparable)this.getMapInternal().aggregate(filter, Aggregators.min(extractor)));
    }

    public <R extends Comparable<? super R>> Optional<T> minBy(ValueExtractor<? super T, ? extends R> extractor) {
        return this.stream().reduce(Remote.BinaryOperator.minBy(Remote.Comparator.comparing(extractor)));
    }

    public <R extends Comparable<? super R>> Optional<T> minBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return this.stream(filter).reduce(Remote.BinaryOperator.minBy(Remote.Comparator.comparing(extractor)));
    }

    public long sum(Remote.ToIntFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public long sum(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public long sum(Remote.ToLongFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public long sum(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return (Long)this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public double sum(Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public double sum(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public BigDecimal sum(Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public BigDecimal sum(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public double average(Remote.ToIntFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public double average(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public double average(Remote.ToLongFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public double average(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public double average(Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public double average(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return (Double)this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public BigDecimal average(Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public BigDecimal average(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return (BigDecimal)this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public <R> Collection<? extends R> distinct(ValueExtractor<? super T, ? extends R> extractor) {
        return (Collection)this.getMapInternal().aggregate(Aggregators.distinctValues(extractor));
    }

    public <R> Collection<? extends R> distinct(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return (Collection)this.getMapInternal().aggregate(filter, Aggregators.distinctValues(extractor));
    }

    public <K> Map<K, Set<T>> groupBy(ValueExtractor<? super T, ? extends K> extractor) {
        return this.stream().collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSet()));
    }

    public <K> Map<K, SortedSet<T>> groupBy(ValueExtractor<? super T, ? extends K> extractor, Remote.Comparator<? super T> orderBy) {
        return this.stream().collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSortedSet(orderBy)));
    }

    public <K> Map<K, Set<T>> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor) {
        return this.stream(filter).collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSet()));
    }

    public <K> Map<K, SortedSet<T>> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor, Remote.Comparator<? super T> orderBy) {
        return this.stream(filter).collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSortedSet(orderBy)));
    }

    public <K, A, R> Map<K, R> groupBy(ValueExtractor<? super T, ? extends K> extractor, RemoteCollector<? super T, A, R> collector) {
        return this.stream().collect(RemoteCollectors.groupingBy(extractor, collector));
    }

    public <K, A, R> Map<K, R> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor, RemoteCollector<? super T, A, R> collector) {
        return this.stream(filter).collect(RemoteCollectors.groupingBy(extractor, collector));
    }

    public <K, A, R, M extends Map<K, R>> M groupBy(ValueExtractor<? super T, ? extends K> extractor, Remote.Supplier<M> mapFactory, RemoteCollector<? super T, A, R> collector) {
        return (M)((Map)this.stream().collect(RemoteCollectors.groupingBy(extractor, mapFactory, collector)));
    }

    public <K, A, R, M extends Map<K, R>> M groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor, Remote.Supplier<M> mapFactory, RemoteCollector<? super T, A, R> collector) {
        return (M)((Map)this.stream(filter).collect(RemoteCollectors.groupingBy(extractor, mapFactory, collector)));
    }

    public <R extends Comparable<? super R>> List<R> top(ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        Object[] aoResults = (Object[])this.getMapInternal().aggregate(Aggregators.topN(extractor, cResults));
        return Stream.of(aoResults).map(o -> (Comparable)o).collect(Collectors.toList());
    }

    public <R extends Comparable<? super R>> List<R> top(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        Object[] aoResults = (Object[])this.getMapInternal().aggregate(filter, Aggregators.topN(extractor, cResults));
        return Stream.of(aoResults).map(o -> (Comparable)o).collect(Collectors.toList());
    }

    public <R> List<R> top(ValueExtractor<? super T, ? extends R> extractor, Remote.Comparator<? super R> comparator, int cResults) {
        Object[] results = (Object[])this.getMapInternal().aggregate(Aggregators.topN(extractor, comparator, cResults));
        return Arrays.asList(results);
    }

    public <R> List<R> top(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, Remote.Comparator<? super R> comparator, int cResults) {
        Object[] results = (Object[])this.getMapInternal().aggregate(filter, Aggregators.topN(extractor, comparator, cResults));
        return Arrays.asList(results);
    }

    public <R extends Comparable<? super R>> List<T> topBy(ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        Object[] results = (Object[])this.getMapInternal().aggregate(Aggregators.topN(ValueExtractor.identity(), new ExtractorComparator<T>(extractor), cResults));
        return Arrays.asList(results);
    }

    public <R extends Comparable<? super R>> List<T> topBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        Object[] results = (Object[])this.getMapInternal().aggregate(filter, Aggregators.topN(ValueExtractor.identity(), new ExtractorComparator<T>(extractor), cResults));
        return Arrays.asList(results);
    }

    public List<T> topBy(Remote.Comparator<? super T> comparator, int cResults) {
        Object[] results = (Object[])this.getMapInternal().aggregate(Aggregators.topN(ValueExtractor.identity(), comparator, cResults));
        return Arrays.asList(results);
    }

    public List<T> topBy(Filter<?> filter, Remote.Comparator<? super T> comparator, int cResults) {
        Object[] results = (Object[])this.getMapInternal().aggregate(filter, Aggregators.topN(ValueExtractor.identity(), comparator, cResults));
        return Arrays.asList(results);
    }

    private NamedMap<ID, T> getMapInternal() {
        this.ensureInitialized();
        return (NamedMap)this.getMap();
    }
}

