/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.repository;

import com.oracle.coherence.repository.AbstractRepositoryBase;
import com.oracle.coherence.repository.EntityFactory;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Aggregators;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.Processors;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.aggregator.DistinctValues;
import com.tangosol.util.aggregator.TopNAggregator;
import com.tangosol.util.comparator.ExtractorComparator;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import com.tangosol.util.stream.RemoteCollectors;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractAsyncRepository<ID, T>
extends AbstractRepositoryBase<ID, T, AsyncNamedMap<ID, T>> {
    @Override
    NamedMap<ID, T> getNamedMap() {
        return ((AsyncNamedMap)this.getMap()).getNamedMap();
    }

    public CompletableFuture<T> save(T entity) {
        return this.getMapInternal().putAll(Collections.singletonMap(this.getId(entity), entity)).thenApply(unused -> entity);
    }

    public CompletableFuture<Void> saveAll(Collection<? extends T> colEntities) {
        return this.saveAll(colEntities.stream());
    }

    public CompletableFuture<Void> saveAll(Stream<? extends T> strEntities) {
        return this.getMapInternal().putAll(strEntities.collect(Collectors.toMap(this::getId, v -> v)));
    }

    public CompletableFuture<T> get(ID id) {
        return this.getMapInternal().get(id);
    }

    public CompletableFuture<Boolean> exists(ID id) {
        return this.getMapInternal().containsKey(id);
    }

    public <R> CompletableFuture<R> get(ID id, ValueExtractor<? super T, ? extends R> extractor) {
        return this.getMapInternal().invoke(id, Processors.extract(extractor));
    }

    public CompletableFuture<Collection<? extends T>> getAll() {
        return this.getMapInternal().values();
    }

    public CompletableFuture<Void> getAll(Consumer<? super T> callback) {
        return this.getMapInternal().values(callback);
    }

    public <R> CompletableFuture<Map<ID, R>> getAll(ValueExtractor<? super T, ? extends R> extractor) {
        return this.getAll(Filters.always(), extractor);
    }

    public <R> CompletableFuture<Void> getAll(ValueExtractor<? super T, ? extends R> extractor, BiConsumer<? super ID, ? super R> callback) {
        return this.getAll(Filters.always(), extractor, callback);
    }

    public CompletableFuture<Collection<T>> getAll(Collection<? extends ID> colIds) {
        return this.getMapInternal().getAll(colIds).thenApply(Map::values);
    }

    public CompletableFuture<Void> getAll(Collection<? extends ID> colIds, Consumer<? super T> callback) {
        return this.getMapInternal().getAll(colIds, (? super Map.Entry<? extends K, ? extends V> entry) -> callback.accept((Object)entry.getValue()));
    }

    public <R> CompletableFuture<Map<ID, R>> getAll(Collection<? extends ID> colIds, ValueExtractor<? super T, ? extends R> extractor) {
        return this.getMapInternal().invokeAll(colIds, Processors.extract(extractor));
    }

    public <R> CompletableFuture<Void> getAll(Collection<? extends ID> colIds, ValueExtractor<? super T, ? extends R> extractor, BiConsumer<? super ID, ? super R> callback) {
        return this.getMapInternal().invokeAll(colIds, Processors.extract(extractor), callback);
    }

    public CompletableFuture<Collection<T>> getAll(Filter<?> filter) {
        return this.getMapInternal().values(filter);
    }

    public CompletableFuture<Void> getAll(Filter<?> filter, Consumer<? super T> callback) {
        return this.getMapInternal().values(filter, callback);
    }

    public <R> CompletableFuture<Map<ID, R>> getAll(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return this.getMapInternal().invokeAll(filter, Processors.extract(extractor));
    }

    public <R> CompletableFuture<Void> getAll(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, BiConsumer<? super ID, ? super R> callback) {
        return this.getMapInternal().invokeAll(filter, Processors.extract(extractor), callback);
    }

    public <R extends Comparable<? super R>> CompletableFuture<Collection<T>> getAllOrderedBy(ValueExtractor<? super T, ? extends R> orderBy) {
        return this.getAllOrderedBy(Filters.always(), Remote.comparator(orderBy));
    }

    public <R extends Comparable<? super R>> CompletableFuture<Collection<T>> getAllOrderedBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> orderBy) {
        return this.getAllOrderedBy(filter, Remote.comparator(orderBy));
    }

    public CompletableFuture<Collection<T>> getAllOrderedBy(Remote.Comparator<? super T> orderBy) {
        return this.getAllOrderedBy(Filters.always(), orderBy);
    }

    public CompletableFuture<Collection<T>> getAllOrderedBy(Filter<?> filter, Remote.Comparator<? super T> orderBy) {
        return this.getMapInternal().values(filter, orderBy);
    }

    public <U> CompletableFuture<Void> update(ID id, ValueUpdater<? super T, ? super U> updater, U value) {
        return this.update(id, updater, value, null);
    }

    public <U> CompletableFuture<Void> update(ID id, ValueUpdater<? super T, ? super U> updater, U value, EntityFactory<? super ID, ? extends T> factory) {
        return this.getMapInternal().invoke(id, AbstractAsyncRepository.updaterProcessor(updater, value, factory));
    }

    public <R> CompletableFuture<R> update(ID id, Remote.Function<? super T, ? extends R> updater) {
        return this.update(id, updater, null);
    }

    public <R> CompletableFuture<R> update(ID id, Remote.Function<? super T, ? extends R> updater, EntityFactory<? super ID, ? extends T> factory) {
        return this.getMapInternal().invoke(id, AbstractAsyncRepository.updateFunctionProcessor(updater, factory));
    }

    public <U, R> CompletableFuture<R> update(ID id, Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value) {
        return this.update(id, updater, value, null);
    }

    public <U, R> CompletableFuture<R> update(ID id, Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value, EntityFactory<? super ID, ? extends T> factory) {
        return this.getMapInternal().invoke(id, AbstractAsyncRepository.updateBiFunctionProcessor(updater, value, factory));
    }

    public <U> CompletableFuture<Void> updateAll(Filter<?> filter, ValueUpdater<? super T, ? super U> updater, U value) {
        return this.getMapInternal().invokeAll(filter, AbstractAsyncRepository.updaterProcessor(updater, value, null)).thenAccept(m -> {});
    }

    public <R> CompletableFuture<Map<ID, R>> updateAll(Filter<?> filter, Remote.Function<? super T, ? extends R> updater) {
        return this.getMapInternal().invokeAll(filter, AbstractAsyncRepository.updateFunctionProcessor(updater, null));
    }

    public <U, R> CompletableFuture<Map<ID, R>> updateAll(Filter<?> filter, Remote.BiFunction<? super T, ? super U, ? extends R> updater, U value) {
        return this.getMapInternal().invokeAll(filter, AbstractAsyncRepository.updateBiFunctionProcessor(updater, value, null));
    }

    public CompletableFuture<Boolean> removeById(ID id) {
        return this.getMapInternal().invoke(id, Processors.remove());
    }

    public CompletableFuture<T> removeById(ID id, boolean fReturn) {
        return this.getMapInternal().invoke(id, Processors.remove(fReturn));
    }

    public CompletableFuture<Boolean> remove(T entity) {
        return this.removeById(this.getId(entity));
    }

    public CompletableFuture<T> remove(T entity, boolean fReturn) {
        return this.removeById(this.getId(entity), fReturn);
    }

    public CompletableFuture<Boolean> removeAllById(Collection<? extends ID> colIds) {
        return this.getMapInternal().invokeAll(colIds, Processors.remove()).thenApply(idBooleanMap -> {
            Iterator iterator = idBooleanMap.values().iterator();
            while (iterator.hasNext()) {
                boolean fResult = (Boolean)iterator.next();
                if (!fResult) continue;
                return true;
            }
            return false;
        });
    }

    public CompletableFuture<Map<ID, T>> removeAllById(Collection<? extends ID> colIds, boolean fReturn) {
        return this.getMapInternal().invokeAll(colIds, Processors.remove(fReturn));
    }

    public CompletableFuture<Boolean> removeAll(Collection<? extends T> colEntities) {
        return this.removeAll(colEntities.stream());
    }

    public CompletableFuture<Map<ID, T>> removeAll(Collection<? extends T> colEntities, boolean fReturn) {
        return this.removeAll(colEntities.stream(), fReturn);
    }

    public CompletableFuture<Boolean> removeAll(Stream<? extends T> strEntities) {
        return this.removeAllById(strEntities.map(this::getId).collect(Collectors.toSet()));
    }

    public CompletableFuture<Map<ID, T>> removeAll(Stream<? extends T> strEntities, boolean fReturn) {
        return this.removeAllById(strEntities.map(this::getId).collect(Collectors.toSet()), fReturn);
    }

    public CompletableFuture<Boolean> removeAll(Filter<?> filter) {
        return this.getMapInternal().invokeAll(filter, Processors.remove()).thenApply(idBooleanMap -> {
            Iterator iterator = idBooleanMap.values().iterator();
            while (iterator.hasNext()) {
                boolean fResult = (Boolean)iterator.next();
                if (!fResult) continue;
                return true;
            }
            return false;
        });
    }

    public CompletableFuture<Map<ID, T>> removeAll(Filter<?> filter, boolean fReturn) {
        return this.getMapInternal().invokeAll(filter, Processors.remove(fReturn));
    }

    public CompletableFuture<Long> count() {
        return this.getMapInternal().aggregate(Aggregators.count()).thenApply(Integer::longValue);
    }

    public CompletableFuture<Long> count(Filter<?> filter) {
        return this.getMapInternal().aggregate(filter, Aggregators.count()).thenApply(Integer::longValue);
    }

    public CompletableFuture<Integer> max(Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.max(extractor)).thenApply(Long::intValue);
    }

    public CompletableFuture<Integer> max(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.max(extractor)).thenApply(Long::intValue);
    }

    public CompletableFuture<Long> max(Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public CompletableFuture<Long> max(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public CompletableFuture<Double> max(Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public CompletableFuture<Double> max(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public CompletableFuture<BigDecimal> max(Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public CompletableFuture<BigDecimal> max(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public <R extends Comparable<? super R>> CompletableFuture<R> max(Remote.ToComparableFunction<? super T, R> extractor) {
        return this.getMapInternal().aggregate(Aggregators.max(extractor));
    }

    public <R extends Comparable<? super R>> CompletableFuture<R> max(Filter<?> filter, Remote.ToComparableFunction<? super T, R> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.max(extractor));
    }

    public <R extends Comparable<? super R>> CompletableFuture<Optional<T>> maxBy(ValueExtractor<? super T, ? extends R> extractor) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream().map(Map.Entry::getValue).reduce(Remote.BinaryOperator.maxBy(Remote.Comparator.comparing(extractor))));
    }

    public <R extends Comparable<? super R>> CompletableFuture<Optional<T>> maxBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream(filter).map(Map.Entry::getValue).reduce(Remote.BinaryOperator.maxBy(Remote.Comparator.comparing(extractor))));
    }

    public CompletableFuture<Integer> min(Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.min(extractor)).thenApply(Long::intValue);
    }

    public CompletableFuture<Integer> min(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.min(extractor)).thenApply(Long::intValue);
    }

    public CompletableFuture<Long> min(Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public CompletableFuture<Long> min(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public CompletableFuture<Double> min(Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public CompletableFuture<Double> min(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public CompletableFuture<BigDecimal> min(Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public CompletableFuture<BigDecimal> min(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public <R extends Comparable<? super R>> CompletableFuture<R> min(Remote.ToComparableFunction<? super T, R> extractor) {
        return this.getMapInternal().aggregate(Aggregators.min(extractor));
    }

    public <R extends Comparable<? super R>> CompletableFuture<R> min(Filter<?> filter, Remote.ToComparableFunction<? super T, R> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.min(extractor));
    }

    public <R extends Comparable<? super R>> CompletableFuture<Optional<T>> minBy(ValueExtractor<? super T, ? extends R> extractor) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream().map(Map.Entry::getValue).reduce(Remote.BinaryOperator.minBy(Remote.Comparator.comparing(extractor))));
    }

    public <R extends Comparable<? super R>> CompletableFuture<Optional<T>> minBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream(filter).map(Map.Entry::getValue).reduce(Remote.BinaryOperator.minBy(Remote.Comparator.comparing(extractor))));
    }

    public CompletableFuture<Long> sum(Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public CompletableFuture<Long> sum(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public CompletableFuture<Long> sum(Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public CompletableFuture<Long> sum(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public CompletableFuture<Double> sum(Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public CompletableFuture<Double> sum(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public CompletableFuture<BigDecimal> sum(Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.sum(extractor));
    }

    public CompletableFuture<BigDecimal> sum(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.sum(extractor));
    }

    public CompletableFuture<Double> average(Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public CompletableFuture<Double> average(Filter<?> filter, Remote.ToIntFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public CompletableFuture<Double> average(Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public CompletableFuture<Double> average(Filter<?> filter, Remote.ToLongFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public CompletableFuture<Double> average(Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public CompletableFuture<Double> average(Filter<?> filter, Remote.ToDoubleFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public CompletableFuture<BigDecimal> average(Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(Aggregators.average(extractor));
    }

    public CompletableFuture<BigDecimal> average(Filter<?> filter, Remote.ToBigDecimalFunction<? super T> extractor) {
        return this.getMapInternal().aggregate(filter, Aggregators.average(extractor));
    }

    public <R> CompletableFuture<Collection<? extends R>> distinct(ValueExtractor<? super T, ? extends R> extractor) {
        DistinctValues aggregator = Aggregators.distinctValues(extractor);
        return this.getMapInternal().aggregate(aggregator);
    }

    public <R> CompletableFuture<Collection<? extends R>> distinct(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor) {
        DistinctValues aggregator = Aggregators.distinctValues(extractor);
        return this.getMapInternal().aggregate(filter, aggregator);
    }

    public <K> CompletableFuture<Map<K, Set<T>>> groupBy(ValueExtractor<? super T, ? extends K> extractor) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream().map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSet())));
    }

    public <K> CompletableFuture<Map<K, SortedSet<T>>> groupBy(ValueExtractor<? super T, ? extends K> extractor, Remote.Comparator<? super T> orderBy) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream().map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSortedSet(orderBy))));
    }

    public <K> CompletableFuture<Map<K, Set<T>>> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream(filter).map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSet())));
    }

    public <K> CompletableFuture<Map<K, SortedSet<T>>> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor, Remote.Comparator<? super T> orderBy) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream(filter).map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, RemoteCollectors.toSortedSet(orderBy))));
    }

    public <K, A, R> CompletableFuture<Map<K, R>> groupBy(ValueExtractor<? super T, ? extends K> extractor, RemoteCollector<? super T, A, R> collector) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream().map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, collector)));
    }

    public <K, A, R> CompletableFuture<Map<K, R>> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor, RemoteCollector<? super T, A, R> collector) {
        return CompletableFuture.supplyAsync(() -> this.getNamedMap().stream(filter).map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, collector)));
    }

    public <K, A, R, M extends Map<K, R>> CompletableFuture<M> groupBy(ValueExtractor<? super T, ? extends K> extractor, Remote.Supplier<M> mapFactory, RemoteCollector<? super T, A, R> collector) {
        return CompletableFuture.supplyAsync(() -> (Map)this.getNamedMap().stream().map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, mapFactory, collector)));
    }

    public <K, A, R, M extends Map<K, R>> CompletableFuture<M> groupBy(Filter<?> filter, ValueExtractor<? super T, ? extends K> extractor, Remote.Supplier<M> mapFactory, RemoteCollector<? super T, A, R> collector) {
        return CompletableFuture.supplyAsync(() -> (Map)this.getNamedMap().stream(filter).map(Map.Entry::getValue).collect(RemoteCollectors.groupingBy(extractor, mapFactory, collector)));
    }

    public <R extends Comparable<? super R>> CompletableFuture<List<R>> top(ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(extractor, cResults);
        return this.getMapInternal().aggregate(aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public <R extends Comparable<? super R>> CompletableFuture<List<R>> top(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(extractor, cResults);
        return this.getMapInternal().aggregate(filter, aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public <R> CompletableFuture<List<R>> top(ValueExtractor<? super T, ? extends R> extractor, Remote.Comparator<? super R> comparator, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(extractor, comparator, cResults);
        return this.getMapInternal().aggregate(aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public <R> CompletableFuture<List<R>> top(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, Remote.Comparator<? super R> comparator, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(extractor, comparator, cResults);
        return this.getMapInternal().aggregate(filter, aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public <R extends Comparable<? super R>> CompletableFuture<List<T>> topBy(ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(ValueExtractor.identity(), new ExtractorComparator<T>(extractor), cResults);
        return this.getMapInternal().aggregate(aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public <R extends Comparable<? super R>> CompletableFuture<List<T>> topBy(Filter<?> filter, ValueExtractor<? super T, ? extends R> extractor, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(ValueExtractor.identity(), new ExtractorComparator<T>(extractor), cResults);
        return this.getMapInternal().aggregate(filter, aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public CompletableFuture<List<T>> topBy(Remote.Comparator<? super T> comparator, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(ValueExtractor.identity(), comparator, cResults);
        return this.getMapInternal().aggregate(aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    public CompletableFuture<List<T>> topBy(Filter<?> filter, Remote.Comparator<? super T> comparator, int cResults) {
        TopNAggregator aggregator = Aggregators.topN(ValueExtractor.identity(), comparator, cResults);
        return this.getMapInternal().aggregate(filter, aggregator).thenApply(rs -> Arrays.stream((Object[])rs).collect(Collectors.toList()));
    }

    private AsyncNamedMap<ID, T> getMapInternal() {
        this.ensureInitialized();
        return (AsyncNamedMap)this.getMap();
    }
}

