/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.persistence;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PersistentStoreInfo
implements Comparable,
PortableObject,
ExternalizableLite {
    private String m_sId;
    private boolean m_fEmpty;

    public PersistentStoreInfo() {
    }

    public PersistentStoreInfo(String sId, boolean fEmpty) {
        this.m_sId = sId;
        this.m_fEmpty = fEmpty;
    }

    public String getId() {
        return this.m_sId;
    }

    public boolean isEmpty() {
        return this.m_fEmpty;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sId = in.readUTF();
        this.m_fEmpty = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sId);
        out.writeBoolean(this.m_fEmpty);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sId = in.readString(0);
        this.m_fEmpty = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sId);
        out.writeBoolean(1, this.m_fEmpty);
    }

    public int compareTo(Object o) {
        PersistentStoreInfo info = (PersistentStoreInfo)o;
        int nResult = this.getId().compareTo(info.getId());
        if (nResult == 0) {
            nResult = -Boolean.valueOf(this.isEmpty()).compareTo(info.isEmpty());
        }
        return nResult;
    }

    public String toString() {
        return "PersistenceStoreInfo [id=" + this.m_sId + ", isEmpty=" + this.m_fEmpty + "]";
    }
}

