/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.persistence;

import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.persistence.PersistenceTools;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.coherence.persistence.PersistentStoreInfo;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WriteBuffer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface PersistenceManager<R> {
    public String getName();

    public PersistentStore createStore(String var1);

    public PersistentStore<R> open(String var1, PersistentStore<R> var2);

    public PersistentStore<R> open(String var1, PersistentStore<R> var2, Collector<Object> var3);

    public void close(String var1);

    public boolean delete(String var1, boolean var2);

    public PersistentStoreInfo[] listStoreInfo();

    public boolean isEmpty(String var1);

    default public boolean contains(String sGUID) {
        for (PersistentStoreInfo storeCurrent : this.listStoreInfo()) {
            if (!storeCurrent.getId().equals(sGUID)) continue;
            return true;
        }
        return false;
    }

    public String[] listOpen();

    default public void read(String sId, InputStream in) throws IOException {
        ReadBuffer.BufferInput bufIn = in instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)((Object)in) : new WrapperBufferInput(in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in));
        this.read(sId, bufIn);
    }

    public void read(String var1, ReadBuffer.BufferInput var2) throws IOException;

    default public void write(String sId, OutputStream out) throws IOException {
        WriteBuffer.BufferOutput bufOut = out instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)((Object)out) : new WrapperBufferOutput(out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out));
        this.write(sId, bufOut);
    }

    public void write(String var1, WriteBuffer.BufferOutput var2) throws IOException;

    default public void writeSafe(String sId) {
    }

    public void release();

    public PersistenceTools getPersistenceTools();

    default public void maintainEnvironment() {
    }
}

