/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.persistence;

public class OfflinePersistenceInfo {
    private final int f_cPartitions;
    private final String f_sStorageFormat;
    private String[] f_asGUIDs;
    private final boolean f_fArchive;
    private final int f_nImplVersion;
    private final int f_nStorageVersion;
    private final int f_nPersistenceVersion;

    public OfflinePersistenceInfo(int cPartitions, String sStorageFormat, boolean fArchive, String[] asGUIDs, int nStorageVersion, int nImplVersion, String sServiceVersion) {
        this(cPartitions, sStorageFormat, fArchive, asGUIDs, nStorageVersion, nImplVersion, Integer.parseInt(sServiceVersion));
    }

    public OfflinePersistenceInfo(int cPartitions, String sStorageFormat, boolean fArchive, String[] asGUIDs, int nStorageVersion, int nImplVersion, int nPersistenceVersion) {
        this.f_cPartitions = cPartitions;
        this.f_sStorageFormat = sStorageFormat;
        this.f_fArchive = fArchive;
        this.f_asGUIDs = asGUIDs == null ? new String[]{} : asGUIDs;
        this.f_nStorageVersion = nStorageVersion;
        this.f_nImplVersion = nImplVersion;
        this.f_nPersistenceVersion = nPersistenceVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Persistence Information\n\n");
        sb.append("Storage version:              ").append(this.getStorageVersion()).append('\n').append("Implementation version:       ").append(this.getImplVersion()).append('\n').append("Number of partition:          ").append(this.getPartitionCount()).append('\n').append("Number of partitions present: ").append(this.getGUIDs().length).append('\n').append("Is Complete?:                 ").append(this.isComplete()).append('\n').append("Is Archived?:                 ").append(this.isArchived()).append('\n').append('\n');
        return sb.toString();
    }

    public int getPartitionCount() {
        return this.f_cPartitions;
    }

    public String getStorageFormat() {
        return this.f_sStorageFormat;
    }

    public String[] getGUIDs() {
        return this.f_asGUIDs;
    }

    public boolean isComplete() {
        return this.f_asGUIDs.length == this.f_cPartitions;
    }

    public boolean isArchived() {
        return this.f_fArchive;
    }

    public int getStorageVersion() {
        return this.f_nStorageVersion;
    }

    public int getImplVersion() {
        return this.f_nImplVersion;
    }

    public String getServiceVersion() {
        return String.valueOf(this.f_nPersistenceVersion);
    }

    public int getPersistenceVersion() {
        return this.f_nPersistenceVersion;
    }
}

