/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.internal.util.Timer;
import com.oracle.coherence.common.internal.util.TimerTask;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Timers {
    private static Timer s_timerNonBlocking;
    private static final AtomicLong s_cNonBlockingTimerTasks;

    public static Disposable scheduleNonBlockingTask(Runnable task, long cMillis) {
        return Timers.scheduleNonBlockingTask(task, cMillis, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Disposable scheduleNonBlockingTask(Runnable task, long cMillis, Set<? super Disposable> setPending) {
        Object object;
        long cExpected;
        final AtomicLong cTasks = s_cNonBlockingTimerTasks;
        do {
            if ((cExpected = cTasks.get()) != 0L) continue;
            final Class<Timers> clz = Timers.class;
            object = clz;
            synchronized (object) {
                cExpected = cTasks.get();
                if (cExpected == 0L && s_timerNonBlocking == null) {
                    Timer timer = s_timerNonBlocking = new Timer("NonBlockingTimer", true);
                    timer.scheduleAtFixedRate(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (cTasks.get() == 0L) {
                                Class clazz = clz;
                                synchronized (clazz) {
                                    if (cTasks.get() == 0L) {
                                        s_timerNonBlocking.cancel();
                                        s_timerNonBlocking = null;
                                    }
                                }
                            }
                        }
                    }, 5000L, 5000L);
                }
                cTasks.incrementAndGet();
                break;
            }
        } while (!cTasks.compareAndSet(cExpected, cExpected + 1L));
        PendingTask taskWrapper = new PendingTask(task, cTasks, setPending);
        if (setPending != null) {
            object = setPending;
            synchronized (object) {
                setPending.add(taskWrapper);
            }
        }
        s_timerNonBlocking.schedule((TimerTask)taskWrapper, cMillis);
        return taskWrapper;
    }

    static {
        s_cNonBlockingTimerTasks = new AtomicLong();
    }

    protected static class PendingTask
    extends TimerTask {
        protected Runnable m_task;
        protected AtomicLong m_cTasks;
        protected Set<? super TimerTask> m_set;

        public PendingTask(Runnable task, AtomicLong cTasks, Set<? super TimerTask> set) {
            this.m_task = task;
            this.m_cTasks = cTasks;
            this.m_set = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable task;
            this.m_cTasks.decrementAndGet();
            Set<? super TimerTask> set = this.m_set;
            if (set != null) {
                Set<? super TimerTask> set2 = set;
                synchronized (set2) {
                    set.remove(this);
                }
            }
            if ((task = this.m_task) != null) {
                task.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Set<? super TimerTask> set = this.m_set;
            if (set != null) {
                Set<? super TimerTask> set2 = set;
                synchronized (set2) {
                    set.remove(this);
                }
                this.m_set = null;
            }
            this.m_task = null;
            if (super.cancel()) {
                this.m_cTasks.decrementAndGet();
                return true;
            }
            return false;
        }

        public String toString() {
            return "TimerTask{" + String.valueOf(this.m_task) + "}";
        }
    }
}

