/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.base.IdentityHolder;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.oracle.coherence.common.collections.InflatableMap;
import com.oracle.coherence.common.util.Gate;
import com.oracle.coherence.common.util.SafeClock;
import com.oracle.coherence.common.util.Sentry;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadGate<R>
implements Gate {
    public static final int GATE_OPEN = 0;
    public static final int GATE_CLOSING = 1;
    public static final int GATE_CLOSED = 2;
    public static final int GATE_DESTROYED = 3;
    private static final int STATUS_OFFSET = 60;
    private static final long ACTIVE_COUNT_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long EMPTY_GATE_OPEN = 0L;
    private static final long FULL_GATE_OPEN = 0xFFFFFFFFFFFFFFFL;
    private static final long EMPTY_GATE_CLOSING = 0x1000000000000000L;
    private static final long EMPTY_GATE_CLOSED = 0x2000000000000000L;
    private final Lock f_lock = new ReentrantLock();
    protected final Condition f_open = this.f_lock.newCondition();
    private final R f_resource;
    protected final AtomicLong f_atomicState = new AtomicLong();
    private int m_cClose;
    private volatile transient Object m_closer;
    private final ThreadLocal<int[]> f_tlcEnters = new ThreadLocal();
    private volatile ConcurrentHashMap<IdentityHolder<Object>, MutableLong> m_mapContenderEnters;
    protected final Sentry<R> f_exitSentry = new Sentry<R>(){

        @Override
        public R getResource() {
            return ThreadGate.this.f_resource;
        }

        @Override
        public void close() {
            ThreadGate.this.exit();
        }
    };
    protected final Sentry<R> f_openSentry = new Sentry<R>(){

        @Override
        public R getResource() {
            return ThreadGate.this.f_resource;
        }

        @Override
        public void close() {
            ThreadGate.this.open();
        }
    };

    public ThreadGate() {
        this(null);
    }

    public ThreadGate(R resource) {
        this.f_resource = resource;
    }

    @Override
    public boolean barEntry(long cMillis) {
        return this.barEntryInternal(Thread.currentThread(), cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean barEntry(Object oContender, long cMillis) {
        Object object = oContender;
        synchronized (object) {
            return this.barEntryInternal(oContender, cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean barEntryInternal(Object oContender, long cMillis) {
        if (oContender == this.getCloser()) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        this.lock();
        try {
            do {
                if (this.getCloser() != null) continue;
                if (this.updateStatus(1) == 3) {
                    this.updateStatus(3);
                    throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                }
                this.setCloser(oContender);
                this.setCloseCount(1);
                boolean bl = true;
                return bl;
            } while ((cMillis = this.doWait(cMillis)) != 0L);
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Sentry<R> close() {
        this.close(-1L);
        return this.f_openSentry;
    }

    @Override
    public boolean close(long cMillis) {
        return this.closeInternal(Thread.currentThread(), cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(Object oContender, long cMillis) {
        Object object = oContender;
        synchronized (object) {
            return this.closeInternal(oContender, cMillis);
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean closeInternal(Object oContender, long cMillis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void destroy() {
        this.destroyInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            this.destroyInternal(oContender);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void destroyInternal(Object oContender) {
        this.lock();
        try {
            switch (this.getStatus()) {
                case 2: {
                    if (oContender != this.getCloser()) {
                        throw new IllegalStateException("ThreadGate.destroy: Gate was not closed by " + String.valueOf(oContender) + "; " + String.valueOf(this));
                    }
                    this.updateStatus(3);
                    this.setCloser(null);
                    this.f_open.signalAll();
                    return;
                }
                case 3: {
                    return;
                }
                default: {
                    throw new IllegalStateException("ThreadGate.destroy: Gate is not closed! " + String.valueOf(this));
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean enter(long cMillis) {
        if (this.adjustThreadLocalEnters(1) > 1) {
            return true;
        }
        AtomicLong atomicState = this.f_atomicState;
        long lStatus = atomicState.get();
        while (lStatus < 0xFFFFFFFFFFFFFFFL) {
            if (atomicState.compareAndSet(lStatus, lStatus + 1L)) {
                return true;
            }
            lStatus = atomicState.get();
        }
        this.adjustThreadLocalEnters(-1);
        return this.enterInternal(Thread.currentThread(), cMillis);
    }

    @Override
    public Sentry<R> enter() {
        this.enter(-1L);
        return this.f_exitSentry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enter(Object oContender, long cMillis) {
        Object object = oContender;
        synchronized (object) {
            return this.enterInternal(oContender, cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean enterInternal(Object oContender, long cMillis) {
        AtomicLong atomicState = this.f_atomicState;
        if (this.incrementEnterCount(oContender) > 1L) {
            return true;
        }
        if (oContender == this.getCloser()) {
            if ((atomicState.get() & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
                this.decrementEnterCount(oContender);
                throw new IllegalStateException("The ThreadGate is full.");
            }
            atomicState.incrementAndGet();
            return true;
        }
        boolean fSuccess = false;
        block13: while (true) {
            block14: while (true) {
                long lStatus = atomicState.get();
                switch ((int)(lStatus >>> 60)) {
                    case 0: {
                        if ((lStatus & 0xFFFFFFFFFFFFFFFL) != 0xFFFFFFFFFFFFFFFL) continue block13;
                        throw new IllegalStateException("The ThreadGate is full.");
                        if (!atomicState.compareAndSet(lStatus, lStatus + 1L)) continue block13;
                        fSuccess = true;
                        boolean bl = true;
                        return bl;
                    }
                    case 1: 
                    case 2: {
                        this.lock();
                        try {
                            long nStatus = this.getStatus();
                            if (nStatus != 1L && nStatus != 2L || (cMillis = this.doWait(cMillis)) != 0L) continue block14;
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            this.unlock();
                            continue block14;
                        }
                    }
                    case 3: {
                        throw new IllegalStateException("ThreadGate.enter: ThreadGate has been destroyed.");
                    }
                    default: {
                        throw new IllegalStateException("ThreadGate.enter: ThreadGate has an invalid status. " + String.valueOf(this));
                    }
                }
                break;
            }
            break;
        }
        finally {
            if (!fSuccess) {
                this.decrementEnterCount(oContender);
            }
        }
    }

    @Override
    public void exit() {
        this.exitInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            this.exitInternal(oContender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitInternal(Object oContender) {
        long cEnterThis = this.decrementEnterCount(oContender);
        if (cEnterThis == 0L) {
            if (this.f_atomicState.decrementAndGet() == 0x1000000000000000L) {
                this.lock();
                try {
                    this.f_open.signalAll();
                }
                finally {
                    this.unlock();
                }
            }
        } else if (cEnterThis < 0L) {
            throw new IllegalMonitorStateException("ThreadGate.exit: (" + String.valueOf(oContender) + ") has already exited! " + String.valueOf(this));
        }
    }

    @Override
    public void open() {
        this.openInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            this.openInternal(oContender);
        }
    }

    protected void openInternal(Object oContender) {
        int cClosed;
        if (oContender == this.getCloser() && (cClosed = this.getCloseCount() - 1) >= 0) {
            this.setCloseCount(cClosed);
            if (cClosed == 0) {
                this.lock();
                try {
                    this.updateStatus(0);
                    this.setCloser(null);
                    this.f_open.signalAll();
                }
                finally {
                    this.unlock();
                }
            }
            return;
        }
        throw new IllegalMonitorStateException("ThreadGate.open: Gate was not closed by " + String.valueOf(oContender) + ";" + String.valueOf(this));
    }

    @Override
    public boolean isClosedByCurrentThread() {
        return this.isClosedByInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedBy(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            return this.isClosedByInternal(oContender);
        }
    }

    protected boolean isClosedByInternal(Object oContender) {
        return oContender == this.getCloser() && this.getStatus() == 2;
    }

    @Override
    public boolean isEnteredByCurrentThread() {
        return this.isEnteredByInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnteredBy(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            return this.isClosedByInternal(oContender);
        }
    }

    protected boolean isEnteredByInternal(Object oContender) {
        return this.getEnterCount(oContender) > 0L;
    }

    @Override
    public boolean isClosed() {
        return this.getStatus() == 2;
    }

    protected void lock() {
        this.f_lock.lock();
    }

    protected void unlock() {
        this.f_lock.unlock();
    }

    protected long doWait(long cMillis) {
        if (cMillis == 0L) {
            return 0L;
        }
        long lTime = SafeClock.INSTANCE.getSafeTimeMillis();
        try {
            this.f_open.await(Math.max(0L, cMillis), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.onInterruptedException(e);
        }
        return cMillis < 0L ? cMillis : Math.max(0L, cMillis - (SafeClock.INSTANCE.getSafeTimeMillis() - lTime));
    }

    public int getActiveCount() {
        return (int)(this.f_atomicState.get() & 0xFFFFFFFFFFFFFFFL);
    }

    public int getCloseCount() {
        return this.m_cClose;
    }

    protected void setCloseCount(int cClose) {
        this.m_cClose = cClose;
    }

    protected Object getCloser() {
        return this.m_closer;
    }

    protected void setCloser(Object oCloser) {
        this.m_closer = oCloser;
    }

    public int getStatus() {
        return (int)(this.f_atomicState.get() >>> 60);
    }

    protected int updateStatus(int nStatus) {
        long lNew;
        long lCurr;
        AtomicLong atomicState = this.f_atomicState;
        long lStatus = (long)nStatus << 60;
        while (!atomicState.compareAndSet(lCurr = atomicState.get(), lNew = lStatus | lCurr & 0xFFFFFFFFFFFFFFFL)) {
        }
        return (int)(lCurr >>> 60);
    }

    public String toString() {
        this.lock();
        try {
            String string = "ThreadGate{State=" + (switch (this.getStatus()) {
                case 0 -> "GATE_OPEN";
                case 1 -> "GATE_CLOSING";
                case 2 -> "GATE_CLOSED";
                case 3 -> "GATE_DESTROYED";
                default -> "INVALID";
            }) + ", ActiveCount=" + this.getActiveCount() + ", CloseCount=" + this.getCloseCount() + ", Closer= " + String.valueOf(this.getCloser()) + "}";
            return string;
        }
        finally {
            this.unlock();
        }
    }

    protected void onInterruptedException(InterruptedException e) {
        throw new RuntimeException(this.toString(), e);
    }

    protected static MutableLong makeCounterFromHolder(IdentityHolder<Object> oHolder) {
        return ThreadGate.makeCounter(oHolder.get());
    }

    protected static MutableLong makeCounter(Object oContender) {
        if (oContender instanceof Thread) {
            throw new IllegalArgumentException("thread based contenders may only be the current thread");
        }
        return new MutableLong();
    }

    protected long getEnterCount(Object oContender) {
        return oContender == Thread.currentThread() ? (long)this.adjustThreadLocalEnters(0) : (oContender instanceof LiteContender ? ((LiteContender)oContender).getCount(this) : (oContender == this.f_atomicState ? 0L : this.ensureEnterCountMap().getOrDefault(new IdentityHolder<Object>(oContender), ThreadGate.makeCounter(oContender)).get()));
    }

    protected long incrementEnterCount(Object oContender) {
        return oContender == Thread.currentThread() ? (long)this.adjustThreadLocalEnters(1) : (oContender instanceof LiteContender ? ((LiteContender)oContender).incrementAndGet(this) : (oContender == this.f_atomicState ? 0L : this.ensureEnterCountMap().computeIfAbsent(new IdentityHolder<Object>(oContender), ThreadGate::makeCounterFromHolder).incrementAndGet()));
    }

    protected long decrementEnterCount(Object oContender) {
        return oContender == Thread.currentThread() ? (long)this.adjustThreadLocalEnters(-1) : (oContender instanceof LiteContender ? ((LiteContender)oContender).decrementAndGet(this) : (oContender == this.f_atomicState ? 0L : this.decrementEnterCountComplex(oContender)));
    }

    protected long decrementEnterCountComplex(Object oContender) {
        IdentityHolder<Object> oHolder;
        ConcurrentHashMap<IdentityHolder<Object>, MutableLong> map = this.ensureEnterCountMap();
        MutableLong cEnter = (MutableLong)map.get(oHolder = new IdentityHolder<Object>(oContender));
        if (cEnter == null) {
            if (oContender instanceof Thread) {
                throw new IllegalArgumentException("thread-based contenders may only be the current thread");
            }
            return -1L;
        }
        long c = cEnter.decrementAndGet();
        if (c <= 0L) {
            map.remove(oHolder, cEnter);
        }
        return c;
    }

    protected ConcurrentHashMap<IdentityHolder<Object>, MutableLong> ensureEnterCountMap() {
        ConcurrentHashMap<IdentityHolder<Object>, MutableLong> map = this.m_mapContenderEnters;
        if (map == null) {
            this.lock();
            try {
                map = this.m_mapContenderEnters;
                if (map == null) {
                    map = this.m_mapContenderEnters = new ConcurrentHashMap();
                }
            }
            finally {
                this.unlock();
            }
        }
        return map;
    }

    protected int adjustThreadLocalEnters(int c) {
        int i;
        int[] ai = this.f_tlcEnters.get();
        if (ai == null) {
            ai = new int[1];
            this.f_tlcEnters.set(ai);
        }
        if ((i = ai[0] + c) >= 0) {
            ai[0] = i;
        }
        return i;
    }

    public static class LiteContender
    extends InflatableMap<ThreadGate, MutableLong> {
        private ThreadGate m_gatePrimary;
        private long m_cEntersPrimary;

        protected long incrementAndGet(ThreadGate gate) {
            return gate == this.m_gatePrimary ? (this.m_cEntersPrimary = this.m_cEntersPrimary + 1L) : this.incrementComplex(gate);
        }

        protected long incrementComplex(ThreadGate gate) {
            MutableLong cEnters = (MutableLong)this.get(gate);
            if (cEnters == null) {
                if (this.m_gatePrimary == null) {
                    this.m_gatePrimary = gate;
                    this.m_cEntersPrimary = 1L;
                    return 1L;
                }
                cEnters = new MutableLong();
                this.put(gate, cEnters);
            }
            return cEnters.incrementAndGet();
        }

        protected long decrementAndGet(ThreadGate gate) {
            if (gate == this.m_gatePrimary) {
                long cEnters;
                if ((cEnters = --this.m_cEntersPrimary) <= 0L) {
                    this.m_gatePrimary = null;
                    this.m_cEntersPrimary = 0L;
                }
                return cEnters;
            }
            MutableLong cEnters = (MutableLong)this.get(gate);
            return cEnters == null ? -1L : cEnters.decrementAndGet();
        }

        protected long getCount(ThreadGate gate) {
            if (gate == this.m_gatePrimary) {
                return this.m_cEntersPrimary;
            }
            MutableLong cEnters = (MutableLong)this.get(gate);
            return cEnters == null ? 0L : cEnters.get();
        }
    }

    public static class NonReentrant<R>
    extends ThreadGate<R> {
        public NonReentrant() {
            this(null);
        }

        public NonReentrant(R resource) {
            super(resource);
        }

        @Override
        public boolean enter(long cMillis) {
            AtomicLong atomicState = this.f_atomicState;
            long lStatus = atomicState.get();
            while (lStatus < 0xFFFFFFFFFFFFFFFL) {
                if (atomicState.compareAndSet(lStatus, lStatus + 1L)) {
                    return true;
                }
                lStatus = atomicState.get();
            }
            return this.enterInternal(this.f_atomicState, cMillis);
        }

        @Override
        public boolean enter(Object oContender, long cMillis) {
            return this.enter(cMillis);
        }

        @Override
        public void exit() {
            this.exitInternal(this.f_atomicState);
        }

        @Override
        public void exit(Object oContender) {
            this.exitInternal(this.f_atomicState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exitInternal(Object oContender) {
            long lStatus = this.f_atomicState.decrementAndGet();
            if (lStatus == 0x1000000000000000L) {
                this.lock();
                try {
                    this.f_open.signalAll();
                }
                finally {
                    this.unlock();
                }
            } else if (lStatus < 0L) {
                throw new IllegalStateException();
            }
        }
    }
}

