/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.base.Associated;
import com.oracle.coherence.common.util.AssociationPile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class SimpleAssociationPile<E>
implements AssociationPile<E> {
    private final LinkedList<E> f_list = new LinkedList();
    private final Set f_setLocked = new HashSet();
    private volatile boolean m_fAllLocked;
    private volatile boolean m_fAvailable;

    @Override
    public synchronized boolean add(E element) {
        this.f_list.add(element);
        this.m_fAvailable = true;
        return true;
    }

    @Override
    public synchronized E poll() {
        if (this.f_list.isEmpty()) {
            this.m_fAvailable = false;
            return null;
        }
        E elFirst = this.f_list.getFirst();
        Contention contention = this.lockAssociation(elFirst, Contention.NONE);
        if (contention == Contention.NONE) {
            this.f_list.removeFirst();
            if (this.f_list.isEmpty()) {
                this.m_fAvailable = false;
            }
            return elFirst;
        }
        Iterator iter = this.f_list.iterator();
        iter.next();
        while (iter.hasNext()) {
            Object el = iter.next();
            contention = this.lockAssociation(el, contention);
            if (contention != Contention.NONE) continue;
            iter.remove();
            return el;
        }
        return null;
    }

    @Override
    public synchronized void release(E element) {
        this.unlockAssociation(element);
    }

    @Override
    public synchronized int size() {
        return this.f_list.size();
    }

    @Override
    public boolean isAvailable() {
        return this.m_fAvailable;
    }

    private Contention lockAssociation(E element, Contention contention) {
        Object oAssoc;
        Object e = oAssoc = element instanceof Associated ? (Object)((Associated)element).getAssociatedKey() : null;
        if (oAssoc == null) {
            return Contention.NONE;
        }
        switch (contention.ordinal()) {
            case 2: {
                return contention;
            }
        }
        if (oAssoc == ASSOCIATION_ALL) {
            if (!this.f_setLocked.isEmpty()) {
                return Contention.ALL;
            }
            this.m_fAllLocked = true;
            return Contention.NONE;
        }
        return !this.m_fAllLocked && this.f_setLocked.add(oAssoc) ? Contention.NONE : Contention.SINGLE;
    }

    private void unlockAssociation(E element) {
        Object oAssoc;
        Object v0 = oAssoc = element instanceof Associated ? ((Associated)element).getAssociatedKey() : null;
        if (oAssoc != null) {
            if (oAssoc == ASSOCIATION_ALL) {
                if (this.m_fAllLocked) {
                    this.m_fAllLocked = false;
                }
            } else {
                this.f_setLocked.remove(oAssoc);
            }
        }
    }

    public static enum Contention {
        NONE,
        SINGLE,
        ALL;

    }
}

