/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final String NUMBER = "(\\d+(?:\\.\\d+)?)";
    private static final String PATTERN_MINUTE = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Mm]))?";
    private static final String PATTERN_HOUR = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Hh]))?";
    private static final String PATTERN_DAY = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Dd]))?";
    private static final String PATTERN_SECOND = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Ss]))?";
    private static final String PATTERN_NANO = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Nn][Ss]))?";
    private static final String PATTERN_MILLI = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Mm][Ss]))?";
    private static final String PATTERN_MICRO = "\\s*((\\d+(?:\\.\\d+)?)\\s*([Uu\u00b5Mm\\u039C\\u03BC][Ss]))?";
    private static final Pattern REGEX_NUMBER = Pattern.compile("(\\d+(?:\\.\\d+)?)");
    private static final Pattern REGEX_PATTERN = Pattern.compile("\\s*((\\d+(?:\\.\\d+)?)\\s*([Dd]))?\\s*((\\d+(?:\\.\\d+)?)\\s*([Hh]))?\\s*((\\d+(?:\\.\\d+)?)\\s*([Mm]))?\\s*((\\d+(?:\\.\\d+)?)\\s*([Ss]))?\\s*((\\d+(?:\\.\\d+)?)\\s*([Mm][Ss]))?\\s*((\\d+(?:\\.\\d+)?)\\s*([Uu\u00b5Mm\\u039C\\u03BC][Ss]))?\\s*((\\d+(?:\\.\\d+)?)\\s*([Nn][Ss]))?");
    private long m_cNanos;

    public Duration(Duration d) {
        assert (d != null);
        this.m_cNanos = d.m_cNanos;
    }

    public Duration(long cNanos) {
        assert (cNanos >= 0L);
        this.m_cNanos = cNanos;
    }

    public Duration(String s) {
        this(s, null);
    }

    public Duration(double nAmount, Magnitude magnitude) {
        assert (nAmount >= 0.0);
        this.m_cNanos = Math.round(nAmount * (double)magnitude.getFactor());
    }

    public Duration(int nAmount, Magnitude magnitude) {
        assert (nAmount >= 0);
        this.m_cNanos = (long)nAmount * magnitude.getFactor();
    }

    public Duration(String s, Magnitude m) {
        Matcher matcher;
        String string = s = s == null ? null : s.trim();
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("An empty or null string was provided.  Expected a duration size");
        }
        boolean fUsedDefault = false;
        if (m != null && (matcher = REGEX_NUMBER.matcher(s)).matches()) {
            String sAmount = matcher.group(1);
            double nAmount = Double.valueOf(sAmount);
            this.m_cNanos = Math.round(nAmount * (double)m.getFactor());
            fUsedDefault = true;
        }
        if (!fUsedDefault && !s.equals("0")) {
            matcher = REGEX_PATTERN.matcher(s);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("The specified %s [%s] is invalid.", this.getClass().getName(), s));
            }
            this.m_cNanos = 0L;
            for (int i = 1; i < matcher.groupCount(); i += 3) {
                String sAmount = matcher.group(i + 1);
                if (sAmount == null) continue;
                double nAmount = Double.valueOf(sAmount);
                String sSuffix = matcher.group(i + 2);
                Magnitude magnitude = Magnitude.fromSuffix(sSuffix);
                this.m_cNanos += Math.round(nAmount * (double)magnitude.getFactor());
            }
        }
    }

    public long getNanos() {
        return this.m_cNanos;
    }

    public long as(Magnitude magnitude) {
        return this.m_cNanos / magnitude.getFactor();
    }

    public String toString(boolean fExact) {
        StringBuilder sbResult = new StringBuilder();
        long cRemainingNanos = this.m_cNanos;
        int cLimit = 2;
        Magnitude magnitude = Magnitude.HIGHEST;
        while (cRemainingNanos > 0L && (fExact || cLimit > 0)) {
            long cMagnitudeUnits = cRemainingNanos / magnitude.getFactor();
            if (cMagnitudeUnits > 0L) {
                cRemainingNanos -= cMagnitudeUnits * magnitude.getFactor();
                if (fExact || magnitude.ordinal() > Magnitude.SECOND.ordinal()) {
                    sbResult.append(cMagnitudeUnits);
                } else {
                    long cNanosPerMagnitudeFractionUnit = magnitude.getFactor() / 1000L;
                    long cMagnitudeFractionUnits = cNanosPerMagnitudeFractionUnit > 0L ? cRemainingNanos / cNanosPerMagnitudeFractionUnit : 0L;
                    long cMagnitudeFractionNanos = cMagnitudeFractionUnits * cNanosPerMagnitudeFractionUnit;
                    double flRem = (double)(cMagnitudeFractionNanos * 1000L / magnitude.getFactor()) / 1000.0;
                    if (flRem >= 0.01 && (fExact || cLimit > 1)) {
                        sbResult.append(String.format("%.2f", (double)cMagnitudeUnits + flRem));
                    } else {
                        sbResult.append(cMagnitudeUnits);
                    }
                    cRemainingNanos = 0L;
                }
                sbResult.append(magnitude.getSuffix());
                --cLimit;
            } else if (sbResult.length() > 0) {
                --cLimit;
            }
            magnitude = magnitude.previous();
        }
        if (sbResult.length() == 0) {
            return "0ns";
        }
        return sbResult.toString();
    }

    public java.time.Duration asJavaDuration() {
        return java.time.Duration.ofNanos(this.getNanos());
    }

    public int hashCode() {
        return 31 + (int)(this.m_cNanos ^ this.m_cNanos >>> 32);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof Duration && ((Duration)obj).m_cNanos == this.m_cNanos;
    }

    public String toString() {
        return this.toString(false);
    }

    public static enum Magnitude {
        NANO(1L, "ns"),
        MICRO(1000L, "us", "\u00b5s", "\u039cs", "\u03bcs"),
        MILLI(1000000L, "ms"),
        SECOND(1000000000L, "s"),
        MINUTE(60000000000L, "m"),
        HOUR(3600000000000L, "h"),
        DAY(86400000000000L, "d");

        private static final Magnitude[] VALUES;
        public static final Magnitude LOWEST;
        public static final Magnitude HIGHEST;
        public final long FACTOR;
        public final String[] SUFFIXES;

        private Magnitude(long nFactor, String ... sSuffixes) {
            this.FACTOR = nFactor;
            this.SUFFIXES = sSuffixes;
        }

        public long getFactor() {
            return this.FACTOR;
        }

        public String getSuffix() {
            return this.SUFFIXES[0];
        }

        public boolean isSuffix(String s) {
            for (String sSuffix : this.SUFFIXES) {
                if (!sSuffix.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        public Magnitude next() {
            if (this.equals((Object)HIGHEST)) {
                return null;
            }
            return VALUES[this.ordinal() + 1];
        }

        public Magnitude previous() {
            if (this.equals((Object)LOWEST)) {
                return null;
            }
            return VALUES[this.ordinal() - 1];
        }

        public static Magnitude fromSuffix(String sSuffix) {
            if ((sSuffix = sSuffix.trim()).length() == 0) {
                return NANO;
            }
            if (sSuffix.length() > 0) {
                for (Magnitude magnitude : VALUES) {
                    if (!magnitude.isSuffix(sSuffix)) continue;
                    return magnitude;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown %s suffix [%s]", Magnitude.class.getName(), sSuffix));
        }

        static {
            VALUES = Magnitude.values();
            LOWEST = VALUES[0];
            HIGHEST = VALUES[VALUES.length - 1];
        }
    }
}

