/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.base.Blocking;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class AutoLock<R>
implements Lock {
    protected Lock f_lockDelegate;
    protected final R f_resource;
    protected final Sentry<R> f_sentry = new Sentry(this);

    public AutoLock(Lock delegate) {
        this(delegate, null);
    }

    public AutoLock(Lock delegate, R resource) {
        this.f_lockDelegate = delegate;
        this.f_resource = resource;
    }

    public Sentry<R> acquire() {
        this.f_lockDelegate.lock();
        return this.f_sentry;
    }

    public R getResource() {
        return this.f_resource;
    }

    @Override
    public void lock() {
        this.f_lockDelegate.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        Blocking.lockInterruptibly(this.f_lockDelegate);
    }

    @Override
    public boolean tryLock() {
        return this.f_lockDelegate.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return Blocking.tryLock(this.f_lockDelegate, time, unit);
    }

    @Override
    public void unlock() {
        this.f_lockDelegate.unlock();
    }

    @Override
    public Condition newCondition() {
        return this.f_lockDelegate.newCondition();
    }

    public static class Sentry<V>
    implements com.oracle.coherence.common.util.Sentry<V> {
        protected final AutoLock<V> f_parent;

        protected Sentry(AutoLock<V> parent) {
            this.f_parent = parent;
        }

        @Override
        public void close() {
            this.f_parent.unlock();
        }

        @Override
        public V getResource() {
            return this.f_parent.getResource();
        }
    }
}

