/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import com.oracle.coherence.common.schema.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static Element getChildElement(Element parent, String ns, String name) {
        NodeList nodes = parent.getElementsByTagNameNS(ns, name);
        if (nodes != null && nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public static List<Element> toElementList(NodeList nodes) {
        ArrayList<Element> elements = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            elements.add((Element)nodes.item(i));
        }
        return elements;
    }

    public static List<Attr> toAttributeList(NamedNodeMap attributeMap) {
        ArrayList<Attr> attributes = new ArrayList<Attr>(attributeMap.getLength());
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            attributes.add((Attr)attributeMap.item(i));
        }
        return attributes;
    }

    public static boolean getBooleanAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        return !StringUtils.isEmpty(value) && Boolean.parseBoolean(value);
    }
}

