/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import com.oracle.coherence.common.schema.util.NameTransformer;
import com.oracle.coherence.common.schema.util.StringUtils;

public class SuffixTransformer
implements NameTransformer {
    private String m_suffix;
    private Mode m_mode;

    public SuffixTransformer(String suffix, Mode mode) {
        if (StringUtils.isEmpty(suffix)) {
            throw new IllegalArgumentException("suffix cannot be null or empty");
        }
        this.m_suffix = suffix;
        this.m_mode = mode;
    }

    @Override
    public String transform(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        String suffix = this.m_suffix;
        if (this.m_mode == Mode.ADD && !source.endsWith(suffix)) {
            return source + suffix;
        }
        if (source.endsWith(suffix)) {
            return source.substring(0, source.length() - suffix.length());
        }
        return source;
    }

    @Override
    public String[] transform(String[] source) {
        if (source != null && source.length > 0) {
            String suffix = this.m_suffix;
            if (this.m_mode == Mode.ADD && !suffix.equals(source[source.length - 1])) {
                String[] result = new String[source.length + 1];
                result[source.length] = suffix;
                System.arraycopy(source, 0, result, 0, source.length);
                return result;
            }
            if (suffix.equals(source[source.length - 1])) {
                String[] result = new String[source.length - 1];
                System.arraycopy(source, 0, result, 0, source.length - 1);
                return result;
            }
        }
        return source;
    }

    public static enum Mode {
        ADD,
        REMOVE;

    }
}

