/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;

public class ResourceLoader
implements Iterable<InputStream> {
    private final String m_resourceName;
    private final Enumeration<URL> m_resources;

    private ResourceLoader(String resourceName, ClassLoader loader) {
        try {
            this.m_resourceName = resourceName;
            this.m_resources = loader.getResources(resourceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<InputStream> iterator() {
        return new Iterator<InputStream>(){

            @Override
            public boolean hasNext() {
                return ResourceLoader.this.m_resources.hasMoreElements();
            }

            @Override
            public InputStream next() {
                try {
                    return ResourceLoader.this.m_resources.nextElement().openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    public static ResourceLoader load(String resourceName, ClassLoader loader) {
        return new ResourceLoader(resourceName, loader);
    }

    public static ResourceLoader load(String resourceName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ResourceLoader.load(resourceName, cl);
    }

    public static ResourceLoader loadInstalled(String resourceName) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return ResourceLoader.load(resourceName, prev);
    }

    public String toString() {
        return "ResourceLoader{resourceName='" + this.m_resourceName + "'}";
    }
}

