/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import com.oracle.coherence.common.schema.util.NameTransformer;
import com.oracle.coherence.common.schema.util.StringUtils;

public class PrefixTransformer
implements NameTransformer {
    private String m_prefix;
    private Mode m_mode;

    public PrefixTransformer(String prefix, Mode mode) {
        if (StringUtils.isEmpty(prefix)) {
            throw new IllegalArgumentException("prefix cannot be null or empty");
        }
        this.m_prefix = prefix;
        this.m_mode = mode;
    }

    @Override
    public String transform(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        String prefix = this.m_prefix;
        if (this.m_mode == Mode.ADD && !source.startsWith(prefix)) {
            return prefix + source;
        }
        if (source.startsWith(prefix)) {
            return source.substring(prefix.length());
        }
        return source;
    }

    @Override
    public String[] transform(String[] source) {
        if (source != null && source.length > 0) {
            String prefix = this.m_prefix;
            if (this.m_mode == Mode.ADD && !prefix.equals(source[0])) {
                String[] result = new String[source.length + 1];
                result[0] = prefix;
                System.arraycopy(source, 0, result, 1, source.length);
                return result;
            }
            if (prefix.equals(source[0])) {
                String[] result = new String[source.length - 1];
                System.arraycopy(source, 1, result, 0, source.length - 1);
                return result;
            }
        }
        return source;
    }

    public static enum Mode {
        ADD,
        REMOVE;

    }
}

