/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import com.oracle.coherence.common.schema.util.NameTransformer;
import com.oracle.coherence.common.schema.util.StringUtils;

public class CapitalizationTransformer
implements NameTransformer {
    private Mode m_mode;

    public CapitalizationTransformer(Mode mode) {
        this.m_mode = mode;
    }

    @Override
    public String transform(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        switch (this.m_mode.ordinal()) {
            case 0: {
                return source.toUpperCase();
            }
            case 1: {
                return source.toLowerCase();
            }
            case 2: {
                return source.substring(0, 1).toUpperCase() + source.substring(1);
            }
            case 3: {
                return source.substring(0, 1).toLowerCase() + source.substring(1);
            }
        }
        return source;
    }

    @Override
    public String[] transform(String[] source) {
        if (source != null) {
            for (int i = 0; i < source.length; ++i) {
                source[i] = this.transform(source[i]);
            }
        }
        return source;
    }

    public static enum Mode {
        UPPER,
        LOWER,
        FIRST_UPPER,
        FIRST_LOWER;

    }
}

