/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang.java.handler;

import com.oracle.coherence.common.schema.AbstractPropertyHandler;
import com.oracle.coherence.common.schema.AbstractTypeDescriptor;
import com.oracle.coherence.common.schema.AbstractTypeHandler;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.lang.java.JavaProperty;
import com.oracle.coherence.common.schema.lang.java.JavaType;
import com.oracle.coherence.common.schema.lang.java.JavaTypeDescriptor;
import com.tangosol.internal.asm.tree.ClassNode;
import com.tangosol.internal.asm.tree.FieldNode;

public class ClassFileHandler {

    public static class ClassFilePropertyHandler
    extends AbstractPropertyHandler<JavaProperty, FieldNode> {
        @Override
        public void importProperty(JavaProperty property, FieldNode source, Schema schema) {
            CanonicalTypeDescriptor ctd = property.getParent().getType();
            if (ctd != null) {
                JavaType javaType = schema.getType(ctd, JavaType.class);
                JavaTypeDescriptor jtd = JavaTypeDescriptor.fromInternal(source.signature != null ? source.signature : source.desc);
                if (javaType == null || jtd.isGenericType()) {
                    property.setType(jtd);
                } else {
                    CanonicalTypeDescriptor desc;
                    AbstractTypeDescriptor abstractTypeDescriptor = desc = javaType.getDescriptor() == null ? ctd : (AbstractTypeDescriptor)javaType.getDescriptor();
                    if (!jtd.isNameEqual(desc)) {
                        property.setType(jtd);
                    }
                }
            }
        }
    }

    public static class ClassFileTypeHandler
    extends AbstractTypeHandler<JavaType, ClassNode> {
        @Override
        public void importType(JavaType type, ClassNode source, Schema schema) {
            JavaTypeDescriptor jtd = JavaTypeDescriptor.fromInternal(source.name);
            if (jtd.getNamespace() == null || !jtd.isNameEqual(type.getParent().getDescriptor())) {
                type.setDescriptor(jtd);
            }
        }
    }
}

