/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang.java;

import com.oracle.coherence.common.schema.PropertyHandler;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaExtension;
import com.oracle.coherence.common.schema.TypeHandler;
import com.oracle.coherence.common.schema.lang.XmlPropertyHandler;
import com.oracle.coherence.common.schema.lang.XmlTypeHandler;
import com.oracle.coherence.common.schema.lang.java.JavaProperty;
import com.oracle.coherence.common.schema.lang.java.JavaType;
import com.oracle.coherence.common.schema.lang.java.JavaTypeDescriptor;
import com.oracle.coherence.common.schema.lang.java.handler.ClassFileHandler;
import com.oracle.coherence.common.schema.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaExtension
implements SchemaExtension {
    private static final String NS = "http://xmlns.oracle.com/coherence/schema/java";

    @Override
    public String getName() {
        return "java";
    }

    @Override
    public Collection<TypeHandler> getTypeHandlers() {
        return Arrays.asList(new ClassFileHandler.ClassFileTypeHandler(), new JavaXmlTypeHandler());
    }

    @Override
    public Collection<PropertyHandler> getPropertyHandlers() {
        return Arrays.asList(new ClassFileHandler.ClassFilePropertyHandler(), new JavaXmlPropertyHandler());
    }

    public static class JavaXmlTypeHandler
    extends XmlTypeHandler<JavaType, JavaTypeDescriptor> {
        public JavaXmlTypeHandler() {
            super(JavaExtension.NS);
        }

        @Override
        protected void importTypeInternal(JavaType type, Element source, Element xmlType, Schema schema) {
            String wrapper = xmlType.getAttribute("wrapper");
            if (!StringUtils.isEmpty(wrapper)) {
                type.setWrapperType((JavaTypeDescriptor)this.parseTypeName(wrapper));
            }
        }

        @Override
        protected void exportTypeInternal(JavaType type, Document doc, Element target, Element xmlType, Schema schema) {
            if (type.getWrapperType() != null) {
                xmlType.setAttribute("wrapper", type.getWrapperType().getFullName());
            }
        }
    }

    public static class JavaXmlPropertyHandler
    extends XmlPropertyHandler<JavaProperty, JavaTypeDescriptor> {
        public JavaXmlPropertyHandler() {
            super(JavaExtension.NS);
        }
    }
}

