/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang.dotnet;

import com.oracle.coherence.common.schema.AbstractTypeDescriptor;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import java.util.ArrayList;
import java.util.List;

public class DotNetTypeDescriptor
extends AbstractTypeDescriptor<DotNetTypeDescriptor> {
    public static final DotNetTypeParser PARSER = new DotNetTypeParser(".");

    private DotNetTypeDescriptor(String[] namespace, String name, boolean fArray) {
        super(namespace, name, fArray);
    }

    private DotNetTypeDescriptor(String[] namespace, String name, boolean fArray, List<DotNetTypeDescriptor> genericArgs) {
        super(namespace, name, fArray, genericArgs);
    }

    public static DotNetTypeDescriptor parse(String type) {
        return (DotNetTypeDescriptor)PARSER.parse(type);
    }

    public static DotNetTypeDescriptor fromCanonical(CanonicalTypeDescriptor type) {
        return new DotNetTypeDescriptor(type.getNamespaceComponents(), type.getName(), type.isArray(), DotNetTypeDescriptor.fromCanonical(type.getGenericArguments()));
    }

    public static List<DotNetTypeDescriptor> fromCanonical(List<CanonicalTypeDescriptor> types) {
        ArrayList<DotNetTypeDescriptor> result = new ArrayList<DotNetTypeDescriptor>(types.size());
        for (CanonicalTypeDescriptor type : types) {
            result.add(DotNetTypeDescriptor.fromCanonical(type));
        }
        return result;
    }

    @Override
    protected DotNetTypeDescriptor createArrayType(String[] namespace, String name) {
        return new DotNetTypeDescriptor(namespace, name, true);
    }

    @Override
    protected AbstractTypeDescriptor.Parser getParser() {
        return PARSER;
    }

    private static class DotNetTypeParser
    extends AbstractTypeDescriptor.Parser<DotNetTypeDescriptor> {
        public DotNetTypeParser(String separator) {
            super(separator);
        }

        @Override
        protected DotNetTypeDescriptor getStandardType(String type) {
            return null;
        }

        @Override
        protected DotNetTypeDescriptor createTypeDescriptor(String[] namespace, String name, boolean fArray, List<DotNetTypeDescriptor> genericArgs) {
            return new DotNetTypeDescriptor(namespace, name, fArray, genericArgs);
        }
    }
}

