/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang;

import com.oracle.coherence.common.schema.AbstractPropertyHandler;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.TypeDescriptor;
import com.oracle.coherence.common.schema.lang.AbstractLangProperty;
import com.oracle.coherence.common.schema.util.StringUtils;
import com.oracle.coherence.common.schema.util.XmlUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlPropertyHandler<T extends AbstractLangProperty<TD>, TD extends TypeDescriptor>
extends AbstractPropertyHandler<T, Element> {
    private String m_nsPrefix;
    private final String m_ns;
    private Class<TD> m_typeDescriptorClass;
    private Method m_parseMethod;

    public XmlPropertyHandler(String ns) {
        this.m_ns = ns;
        Type superclass = this.getClass().getGenericSuperclass();
        this.m_typeDescriptorClass = (Class)((ParameterizedType)superclass).getActualTypeArguments()[1];
    }

    @Override
    public void importProperty(T property, Element source, Schema schema) {
        Element xmlProperty = XmlUtils.getChildElement(source, this.getNS(), "property");
        if (xmlProperty != null) {
            String type = xmlProperty.getAttributeNS(this.getNS(), "type");
            ((AbstractLangProperty)property).setType(this.parseTypeName(type));
            this.importPropertyInternal(property, source, xmlProperty, schema);
        }
    }

    @Override
    public void exportProperty(T property, Element target, Schema schema) {
        if (((AbstractLangProperty)property).getType() != null) {
            Document doc = target.getOwnerDocument();
            doc.getDocumentElement().setAttribute("xmlns:" + this.getPrefix(), this.getNS());
            Element xmlProperty = doc.createElementNS(this.getNS(), this.getPrefix() + ":property");
            xmlProperty.setAttribute("type", ((AbstractLangProperty)property).getType().toString());
            target.appendChild(xmlProperty);
            this.exportPropertyInternal(property, target, xmlProperty, schema);
        }
    }

    protected void importPropertyInternal(T property, Element source, Element xmlProperty, Schema schema) {
    }

    protected void exportPropertyInternal(T property, Element target, Element xmlProperty, Schema schema) {
    }

    protected TD parseTypeName(String name) {
        try {
            if (this.m_parseMethod == null) {
                this.m_parseMethod = this.m_typeDescriptorClass.getMethod("parse", String.class);
            }
            return (TD)((TypeDescriptor)this.m_parseMethod.invoke(this.m_typeDescriptorClass, name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getPrefix() {
        if (this.m_nsPrefix == null) {
            String[] ns = StringUtils.split(this.m_ns, "/");
            this.m_nsPrefix = ns[ns.length - 1];
        }
        return this.m_nsPrefix;
    }

    protected String getNS() {
        return this.m_ns;
    }
}

