/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.schema.AbstractSchemaSource;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.util.StringUtils;
import com.oracle.coherence.common.schema.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSchemaSource
extends AbstractSchemaSource<Element, Element> {
    protected InputStream m_inputXml;

    public XmlSchemaSource(String fileName) {
        File file = new File(fileName);
        try {
            this.m_inputXml = file.exists() ? new FileInputStream(file) : Classes.getContextClassLoader().getResourceAsStream(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.m_inputXml == null) {
            throw new IllegalArgumentException(String.format("The specified XML file %s cannot be found", fileName));
        }
    }

    public XmlSchemaSource(File file) {
        try {
            this.m_inputXml = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("The specified XML file %s cannot be found", file.getAbsolutePath()), e);
        }
    }

    public XmlSchemaSource(InputStream inputXml) {
        this.m_inputXml = inputXml;
    }

    @Override
    public void populateSchema(Schema schema) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.m_inputXml);
            Element root = doc.getDocumentElement();
            boolean fExternal = XmlUtils.getBooleanAttribute(root, "external");
            List<Element> types = XmlUtils.toElementList(root.getElementsByTagName("type"));
            for (Element t : types) {
                String fullName = CanonicalTypeDescriptor.parse(t.getAttribute("name")).getFullName();
                ExtensibleType type = this.populateTypeInternal(schema, schema.getType(fullName), t);
                type.setExternal(fExternal);
                schema.addType(type);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getPropertyName(Element source) {
        return source.getAttribute("name");
    }

    @Override
    protected Collection<Element> getProperties(Element source) {
        return XmlUtils.toElementList(source.getElementsByTagName("property"));
    }

    @Override
    public Class<Element> getExternalTypeClass() {
        return Element.class;
    }

    @Override
    public void importType(ExtensibleType type, Element source, Schema schema) {
        String name = source.getAttribute("name");
        type.setDescriptor(CanonicalTypeDescriptor.parse(name));
        String base = source.getAttribute("base");
        if (!StringUtils.isEmpty(base)) {
            type.setBase(CanonicalTypeDescriptor.parse(base));
        }
        if (source.hasAttribute("external")) {
            boolean fExternal = Boolean.parseBoolean(source.getAttribute("external"));
            if (!StringUtils.isEmpty(base)) {
                type.setExternal(fExternal);
            }
        }
        List<Element> interfaces = XmlUtils.toElementList(source.getElementsByTagName("interface"));
        for (Element e : interfaces) {
            name = e.getAttribute("name");
            type.addInterface(CanonicalTypeDescriptor.parse(name));
        }
    }

    @Override
    public void exportType(ExtensibleType type, Element target, Schema schema) {
    }

    @Override
    public Class<Element> getExternalPropertyClass() {
        return Element.class;
    }

    @Override
    public void importProperty(ExtensibleProperty property, Element source, Schema schema) {
        property.setName(source.getAttribute("name"));
        property.setType(CanonicalTypeDescriptor.parse(source.getAttribute("type")));
    }

    @Override
    public void exportProperty(ExtensibleProperty property, Element target, Schema schema) {
    }
}

