/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.AbstractSchemaExporter;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.PropertyHandler;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.TypeHandler;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSchemaExporter
extends AbstractSchemaExporter<Element, Element> {
    private static final String NS = "http://xmlns.oracle.com/coherence/schema";
    private OutputStream m_outputStream;

    public XmlSchemaExporter() {
        this(System.out);
    }

    public XmlSchemaExporter(OutputStream outputStream) {
        this.m_outputStream = outputStream;
    }

    @Override
    public void export(Schema schema) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElementNS(NS, "schema");
            doc.appendChild(root);
            for (ExtensibleType t : schema) {
                Element type = doc.createElementNS(NS, "type");
                this.exportType(t, type, schema);
                for (TypeHandler handler : schema.getTypeHandlers(this.getExternalTypeClass())) {
                    Object ext = t.getExtension(handler.getInternalTypeClass());
                    handler.exportType(ext, type, schema);
                }
                for (ExtensibleProperty p : t.getProperties()) {
                    Element property = doc.createElementNS(NS, "property");
                    this.exportProperty(p, property, schema);
                    for (PropertyHandler handler : schema.getPropertyHandlers(this.getExternalPropertyClass())) {
                        Object ext = p.getExtension(handler.getInternalPropertyClass());
                        handler.exportProperty(ext, property, schema);
                    }
                    type.appendChild(property);
                }
                root.appendChild(type);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.m_outputStream);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<Element> getExternalTypeClass() {
        return Element.class;
    }

    @Override
    public void exportType(ExtensibleType type, Element target, Schema schema) {
        target.setAttribute("name", type.getFullName());
    }

    @Override
    public Class<Element> getExternalPropertyClass() {
        return Element.class;
    }

    @Override
    public void exportProperty(ExtensibleProperty property, Element target, Schema schema) {
        target.setAttribute("name", property.getName());
        target.setAttribute("type", property.getType().toString());
    }
}

