/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class SchemaBuilder {
    private List<SchemaSource> m_schemaSources;
    private Map<String, ExtensibleType> m_store;

    public SchemaBuilder() {
        ArrayList<SchemaSource> schemaSources = new ArrayList<SchemaSource>();
        ServiceLoader<SchemaSource> loader = ServiceLoader.load(SchemaSource.class, this.getClass().getClassLoader());
        for (SchemaSource source : loader) {
            schemaSources.add(source);
        }
        this.m_schemaSources = schemaSources;
    }

    public SchemaBuilder addSchemaSource(SchemaSource schemaSource) {
        this.m_schemaSources.add(schemaSource);
        return this;
    }

    public SchemaBuilder setStore(Map<String, ExtensibleType> store) {
        this.m_store = store;
        return this;
    }

    public Schema build() {
        Schema schema = new Schema(this.m_store);
        for (SchemaSource ts : this.m_schemaSources) {
            ts.populateSchema(schema);
        }
        return schema;
    }
}

