/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.PropertyHandler;
import com.oracle.coherence.common.schema.SchemaExtension;
import com.oracle.coherence.common.schema.SchemaVisitor;
import com.oracle.coherence.common.schema.Type;
import com.oracle.coherence.common.schema.TypeHandler;
import com.oracle.coherence.common.schema.XmlSchemaSource;
import com.oracle.coherence.common.schema.lang.cpp.CppExtension;
import com.oracle.coherence.common.schema.lang.dotnet.DotNetExtension;
import com.oracle.coherence.common.schema.lang.java.JavaExtension;
import com.oracle.coherence.common.schema.lang.java.JavaType;
import com.oracle.coherence.common.schema.util.ResourceLoader;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class Schema
implements Iterable<ExtensibleType> {
    protected Map<String, ExtensibleType> m_typeMap;
    protected Set<String> m_extensions = new HashSet<String>();
    protected Map<String, Set<TypeHandler>> m_typeHandlers = new LinkedHashMap<String, Set<TypeHandler>>();
    protected Map<String, Set<PropertyHandler>> m_propertyHandlers = new LinkedHashMap<String, Set<PropertyHandler>>();

    protected Schema(Map<String, ExtensibleType> typeMap) {
        this.m_typeMap = typeMap == null ? new LinkedHashMap() : typeMap;
        this.registerExtension(new JavaExtension());
        this.registerExtension(new DotNetExtension());
        this.registerExtension(new CppExtension());
        ServiceLoader<SchemaExtension> loader = ServiceLoader.load(SchemaExtension.class, Classes.getContextClassLoader());
        for (SchemaExtension ext : loader) {
            this.registerExtension(ext);
        }
        ResourceLoader resourceLoader = ResourceLoader.load("META-INF/schema.xml", Classes.getContextClassLoader());
        for (InputStream in : resourceLoader) {
            XmlSchemaSource ts = new XmlSchemaSource(in);
            ts.populateSchema(this);
        }
    }

    public void accept(SchemaVisitor visitor) {
        for (Type type : this) {
            type.accept(visitor);
        }
    }

    @Override
    public Iterator<ExtensibleType> iterator() {
        return Collections.unmodifiableCollection(this.m_typeMap.values()).iterator();
    }

    public ExtensibleType getType(CanonicalTypeDescriptor td) {
        return this.getType(td.getFullName());
    }

    public ExtensibleType getType(String fullName) {
        return this.m_typeMap.get(fullName);
    }

    public <T extends Type> T getType(CanonicalTypeDescriptor td, Class<T> clazz) {
        return this.getType(td.getFullName(), clazz);
    }

    public <T extends Type> T getType(String fullName, Class<T> clazz) {
        return this.m_typeMap.get(fullName).getExtension(clazz);
    }

    public boolean containsType(CanonicalTypeDescriptor td) {
        return this.containsType(td.getFullName());
    }

    public boolean containsType(String fullName) {
        return this.m_typeMap.containsKey(fullName);
    }

    public void addType(ExtensibleType type) {
        this.m_typeMap.put(type.getFullName(), type);
    }

    public ExtensibleType findTypeByJavaName(String name) {
        for (ExtensibleType type : this.m_typeMap.values()) {
            JavaType javaType = type.getExtension(JavaType.class);
            if (javaType == null || !name.equals(javaType.getFullName()) && (javaType.getWrapperType() == null || !name.equals(javaType.getWrapperType().getFullName())) && !javaType.implementsInterface(name)) continue;
            return type;
        }
        return null;
    }

    protected synchronized void registerExtension(SchemaExtension extension) {
        this.m_extensions.add(extension.getName());
        extension.getTypeHandlers().forEach(this::registerTypeHandler);
        extension.getPropertyHandlers().forEach(this::registerPropertyHandler);
    }

    protected synchronized void registerTypeHandler(TypeHandler handler) {
        String name = handler.getExternalTypeClass().getName();
        this.m_typeHandlers.computeIfAbsent(name, k -> new HashSet()).add(handler);
    }

    protected synchronized void registerPropertyHandler(PropertyHandler handler) {
        String name = handler.getExternalPropertyClass().getName();
        this.m_propertyHandlers.computeIfAbsent(name, k -> new HashSet()).add(handler);
    }

    public Set<TypeHandler> getTypeHandlers(Class external) {
        return this.m_typeHandlers.getOrDefault(external.getName(), Collections.emptySet());
    }

    public Set<PropertyHandler> getPropertyHandlers(Class external) {
        return this.m_propertyHandlers.getOrDefault(external.getName(), Collections.emptySet());
    }
}

