/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.schema.AbstractSchemaSource;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.lang.java.JavaTypeDescriptor;
import com.oracle.coherence.common.schema.util.NameTransformer;
import com.oracle.coherence.common.schema.util.NameTransformerChain;
import com.tangosol.internal.asm.ClassReaderInternal;
import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.tree.AnnotationNode;
import com.tangosol.internal.asm.tree.ClassNode;
import com.tangosol.internal.asm.tree.FieldNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassFileSchemaSource
extends AbstractSchemaSource<ClassNode, FieldNode> {
    private static final Logger LOG = Logger.getLogger(ClassFileSchemaSource.class.getName());
    private static final int EXCLUDED_FIELDS = 136;
    private Set<File> m_files = new LinkedHashSet<File>();
    private Predicate<ClassNode> m_typeFilter = t -> true;
    private Predicate<FieldNode> m_propertyFilter = t -> (t.access & 0x88) == 0;
    private boolean m_fMissingPropsAsObject = false;
    private NameTransformer m_namespaceTransformer = new NameTransformerChain().removePrefix("com").removePrefix("net").removePrefix("org").firstLetterToUppercase();
    private NameTransformer m_classNameTransformer = null;
    private NameTransformer m_propertyNameTransformer = new NameTransformerChain().removePrefix("m_").firstLetterToUppercase();
    private int m_nPass;
    protected static boolean s_isWindows = new StringTokenizer(System.getProperty("os.name").toLowerCase().trim()).nextToken().contains("windows");

    public ClassFileSchemaSource withClassesFromDirectory(String directoryName) {
        return this.withClassesFromDirectory(new File(directoryName));
    }

    public ClassFileSchemaSource withClassesFromDirectory(Path directoryPath) {
        return this.withClassesFromDirectory(directoryPath.toFile());
    }

    public ClassFileSchemaSource withClassesFromDirectory(File directory) {
        this.m_files.add(directory);
        return this;
    }

    public ClassFileSchemaSource withClassesFromJarFile(String jarFileName) {
        return this.withClassesFromJarFile(new File(jarFileName));
    }

    public ClassFileSchemaSource withClassesFromJarFile(Path jarFilePath) {
        return this.withClassesFromJarFile(jarFilePath.toFile());
    }

    public ClassFileSchemaSource withClassesFromJarFile(File jarFile) {
        this.m_files.add(jarFile);
        return this;
    }

    public ClassFileSchemaSource withClassFile(String fileName) {
        return this.withClassFile(new File(fileName));
    }

    public ClassFileSchemaSource withClassFile(Path filePath) {
        return this.withClassFile(filePath.toFile());
    }

    public ClassFileSchemaSource withClassFile(File file) {
        this.m_files.add(file);
        return this;
    }

    public ClassFileSchemaSource withTypeFilter(Predicate<ClassNode> typeFilter) {
        this.m_typeFilter = typeFilter;
        return this;
    }

    public ClassFileSchemaSource withPropertyFilter(Predicate<FieldNode> propertyFilter) {
        this.m_propertyFilter = this.m_propertyFilter.and(propertyFilter);
        return this;
    }

    public ClassFileSchemaSource withNamespaceTransformer(NameTransformer transformer) {
        this.m_namespaceTransformer = transformer;
        return this;
    }

    public ClassFileSchemaSource withClassNameTransformer(NameTransformer transformer) {
        this.m_classNameTransformer = transformer;
        return this;
    }

    public ClassFileSchemaSource withPropertyNameTransformer(NameTransformer transformer) {
        this.m_propertyNameTransformer = transformer;
        return this;
    }

    public ClassFileSchemaSource withMissingPropertiesAsObject() {
        this.m_fMissingPropsAsObject = true;
        return this;
    }

    @Override
    public void populateSchema(Schema schema) {
        try {
            for (int i = 1; i <= 2; ++i) {
                this.m_nPass = i;
                for (File file : this.m_files) {
                    if (file.isDirectory()) {
                        this.populateSchemaFromDirectory(schema, file);
                        continue;
                    }
                    if (file.getName().endsWith(".jar")) {
                        this.populateSchemaFromJarFile(schema, file);
                        continue;
                    }
                    if (file.getName().endsWith(".class")) {
                        this.populateSchemaFromFile(schema, file);
                        continue;
                    }
                    LOG.finer("Ignoring " + String.valueOf(file) + ". Unknown file type.");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void populateSchemaFromDirectory(Schema schema, File directory) throws IOException {
        LOG.finer("Populating schema from class files in " + String.valueOf(directory));
        if (!directory.exists()) {
            throw new IllegalArgumentException("Specified path [" + directory.getAbsolutePath() + "] does not exist");
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (this.isPass(1)) {
                    LOG.finer("Processing " + file.getAbsolutePath());
                }
                if (file.isDirectory()) {
                    this.populateSchemaFromDirectory(schema, file);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                this.populateSchemaFromFile(schema, file);
            }
        }
    }

    protected void populateSchemaFromJarFile(Schema schema, File jarFile) throws IOException {
        InputStream jarIn;
        LOG.finer("Populating schema from JAR file " + String.valueOf(jarFile));
        if (jarFile.exists()) {
            jarIn = new FileInputStream(jarFile);
        } else {
            String sJarFileName = jarFile.toString();
            if (s_isWindows) {
                sJarFileName = sJarFileName.replace('\\', '/');
            }
            jarIn = Classes.getContextClassLoader(this).getResourceAsStream(sJarFileName);
        }
        if (jarIn != null) {
            try (ZipInputStream zipIn = new ZipInputStream(jarIn);){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.endsWith(".class") && !"module-info.class".equals(name)) {
                        if (this.isPass(1)) {
                            LOG.finer("Processing " + name);
                        }
                        this.populateSchema(schema, zipIn);
                    }
                    entry = zipIn.getNextEntry();
                }
            }
        } else {
            throw new IllegalArgumentException("Specified JAR file [" + jarFile.getAbsolutePath() + "] does not exist");
        }
    }

    protected void populateSchemaFromFile(Schema schema, File file) throws IOException {
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                this.populateSchema(schema, in);
            }
        }
        String sFilename = file.toString();
        if (s_isWindows) {
            sFilename = sFilename.replace('\\', '/');
        }
        try (InputStream in = Classes.getContextClassLoader(this).getResourceAsStream(sFilename);){
            if (in != null) {
                this.populateSchema(schema, in);
            } else if (this.isPass(1)) {
                LOG.finer("Skipping non-existent file " + String.valueOf(file));
            }
        }
    }

    protected void populateSchema(Schema schema, InputStream in) throws IOException {
        ClassReaderInternal reader = new ClassReaderInternal(in);
        ClassNode source = new ClassNode();
        reader.accept(source, 0);
        if (this.m_typeFilter.test(source)) {
            JavaTypeDescriptor jtd = JavaTypeDescriptor.fromInternal(source.name);
            ExtensibleType type = schema.findTypeByJavaName(jtd.getFullName());
            if (type == null) {
                if (this.isPass(1)) {
                    type = new ExtensibleType();
                    CanonicalTypeDescriptor ctd = CanonicalTypeDescriptor.from(jtd, schema);
                    if (this.m_namespaceTransformer != null) {
                        ctd.setNamespace(this.m_namespaceTransformer.transform(ctd.getNamespaceComponents()));
                    }
                    if (this.m_classNameTransformer != null) {
                        ctd.setName(this.m_classNameTransformer.transform(ctd.getName()));
                    }
                    type.setDescriptor(ctd);
                } else {
                    throw new IllegalStateException("Type " + jtd.getFullName() + " should have been added to the schema during the first pass");
                }
            }
            this.populateTypeInternal(schema, type, source);
            schema.addType(type);
            if (this.isPass(2)) {
                LOG.finer("Added type " + type.getFullName() + " to the schema");
            }
        }
    }

    protected boolean isPass(int nPass) {
        return this.m_nPass == nPass;
    }

    @Override
    protected String getPropertyName(FieldNode source) {
        return this.m_propertyNameTransformer == null ? source.name : this.m_propertyNameTransformer.transform(source.name);
    }

    @Override
    protected Collection<FieldNode> getProperties(ClassNode source) {
        List<FieldNode> fields = source.fields;
        return fields.stream().filter(this.m_propertyFilter).collect(Collectors.toList());
    }

    @Override
    public Class<ClassNode> getExternalTypeClass() {
        return ClassNode.class;
    }

    @Override
    public void importType(ExtensibleType type, ClassNode source, Schema schema) {
        if (this.isPass(2)) {
            JavaTypeDescriptor jtd = JavaTypeDescriptor.fromInternal(source.superName);
            if (jtd != JavaTypeDescriptor.OBJECT) {
                type.setBase(CanonicalTypeDescriptor.from(jtd, schema));
            }
            List<String> interfaces = source.interfaces;
            for (String intf : interfaces) {
                jtd = JavaTypeDescriptor.fromInternal(intf);
                CanonicalTypeDescriptor ctd = CanonicalTypeDescriptor.from(jtd, schema);
                if (!schema.containsType(ctd.getFullName())) continue;
                type.addInterface(ctd);
            }
        }
    }

    @Override
    public void exportType(ExtensibleType type, ClassNode target, Schema schema) {
    }

    @Override
    public Class<FieldNode> getExternalPropertyClass() {
        return FieldNode.class;
    }

    @Override
    public void importProperty(ExtensibleProperty property, FieldNode source, Schema schema) {
        if (this.isPass(1)) {
            String name = this.m_propertyNameTransformer == null ? source.name : this.m_propertyNameTransformer.transform(source.name);
            property.setName(name);
        }
        if (this.isPass(2)) {
            JavaTypeDescriptor jtd = JavaTypeDescriptor.fromInternal(source.signature != null ? source.signature : source.desc);
            if (schema.findTypeByJavaName(jtd.getFullName()) == null) {
                if (this.m_fMissingPropsAsObject) {
                    jtd = JavaTypeDescriptor.OBJECT;
                } else {
                    throw new IllegalStateException("Property type " + jtd.getFullName() + " is not present in the schema. ");
                }
            }
            property.setType(CanonicalTypeDescriptor.from(jtd, schema));
        }
    }

    @Override
    public void exportProperty(ExtensibleProperty property, FieldNode target, Schema schema) {
    }

    public static class Filters {
        public static Predicate<ClassNode> implementsInterface(Class clzInterface) {
            return cn -> cn.interfaces.contains(Type.getDescriptor(clzInterface));
        }

        public static Predicate<ClassNode> extendsClass(Class clzParent) {
            return cn -> cn.superName.equals(Type.getDescriptor(clzParent));
        }

        public static Predicate<ClassNode> hasAnnotation(Class clzAnnotation) {
            return cn -> {
                if (cn.visibleAnnotations != null) {
                    String desc = Type.getDescriptor(clzAnnotation);
                    for (AnnotationNode an : cn.visibleAnnotations) {
                        if (!desc.equals(an.desc)) continue;
                        return true;
                    }
                }
                return false;
            };
        }
    }
}

