/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Property;
import com.oracle.coherence.common.schema.SchemaVisitor;
import com.oracle.coherence.common.schema.Type;
import com.oracle.coherence.common.schema.TypeDescriptor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractType<P extends Property, TD extends TypeDescriptor>
implements Type<P, TD> {
    private ExtensibleType m_parent;
    private Class<P> m_propertyClass;
    private Class<TD> m_typeDescriptorClass;

    protected AbstractType(ExtensibleType parent) {
        this.m_parent = parent;
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        java.lang.reflect.Type[] actualTypeArguments = ((ParameterizedType)superclass).getActualTypeArguments();
        this.m_propertyClass = (Class)actualTypeArguments[0];
        this.m_typeDescriptorClass = actualTypeArguments.length > 1 ? (Class)actualTypeArguments[1] : CanonicalTypeDescriptor.class;
    }

    @Override
    public String getNamespace() {
        if (this.getDescriptor() == null) {
            return null;
        }
        return this.getDescriptor().getNamespace();
    }

    @Override
    public String getName() {
        if (this.getDescriptor() == null) {
            return null;
        }
        return this.getDescriptor().getName();
    }

    @Override
    public String getFullName() {
        if (this.getDescriptor() == null) {
            return null;
        }
        return this.getDescriptor().getFullName();
    }

    @Override
    public <T extends Type> T getExtension(Class<T> clzExtension) {
        return this.m_parent.getExtension(clzExtension);
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visitType(this);
    }

    @Override
    public P getProperty(String propertyName) {
        return this.m_parent.getProperty(propertyName).getExtension(this.m_propertyClass);
    }

    @Override
    public List<P> getProperties() {
        Collection<ExtensibleProperty> properties = this.m_parent.getProperties();
        ArrayList<P> results = new ArrayList<P>(properties.size());
        for (ExtensibleProperty p : properties) {
            P property = p.getExtension(this.m_propertyClass);
            if (property == null) continue;
            results.add(property);
        }
        return results;
    }

    public ExtensibleType getParent() {
        return this.m_parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + ", desc=" + String.valueOf(this.getDescriptor()) + "}";
    }

    protected Class<P> getPropertyClass() {
        return this.m_propertyClass;
    }

    protected Class<TD> getTypeDescriptorClass() {
        return this.m_typeDescriptorClass;
    }
}

