/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.Property;
import com.oracle.coherence.common.schema.SchemaVisitor;
import com.oracle.coherence.common.schema.TypeDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractProperty<TD extends TypeDescriptor>
implements Property<TD> {
    private ExtensibleProperty m_parent;
    private Class<TD> m_typeDescriptorClass;

    protected AbstractProperty(ExtensibleProperty parent) {
        this.m_parent = parent;
        Type superclass = this.getClass().getGenericSuperclass();
        try {
            this.m_typeDescriptorClass = (Class)((ParameterizedType)superclass).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            this.m_typeDescriptorClass = CanonicalTypeDescriptor.class;
        }
    }

    @Override
    public String getName() {
        return this.m_parent.getName();
    }

    @Override
    public <T extends Property> T getExtension(Class<T> extensionType) {
        return this.m_parent.getExtension(extensionType);
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visitProperty(this);
    }

    public ExtensibleProperty getParent() {
        return this.m_parent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + ", type=" + String.valueOf(this.getType()) + "}";
    }

    protected Class<TD> getTypeDescriptorClass() {
        return this.m_typeDescriptorClass;
    }
}

