/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net.exabus.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Factory;
import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.net.SSLSettings;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.common.net.SdpSocketProvider;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.oracle.coherence.common.net.exabus.Bus;
import com.oracle.coherence.common.net.exabus.Depot;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.Event;
import com.oracle.coherence.common.net.exabus.MemoryBus;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.oracle.coherence.common.net.exabus.spi.Driver;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SimpleDepot
implements Depot {
    private static final String TCP_SOCKET_BUS = "TcpSocketBus";
    public static final String TCP_MESSAGE_BUS_PROTOCOL = "tmb";
    public static final String TCP_MEMORY_BUS_PROTOCOL = "trb";
    private static final String TCP_SECURE_SOCKET_BUS = "SecureTcpSocketBus";
    public static final String TCP_SECURE_MESSAGE_BUS_PROTOCOL = "tmbs";
    public static final String TCP_SECURE_MEMORY_BUS_PROTOCOL = "trbs";
    private static final String SDP_SOCKET_BUS = "SdpSocketBus";
    public static final String SDP_MESSAGE_BUS_PROTOCOL = "sdmb";
    public static final String SDP_MEMORY_BUS_PROTOCOL = "sdrb";
    private static final String SDP_SECURE_SOCKET_BUS = "SecureSdpSocketBus";
    public static final String SDP_SECURE_MESSAGE_BUS_PROTOCOL = "sdmbs";
    public static final String SDP_SECURE_MEMORY_BUS_PROTOCOL = "sdrbs";
    private static Logger LOGGER = Logger.getLogger(SimpleDepot.class.getName());
    protected Dependencies m_dependencies;

    public SimpleDepot() {
        this(null);
    }

    public SimpleDepot(Dependencies deps) {
        this.m_dependencies = deps = this.copyDependencies(deps).validate();
        for (Driver driver : deps.getDrivers().values()) {
            driver.setDepot(this);
        }
    }

    public static SimpleDepot getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public EndPoint resolveEndPoint(String sName) {
        for (Driver driver : this.getDependencies().getDrivers().values()) {
            EndPoint ep = driver.resolveEndPoint(sName);
            if (ep == null) continue;
            return ep;
        }
        throw new IllegalArgumentException("unresolvable endpoint " + sName + "; no supporting driver registered");
    }

    @Override
    public MessageBus createMessageBus(EndPoint pointLocal) {
        if (pointLocal == null) {
            pointLocal = this.getDefaultMessageBusEndPoint();
        }
        for (Driver driver : this.getDependencies().getDrivers().values()) {
            if (!driver.isSupported(pointLocal)) continue;
            Bus bus = driver.createBus(pointLocal);
            if (bus instanceof MessageBus) {
                return (MessageBus)bus;
            }
            new BusCloser(bus).close();
            throw new IllegalArgumentException(String.valueOf(pointLocal) + " does not describe a MessageBus");
        }
        throw new IllegalArgumentException(String.valueOf(pointLocal) + " is not creatable; no supporting driver registered");
    }

    @Override
    public MemoryBus createMemoryBus(EndPoint pointLocal) {
        if (pointLocal == null) {
            pointLocal = this.getDefaultMemoryBusEndPoint();
        }
        for (Driver driver : this.getDependencies().getDrivers().values()) {
            if (!driver.isSupported(pointLocal)) continue;
            Bus bus = driver.createBus(pointLocal);
            if (bus instanceof MemoryBus) {
                return (MemoryBus)bus;
            }
            new BusCloser(bus).close();
            throw new IllegalArgumentException(String.valueOf(pointLocal) + " does not describe a MemoryBus");
        }
        throw new IllegalArgumentException(String.valueOf(pointLocal) + " is not creatable; no supporting driver registered");
    }

    protected EndPoint getDefaultMessageBusEndPoint() {
        return this.resolveEndPoint(this.getDependencies().getDefaultMessageBusEndPoint());
    }

    protected EndPoint getDefaultMemoryBusEndPoint() {
        return this.resolveEndPoint(this.getDependencies().getDefaultMemoryBusEndPoint());
    }

    protected void registerDriver(Driver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("driver cannot be null");
        }
        driver.setDepot(this);
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    public static interface Dependencies {
        public String getDefaultMessageBusEndPoint();

        public Dependencies setDefaultMessageBusEndPoint(String var1);

        public String getDefaultMemoryBusEndPoint();

        public Dependencies setDefaultMemoryBusEndPoint(String var1);

        public Map<String, Driver> getDrivers();

        public Dependencies setDrivers(Map<String, Driver> var1);

        public Logger getLogger();

        public SSLSettings getSSLSettings();
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected String m_sDefaultMsgBusEndPoint;
        protected String m_sDefaultMemBusEndPoint;
        protected Map<String, Driver> m_mapDriver;
        protected Logger m_logger;
        protected SSLSettings m_settingsSSL;

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_sDefaultMsgBusEndPoint = deps.getDefaultMessageBusEndPoint();
                this.m_sDefaultMemBusEndPoint = deps.getDefaultMemoryBusEndPoint();
                this.m_mapDriver = deps.getDrivers();
                this.m_logger = deps.getLogger();
            }
        }

        @Override
        public String getDefaultMessageBusEndPoint() {
            String sEp = this.m_sDefaultMsgBusEndPoint;
            return sEp == null ? "tmb://0.0.0.0:-1" : sEp;
        }

        @Override
        public DefaultDependencies setDefaultMessageBusEndPoint(String sEp) {
            this.m_sDefaultMsgBusEndPoint = sEp;
            return this;
        }

        @Override
        public String getDefaultMemoryBusEndPoint() {
            String sEp = this.m_sDefaultMemBusEndPoint;
            return sEp == null ? "trb://0.0.0.0:-1" : sEp;
        }

        @Override
        public DefaultDependencies setDefaultMemoryBusEndPoint(String sEp) {
            this.m_sDefaultMemBusEndPoint = sEp;
            return this;
        }

        @Override
        public Map<String, Driver> getDrivers() {
            Map<String, Driver> mapDriver = this.m_mapDriver;
            if (mapDriver == null) {
                mapDriver = new HashMap<String, Driver>();
                mapDriver.put(SimpleDepot.TCP_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.TCP_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.TCP_MEMORY_BUS_PROTOCOL).setSocketProvider(TcpSocketProvider.MULTIPLEXED)));
                mapDriver.put(SimpleDepot.SDP_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.SDP_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.SDP_MEMORY_BUS_PROTOCOL).setSocketProvider(SdpSocketProvider.MULTIPLEXED)));
                SSLSettings settingsSSL = this.m_settingsSSL;
                if (settingsSSL != null) {
                    mapDriver.put(SimpleDepot.TCP_SECURE_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.TCP_SECURE_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.TCP_SECURE_MEMORY_BUS_PROTOCOL).setSocketProvider(new SSLSocketProvider(new SSLSocketProvider.DefaultDependencies().applySSLSettings(settingsSSL).setDelegate(TcpSocketProvider.MULTIPLEXED)))));
                    mapDriver.put(SimpleDepot.SDP_SECURE_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.SDP_SECURE_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.SDP_SECURE_MEMORY_BUS_PROTOCOL).setSocketProvider(new SSLSocketProvider(new SSLSocketProvider.DefaultDependencies().applySSLSettings(settingsSSL).setDelegate(SdpSocketProvider.MULTIPLEXED)))));
                }
                this.m_mapDriver = mapDriver = Collections.unmodifiableMap(mapDriver);
            }
            return mapDriver;
        }

        @Override
        public DefaultDependencies setDrivers(Map<String, Driver> mapDriver) {
            this.m_mapDriver = mapDriver;
            return this;
        }

        @Override
        public Logger getLogger() {
            Logger logger = this.m_logger;
            return logger == null ? LOGGER : logger;
        }

        public DefaultDependencies setLogger(Logger logger) {
            this.m_logger = logger;
            return this;
        }

        @Override
        public SSLSettings getSSLSettings() {
            return this.m_settingsSSL;
        }

        public DefaultDependencies setSSLSettings(SSLSettings settingsSSL) {
            this.m_settingsSSL = settingsSSL;
            return this;
        }

        protected DefaultDependencies validate() {
            DefaultDependencies.ensureArgument(this.getDefaultMemoryBusEndPoint(), "DefaultMemoryBusEndPoint");
            DefaultDependencies.ensureArgument(this.getDefaultMessageBusEndPoint(), "DefaultMessageBusEndPoint");
            DefaultDependencies.ensureArgument(this.getDrivers(), "Drivers");
            for (Driver driver : this.getDrivers().values()) {
                DefaultDependencies.ensureArgument(driver, "driver");
            }
            return this;
        }

        protected static void ensureArgument(Object o, String sName) {
            if (o == null) {
                throw new IllegalArgumentException(sName + " cannot be null");
            }
        }
    }

    private static class SingletonHolder {
        public static final SimpleDepot INSTANCE = new SimpleDepot();

        private SingletonHolder() {
        }
    }

    protected class BusCloser
    implements Collector<Event>,
    Closeable {
        private Bus m_bus;

        BusCloser(Bus bus) {
            this.m_bus = bus;
            bus.setEventCollector(this);
            bus.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Event event) {
            switch (event.getType()) {
                case OPEN: {
                    this.m_bus.close();
                    break;
                }
                case CLOSE: {
                    BusCloser busCloser = this;
                    synchronized (busCloser) {
                        this.m_bus = null;
                        this.notify();
                        break;
                    }
                }
            }
        }

        @Override
        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            boolean fInterrupted = false;
            BusCloser busCloser = this;
            synchronized (busCloser) {
                while (this.m_bus != null) {
                    try {
                        Blocking.wait(this);
                    }
                    catch (InterruptedException e) {
                        fInterrupted = true;
                    }
                }
            }
            if (fInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected static class DeferredDriver
    implements Driver {
        protected final Factory<Driver> f_factory;
        protected volatile Driver m_delegate;
        protected Depot m_depot;

        public DeferredDriver(Factory<Driver> factory) {
            this.f_factory = factory;
        }

        @Override
        public void setDepot(Depot depot) {
            this.m_depot = depot;
            if (this.m_delegate != null) {
                this.m_delegate.setDepot(depot);
            }
        }

        @Override
        public Depot getDepot() {
            return this.m_depot;
        }

        @Override
        public EndPoint resolveEndPoint(String sName) {
            return this.delegate().resolveEndPoint(sName);
        }

        @Override
        public boolean isSupported(EndPoint point) {
            return this.delegate().isSupported(point);
        }

        @Override
        public Bus createBus(EndPoint pointLocal) {
            return this.delegate().createBus(pointLocal);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Driver delegate() {
            Driver driver = this.m_delegate;
            if (driver == null) {
                DeferredDriver deferredDriver = this;
                synchronized (deferredDriver) {
                    try {
                        this.m_delegate = driver = this.f_factory.create();
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException(e);
                    }
                }
            }
            return driver;
        }
    }
}

