/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.base.Factory;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.internal.net.HashSelectionService;
import com.oracle.coherence.common.internal.net.MultiProviderSelectionService;
import com.oracle.coherence.common.internal.net.ResumableSelectionService;
import com.oracle.coherence.common.internal.net.RoundRobinSelectionService;
import com.oracle.coherence.common.net.SelectionService;
import com.oracle.coherence.common.util.Duration;
import java.util.concurrent.ThreadFactory;

public class SelectionServices {
    public static SelectionService getDefaultService() {
        return DefaultServiceHolder.INSTANCE;
    }

    private static final class DefaultServiceHolder {
        private static final SelectionService INSTANCE;
        private static final ThreadGroup GROUP;

        private DefaultServiceHolder() {
        }

        static {
            GROUP = new ThreadGroup("SelectionService");
            GROUP.setDaemon(false);
            final int cThreads = Integer.parseInt(System.getProperty(SelectionServices.class.getName() + ".threads", String.valueOf(Platform.getPlatform().getFairShareProcessors())));
            final long cMillisTimeout = new Duration(System.getProperty(SelectionServices.class.getName() + ".timeout", "5s")).as(Duration.Magnitude.MILLI);
            LoadBalancer balancer = LoadBalancer.valueOf(System.getProperty(SelectionServices.class.getName() + ".loadBalancer", LoadBalancer.HASH.name()));
            final Factory<SelectionService> factoryService = new Factory<SelectionService>(){

                @Override
                public SelectionService create() {
                    return new ResumableSelectionService(new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread thread = new Thread(GROUP, r);
                            thread.setDaemon(true);
                            return thread;
                        }
                    }).setIdleTimeout(cMillisTimeout);
                }
            };
            INSTANCE = new MultiProviderSelectionService(balancer == LoadBalancer.ROUND_ROBIN ? new Factory<SelectionService>(){

                @Override
                public SelectionService create() {
                    return new RoundRobinSelectionService(cThreads, factoryService);
                }
            } : new Factory<SelectionService>(){

                @Override
                public SelectionService create() {
                    return new HashSelectionService(cThreads, factoryService);
                }
            }){

                @Override
                public void shutdown() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static enum LoadBalancer {
        HASH,
        ROUND_ROBIN;

    }
}

