/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.internal.net.ssl.SSLCertUtility;
import com.oracle.coherence.common.internal.net.ssl.SSLServerSocket;
import com.oracle.coherence.common.internal.net.ssl.SSLServerSocketChannel;
import com.oracle.coherence.common.internal.net.ssl.SSLSocket;
import com.oracle.coherence.common.internal.net.ssl.SSLSocketChannel;
import com.oracle.coherence.common.internal.security.SecurityProvider;
import com.oracle.coherence.common.net.SSLSettings;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.oracle.coherence.common.util.DaemonThreadFactory;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.net.ssl.RefreshPolicy;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

public class SSLSocketProvider
implements SocketProvider {
    protected Dependencies m_dependencies;
    private static final Logger LOGGER = Logger.getLogger(SSLSocketProvider.class.getName());
    public static final Seconds NO_REFRESH = new Seconds(0);
    private static final Executor DEFAULT_EXECUTOR = Executors.newCachedThreadPool(new DaemonThreadFactory("SSLExecutor-"));

    public SSLSocketProvider() {
        this(null);
    }

    public SSLSocketProvider(Dependencies deps) {
        this.m_dependencies = this.copyDependencies(deps).validate();
    }

    @Override
    public SocketAddress resolveAddress(String sAddr) {
        return this.getDependencies().getDelegateSocketProvider().resolveAddress(sAddr);
    }

    @Override
    public String getAddressString(Socket socket) {
        return this.getDependencies().getDelegateSocketProvider().getAddressString(socket);
    }

    @Override
    public String getAddressString(ServerSocket socket) {
        return this.getDependencies().getDelegateSocketProvider().getAddressString(socket);
    }

    @Override
    public Socket openSocket() throws IOException {
        return new SSLSocket(this.getDependencies().getDelegateSocketProvider().openSocket(), this);
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return new SSLSocketChannel(this.getDependencies().getDelegateSocketProvider().openSocketChannel(), this);
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        return new SSLServerSocket(this.getDependencies().getDelegateSocketProvider().openServerSocket(), this);
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new SSLServerSocketChannel(this.getDependencies().getDelegateSocketProvider().openServerSocketChannel(), this);
    }

    @Override
    public SocketProvider getDelegate() {
        return this.getDependencies().getDelegateSocketProvider();
    }

    public String toString() {
        return "SSLSocketProvider(" + this.getDependencies().toString() + ")";
    }

    public void ensureSessionValidity(SSLSession session, Socket socket) throws SSLException {
        if (session == null || socket == null) {
            throw new IllegalArgumentException();
        }
        HostnameVerifier verifier = this.getDependencies().getHostnameVerifier();
        if (verifier != null && !verifier.verify(socket.getInetAddress().getHostName(), session)) {
            throw new SSLException("Unacceptable peer: " + String.valueOf(socket));
        }
        this.getDependencies().getLogger().log(Level.FINE, "Established " + session.getCipherSuite() + " connection with " + String.valueOf(socket));
        if (SSLCertUtility.useSelfSigned(session)) {
            this.getDependencies().getLogger().log(Level.WARNING, "Using self-signed SSL certificate in production environment is not recommended.\nPlease use SSL certificate that is signed by an certificate authority.");
        }
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    public static interface Dependencies {
        public static final String DEFAULT_SSL_PROTOCOL = "TLS";
        public static final String DEFAULT_IDENTITY_ALGORITHM = "SunX509";
        public static final String DEFAULT_TRUST_ALGORITHM = "SunX509";
        public static final String KEYSTORE_TYPE_JKS = "JKS";
        public static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
        public static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";

        public SocketProvider getDelegateSocketProvider();

        public SSLContext getSSLContext();

        public SSLParameters getSSLParameters();

        public ClientAuthMode getClientAuth();

        public DefaultDependencies setClientAuth(ClientAuthMode var1);

        public HostnameVerifier getHostnameVerifier();

        public String[] getEnabledCipherSuites();

        public String[] getEnabledProtocolVersions();

        public Executor getExecutor();

        public Logger getLogger();

        public Dependencies setDescription(String var1);

        public Seconds getRefreshPeriod();

        public RefreshPolicy getRefreshPolicy();

        public SSLContextDependencies getSSLContextDependencies();
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected SocketProvider m_delegate = TcpSocketProvider.INSTANCE;
        protected SSLContext m_ctx;
        protected ClientAuthMode m_clientAuthMode;
        protected HostnameVerifier m_hostnameVerifier;
        protected String[] m_asCipherSuitesEnabled;
        protected String[] m_asProtocolVersionsEnabled;
        protected Executor m_executor;
        protected Logger m_logger;
        protected String m_sDescription = "SSLSocketProvider()";
        protected Seconds m_refreshPeriod = NO_REFRESH;
        protected RefreshPolicy m_refreshPolicy = RefreshPolicy.Always;
        protected SSLContextDependencies m_sslContextDependencies;

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_delegate = deps.getDelegateSocketProvider();
                this.m_ctx = deps.getSSLContext();
                this.m_clientAuthMode = deps.getClientAuth();
                this.m_hostnameVerifier = deps.getHostnameVerifier();
                this.m_asCipherSuitesEnabled = deps.getEnabledCipherSuites();
                this.m_asProtocolVersionsEnabled = deps.getEnabledProtocolVersions();
                this.m_executor = deps.getExecutor();
                this.m_logger = deps.getLogger();
            }
        }

        public DefaultDependencies applySSLSettings(SSLSettings settingsSSL) {
            return this.setSSLContext(settingsSSL.getSSLContext()).setClientAuth(settingsSSL.getClientAuth()).setHostnameVerifier(settingsSSL.getHostnameVerifier()).setEnabledCipherSuites(settingsSSL.getEnabledCipherSuites()).setEnabledProtocolVersions(settingsSSL.getEnabledProtocolVersions());
        }

        @Override
        public SocketProvider getDelegateSocketProvider() {
            return this.m_delegate;
        }

        public DefaultDependencies setDelegate(SocketProvider delegate) {
            this.m_delegate = delegate;
            return this;
        }

        @Override
        public SSLContext getSSLContext() {
            SSLContext ctx = this.m_ctx;
            try {
                return ctx == null ? SSLContext.getDefault() : ctx;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }

        public DefaultDependencies setSSLContext(SSLContext ctx) {
            this.m_ctx = ctx;
            return this;
        }

        @Override
        public SSLParameters getSSLParameters() {
            SSLContext ctx = this.getSSLContext();
            SSLParameters params = ctx.getDefaultSSLParameters();
            String[] asCiphers = this.getEnabledCipherSuites();
            String[] asProtocols = this.getEnabledProtocolVersions();
            if (asCiphers != null) {
                params.setCipherSuites(asCiphers);
            }
            if (asProtocols != null) {
                params.setProtocols(asProtocols);
            }
            switch (this.getClientAuth().ordinal()) {
                case 1: {
                    params.setNeedClientAuth(false);
                    params.setWantClientAuth(true);
                    break;
                }
                case 2: {
                    params.setWantClientAuth(true);
                    params.setNeedClientAuth(true);
                    break;
                }
                default: {
                    params.setWantClientAuth(false);
                    params.setNeedClientAuth(false);
                }
            }
            return params;
        }

        @Override
        public ClientAuthMode getClientAuth() {
            return this.m_clientAuthMode;
        }

        @Override
        public DefaultDependencies setClientAuth(ClientAuthMode mode) {
            this.m_clientAuthMode = mode;
            return this;
        }

        @Override
        public HostnameVerifier getHostnameVerifier() {
            return this.m_hostnameVerifier;
        }

        public DefaultDependencies setHostnameVerifier(HostnameVerifier verifier) {
            this.m_hostnameVerifier = verifier;
            return this;
        }

        @Override
        public Executor getExecutor() {
            Executor executor = this.m_executor;
            return executor == null ? DEFAULT_EXECUTOR : executor;
        }

        public DefaultDependencies setExecutor(Executor executor) {
            this.m_executor = executor;
            return this;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.m_asCipherSuitesEnabled;
        }

        public DefaultDependencies setEnabledCipherSuites(String[] asCiphers) {
            this.m_asCipherSuitesEnabled = asCiphers;
            return this;
        }

        @Override
        public String[] getEnabledProtocolVersions() {
            return this.m_asProtocolVersionsEnabled;
        }

        public DefaultDependencies setEnabledProtocolVersions(String[] asProtocols) {
            this.m_asProtocolVersionsEnabled = asProtocols;
            return this;
        }

        public DefaultDependencies setRefreshPeriod(Seconds refreshPeriod) {
            this.m_refreshPeriod = refreshPeriod == null ? NO_REFRESH : refreshPeriod;
            return this;
        }

        @Override
        public Seconds getRefreshPeriod() {
            return this.m_refreshPeriod;
        }

        @Override
        public RefreshPolicy getRefreshPolicy() {
            return this.m_refreshPolicy;
        }

        public DefaultDependencies setRefreshPolicy(RefreshPolicy policy) {
            this.m_refreshPolicy = policy == null ? RefreshPolicy.Always : policy;
            return this;
        }

        @Override
        public SSLContextDependencies getSSLContextDependencies() {
            return new SSLContextDependencies(this.m_sslContextDependencies, null);
        }

        public void setSSLContextDependencies(SSLContextDependencies deps) {
            this.m_sslContextDependencies = deps;
        }

        @Override
        public Logger getLogger() {
            Logger logger = this.m_logger;
            return logger == null ? LOGGER : logger;
        }

        public DefaultDependencies setLogger(Logger logger) {
            this.m_logger = logger;
            return this;
        }

        @Override
        public DefaultDependencies setDescription(String s) {
            this.m_sDescription = s;
            return this;
        }

        public String toString() {
            ClientAuthMode clientAuth;
            if (this.m_sDescription != null && !this.m_sDescription.isEmpty()) {
                return this.m_sDescription;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getSSLContext());
            if (this.getHostnameVerifier() != null) {
                sb.append(", hostname-verifier=enabled");
            }
            if ((clientAuth = this.getClientAuth()) != null) {
                sb.append(", client-auth=" + String.valueOf((Object)clientAuth));
            }
            return sb.toString();
        }

        protected DefaultDependencies validate() throws IllegalArgumentException {
            DefaultDependencies.ensureArgument(this.getDelegateSocketProvider(), "DelegateSocketProvider");
            DefaultDependencies.ensureArgument(this.getExecutor(), "Executor");
            DefaultDependencies.ensureArgument(this.getLogger(), "Logger");
            return this;
        }

        protected static void ensureArgument(Object o, String sName) {
            if (o == null) {
                throw new IllegalArgumentException(sName + " cannot be null");
            }
        }

        static {
            SecurityProvider.ensureRegistration();
        }
    }

    public static enum ClientAuthMode {
        none,
        wanted,
        required;

    }
}

